/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.VcsRootError;
import com.intellij.openapi.vcs.configurable.VcsMappingConfigurationDialog;
import com.intellij.openapi.vcs.configurable.VcsUpdateInfoScopeFilterConfigurable;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.roots.VcsRootErrorsFinder;
import com.intellij.openapi.vcs.update.AbstractCommonUpdateAction;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirectoryConfigurationPanel
extends JPanel
implements Disposable {
    private static final int POSTPONE_MAPPINGS_LOADING_PANEL = 300;
    private final Project myProject;
    @Nls
    private final String myProjectMessage;
    private final ProjectLevelVcsManager myVcsManager;
    private final TableView<MapInfo> myDirectoryMappingTable;
    private final ComboBox<AbstractVcs> myVcsComboBox;
    private final MyDirectoryRenderer myDirectoryRenderer;
    private final ListTableModel<MapInfo> myModel;
    private final List<AbstractVcs> myAllVcss;
    private final boolean myIsDisabled;
    private final VcsConfiguration myVcsConfiguration;
    @NotNull
    private final Map<String, VcsRootChecker> myCheckers;
    private final VcsUpdateInfoScopeFilterConfigurable myScopeFilterConfig;
    private JBLoadingPanel myLoadingPanel;
    private ProgressIndicator myRootDetectionIndicator;

    @NotNull
    private static SimpleTextAttributes getAttributes(@NotNull MapInfo info) {
        if (info == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(0);
        }
        if (info == MapInfo.SEPARATOR) {
            return new SimpleTextAttributes(129, null);
        }
        if (info.type == MapInfo.Type.INVALID) {
            return new SimpleTextAttributes(0, (Color)JBColor.RED);
        }
        if (info.type == MapInfo.Type.UNREGISTERED) {
            return new SimpleTextAttributes(1, (Color)JBColor.GRAY);
        }
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (simpleTextAttributes == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(1);
        }
        return simpleTextAttributes;
    }

    public VcsDirectoryConfigurationPanel(@NotNull Project project2) {
        if (project2 == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(2);
        }
        this.myRootDetectionIndicator = null;
        this.myProject = project2;
        this.myVcsConfiguration = VcsConfiguration.getInstance(this.myProject);
        this.myProjectMessage = new HtmlBuilder().append(VcsDirectoryMapping.PROJECT_CONSTANT.get()).append(" - ").append(DefaultVcsRootPolicy.getInstance(this.myProject).getProjectConfigurationMessage().replace('\n', ' ')).wrapWithHtmlBody().toString();
        this.myIsDisabled = this.myProject.isDefault();
        this.myVcsManager = ProjectLevelVcsManager.getInstance(project2);
        this.myAllVcss = Arrays.asList(this.myVcsManager.getAllSupportedVcss());
        this.myDirectoryMappingTable = new TableView();
        this.myDirectoryMappingTable.setShowGrid(false);
        this.myDirectoryMappingTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        TableSpeedSearch.installOn(this.myDirectoryMappingTable, info -> info instanceof MapInfo ? MyDirectoryRenderer.getPresentablePath(this.myProject, ((MapInfo)info).mapping) : "");
        this.myScopeFilterConfig = new VcsUpdateInfoScopeFilterConfigurable(this.myProject, this.myVcsConfiguration);
        this.myCheckers = new HashMap<String, VcsRootChecker>();
        this.updateRootCheckers();
        this.setLayout(new BorderLayout());
        this.add(this.createMainComponent());
        this.myDirectoryRenderer = new MyDirectoryRenderer(this.myProject);
        this.myModel = new ListTableModel(new ColumnInfo[]{new MyDirectoryColumnInfo(), new MyVcsColumnInfo()});
        this.myDirectoryMappingTable.setModelAndUpdateColumns(this.myModel);
        this.initializeModel();
        this.myVcsComboBox = VcsDirectoryConfigurationPanel.buildVcsesComboBox(this.myProject);
        this.myVcsComboBox.addItemListener(e -> {
            if (this.myDirectoryMappingTable.isEditing()) {
                this.myDirectoryMappingTable.stopEditing();
            }
        });
        this.myDirectoryMappingTable.setRowHeight(this.myVcsComboBox.getPreferredSize().height);
        if (this.myIsDisabled) {
            this.myDirectoryMappingTable.setEnabled(false);
        }
    }

    public void dispose() {
        if (this.myRootDetectionIndicator != null) {
            this.myRootDetectionIndicator.cancel();
        }
        this.myScopeFilterConfig.disposeUIResources();
    }

    private void updateRootCheckers() {
        this.myCheckers.clear();
        for (VcsRootChecker checker : VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList()) {
            VcsKey key2 = checker.getSupportedVcs();
            AbstractVcs vcs = this.myVcsManager.findVcsByName(key2.getName());
            if (vcs == null) continue;
            this.myCheckers.put(key2.getName(), checker);
        }
    }

    private void initializeModel() {
        this.myScopeFilterConfig.reset();
        ArrayList<MapInfo> mappings = new ArrayList<MapInfo>();
        for (VcsDirectoryMapping mapping : ProjectLevelVcsManager.getInstance(this.myProject).getDirectoryMappings()) {
            mappings.add(MapInfo.registered(new VcsDirectoryMapping(mapping.getDirectory(), mapping.getVcs(), mapping.getRootSettings()), this.isMappingValid(mapping)));
        }
        this.myModel.setItems(mappings);
        this.scheduleUnregisteredRootsLoading();
    }

    private void scheduleUnregisteredRootsLoading() {
        if (this.myProject.isDefault() || !TrustedProjects.isTrusted((Project)this.myProject)) {
            return;
        }
        if (this.myRootDetectionIndicator != null) {
            this.myRootDetectionIndicator.cancel();
        }
        if (!VcsUtil.shouldDetectVcsMappingsFor(this.myProject)) {
            return;
        }
        this.myRootDetectionIndicator = BackgroundTaskUtil.executeAndTryWait(indicator -> {
            List<VcsDirectoryMapping> unregisteredRoots = VcsRootErrorsFinder.getInstance(this.myProject).getOrFind().stream().filter(error -> error.getType() == VcsRootError.Type.UNREGISTERED_ROOT).map(error -> error.getMapping()).toList();
            return () -> {
                if (indicator.isCanceled()) {
                    return;
                }
                this.myLoadingPanel.stopLoading();
                if (!unregisteredRoots.isEmpty()) {
                    this.myModel.addRow((Object)MapInfo.SEPARATOR);
                    for (VcsDirectoryMapping mapping : unregisteredRoots) {
                        this.myModel.addRow((Object)MapInfo.unregistered(mapping));
                    }
                }
            };
        }, () -> this.myLoadingPanel.startLoading(), (long)300L, (boolean)false);
    }

    private boolean isMappingValid(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(3);
        }
        if (mapping.isDefaultMapping()) {
            return true;
        }
        VcsRootChecker checker = this.myCheckers.get(mapping.getVcs());
        if (checker == null) {
            return true;
        }
        VirtualFile directory = LocalFileSystem.getInstance().findFileByPath(mapping.getDirectory());
        return directory != null && checker.validateRoot(directory);
    }

    @NotNull
    public static ComboBox<AbstractVcs> buildVcsesComboBox(@NotNull Project project2) {
        if (project2 == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(4);
        }
        Object[] allVcses = ProjectLevelVcsManager.getInstance(project2).getAllSupportedVcss();
        ComboBox comboBox = new ComboBox((Object[])((AbstractVcs[])ArrayUtil.append((Object[])allVcses, null)));
        comboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)VcsBundle.message("none.vcs.presentation", new Object[0]), AbstractVcs::getDisplayName));
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(5);
        }
        return comboBox2;
    }

    private void addMapping() {
        VcsMappingConfigurationDialog dlg = new VcsMappingConfigurationDialog(this.myProject, VcsBundle.message("directory.mapping.add.title", new Object[0]));
        if (dlg.showAndGet()) {
            this.addMapping(dlg.getMapping());
        }
    }

    private void addMapping(VcsDirectoryMapping mapping) {
        ArrayList<MapInfo> items2 = new ArrayList<MapInfo>(this.myModel.getItems());
        items2.add(MapInfo.registered(new VcsDirectoryMapping(mapping.getDirectory(), mapping.getVcs(), mapping.getRootSettings()), this.isMappingValid(mapping)));
        items2.sort(MapInfo.COMPARATOR);
        this.myModel.setItems(items2);
    }

    private void addSelectedUnregisteredMappings(List<MapInfo> infos) {
        ArrayList<MapInfo> items2 = new ArrayList<MapInfo>(this.myModel.getItems());
        for (MapInfo info : infos) {
            items2.remove(info);
            items2.add(MapInfo.registered(info.mapping, this.isMappingValid(info.mapping)));
        }
        VcsDirectoryConfigurationPanel.sortAndAddSeparatorIfNeeded(items2);
        this.myModel.setItems(items2);
    }

    private static void sortAndAddSeparatorIfNeeded(@NotNull List<MapInfo> items2) {
        if (items2 == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(6);
        }
        boolean hasUnregistered = false;
        boolean hasSeparator = false;
        for (MapInfo item2 : items2) {
            if (item2.type == MapInfo.Type.UNREGISTERED) {
                hasUnregistered = true;
                continue;
            }
            if (item2.type != MapInfo.Type.SEPARATOR) continue;
            hasSeparator = true;
        }
        if (!hasUnregistered && hasSeparator) {
            items2.remove(MapInfo.SEPARATOR);
        } else if (hasUnregistered && !hasSeparator) {
            items2.add(MapInfo.SEPARATOR);
        }
        items2.sort(MapInfo.COMPARATOR);
    }

    private void editMapping() {
        VcsMappingConfigurationDialog dlg = new VcsMappingConfigurationDialog(this.myProject, VcsBundle.message("directory.mapping.remove.title", new Object[0]));
        int row2 = this.myDirectoryMappingTable.getSelectedRow();
        VcsDirectoryMapping mapping = ((MapInfo)this.myDirectoryMappingTable.getRow((int)row2)).mapping;
        dlg.setMapping(mapping);
        if (dlg.showAndGet()) {
            this.setMapping(row2, dlg.getMapping());
        }
    }

    private void setMapping(int row2, @NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(7);
        }
        ArrayList<MapInfo> items2 = new ArrayList<MapInfo>(this.myModel.getItems());
        items2.set(row2, MapInfo.registered(mapping, this.isMappingValid(mapping)));
        items2.sort(MapInfo.COMPARATOR);
        this.myModel.setItems(items2);
    }

    private void removeMapping() {
        ArrayList<MapInfo> mappings = new ArrayList<MapInfo>(this.myModel.getItems());
        int index = this.myDirectoryMappingTable.getSelectionModel().getMinSelectionIndex();
        Collection selection = this.myDirectoryMappingTable.getSelection();
        mappings.removeAll(selection);
        List removedValidRoots = ContainerUtil.mapNotNull((Collection)selection, info -> info.type == MapInfo.Type.NORMAL && this.myCheckers.get(info.mapping.getVcs()) != null ? MapInfo.unregistered(info.mapping) : null);
        mappings.addAll(removedValidRoots);
        VcsDirectoryConfigurationPanel.sortAndAddSeparatorIfNeeded(mappings);
        this.myModel.setItems(mappings);
        if (mappings.size() > 0) {
            if (index >= mappings.size()) {
                index = mappings.size() - 1;
            }
            this.myDirectoryMappingTable.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    protected JComponent createMainComponent() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBag gb = new GridBag().setDefaultInsets((Insets)JBUI.insets((int)0, (int)0, (int)4, (int)10)).setDefaultWeightX(1.0).setDefaultFill(2);
        JComponent mappingsTable = this.createMappingsTable();
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 600);
        this.myLoadingPanel.add((Component)mappingsTable);
        panel2.add((Component)this.myLoadingPanel, gb.nextLine().next().fillCell().weighty(1.0));
        panel2.add((Component)this.createProjectMappingDescription(), gb.nextLine().next());
        if (!AbstractCommonUpdateAction.showsCustomNotification(Arrays.asList(this.myVcsManager.getAllActiveVcss()))) {
            panel2.add((Component)this.myScopeFilterConfig.createComponent(), gb.nextLine().next());
        }
        return panel2;
    }

    private JComponent createMappingsTable() {
        JPanel panelForTable = ToolbarDecorator.createDecorator(this.myDirectoryMappingTable, null).setAddActionUpdater(e -> !this.myIsDisabled && this.rootsOfOneKindInSelection()).setAddAction(button -> {
            List<MapInfo> unregisteredRoots = this.getSelectedUnregisteredRoots();
            if (unregisteredRoots.isEmpty()) {
                this.addMapping();
            } else {
                this.addSelectedUnregisteredMappings(unregisteredRoots);
            }
            this.updateRootCheckers();
        }).setEditActionUpdater(e -> !this.myIsDisabled && this.onlyRegisteredRootsInSelection()).setEditAction(button -> {
            this.editMapping();
            this.updateRootCheckers();
        }).setRemoveActionUpdater(e -> !this.myIsDisabled && this.onlyRegisteredRootsInSelection()).setRemoveAction(button -> {
            this.removeMapping();
            this.updateRootCheckers();
        }).disableUpDownActions().createPanel();
        panelForTable.setPreferredSize((Dimension)new JBDimension(-1, 200));
        return panelForTable;
    }

    @NotNull
    private List<MapInfo> getSelectedUnregisteredRoots() {
        List list = ContainerUtil.filter((Collection)this.myDirectoryMappingTable.getSelection(), info -> info.type == MapInfo.Type.UNREGISTERED);
        if (list == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(8);
        }
        return list;
    }

    private boolean rootsOfOneKindInSelection() {
        Collection selection = this.myDirectoryMappingTable.getSelection();
        if (selection.isEmpty()) {
            return true;
        }
        if (selection.size() == 1 && ((MapInfo)selection.iterator().next()).type == MapInfo.Type.SEPARATOR) {
            return true;
        }
        List<MapInfo> selectedRegisteredRoots = this.getSelectedRegisteredRoots();
        return selectedRegisteredRoots.size() == selection.size() || selectedRegisteredRoots.size() == 0;
    }

    @NotNull
    private List<MapInfo> getSelectedRegisteredRoots() {
        Collection selection = this.myDirectoryMappingTable.getSelection();
        List list = ContainerUtil.filter((Collection)selection, info -> info.type == MapInfo.Type.NORMAL || info.type == MapInfo.Type.INVALID);
        if (list == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(9);
        }
        return list;
    }

    private boolean onlyRegisteredRootsInSelection() {
        return this.getSelectedRegisteredRoots().size() == this.myDirectoryMappingTable.getSelection().size();
    }

    private JComponent createProjectMappingDescription() {
        JBLabel label = new JBLabel(this.myProjectMessage);
        label.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        label.setFontColor(UIUtil.FontColor.BRIGHTER);
        label.setBorder((Border)JBUI.Borders.empty((int)2, (int)5, (int)2, (int)0));
        return label;
    }

    public void reset() {
        this.initializeModel();
    }

    public void apply() throws ConfigurationException {
        this.adjustIgnoredRootsSettings();
        this.myVcsManager.setDirectoryMappings(this.getModelMappings());
        this.myScopeFilterConfig.apply();
        this.initializeModel();
    }

    private void adjustIgnoredRootsSettings() {
        List<VcsDirectoryMapping> newMappings = this.getModelMappings();
        List<VcsDirectoryMapping> previousMappings = this.myVcsManager.getDirectoryMappings();
        this.myVcsConfiguration.addIgnoredUnregisteredRoots(previousMappings.stream().filter(mapping -> !newMappings.contains(mapping) && !mapping.isDefaultMapping()).map(mapping -> mapping.getDirectory()).collect(Collectors.toList()));
        this.myVcsConfiguration.removeFromIgnoredUnregisteredRoots(ContainerUtil.map(newMappings, VcsDirectoryMapping::getDirectory));
    }

    public boolean isModified() {
        if (this.myScopeFilterConfig.isModified()) {
            return true;
        }
        return !this.getModelMappings().equals(this.myVcsManager.getDirectoryMappings());
    }

    @NotNull
    private List<VcsDirectoryMapping> getModelMappings() {
        List list = ContainerUtil.mapNotNull((Collection)this.myModel.getItems(), info -> info == MapInfo.SEPARATOR || info.type == MapInfo.Type.UNREGISTERED ? null : info.mapping);
        if (list == null) {
            VcsDirectoryConfigurationPanel.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVcsesComboBox";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedUnregisteredRoots";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRegisteredRoots";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMappingValid";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildVcsesComboBox";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sortAndAddSeparatorIfNeeded";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setMapping";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 5, 8, 9, 10 -> new IllegalStateException(string2);
        };
    }

    private static final class MapInfo {
        static final MapInfo SEPARATOR = new MapInfo(new VcsDirectoryMapping("SEPARATOR", "SEP"), Type.SEPARATOR);
        static final Comparator<MapInfo> COMPARATOR = (o1, o2) -> {
            if (o1.type.isRegistered() && o2.type.isRegistered() || o1.type == Type.UNREGISTERED && o2.type == Type.UNREGISTERED) {
                return Comparing.compare((Comparable)((Object)o1.mapping.getDirectory()), (Comparable)((Object)o2.mapping.getDirectory()));
            }
            return o1.type.compareTo(o2.type);
        };
        private final Type type;
        private VcsDirectoryMapping mapping;

        static MapInfo unregistered(@NotNull VcsDirectoryMapping mapping) {
            if (mapping == null) {
                MapInfo.$$$reportNull$$$0(0);
            }
            return new MapInfo(mapping, Type.UNREGISTERED);
        }

        static MapInfo registered(@NotNull VcsDirectoryMapping mapping, boolean valid) {
            if (mapping == null) {
                MapInfo.$$$reportNull$$$0(1);
            }
            return new MapInfo(mapping, valid ? Type.NORMAL : Type.INVALID);
        }

        private MapInfo(@NotNull VcsDirectoryMapping mapping, @NotNull Type type2) {
            if (mapping == null) {
                MapInfo.$$$reportNull$$$0(2);
            }
            if (type2 == null) {
                MapInfo.$$$reportNull$$$0(3);
            }
            this.mapping = mapping;
            this.type = type2;
        }

        public String toString() {
            if (this.type == Type.SEPARATOR) {
                return "";
            }
            return this.mapping.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MapInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unregistered";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registered";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static enum Type {
            NORMAL,
            INVALID,
            SEPARATOR,
            UNREGISTERED;


            boolean isRegistered() {
                return this == NORMAL || this == INVALID;
            }
        }
    }

    private static class MyDirectoryRenderer
    extends ColoredTableCellRenderer {
        private final Project myProject;

        MyDirectoryRenderer(Project project2) {
            this.myProject = project2;
        }

        protected void customizeCellRenderer(@NotNull JTable table, Object value2, boolean selected, boolean hasFocus, int row2, int column) {
            if (table == null) {
                MyDirectoryRenderer.$$$reportNull$$$0(0);
            }
            if (value2 instanceof MapInfo) {
                MapInfo info = (MapInfo)value2;
                SimpleTextAttributes textAttributes = VcsDirectoryConfigurationPanel.getAttributes(info);
                if (!(selected || info != MapInfo.SEPARATOR && info.type != MapInfo.Type.UNREGISTERED)) {
                    this.setBackground(UIUtil.getDecoratedRowColor());
                }
                if (info == MapInfo.SEPARATOR) {
                    this.append(VcsBundle.message("unregistered.roots.label", new Object[0]), textAttributes);
                    return;
                }
                String presentablePath = MyDirectoryRenderer.getPresentablePath(this.myProject, info.mapping);
                SpeedSearchUtil.appendFragmentsForSpeedSearch((JComponent)table, (String)presentablePath, (SimpleTextAttributes)textAttributes, (boolean)selected, (SimpleColoredComponent)this);
            }
        }

        @NotNull
        @NlsSafe
        private static String getPresentablePath(@NotNull Project project2, @NotNull VcsDirectoryMapping mapping) {
            if (project2 == null) {
                MyDirectoryRenderer.$$$reportNull$$$0(1);
            }
            if (mapping == null) {
                MyDirectoryRenderer.$$$reportNull$$$0(2);
            }
            if (mapping.isDefaultMapping()) {
                String string2 = VcsDirectoryMapping.PROJECT_CONSTANT.get();
                if (string2 == null) {
                    MyDirectoryRenderer.$$$reportNull$$$0(3);
                }
                return string2;
            }
            String directory = mapping.getDirectory();
            VirtualFile baseDir2 = project2.getBaseDir();
            if (baseDir2 == null) {
                String string3 = new File(directory).getPath();
                if (string3 == null) {
                    MyDirectoryRenderer.$$$reportNull$$$0(4);
                }
                return string3;
            }
            File directoryFile = new File(StringUtil.trimEnd((String)UriUtil.trimTrailingSlashes((String)directory), (String)"\\") + "/");
            File ioBase = new File(baseDir2.getPath());
            if (directoryFile.isAbsolute() && !FileUtil.isAncestor((File)ioBase, (File)directoryFile, (boolean)false)) {
                String string4 = new File(directory).getPath();
                if (string4 == null) {
                    MyDirectoryRenderer.$$$reportNull$$$0(5);
                }
                return string4;
            }
            String relativePath = FileUtil.getRelativePath((File)ioBase, (File)directoryFile);
            if (".".equals(relativePath) || relativePath == null) {
                String string5 = ioBase.getPath();
                if (string5 == null) {
                    MyDirectoryRenderer.$$$reportNull$$$0(6);
                }
                return string5;
            }
            String string6 = relativePath + " (" + ioBase + ")";
            if (string6 == null) {
                MyDirectoryRenderer.$$$reportNull$$$0(7);
            }
            return string6;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MyDirectoryRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MyDirectoryRenderer";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentablePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeCellRenderer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentablePath";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 4, 5, 6, 7 -> new IllegalStateException(string2);
            };
        }
    }

    private class MyDirectoryColumnInfo
    extends ColumnInfo<MapInfo, MapInfo> {
        MyDirectoryColumnInfo() {
            super(VcsBundle.message("column.info.configure.vcses.directory", new Object[0]));
        }

        public MapInfo valueOf(MapInfo mapping) {
            return mapping;
        }

        public TableCellRenderer getRenderer(MapInfo vcsDirectoryMapping) {
            return VcsDirectoryConfigurationPanel.this.myDirectoryRenderer;
        }
    }

    private class MyVcsColumnInfo
    extends ColumnInfo<MapInfo, String> {
        MyVcsColumnInfo() {
            super(VcsBundle.message("column.name.configure.vcses.vcs", new Object[0]));
        }

        public String valueOf(MapInfo object) {
            return object.mapping.getVcs();
        }

        public boolean isCellEditable(MapInfo info) {
            return info != MapInfo.SEPARATOR && info.type != MapInfo.Type.UNREGISTERED;
        }

        public void setValue(MapInfo o, String aValue) {
            o.mapping = new VcsDirectoryMapping(o.mapping.getDirectory(), aValue, o.mapping.getRootSettings());
        }

        public TableCellRenderer getRenderer(MapInfo info) {
            return new MyVcsRenderer(info, VcsDirectoryConfigurationPanel.this.myAllVcss);
        }

        public TableCellEditor getEditor(MapInfo o) {
            return new AbstractTableCellEditor(){

                public Object getCellEditorValue() {
                    AbstractVcs selectedVcs = (AbstractVcs)VcsDirectoryConfigurationPanel.this.myVcsComboBox.getItem();
                    return selectedVcs == null ? "" : selectedVcs.getName();
                }

                public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row2, int column) {
                    VcsDirectoryConfigurationPanel.this.myVcsComboBox.setSelectedItem(value2);
                    return VcsDirectoryConfigurationPanel.this.myVcsComboBox;
                }
            };
        }

        @Nullable
        public String getMaxStringValue() {
            String maxString = null;
            for (AbstractVcs vcs : VcsDirectoryConfigurationPanel.this.myAllVcss) {
                String name = vcs.getDisplayName();
                if (maxString != null && maxString.length() >= name.length()) continue;
                maxString = name;
            }
            return maxString;
        }

        public int getAdditionalWidth() {
            return 10;
        }
    }

    private static class MyVcsRenderer
    extends ColoredTableCellRenderer {
        private final MapInfo myInfo;
        @NotNull
        private final List<? extends AbstractVcs> myAllVcses;

        MyVcsRenderer(@NotNull MapInfo info, @NotNull List<? extends AbstractVcs> allVcses) {
            if (info == null) {
                MyVcsRenderer.$$$reportNull$$$0(0);
            }
            if (allVcses == null) {
                MyVcsRenderer.$$$reportNull$$$0(1);
            }
            this.myInfo = info;
            this.myAllVcses = allVcses;
        }

        protected void customizeCellRenderer(@NotNull JTable table, Object value2, boolean selected, boolean hasFocus, int row2, int column) {
            AbstractVcs vcs;
            String vcsName;
            if (table == null) {
                MyVcsRenderer.$$$reportNull$$$0(2);
            }
            if (this.myInfo == MapInfo.SEPARATOR) {
                if (!selected) {
                    this.setBackground(UIUtil.getDecoratedRowColor());
                }
                return;
            }
            if (this.myInfo.type == MapInfo.Type.UNREGISTERED && !selected) {
                this.setBackground(UIUtil.getDecoratedRowColor());
            }
            String text2 = (vcsName = this.myInfo.mapping.getVcs()).isEmpty() ? VcsBundle.message("none.vcs.presentation", new Object[0]) : ((vcs = (AbstractVcs)ContainerUtil.find(this.myAllVcses, it -> vcsName.equals(it.getName()))) != null ? vcs.getDisplayName() : VcsBundle.message("unknown.vcs.presentation", vcsName));
            this.append(text2, VcsDirectoryConfigurationPanel.getAttributes(this.myInfo));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allVcses";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/configurable/VcsDirectoryConfigurationPanel$MyVcsRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

