/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.google.common.collect.Multiset;
import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdService;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListAvailabilityListener;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsFreezingProcess;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.ex.ChangelistsLocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.LocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.LocalLineStatusTrackerImpl;
import com.intellij.openapi.vcs.impl.ActiveChangeListTracker;
import com.intellij.openapi.vcs.impl.BaseRevisionStatusTrackerContentLoader;
import com.intellij.openapi.vcs.impl.ChangelistsLocalStatusTrackerProvider;
import com.intellij.openapi.vcs.impl.DefaultLocalStatusTrackerProvider;
import com.intellij.openapi.vcs.impl.LineStatusTrackerContentLoader;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import com.intellij.openapi.vcs.impl.LineStatusTrackerSettingListener;
import com.intellij.openapi.vcs.impl.LocalLineStatusTrackerProvider;
import com.intellij.openapi.vcs.impl.PartialLineStatusTrackerManagerState;
import com.intellij.openapi.vcs.impl.Result;
import com.intellij.openapi.vcs.impl.SingleThreadLoader;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vcs.impl.VcsBaseContentProviderListener;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandlerKt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b1\u0018\u0000 a2\u00020\u00012\u00020\u0002:\u0016_`abcdefghijklmnopqrstB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u0002J\b\u0010$\u001a\u00020\u001aH\u0016J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u0014H\u0016J\u0018\u0010&\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\fH\u0002J\u0010\u0010(\u001a\u00020!2\u0006\u0010'\u001a\u00020\fH\u0003J\u0013\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0000\u00a2\u0006\u0002\b,J\b\u0010-\u001a\u00020!H\u0016J\b\u0010.\u001a\u00020!H\u0003J\u0016\u0010/\u001a\b\u0012\u0002\b\u0003\u0018\u0001002\u0006\u0010'\u001a\u00020\fH\u0016J\u0016\u0010/\u001a\b\u0012\u0002\b\u0003\u0018\u0001002\u0006\u00101\u001a\u00020\u0014H\u0016J\u001a\u00102\u001a\u0004\u0018\u0001032\u0006\u0010%\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\fH\u0002J\u0010\u00104\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003000*J\b\u00105\u001a\u000206H\u0002J&\u00107\u001a\b\u0012\u0002\b\u0003\u0018\u0001082\u0006\u0010%\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\f2\u0006\u00109\u001a\u000203H\u0002J\u0010\u0010:\u001a\u00020!2\u0006\u0010;\u001a\u00020<H\u0016J\u001c\u0010=\u001a\u00020!2\b\b\u0001\u0010>\u001a\u00020?2\b\u00101\u001a\u0004\u0018\u00010\u0014H\u0002J\u0015\u0010@\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\bAJ\u0018\u0010B\u001a\u00020!2\u0006\u0010'\u001a\u00020\f2\u0006\u0010C\u001a\u00020DH\u0007J\b\u0010E\u001a\u00020!H\u0003J\u0010\u0010F\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0014H\u0003J\u001c\u0010G\u001a\u00020!2\n\u0010H\u001a\u0006\u0012\u0002\b\u0003082\u0006\u00109\u001a\u000203H\u0003J\u0010\u0010I\u001a\u00020!2\u0006\u0010J\u001a\u00020\u001fH\u0002J\b\u0010K\u001a\u00020!H\u0007J\u001a\u0010L\u001a\u00020!2\u0006\u0010'\u001a\u00020\f2\b\b\u0002\u0010M\u001a\u00020\u001aH\u0003J\u0018\u0010N\u001a\u00020!2\u0006\u0010'\u001a\u00020\f2\u0006\u0010O\u001a\u00020\u0007H\u0017J\u0018\u0010P\u001a\u00020!2\u0006\u0010'\u001a\u00020\f2\u0006\u0010O\u001a\u00020\u0007H\u0017J\u0010\u0010Q\u001a\u00020!2\u0006\u0010J\u001a\u00020\u001fH\u0002J\b\u0010R\u001a\u00020!H\u0007J\u001b\u0010S\u001a\u00020!2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00150*H\u0001\u00a2\u0006\u0002\bUJ\b\u0010V\u001a\u00020!H\u0002J\b\u0010W\u001a\u00020!H\u0002J\"\u0010X\u001a\u00020!2\u0006\u0010%\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\f2\b\b\u0002\u0010Y\u001a\u00020\u001aH\u0002J\u001a\u0010Z\u001a\u00020!2\u0006\u0010J\u001a\u00020\u001f2\b\b\u0002\u0010M\u001a\u00020\u001aH\u0002J\b\u0010[\u001a\u00020!H\u0002J\b\u0010\\\u001a\u00020!H\u0002J\b\u0010]\u001a\u00020!H\u0007J\u001c\u0010^\u001a\u00020!2\b\b\u0001\u0010>\u001a\u00020?2\b\u0010'\u001a\u0004\u0018\u00010\fH\u0002J\u001c\u0010^\u001a\u00020!2\b\b\u0001\u0010>\u001a\u00020?2\b\u00101\u001a\u0004\u0018\u00010\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\r\u001a\u0015\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u000e\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00180\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u00060\u001cR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001f0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006u"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManagerI;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "LOCK", "", "clmFreezeCounter", "", "documentsInDefaultChangeList", "Ljava/util/HashSet;", "Lcom/intellij/openapi/editor/Document;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "fileStatesAwaitingRefresh", "Ljava/util/HashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$State;", "filesWithDamagedInactiveRanges", "forcedDocuments", "Lcom/google/common/collect/Multiset;", "isDisposed", "", "loader", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyBaseRevisionLoader;", "partialChangeListsEnabled", "trackers", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData;", "addTrackerListener", "", "listener", "disposable", "arePartialChangelistsEnabled", "virtualFile", "canCreateTrackerFor", "document", "checkIfTrackerCanBeReleased", "collectPartiallyChangedFilesStates", "", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$FullState;", "collectPartiallyChangedFilesStates$intellij_platform_vcs_impl", "dispose", "expireInactiveRangesDamagedNotifications", "getLineStatusTracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "file", "getTrackerProvider", "Lcom/intellij/openapi/vcs/impl/LocalLineStatusTrackerProvider;", "getTrackers", "getTrackingMode", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;", "installTracker", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "provider", "invokeAfterUpdate", "task", "Ljava/lang/Runnable;", "log", "message", "", "notifyInactiveRangesDamaged", "notifyInactiveRangesDamaged$intellij_platform_vcs_impl", "offerTrackerContent", "text", "", "onEverythingChanged", "onFileChanged", "refreshTracker", "tracker", "registerTrackerInCLM", "data", "releaseAllTrackers", "releaseTracker", "wasUnbound", "releaseTrackerFor", "requester", "requestTrackerFor", "reregisterTrackerInCLM", "resetExcludedFromCommitMarkers", "restoreTrackersForPartiallyChangedFiles", "trackerStates", "restoreTrackersForPartiallyChangedFiles$intellij_platform_vcs_impl", "showInactiveRangesDamagedNotification", "startListenForEditors", "switchTracker", "refreshExisting", "unregisterTrackerInCLM", "updatePartialChangeListsAvailability", "updateTrackingSettings", "waitUntilBaseContentsLoaded", "warn", "BaseContentProviderListener", "CheckinFactory", "Companion", "InactiveRangesDamagedNotification", "Listener", "ListenerAdapter", "MyApplicationListener", "MyBaseRevisionLoader", "MyChangeListAvailabilityListener", "MyChangeListListener", "MyCommandListener", "MyDocumentListener", "MyEditorFactoryListener", "MyFileDocumentManagerListener", "MyFileStatusListener", "MyFreezeListener", "MyLineStatusTrackerSettingListener", "MyStartupActivity", "MyVirtualFileListener", "RefreshData", "RefreshRequest", "TrackerData", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nLineStatusTrackerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ClientId.kt\ncom/intellij/codeWithMe/ClientId$Companion\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1478:1\n1549#2:1479\n1620#2,3:1480\n12744#3,2:1483\n2298#3,5:1507\n13579#3,2:1512\n13579#3,2:1514\n201#4,7:1485\n208#4,10:1496\n19#5,4:1492\n10#5:1516\n1#6:1506\n*S KotlinDebug\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager\n*L\n226#1:1479\n226#1:1480,3\n383#1:1483,2\n1074#1:1507,5\n1077#1:1512,2\n1091#1:1514,2\n647#1:1485,7\n647#1:1496,10\n647#1:1492,4\n97#1:1516\n*E\n"})
public final class LineStatusTrackerManager
implements LineStatusTrackerManagerI,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Object LOCK;
    private boolean isDisposed;
    @NotNull
    private final HashMap<Document, TrackerData> trackers;
    @NotNull
    private final HashMap<Document, Multiset<Object>> forcedDocuments;
    @NotNull
    private final EventDispatcher<Listener> eventDispatcher;
    private boolean partialChangeListsEnabled;
    @NotNull
    private final HashSet<Document> documentsInDefaultChangeList;
    private int clmFreezeCounter;
    @NotNull
    private final HashSet<VirtualFile> filesWithDamagedInactiveRanges;
    @NotNull
    private final HashMap<VirtualFile, ChangelistsLocalLineStatusTracker.State> fileStatesAwaitingRefresh;
    @NotNull
    private final MyBaseRevisionLoader loader;
    @NotNull
    private static final Logger LOG;

    public LineStatusTrackerManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.LOCK = new Object();
        this.trackers = new HashMap();
        this.forcedDocuments = new HashMap();
        EventDispatcher eventDispatcher = EventDispatcher.create(Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(Listener::class.java)");
        this.eventDispatcher = eventDispatcher;
        this.documentsInDefaultChangeList = new HashSet();
        this.filesWithDamagedInactiveRanges = new HashSet();
        this.fileStatesAwaitingRefresh = new HashMap();
        this.loader = new MyBaseRevisionLoader();
    }

    private final void startListenForEditors() {
        MessageBusConnection connection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = LineStatusTrackerSettingListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new MyLineStatusTrackerSettingListener());
        Topic<VcsFreezingProcess.Listener> topic2 = VcsFreezingProcess.Listener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"TOPIC");
        connection.subscribe(topic2, (Object)new MyFreezeListener());
        Topic topic3 = CommandListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic3, (String)"TOPIC");
        connection.subscribe(topic3, (Object)new MyCommandListener());
        Topic<ChangeListListener> topic4 = ChangeListListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic4, (String)"TOPIC");
        connection.subscribe(topic4, (Object)new MyChangeListListener());
        Topic<ChangeListAvailabilityListener> topic5 = ChangeListAvailabilityListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic5, (String)"TOPIC");
        connection.subscribe(topic5, (Object)new MyChangeListAvailabilityListener());
        Topic topic6 = FileStatusListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic6, (String)"TOPIC");
        connection.subscribe(topic6, (Object)new MyFileStatusListener());
        Topic<VcsBaseContentProviderListener> topic7 = VcsBaseContentProviderListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic7, (String)"TOPIC");
        connection.subscribe(topic7, (Object)new BaseContentProviderListener());
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic8 = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic8, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic8, (Object)new MyVirtualFileListener());
        LocalLineStatusTrackerProvider.Companion.getEP_NAME$intellij_platform_vcs_impl().addChangeListener(() -> LineStatusTrackerManager.startListenForEditors$lambda$0(this), (Disposable)this);
        VcsBaseContentProvider.EP_NAME.addChangeListener((AreaInstance)this.project, () -> LineStatusTrackerManager.startListenForEditors$lambda$1(this), (Disposable)this);
        this.updatePartialChangeListsAvailability();
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.project)).execute(() -> LineStatusTrackerManager.startListenForEditors$lambda$2(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.isDisposed = true;
        Disposer.dispose((Disposable)this.loader);
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            for (Map.Entry entry2 : ((Map)this.forcedDocuments).entrySet()) {
                Document document2 = (Document)entry2.getKey();
                Multiset multiset2 = (Multiset)entry2.getValue();
                for (Object requester : multiset2.elementSet()) {
                    this.warn("Tracker is being held on dispose by " + requester, document2);
                }
            }
            this.forcedDocuments.clear();
            for (TrackerData data2 : this.trackers.values()) {
                Intrinsics.checkNotNullExpressionValue((Object)data2, (String)"data");
                LineStatusTrackerManager.unregisterTrackerInCLM$default(this, data2, false, 2, null);
                data2.getTracker().release();
            }
            this.trackers.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LineStatusTracker<?> getLineStatusTracker(@NotNull Document document2) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            TrackerData trackerData = this.trackers.get(document2);
            LineStatusTracker lineStatusTracker = trackerData != null ? trackerData.getTracker() : null;
            return lineStatusTracker;
        }
    }

    @Override
    @Nullable
    public LineStatusTracker<?> getLineStatusTracker(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Document document2 = FileDocumentManager.getInstance().getCachedDocument(file);
        if (document2 == null) {
            return null;
        }
        Document document3 = document2;
        return this.getLineStatusTracker(document3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresEdt
    public void requestTrackerFor(@NotNull Document document2, @NotNull Object requester) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)requester, (String)"requester");
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            if (this.isDisposed) {
                this.warn("Tracker is being requested after dispose by " + requester, document2);
                return;
            }
            Multiset multiset2 = this.forcedDocuments.computeIfAbsent(document2, arg_0 -> LineStatusTrackerManager.requestTrackerFor$lambda$6$lambda$5(requestTrackerFor.1.multiset.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)multiset2, (String)"forcedDocuments.computeI\u2026hMultiset.create<Any>() }");
            Multiset multiset3 = multiset2;
            multiset3.add(requester);
            if (this.trackers.get(document2) == null) {
                VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document2);
                if (virtualFile == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"FileDocumentManager.getI\u2026tFile(document) ?: return");
                VirtualFile virtualFile2 = virtualFile;
                LineStatusTrackerManager.switchTracker$default(this, virtualFile2, document2, false, 4, null);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresEdt
    public void releaseTrackerFor(@NotNull Document document2, @NotNull Object requester) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)requester, (String)"requester");
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            Multiset<Object> multiset2 = this.forcedDocuments.get(document2);
            if (multiset2 == null || !multiset2.contains(requester)) {
                this.warn("Tracker release underflow by " + requester, document2);
                return;
            }
            multiset2.remove(requester);
            if (multiset2.isEmpty()) {
                this.forcedDocuments.remove(document2);
                this.checkIfTrackerCanBeReleased(document2);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void invokeAfterUpdate(@NotNull Runnable task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        this.loader.addAfterUpdateRunnable(task2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<LineStatusTracker<?>> getTrackers() {
        Object object = this.LOCK;
        synchronized (object) {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Collection<TrackerData> collection = this.trackers.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"trackers.values");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TrackerData trackerData = (TrackerData)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(it.getTracker());
            }
            List list = (List)destination$iv$iv;
            return list;
        }
    }

    public final void addTrackerListener(@NotNull Listener listener2, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.eventDispatcher.addListener((EventListener)listener2, disposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    private final void checkIfTrackerCanBeReleased(Document document2) {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            TrackerData trackerData = this.trackers.get(document2);
            if (trackerData == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)trackerData, (String)"trackers[document] ?: return");
            TrackerData data2 = trackerData;
            if (this.forcedDocuments.containsKey(document2)) {
                return;
            }
            if (data2.getTracker() instanceof ChangelistsLocalLineStatusTracker) {
                boolean hasPartialChanges = ((ChangelistsLocalLineStatusTracker)data2.getTracker()).hasPartialState$intellij_platform_vcs_impl();
                if (hasPartialChanges) {
                    this.log("checkIfTrackerCanBeReleased - hasPartialChanges", data2.getTracker().getVirtualFile());
                    return;
                }
                boolean isLoading = this.loader.hasRequestFor(document2);
                if (isLoading) {
                    this.log("checkIfTrackerCanBeReleased - isLoading", data2.getTracker().getVirtualFile());
                    if (((ChangelistsLocalLineStatusTracker)data2.getTracker()).hasPendingPartialState$intellij_platform_vcs_impl() || this.fileStatesAwaitingRefresh.containsKey(data2.getTracker().getVirtualFile())) {
                        this.log("checkIfTrackerCanBeReleased - has pending state", data2.getTracker().getVirtualFile());
                        return;
                    }
                }
            }
            LineStatusTrackerManager.releaseTracker$default(this, document2, false, 2, null);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    private final void onEverythingChanged() {
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            if (this.isDisposed) {
                return;
            }
            this.log("onEverythingChanged", null);
            HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
            for (TrackerData data2 : this.trackers.values()) {
                files2.add(data2.getTracker().getVirtualFile());
            }
            for (Document document2 : this.forcedDocuments.keySet()) {
                VirtualFile file = FileDocumentManager.getInstance().getFile(document2);
                if (file == null) continue;
                files2.add(file);
            }
            for (VirtualFile file : files2) {
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                this.onFileChanged(file);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    private final void onFileChanged(VirtualFile virtualFile) {
        Document document2 = FileDocumentManager.getInstance().getCachedDocument(virtualFile);
        if (document2 == null) {
            return;
        }
        Document document3 = document2;
        Object object = this.LOCK;
        synchronized (object) {
            LocalLineStatusTracker<?> tracker;
            boolean bl = false;
            if (this.isDisposed) {
                return;
            }
            this.log("onFileChanged", virtualFile);
            TrackerData trackerData = this.trackers.get(document3);
            LocalLineStatusTracker<Object> localLineStatusTracker = tracker = trackerData != null ? trackerData.getTracker() : null;
            if (tracker != null || this.forcedDocuments.containsKey(document3)) {
                this.switchTracker(virtualFile, document3, true);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void registerTrackerInCLM(TrackerData data2) {
        LocalLineStatusTracker<?> tracker = data2.getTracker();
        VirtualFile virtualFile = tracker.getVirtualFile();
        if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) {
            return;
        }
        LOG.assertTrue(virtualFile.isInLocalFileSystem(), (Object)virtualFile);
        FilePath filePath = VcsUtil.getFilePath(virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(virtualFile)");
        FilePath filePath2 = filePath;
        if (data2.getClmFilePath() != null) {
            LOG.error("[registerTrackerInCLM] tracker already registered");
            return;
        }
        ChangeListManagerImpl.getInstanceImpl(this.project).registerChangeTracker(filePath2, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
        data2.setClmFilePath(filePath2);
    }

    private final void unregisterTrackerInCLM(TrackerData data2, boolean wasUnbound) {
        LocalLineStatusTracker<?> tracker = data2.getTracker();
        VirtualFile virtualFile = tracker.getVirtualFile();
        if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) {
            return;
        }
        LOG.assertTrue(virtualFile.isInLocalFileSystem(), (Object)virtualFile);
        FilePath filePath = data2.getClmFilePath();
        if (filePath == null) {
            LOG.error("[unregisterTrackerInCLM] tracker is not registered");
            return;
        }
        ChangeListManagerImpl.getInstanceImpl(this.project).unregisterChangeTracker(filePath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
        data2.setClmFilePath(null);
        FilePath filePath2 = VcsUtil.getFilePath(virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)filePath2, (String)"getFilePath(virtualFile)");
        FilePath actualFilePath = filePath2;
        if (!Intrinsics.areEqual((Object)filePath, (Object)actualFilePath) && !wasUnbound) {
            LOG.error("[unregisterTrackerInCLM] unexpected file path: expected: " + filePath + ", actual: " + actualFilePath);
        }
    }

    static /* synthetic */ void unregisterTrackerInCLM$default(LineStatusTrackerManager lineStatusTrackerManager, TrackerData trackerData, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        lineStatusTrackerManager.unregisterTrackerInCLM(trackerData, bl);
    }

    private final void reregisterTrackerInCLM(TrackerData data2) {
        LocalLineStatusTracker<?> tracker = data2.getTracker();
        VirtualFile virtualFile = tracker.getVirtualFile();
        if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) {
            return;
        }
        LOG.assertTrue(virtualFile.isInLocalFileSystem(), (Object)virtualFile);
        FilePath oldFilePath = data2.getClmFilePath();
        FilePath filePath = VcsUtil.getFilePath(virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(virtualFile)");
        FilePath newFilePath = filePath;
        if (oldFilePath == null) {
            LOG.error("[reregisterTrackerInCLM] tracker is not registered");
            return;
        }
        if (!Intrinsics.areEqual((Object)oldFilePath, (Object)newFilePath)) {
            ChangeListManagerImpl.getInstanceImpl(this.project).unregisterChangeTracker(oldFilePath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
            ChangeListManagerImpl.getInstanceImpl(this.project).registerChangeTracker(newFilePath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
            data2.setClmFilePath(newFilePath);
        }
    }

    private final boolean canCreateTrackerFor(VirtualFile virtualFile, Document document2) {
        if (this.isDisposed) {
            return false;
        }
        return (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(virtualFile, document2){
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ Document $document;
            {
                this.$virtualFile = $virtualFile;
                this.$document = $document;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$virtualFile.isValid() && !this.$virtualFile.getFileType().isBinary() && !FileDocumentManager.getInstance().isPartialPreviewOfALargeFile(this.$document);
            }
        }));
    }

    @Override
    public boolean arePartialChangelistsEnabled() {
        boolean bl;
        block2: {
            if (!this.partialChangeListsEnabled) {
                return false;
            }
            AbstractVcs[] abstractVcsArray = ProjectLevelVcsManager.getInstance(this.project).getAllActiveVcss();
            Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getInstance(project).allActiveVcss");
            Object[] $this$any$iv = abstractVcsArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                AbstractVcs it = (AbstractVcs)element$iv;
                boolean bl2 = false;
                if (!it.arePartialChangelistsSupported()) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean arePartialChangelistsEnabled(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (!this.partialChangeListsEnabled) {
            return false;
        }
        AbstractVcs vcs = VcsUtil.getVcsFor(this.project, virtualFile);
        return vcs != null && vcs.arePartialChangelistsSupported();
    }

    private final void switchTracker(VirtualFile virtualFile, Document document2, boolean refreshExisting) {
        LocalLineStatusTracker<?> oldTracker;
        LocalLineStatusTrackerProvider provider = this.getTrackerProvider(virtualFile, document2);
        TrackerData trackerData = this.trackers.get(document2);
        LocalLineStatusTracker<Object> localLineStatusTracker = oldTracker = trackerData != null ? trackerData.getTracker() : null;
        if (oldTracker != null && provider != null && provider.isMyTracker(oldTracker)) {
            if (refreshExisting) {
                this.refreshTracker(oldTracker, provider);
            }
        } else {
            LineStatusTrackerManager.releaseTracker$default(this, document2, false, 2, null);
            if (provider != null) {
                this.installTracker(virtualFile, document2, provider);
            }
        }
    }

    static /* synthetic */ void switchTracker$default(LineStatusTrackerManager lineStatusTrackerManager, VirtualFile virtualFile, Document document2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        lineStatusTrackerManager.switchTracker(virtualFile, document2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LocalLineStatusTracker<?> installTracker(VirtualFile virtualFile, Document document2, LocalLineStatusTrackerProvider provider) {
        LocalLineStatusTracker<?> localLineStatusTracker;
        if (this.isDisposed) {
            return null;
        }
        if (this.trackers.get(document2) != null) {
            return null;
        }
        AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.allowSlowOperations((String)"vcs.line-status-tracker-provider");
        Throwable throwable = null;
        try {
            LocalLineStatusTracker<?> localLineStatusTracker2;
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            if (provider.createTracker(this.project, virtualFile) == null) {
                LocalLineStatusTracker<?> localLineStatusTracker3 = null;
                return localLineStatusTracker3;
            }
            localLineStatusTracker = localLineStatusTracker2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        LocalLineStatusTracker<?> tracker = localLineStatusTracker;
        tracker.setMode(this.getTrackingMode());
        TrackerData data2 = new TrackerData(tracker, null, null, 6, null);
        TrackerData replacedData = this.trackers.put(document2, data2);
        LOG.assertTrue(replacedData == null);
        this.registerTrackerInCLM(data2);
        this.refreshTracker(tracker, provider);
        ((Listener)this.eventDispatcher.getMulticaster()).onTrackerAdded((LineStatusTracker)tracker);
        if (this.clmFreezeCounter > 0) {
            tracker.freeze();
        }
        this.log("Tracker installed", virtualFile);
        return tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LocalLineStatusTrackerProvider getTrackerProvider(VirtualFile virtualFile, Document document2) {
        AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.allowSlowOperations((String)"vcs.line-status-tracker-provider");
        Throwable throwable = null;
        try {
            Object v1;
            block10: {
                AccessToken it = (AccessToken)autoCloseable;
                boolean bl = false;
                if (!this.canCreateTrackerFor(virtualFile, document2)) {
                    LocalLineStatusTrackerProvider localLineStatusTrackerProvider = null;
                    return localLineStatusTrackerProvider;
                }
                LocalLineStatusTrackerProvider localLineStatusTrackerProvider = (LocalLineStatusTrackerProvider)LocalLineStatusTrackerProvider.Companion.getEP_NAME$intellij_platform_vcs_impl().findFirstSafe(arg_0 -> LineStatusTrackerManager.getTrackerProvider$lambda$18$lambda$15((Function1)new Function1<LocalLineStatusTrackerProvider, Boolean>(this, virtualFile){
                    final /* synthetic */ LineStatusTrackerManager this$0;
                    final /* synthetic */ VirtualFile $virtualFile;
                    {
                        this.this$0 = $receiver;
                        this.$virtualFile = $virtualFile;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull LocalLineStatusTrackerProvider it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return it.isTrackedFile(LineStatusTrackerManager.access$getProject$p(this.this$0), this.$virtualFile);
                    }
                }, arg_0));
                if (localLineStatusTrackerProvider != null) {
                    LocalLineStatusTrackerProvider it2 = localLineStatusTrackerProvider;
                    boolean bl2 = false;
                    LocalLineStatusTrackerProvider localLineStatusTrackerProvider2 = it2;
                    return localLineStatusTrackerProvider2;
                }
                Object[] objectArray = new BaseRevisionStatusTrackerContentLoader[]{ChangelistsLocalStatusTrackerProvider.INSTANCE, DefaultLocalStatusTrackerProvider.INSTANCE};
                Iterable iterable = CollectionsKt.listOf((Object[])objectArray);
                for (Object t : iterable) {
                    BaseRevisionStatusTrackerContentLoader it3 = (BaseRevisionStatusTrackerContentLoader)t;
                    boolean bl3 = false;
                    if (!it3.isTrackedFile(this.project, virtualFile)) continue;
                    v1 = t;
                    break block10;
                }
                v1 = null;
            }
            LocalLineStatusTrackerProvider localLineStatusTrackerProvider = v1;
            return localLineStatusTrackerProvider;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @RequiresEdt
    private final void releaseTracker(Document document2, boolean wasUnbound) {
        TrackerData trackerData = this.trackers.remove(document2);
        if (trackerData == null) {
            return;
        }
        TrackerData data2 = trackerData;
        ((Listener)this.eventDispatcher.getMulticaster()).onTrackerRemoved((LineStatusTracker)data2.getTracker());
        this.unregisterTrackerInCLM(data2, wasUnbound);
        data2.getTracker().release();
        this.log("Tracker released", data2.getTracker().getVirtualFile());
    }

    static /* synthetic */ void releaseTracker$default(LineStatusTrackerManager lineStatusTrackerManager, Document document2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        lineStatusTrackerManager.releaseTracker(document2, bl);
    }

    private final void updatePartialChangeListsAvailability() {
        this.partialChangeListsEnabled = VcsApplicationSettings.getInstance().ENABLE_PARTIAL_CHANGELISTS && ChangeListManager.getInstance(this.project).areChangeListsEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateTrackingSettings() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            if (this.isDisposed) {
                return;
            }
            LocalLineStatusTracker.Mode mode = this.getTrackingMode();
            for (TrackerData data2 : this.trackers.values()) {
                data2.getTracker().setMode(mode);
            }
            Unit unit = Unit.INSTANCE;
        }
        this.onEverythingChanged();
    }

    private final LocalLineStatusTracker.Mode getTrackingMode() {
        VcsApplicationSettings settings = VcsApplicationSettings.getInstance();
        return new LocalLineStatusTracker.Mode(settings.SHOW_LST_GUTTER_MARKERS, settings.SHOW_LST_ERROR_STRIPE_MARKERS, settings.SHOW_WHITESPACES_IN_LST);
    }

    @RequiresEdt
    private final void refreshTracker(LocalLineStatusTracker<?> tracker, LocalLineStatusTrackerProvider provider) {
        if (this.isDisposed) {
            return;
        }
        if (!(provider instanceof LineStatusTrackerContentLoader)) {
            return;
        }
        this.loader.scheduleRefresh(new RefreshRequest(tracker.getDocument(), (LineStatusTrackerContentLoader)provider));
        this.log("Refresh queued", tracker.getVirtualFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RequiresEdt
    @ApiStatus.Internal
    public final void offerTrackerContent(@NotNull Document document2, @NotNull CharSequence text2) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            try {
                String string2;
                void this_$iv;
                LocalLineStatusTracker<?> tracker = null;
                Object object = this.LOCK;
                synchronized (object) {
                    boolean bl = false;
                    TrackerData data2 = this.trackers.get(document2);
                    if (data2 == null || data2.getContentInfo() != null) {
                        return;
                    }
                    tracker = data2.getTracker();
                    Unit $i$a$-synchronized-LineStatusTrackerManager$offerTrackerContent$2 = Unit.INSTANCE;
                }
                if (!(tracker instanceof LocalLineStatusTrackerImpl)) break block13;
                ClientId.Companion companion = ClientId.Companion;
                ClientId clientId$iv = ClientId.Companion.getLocalId();
                boolean $i$f$withClientId = false;
                ClientIdService clientIdService = this_$iv.getCachedService();
                if (clientIdService == null) {
                    boolean bl = false;
                    ((LocalLineStatusTrackerImpl)tracker).setBaseRevision(text2);
                    this.log("Offered content", tracker.getVirtualFile());
                    break block13;
                }
                ClientIdService service$iv = clientIdService;
                if (service$iv.isValid(clientId$iv)) {
                    ClientId clientId = clientId$iv;
                    string2 = clientId != null ? clientId.getValue() : null;
                } else {
                    Logger $this$trace$iv$iv = this_$iv.getClientIdLogger();
                    boolean $i$f$trace = false;
                    if ($this$trace$iv$iv.isTraceEnabled()) {
                        Logger logger = $this$trace$iv$iv;
                        boolean bl = false;
                        logger.trace("Invalid ClientId " + clientId$iv + " replaced with null at " + new Throwable().fillInStackTrace());
                    }
                    string2 = null;
                }
                String newClientIdValue$iv = string2;
                String oldClientIdValue$iv = service$iv.getClientIdValue();
                try {
                    service$iv.setClientIdValue(newClientIdValue$iv);
                    boolean bl = false;
                    ((LocalLineStatusTrackerImpl)tracker).setBaseRevision(text2);
                    this.log("Offered content", tracker.getVirtualFile());
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    service$iv.setClientIdValue(oldClientIdValue$iv);
                }
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    private final void log(@NonNls String message2, VirtualFile file) {
        if (LOG.isDebugEnabled()) {
            if (file != null) {
                LOG.debug(message2 + "; file: " + file.getPath());
            } else {
                LOG.debug(message2);
            }
        }
    }

    private final void warn(@NonNls String message2, Document document2) {
        VirtualFile virtualFile;
        Document document3 = document2;
        if (document3 != null) {
            Document it = document3;
            boolean bl = false;
            virtualFile = FileDocumentManager.getInstance().getFile(it);
        } else {
            virtualFile = null;
        }
        VirtualFile file = virtualFile;
        this.warn(message2, file);
    }

    private final void warn(@NonNls String message2, VirtualFile file) {
        if (file != null) {
            LOG.warn(message2 + "; file: " + file.getPath());
        } else {
            LOG.warn(message2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final void resetExcludedFromCommitMarkers() {
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            List documents = new ArrayList();
            for (TrackerData data2 : this.trackers.values()) {
                LocalLineStatusTracker<?> tracker = data2.getTracker();
                if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) continue;
                ((ChangelistsLocalLineStatusTracker)tracker).resetExcludedFromCommitMarkers$intellij_platform_vcs_impl();
                documents.add(tracker.getDocument());
            }
            for (Document document2 : documents) {
                this.checkIfTrackerCanBeReleased(document2);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<ChangelistsLocalLineStatusTracker.FullState> collectPartiallyChangedFilesStates$intellij_platform_vcs_impl() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        List result2 = new ArrayList();
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            for (TrackerData data2 : this.trackers.values()) {
                boolean hasPartialChanges;
                LocalLineStatusTracker<?> tracker = data2.getTracker();
                if (!(tracker instanceof ChangelistsLocalLineStatusTracker) || !(hasPartialChanges = ((ChangelistsLocalLineStatusTracker)tracker).getAffectedChangeListsIds().size() > 1)) continue;
                result2.add(((ChangelistsLocalLineStatusTracker)tracker).storeTrackerState$intellij_platform_vcs_impl());
            }
            Unit unit = Unit.INSTANCE;
        }
        return result2;
    }

    @RequiresEdt
    public final void restoreTrackersForPartiallyChangedFiles$intellij_platform_vcs_impl(@NotNull List<? extends ChangelistsLocalLineStatusTracker.State> trackerStates) {
        Intrinsics.checkNotNullParameter(trackerStates, (String)"trackerStates");
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this, trackerStates){
            final /* synthetic */ LineStatusTrackerManager this$0;
            final /* synthetic */ List<ChangelistsLocalLineStatusTracker.State> $trackerStates;
            {
                this.this$0 = $receiver;
                this.$trackerStates = $trackerStates;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0);
                LineStatusTrackerManager lineStatusTrackerManager = this.this$0;
                List<ChangelistsLocalLineStatusTracker.State> list = this.$trackerStates;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    if (LineStatusTrackerManager.access$isDisposed$p(lineStatusTrackerManager)) {
                        return;
                    }
                    for (ChangelistsLocalLineStatusTracker.State state : list) {
                        Document document2;
                        VirtualFile virtualFile = state.getVirtualFile();
                        if (FileDocumentManager.getInstance().getDocument(virtualFile) == null) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"FileDocumentManager.getI\u2026(virtualFile) ?: continue");
                        LocalLineStatusTrackerProvider provider = LineStatusTrackerManager.access$getTrackerProvider(lineStatusTrackerManager, virtualFile, document2);
                        if (!Intrinsics.areEqual((Object)provider, (Object)ChangelistsLocalStatusTrackerProvider.INSTANCE)) continue;
                        LineStatusTrackerManager.switchTracker$default(lineStatusTrackerManager, virtualFile, document2, false, 4, null);
                        TrackerData trackerData = (TrackerData)LineStatusTrackerManager.access$getTrackers$p(lineStatusTrackerManager).get(document2);
                        LocalLineStatusTracker<Object> tracker = trackerData != null ? trackerData.getTracker() : null;
                        if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) continue;
                        boolean isLoading = LineStatusTrackerManager.access$getLoader$p(lineStatusTrackerManager).hasRequestFor(document2);
                        if (isLoading) {
                            LineStatusTrackerManager.access$getFileStatesAwaitingRefresh$p(lineStatusTrackerManager).put(state.getVirtualFile(), state);
                            LineStatusTrackerManager.access$log(lineStatusTrackerManager, "State restoration scheduled", virtualFile);
                            continue;
                        }
                        boolean success2 = ((ChangelistsLocalLineStatusTracker)tracker).restoreState$intellij_platform_vcs_impl(state);
                        LineStatusTrackerManager.access$log(lineStatusTrackerManager, "State restored. success - " + success2, virtualFile);
                    }
                    LineStatusTrackerManager.access$getLoader$p(lineStatusTrackerManager).addAfterUpdateRunnable(() -> restoreTrackersForPartiallyChangedFiles.1.invoke$lambda$2$lambda$1(lineStatusTrackerManager));
                    Unit unit = Unit.INSTANCE;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final void invoke$lambda$2$lambda$1(LineStatusTrackerManager this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Object object = LineStatusTrackerManager.access$getLOCK$p(this$0);
                synchronized (object) {
                    boolean bl = false;
                    LineStatusTrackerManager.access$log(this$0, "State restoration finished", null);
                    LineStatusTrackerManager.access$getFileStatesAwaitingRefresh$p(this$0).clear();
                    Unit unit = Unit.INSTANCE;
                }
            }
        }));
        this.onEverythingChanged();
    }

    @RequiresEdt
    public final void notifyInactiveRangesDamaged$intellij_platform_vcs_impl(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        if (this.filesWithDamagedInactiveRanges.contains(virtualFile) || Intrinsics.areEqual((Object)virtualFile, (Object)FileEditorManagerEx.Companion.getInstanceEx(this.project).getCurrentFile())) {
            return;
        }
        this.filesWithDamagedInactiveRanges.add(virtualFile);
    }

    private final void showInactiveRangesDamagedNotification() {
        InactiveRangesDamagedNotification lastNotification;
        InactiveRangesDamagedNotification it;
        InactiveRangesDamagedNotification element$iv;
        int n;
        InactiveRangesDamagedNotification[] currentNotifications;
        block4: {
            InactiveRangesDamagedNotification inactiveRangesDamagedNotification;
            Notification[] notificationArray = NotificationsManager.getNotificationsManager().getNotificationsOfType(InactiveRangesDamagedNotification.class, this.project);
            Intrinsics.checkNotNullExpressionValue((Object)notificationArray, (String)"getNotificationsManager(\u2026ion::class.java, project)");
            InactiveRangesDamagedNotification[] $this$lastOrNull$iv = currentNotifications = (InactiveRangesDamagedNotification[])notificationArray;
            boolean $i$f$lastOrNull = false;
            n = $this$lastOrNull$iv.length + -1;
            if (0 <= n) {
                do {
                    int index$iv = n--;
                    it = element$iv = $this$lastOrNull$iv[index$iv];
                    boolean bl = false;
                    if (!(!it.isExpired())) continue;
                    inactiveRangesDamagedNotification = element$iv;
                    break block4;
                } while (0 <= n);
            }
            inactiveRangesDamagedNotification = lastNotification = null;
        }
        if (lastNotification != null) {
            this.filesWithDamagedInactiveRanges.addAll((Collection<VirtualFile>)lastNotification.getVirtualFiles());
        }
        InactiveRangesDamagedNotification[] $this$forEach$iv = currentNotifications;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            it.expire();
        }
        Set files2 = CollectionsKt.toSet((Iterable)this.filesWithDamagedInactiveRanges);
        this.filesWithDamagedInactiveRanges.clear();
        new InactiveRangesDamagedNotification(this.project, files2).notify(this.project);
    }

    @RequiresEdt
    private final void expireInactiveRangesDamagedNotifications() {
        InactiveRangesDamagedNotification[] currentNotifications;
        this.filesWithDamagedInactiveRanges.clear();
        Notification[] notificationArray = NotificationsManager.getNotificationsManager().getNotificationsOfType(InactiveRangesDamagedNotification.class, this.project);
        Intrinsics.checkNotNullExpressionValue((Object)notificationArray, (String)"getNotificationsManager(\u2026ion::class.java, project)");
        InactiveRangesDamagedNotification[] $this$forEach$iv = currentNotifications = (InactiveRangesDamagedNotification[])notificationArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            InactiveRangesDamagedNotification element$iv;
            InactiveRangesDamagedNotification it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            it.expire();
        }
    }

    @TestOnly
    public final void waitUntilBaseContentsLoaded() {
        boolean bl = ApplicationManager.getApplication().isUnitTestMode();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            UIUtil.dispatchAllInvocationEvents();
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.loader.addAfterUpdateRunnable(() -> LineStatusTrackerManager.waitUntilBaseContentsLoaded$lambda$28(semaphore));
        long start2 = System.currentTimeMillis();
        do {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                UIUtil.dispatchAllInvocationEvents();
            }
            if (!semaphore.waitFor(10L)) continue;
            return;
        } while (System.currentTimeMillis() - start2 <= 10000L);
        this.loader.dumpInternalState();
        System.err.println(ThreadDumper.dumpThreadsToString());
        throw new IllegalStateException("Couldn't await base contents");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final void releaseAllTrackers() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            this.forcedDocuments.clear();
            for (TrackerData data2 : this.trackers.values()) {
                Intrinsics.checkNotNullExpressionValue((Object)data2, (String)"data");
                LineStatusTrackerManager.unregisterTrackerInCLM$default(this, data2, false, 2, null);
                data2.getTracker().release();
            }
            this.trackers.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void startListenForEditors$lambda$0(LineStatusTrackerManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateTrackingSettings();
    }

    private static final void startListenForEditors$lambda$1(LineStatusTrackerManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onEverythingChanged();
    }

    private static final void startListenForEditors$lambda$2(LineStatusTrackerManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.project.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)this$0.new MyApplicationListener(), (Disposable)this$0);
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)this$0.new MyDocumentListener(), (Disposable)this$0);
        this$0.new MyEditorFactoryListener().install(this$0);
        this$0.onEverythingChanged();
        PartialLineStatusTrackerManagerState.Companion.restoreState$intellij_platform_vcs_impl(this$0.project);
    }

    private static final Multiset requestTrackerFor$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Multiset)$tmp0.invoke(p0);
    }

    private static final boolean getTrackerProvider$lambda$18$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void waitUntilBaseContentsLoaded$lambda$28(Semaphore $semaphore) {
        Intrinsics.checkNotNullParameter((Object)$semaphore, (String)"$semaphore");
        $semaphore.up();
    }

    @JvmStatic
    @NotNull
    public static final LineStatusTrackerManagerI getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @JvmStatic
    @NotNull
    public static final LineStatusTrackerManager getInstanceImpl(@NotNull Project project2) {
        return Companion.getInstanceImpl(project2);
    }

    public static final /* synthetic */ void access$reregisterTrackerInCLM(LineStatusTrackerManager $this, TrackerData data2) {
        $this.reregisterTrackerInCLM(data2);
    }

    public static final /* synthetic */ void access$expireInactiveRangesDamagedNotifications(LineStatusTrackerManager $this) {
        $this.expireInactiveRangesDamagedNotifications();
    }

    public static final /* synthetic */ int access$getClmFreezeCounter$p(LineStatusTrackerManager $this) {
        return $this.clmFreezeCounter;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$setClmFreezeCounter$p(LineStatusTrackerManager $this, int n) {
        $this.clmFreezeCounter = n;
    }

    public static final /* synthetic */ MyBaseRevisionLoader access$getLoader$p(LineStatusTrackerManager $this) {
        return $this.loader;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LineStatusTrackerManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$BaseContentProviderListener;", "Lcom/intellij/openapi/vcs/impl/VcsBaseContentProviderListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "onEverythingChanged", "", "onFileBaseContentChanged", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.vcs.impl"})
    private final class BaseContentProviderListener
    implements VcsBaseContentProviderListener {
        @Override
        public void onFileBaseContentChanged(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(LineStatusTrackerManager.this, file){
                final /* synthetic */ LineStatusTrackerManager this$0;
                final /* synthetic */ VirtualFile $file;
                {
                    this.this$0 = $receiver;
                    this.$file = $file;
                    super(0);
                }

                public final void invoke() {
                    LineStatusTrackerManager.access$onFileChanged(this.this$0, this.$file);
                }
            }), (int)1, null);
        }

        @Override
        public void onEverythingChanged() {
            ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ BaseContentProviderListener this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.onEverythingChanged();
                }
            }), (int)1, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$CheckinFactory;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandlerFactory;", "()V", "createHandler", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "panel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "intellij.platform.vcs.impl"})
    public static final class CheckinFactory
    extends CheckinHandlerFactory {
        @Override
        @NotNull
        public CheckinHandler createHandler(@NotNull CheckinProjectPanel panel2, @NotNull CommitContext commitContext) {
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            Intrinsics.checkNotNullParameter((Object)((Object)commitContext), (String)"commitContext");
            Project project2 = panel2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"panel.project");
            Project project3 = project2;
            return new CheckinHandler(project3, panel2){
                final /* synthetic */ Project $project;
                final /* synthetic */ CheckinProjectPanel $panel;
                {
                    this.$project = $project;
                    this.$panel = $panel;
                }

                public void checkinSuccessful() {
                    this.resetExcludedFromCommit();
                }

                public void checkinFailed(@Nullable List<VcsException> exception) {
                    this.resetExcludedFromCommit();
                }

                private final void resetExcludedFromCommit() {
                    ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this.$project, this.$panel){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ CheckinProjectPanel $panel;
                        {
                            this.$project = $project;
                            this.$panel = $panel;
                            super(0);
                        }

                        public final void invoke() {
                            if (!this.$project.isDisposed() && !AbstractCommitWorkflowHandlerKt.isNonModalCommit(this.$panel)) {
                                LineStatusTrackerManager.Companion.getInstanceImpl(this.$project).resetExcludedFromCommitMarkers();
                            }
                        }
                    }), (int)1, null);
                }
            };
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManagerI;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceImpl", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nLineStatusTrackerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,1478:1\n29#2,3:1479\n*S KotlinDebug\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Companion\n*L\n100#1:1479,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LineStatusTrackerManagerI getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<LineStatusTrackerManagerI> serviceClass$iv = LineStatusTrackerManagerI.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            return (LineStatusTrackerManagerI)object;
        }

        @JvmStatic
        @NotNull
        public final LineStatusTrackerManager getInstanceImpl(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            LineStatusTrackerManagerI lineStatusTrackerManagerI = this.getInstance(project2);
            Intrinsics.checkNotNull((Object)lineStatusTrackerManagerI, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.impl.LineStatusTrackerManager");
            return (LineStatusTrackerManager)lineStatusTrackerManagerI;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$InactiveRangesDamagedNotification;", "Lcom/intellij/notification/Notification;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "getVirtualFiles", "()Ljava/util/Set;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nLineStatusTrackerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager$InactiveRangesDamagedNotification\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1478:1\n766#2:1479\n857#2,2:1480\n*S KotlinDebug\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager$InactiveRangesDamagedNotification\n*L\n1105#1:1479\n1105#1:1480,2\n*E\n"})
    private static final class InactiveRangesDamagedNotification
    extends Notification {
        @NotNull
        private final Set<VirtualFile> virtualFiles;

        public InactiveRangesDamagedNotification(@NotNull Project project2, @NotNull Set<? extends VirtualFile> virtualFiles2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(virtualFiles2, (String)"virtualFiles");
            super(VcsNotifier.STANDARD_NOTIFICATION.getDisplayId(), VcsBundle.message("lst.inactive.ranges.damaged.notification", new Object[0]), NotificationType.INFORMATION);
            this.virtualFiles = virtualFiles2;
            this.setIcon(AllIcons.Toolwindows.ToolWindowChanges);
            this.setDisplayId("vcs.inactive.ranges.damaged");
            this.addAction((AnAction)NotificationAction.createSimple(InactiveRangesDamagedNotification::_init_$lambda$0, () -> InactiveRangesDamagedNotification._init_$lambda$3(project2, this)));
        }

        @NotNull
        public final Set<VirtualFile> getVirtualFiles() {
            return this.virtualFiles;
        }

        private static final String _init_$lambda$0() {
            return VcsBundle.message("action.NotificationAction.InactiveRangesDamagedNotification.text.view.changes", new Object[0]);
        }

        private static final void lambda$3$lambda$2(Project $project, List $changes) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$changes, (String)"$changes");
            ChangesViewManager.getInstance($project).selectChanges($changes);
        }

        /*
         * WARNING - void declaration
         */
        private static final void _init_$lambda$3(Project $project, InactiveRangesDamagedNotification this$0) {
            ToolWindow window;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            LocalChangeList localChangeList = ChangeListManager.getInstance($project).getDefaultChangeList();
            Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getInstance(project).defaultChangeList");
            LocalChangeList defaultList = localChangeList;
            Collection<Change> collection = defaultList.getChanges();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"defaultList.changes");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Change it = (Change)element$iv$iv;
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)this$0.virtualFiles, (Object)it.getVirtualFile())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List changes = (List)destination$iv$iv;
            ToolWindow toolWindow = window = ChangesViewContentManager.Companion.getToolWindowFor($project, "Local Changes");
            if (toolWindow != null) {
                toolWindow.activate(() -> InactiveRangesDamagedNotification.lambda$3$lambda$2($project, changes));
            }
            this$0.expire();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\u0014\u0010\u0006\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Listener;", "Ljava/util/EventListener;", "onTrackerAdded", "", "tracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "onTrackerRemoved", "intellij.platform.vcs.impl"})
    public static interface Listener
    extends EventListener {
        default public void onTrackerAdded(@NotNull LineStatusTracker<?> tracker) {
            Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        }

        default public void onTrackerRemoved(@NotNull LineStatusTracker<?> tracker) {
            Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ListenerAdapter;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Listener;", "()V", "intellij.platform.vcs.impl"})
    public static class ListenerAdapter
    implements Listener {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyApplicationListener;", "Lcom/intellij/openapi/application/ApplicationListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "afterWriteActionFinished", "", "action", "", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nLineStatusTrackerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyApplicationListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1478:1\n1549#2:1479\n1620#2,3:1480\n*S KotlinDebug\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyApplicationListener\n*L\n820#1:1479\n820#1:1480,3\n*E\n"})
    private final class MyApplicationListener
    implements ApplicationListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void afterWriteActionFinished(@NotNull Object action2) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            LineStatusTrackerManager.this.documentsInDefaultChangeList.clear();
            Object object = LineStatusTrackerManager.this.LOCK;
            LineStatusTrackerManager lineStatusTrackerManager = LineStatusTrackerManager.this;
            Object object2 = object;
            synchronized (object2) {
                void $this$mapTo$iv$iv;
                boolean bl = false;
                Collection collection = lineStatusTrackerManager.trackers.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"trackers.values");
                Iterable $this$map$iv = collection;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    TrackerData trackerData = (TrackerData)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    collection2.add(it.getTracker().getDocument());
                }
                List documents = (List)destination$iv$iv;
                for (Document document2 : documents) {
                    lineStatusTrackerManager.checkIfTrackerCanBeReleased(document2);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0015J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyBaseRevisionLoader;", "Lcom/intellij/openapi/vcs/impl/SingleThreadLoader;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshRequest;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshData;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "handleCanceled", "", "document", "Lcom/intellij/openapi/editor/Document;", "handleError", "request", "handleResult", "result", "Lcom/intellij/openapi/vcs/impl/Result;", "handleSuccess", "refreshData", "hasRequestFor", "", "loadRequest", "restorePendingTrackerState", "intellij.platform.vcs.impl"})
    private final class MyBaseRevisionLoader
    extends SingleThreadLoader<RefreshRequest, RefreshData> {
        public final boolean hasRequestFor(@NotNull Document document2) {
            Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
            return this.hasRequest((Function1)new Function1<RefreshRequest, Boolean>(document2){
                final /* synthetic */ Document $document;
                {
                    this.$document = $document;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull RefreshRequest it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getDocument(), (Object)this.$document);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected Result<RefreshData> loadRequest(@NotNull RefreshRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            if (LineStatusTrackerManager.this.isDisposed) {
                return new Result.Canceled();
            }
            Document document2 = request.getDocument();
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document2);
            LineStatusTrackerContentLoader loader2 = request.getLoader();
            LineStatusTrackerManager.this.log("Loading started", virtualFile);
            if (virtualFile == null || !virtualFile.isValid()) {
                LineStatusTrackerManager.this.log("Loading error: virtual file is not valid", virtualFile);
                return new Result.Error();
            }
            if (!LineStatusTrackerManager.this.canCreateTrackerFor(virtualFile, document2) || !loader2.isTrackedFile(LineStatusTrackerManager.this.project, virtualFile)) {
                LineStatusTrackerManager.this.log("Loading error: virtual file is not a tracked file", virtualFile);
                return new Result.Error();
            }
            LineStatusTrackerContentLoader.ContentInfo newContentInfo = loader2.getContentInfo(LineStatusTrackerManager.this.project, virtualFile);
            if (newContentInfo == null) {
                LineStatusTrackerManager.this.log("Loading error: base revision not found", virtualFile);
                return new Result.Error();
            }
            Object object = LineStatusTrackerManager.this.LOCK;
            LineStatusTrackerManager lineStatusTrackerManager = LineStatusTrackerManager.this;
            Object object2 = object;
            synchronized (object2) {
                block11: {
                    TrackerData data2;
                    block10: {
                        boolean bl = false;
                        data2 = (TrackerData)lineStatusTrackerManager.trackers.get(document2);
                        if (data2 != null) break block10;
                        lineStatusTrackerManager.log("Loading cancelled: tracker not found", virtualFile);
                        Result result2 = new Result.Canceled();
                        return result2;
                    }
                    if (loader2.shouldBeUpdated(data2.getContentInfo(), newContentInfo)) break block11;
                    lineStatusTrackerManager.log("Loading cancelled: no need to update", virtualFile);
                    Result result3 = new Result.Canceled();
                    return result3;
                }
                Unit unit = Unit.INSTANCE;
            }
            LineStatusTrackerContentLoader.TrackerContent content = loader2.loadContent(LineStatusTrackerManager.this.project, newContentInfo);
            if (content == null) {
                LineStatusTrackerManager.this.log("Loading error: provider failure", virtualFile);
                return new Result.Error();
            }
            LineStatusTrackerManager.this.log("Loading successful", virtualFile);
            return new Result.Success<RefreshData>(new RefreshData(content, newContentInfo));
        }

        @Override
        @RequiresEdt
        protected void handleResult(@NotNull RefreshRequest request, @NotNull Result<RefreshData> result2) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            Document document2 = request.getDocument();
            Result<RefreshData> result3 = result2;
            if (result3 instanceof Result.Canceled) {
                this.handleCanceled(document2);
            } else if (result3 instanceof Result.Error) {
                this.handleError(request, document2);
            } else if (result3 instanceof Result.Success) {
                this.handleSuccess(request, document2, (RefreshData)((Result.Success)result2).getData());
            }
            LineStatusTrackerManager.this.checkIfTrackerCanBeReleased(document2);
        }

        private final void handleCanceled(Document document2) {
            this.restorePendingTrackerState(document2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleError(RefreshRequest request, Document document2) {
            Object object = LineStatusTrackerManager.this.LOCK;
            LineStatusTrackerManager lineStatusTrackerManager = LineStatusTrackerManager.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                LineStatusTrackerContentLoader loader2 = request.getLoader();
                TrackerData trackerData = (TrackerData)lineStatusTrackerManager.trackers.get(document2);
                if (trackerData == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)trackerData, (String)"trackers[document] ?: return");
                TrackerData data2 = trackerData;
                LocalLineStatusTracker<?> tracker = data2.getTracker();
                if (loader2.isMyTracker(tracker)) {
                    loader2.handleLoadingError(tracker);
                }
                data2.setContentInfo(null);
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleSuccess(RefreshRequest request, Document document2, RefreshData refreshData) {
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document2);
            if (virtualFile == null) {
                LineStatusTrackerManager.this.log("Loading finished: document is not bound", null);
                return;
            }
            LineStatusTrackerContentLoader loader2 = request.getLoader();
            LocalLineStatusTracker<?> tracker = null;
            Object object = LineStatusTrackerManager.this.LOCK;
            LineStatusTrackerManager lineStatusTrackerManager = LineStatusTrackerManager.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                TrackerData data2 = (TrackerData)lineStatusTrackerManager.trackers.get(document2);
                if (data2 == null) {
                    lineStatusTrackerManager.log("Loading finished: tracker already released", virtualFile);
                    return;
                }
                tracker = data2.getTracker();
                if (!loader2.isMyTracker(tracker)) {
                    lineStatusTrackerManager.log("Loading finished: wrong tracker. tracker: " + tracker + ", loader: " + loader2, virtualFile);
                    return;
                }
                if (!loader2.shouldBeUpdated(data2.getContentInfo(), refreshData.getContentInfo())) {
                    lineStatusTrackerManager.log("Loading finished: no need to update", virtualFile);
                    return;
                }
                data2.setContentInfo(refreshData.getContentInfo());
                Unit unit = Unit.INSTANCE;
            }
            LineStatusTrackerManager.this.log("Loading finished: applying content", virtualFile);
            loader2.setLoadedContent(tracker, refreshData.getContent());
            LineStatusTrackerManager.this.log("Loading finished: success", virtualFile);
            this.restorePendingTrackerState(document2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void restorePendingTrackerState(Document document2) {
            LineStatusTracker<?> tracker = LineStatusTrackerManager.this.getLineStatusTracker(document2);
            if (tracker instanceof ChangelistsLocalLineStatusTracker) {
                ChangelistsLocalLineStatusTracker.State state;
                VirtualFile virtualFile = tracker.getVirtualFile();
                Object object = LineStatusTrackerManager.this.LOCK;
                LineStatusTrackerManager lineStatusTrackerManager = LineStatusTrackerManager.this;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    ChangelistsLocalLineStatusTracker.State state2 = (ChangelistsLocalLineStatusTracker.State)lineStatusTrackerManager.fileStatesAwaitingRefresh.remove(virtualFile);
                    if (state2 == null) {
                        return;
                    }
                    ChangelistsLocalLineStatusTracker.State state3 = state2;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl16 : MonitorExitStatement: MONITOREXIT : var8_6
                    state = state3;
                }
                Intrinsics.checkNotNullExpressionValue((Object)state, (String)"synchronized(LOCK) {\n   \u2026File) ?: return\n        }");
                ChangelistsLocalLineStatusTracker.State state4 = state;
                boolean success2 = ((ChangelistsLocalLineStatusTracker)tracker).restoreState$intellij_platform_vcs_impl(state4);
                LineStatusTrackerManager.this.log("Pending state restored. success - " + success2, virtualFile);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyChangeListAvailabilityListener;", "Lcom/intellij/openapi/vcs/changes/ChangeListAvailabilityListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "onAfter", "", "onBefore", "intellij.platform.vcs.impl"})
    private final class MyChangeListAvailabilityListener
    implements ChangeListAvailabilityListener {
        @Override
        public void onBefore() {
            List<ChangelistsLocalLineStatusTracker.FullState> fileStates;
            if (ChangeListManager.getInstance(LineStatusTrackerManager.this.project).areChangeListsEnabled() && !((Collection)(fileStates = Companion.getInstanceImpl(LineStatusTrackerManager.this.project).collectPartiallyChangedFilesStates$intellij_platform_vcs_impl())).isEmpty()) {
                PartialLineStatusTrackerManagerState.Companion.saveCurrentState$intellij_platform_vcs_impl(LineStatusTrackerManager.this.project, fileStates);
            }
        }

        @Override
        public void onAfter() {
            LineStatusTrackerManager.this.updatePartialChangeListsAvailability();
            LineStatusTrackerManager.this.onEverythingChanged();
            if (ChangeListManager.getInstance(LineStatusTrackerManager.this.project).areChangeListsEnabled()) {
                PartialLineStatusTrackerManagerState.Companion.restoreState$intellij_platform_vcs_impl(LineStatusTrackerManager.this.project);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyChangeListListener;", "Lcom/intellij/openapi/vcs/changes/ChangeListAdapter;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "defaultListChanged", "", "oldDefaultList", "Lcom/intellij/openapi/vcs/changes/ChangeList;", "newDefaultList", "intellij.platform.vcs.impl"})
    private final class MyChangeListListener
    extends ChangeListAdapter {
        @Override
        public void defaultListChanged(@Nullable ChangeList oldDefaultList, @Nullable ChangeList newDefaultList) {
            ActionsKt.runInEdt((ModalityState)ModalityState.any(), (Function0)((Function0)new Function0<Unit>(LineStatusTrackerManager.this){
                final /* synthetic */ LineStatusTrackerManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    if (LineStatusTrackerManager.access$getProject$p(this.this$0).isDisposed()) {
                        return;
                    }
                    LineStatusTrackerManager.access$expireInactiveRangesDamagedNotifications(this.this$0);
                    Editor[] editorArray = EditorFactory.getInstance().getAllEditors();
                    Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getInstance().allEditors");
                    Object[] $this$forEach$iv = editorArray;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Editor it = (Editor)element$iv;
                        boolean bl = false;
                        if (!(it instanceof EditorEx)) continue;
                        ((EditorEx)it).getGutterComponentEx().repaint();
                    }
                }
            }));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyCommandListener;", "Lcom/intellij/openapi/command/CommandListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "commandFinished", "", "event", "Lcom/intellij/openapi/command/CommandEvent;", "intellij.platform.vcs.impl"})
    private final class MyCommandListener
    implements CommandListener {
        public void commandFinished(@NotNull CommandEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled) {
                return;
            }
            if (CommandProcessor.getInstance().getCurrentCommand() == null && !LineStatusTrackerManager.this.filesWithDamagedInactiveRanges.isEmpty()) {
                LineStatusTrackerManager.this.showInactiveRangesDamagedNotification();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "intellij.platform.vcs.impl"})
    private final class MyDocumentListener
    implements DocumentListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentChanged(@NotNull DocumentEvent event) {
            boolean inAnotherChangelist;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                return;
            }
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled || LineStatusTrackerManager.this.project.isDisposed()) {
                return;
            }
            Document document2 = event.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"event.document");
            Document document3 = document2;
            if (LineStatusTrackerManager.this.documentsInDefaultChangeList.contains(document3)) {
                return;
            }
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document3);
            if (virtualFile == null) {
                return;
            }
            VirtualFile virtualFile2 = virtualFile;
            if (LineStatusTrackerManager.this.getLineStatusTracker(document3) != null) {
                return;
            }
            LocalLineStatusTrackerProvider provider = LineStatusTrackerManager.this.getTrackerProvider(virtualFile2, document3);
            if (!Intrinsics.areEqual((Object)provider, (Object)ChangelistsLocalStatusTrackerProvider.INSTANCE)) {
                return;
            }
            LocalChangeList changeList = ChangeListManager.getInstance(LineStatusTrackerManager.this.project).getChangeList(virtualFile2);
            boolean bl = inAnotherChangelist = changeList != null && !ActiveChangeListTracker.Companion.getInstance(LineStatusTrackerManager.this.project).isActiveChangeList(changeList);
            if (inAnotherChangelist) {
                LocalLineStatusTracker localLineStatusTracker;
                LineStatusTrackerManager.this.log("Tracker install from DocumentListener: ", virtualFile2);
                Object object = LineStatusTrackerManager.this.LOCK;
                LineStatusTrackerManager lineStatusTrackerManager = LineStatusTrackerManager.this;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl2 = false;
                    localLineStatusTracker = lineStatusTrackerManager.installTracker(virtualFile2, document3, provider);
                }
                LocalLineStatusTracker tracker = localLineStatusTracker;
                if (tracker instanceof ChangelistsLocalLineStatusTracker) {
                    ((ChangelistsLocalLineStatusTracker)tracker).replayChangesFromDocumentEvents(CollectionsKt.listOf((Object)event));
                }
            } else {
                LineStatusTrackerManager.this.documentsInDefaultChangeList.add(document3);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyEditorFactoryListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "editorReleased", "install", "disposable", "Lcom/intellij/openapi/Disposable;", "isTrackedEditor", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.vcs.impl"})
    private final class MyEditorFactoryListener
    implements EditorFactoryListener {
        public final void install(@NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            EditorFactory editorFactory = EditorFactory.getInstance();
            Editor[] editorArray = editorFactory.getAllEditors();
            Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"editorFactory.allEditors");
            for (Editor editor : editorArray) {
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"editor");
                if (!this.isTrackedEditor(editor)) continue;
                Document document2 = editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"editor.document");
                LineStatusTrackerManager.this.requestTrackerFor(document2, editor);
            }
            editorFactory.addEditorFactoryListener((EditorFactoryListener)this, disposable);
        }

        public void editorCreated(@NotNull EditorFactoryEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Editor editor = event.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"event.editor");
            Editor editor2 = editor;
            if (this.isTrackedEditor(editor2)) {
                Document document2 = editor2.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"editor.document");
                LineStatusTrackerManager.this.requestTrackerFor(document2, editor2);
            }
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Editor editor = event.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"event.editor");
            Editor editor2 = editor;
            if (this.isTrackedEditor(editor2)) {
                Document document2 = editor2.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"editor.document");
                LineStatusTrackerManager.this.releaseTrackerFor(document2, editor2);
            }
        }

        private final boolean isTrackedEditor(Editor editor) {
            return !LineStatusTrackerManager.this.project.isDisposed() && (editor.getProject() == null || Intrinsics.areEqual((Object)editor.getProject(), (Object)LineStatusTrackerManager.this.project)) && FileDocumentManager.getInstance().getFile(editor.getDocument()) != null;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyFileDocumentManagerListener;", "Lcom/intellij/openapi/fileEditor/FileDocumentManagerListener;", "()V", "afterDocumentUnbound", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.platform.vcs.impl"})
    public static final class MyFileDocumentManagerListener
    implements FileDocumentManagerListener {
        public void afterDocumentUnbound(@NotNull VirtualFile file, @NotNull Document document2) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
            ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
            if (projectManager == null) {
                return;
            }
            ProjectManager projectManager2 = projectManager;
            Project[] projectArray = projectManager2.getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"projectManager.openProjects");
            for (Project project2 : projectArray) {
                LineStatusTrackerManager lstm;
                Object object = project2.getServiceIfCreated(LineStatusTrackerManagerI.class);
                if ((object instanceof LineStatusTrackerManager ? (LineStatusTrackerManager)object : null) == null) continue;
                lstm = lstm;
                lstm.releaseTracker(document2, true);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyFileStatusListener;", "Lcom/intellij/openapi/vcs/FileStatusListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "fileStatusChanged", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileStatusesChanged", "intellij.platform.vcs.impl"})
    private final class MyFileStatusListener
    implements FileStatusListener {
        public void fileStatusesChanged() {
            LineStatusTrackerManager.this.onEverythingChanged();
        }

        public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            LineStatusTrackerManager.this.onFileChanged(virtualFile);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyFreezeListener;", "Lcom/intellij/openapi/vcs/changes/VcsFreezingProcess$Listener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "onFreeze", "", "onUnfreeze", "intellij.platform.vcs.impl"})
    private final class MyFreezeListener
    implements VcsFreezingProcess.Listener {
        @Override
        public void onFreeze() {
            ActionsKt.runReadAction((Function0)((Function0)new Function0<Integer>(LineStatusTrackerManager.this){
                final /* synthetic */ LineStatusTrackerManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public final Integer invoke() {
                    Integer n;
                    Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0);
                    LineStatusTrackerManager lineStatusTrackerManager = this.this$0;
                    Object object2 = object;
                    synchronized (object2) {
                        boolean bl = false;
                        if (LineStatusTrackerManager.access$getClmFreezeCounter$p(lineStatusTrackerManager) == 0) {
                            for (TrackerData data2 : LineStatusTrackerManager.access$getTrackers$p(lineStatusTrackerManager).values()) {
                                try {
                                    data2.getTracker().freeze();
                                }
                                catch (Throwable e) {
                                    LineStatusTrackerManager.access$getLOG$cp().error(e);
                                }
                            }
                        }
                        int n2 = LineStatusTrackerManager.access$getClmFreezeCounter$p(lineStatusTrackerManager);
                        LineStatusTrackerManager.access$setClmFreezeCounter$p(lineStatusTrackerManager, n2 + 1);
                        n = n2;
                    }
                    return n;
                }
            }));
        }

        @Override
        public void onUnfreeze() {
            ActionsKt.runInEdt((ModalityState)ModalityState.any(), (Function0)((Function0)new Function0<Unit>(LineStatusTrackerManager.this){
                final /* synthetic */ LineStatusTrackerManager this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0);
                    LineStatusTrackerManager lineStatusTrackerManager = this.this$0;
                    Object object2 = object;
                    synchronized (object2) {
                        boolean bl = false;
                        int n = LineStatusTrackerManager.access$getClmFreezeCounter$p(lineStatusTrackerManager);
                        LineStatusTrackerManager.access$setClmFreezeCounter$p(lineStatusTrackerManager, n + -1);
                        if (LineStatusTrackerManager.access$getClmFreezeCounter$p(lineStatusTrackerManager) == 0) {
                            for (TrackerData data2 : LineStatusTrackerManager.access$getTrackers$p(lineStatusTrackerManager).values()) {
                                try {
                                    data2.getTracker().unfreeze();
                                }
                                catch (Throwable e) {
                                    LineStatusTrackerManager.access$getLOG$cp().error(e);
                                }
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyLineStatusTrackerSettingListener;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerSettingListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "settingsUpdated", "", "intellij.platform.vcs.impl"})
    private final class MyLineStatusTrackerSettingListener
    implements LineStatusTrackerSettingListener {
        public void settingsUpdated() {
            LineStatusTrackerManager.this.updatePartialChangeListsAvailability();
            LineStatusTrackerManager.this.updateTrackingSettings();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyStartupActivity;", "Lcom/intellij/openapi/vcs/impl/VcsStartupActivity;", "()V", "getOrder", "", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class MyStartupActivity
    implements VcsStartupActivity {
        @Override
        public void runActivity(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Companion.getInstanceImpl(project2).startListenForEditors();
        }

        @Override
        public int getOrder() {
            return VcsInitObject.OTHER_INITIALIZATION.getOrder();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0016\u0010\b\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J$\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyVirtualFileListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "before", "forEachTrackerUnder", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "action", "Lkotlin/Function1;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData;", "handleFileDeletion", "handleFileMovement", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nLineStatusTrackerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyVirtualFileListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1478:1\n766#2:1479\n857#2,2:1480\n*S KotlinDebug\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyVirtualFileListener\n*L\n759#1:1479\n759#1:1480,2\n*E\n"})
    private final class MyVirtualFileListener
    implements BulkFileListener {
        public void before(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            for (VFileEvent vFileEvent : events) {
                if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                VirtualFile virtualFile = ((VFileDeleteEvent)vFileEvent).getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
                this.handleFileDeletion(virtualFile);
            }
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            for (VFileEvent vFileEvent : events) {
                VFileEvent vFileEvent2 = vFileEvent;
                if (vFileEvent2 instanceof VFilePropertyChangeEvent) {
                    if (Intrinsics.areEqual((Object)"encoding", (Object)((VFilePropertyChangeEvent)vFileEvent).getPropertyName())) {
                        VirtualFile virtualFile = ((VFilePropertyChangeEvent)vFileEvent).getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
                        LineStatusTrackerManager.this.onFileChanged(virtualFile);
                        continue;
                    }
                    if (!((VFilePropertyChangeEvent)vFileEvent).isRename()) continue;
                    VirtualFile virtualFile = ((VFilePropertyChangeEvent)vFileEvent).getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
                    this.handleFileMovement(virtualFile);
                    continue;
                }
                if (!(vFileEvent2 instanceof VFileMoveEvent)) continue;
                VirtualFile virtualFile = ((VFileMoveEvent)vFileEvent).getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"event.file");
                this.handleFileMovement(virtualFile);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleFileMovement(VirtualFile file) {
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled) {
                return;
            }
            Object object = LineStatusTrackerManager.this.LOCK;
            LineStatusTrackerManager lineStatusTrackerManager = LineStatusTrackerManager.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                this.forEachTrackerUnder(file, (Function1<? super TrackerData, Unit>)((Function1)new Function1<TrackerData, Unit>(lineStatusTrackerManager){
                    final /* synthetic */ LineStatusTrackerManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull TrackerData data2) {
                        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                        LineStatusTrackerManager.access$reregisterTrackerInCLM(this.this$0, data2);
                    }
                }));
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleFileDeletion(VirtualFile file) {
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled) {
                return;
            }
            Object object = LineStatusTrackerManager.this.LOCK;
            LineStatusTrackerManager lineStatusTrackerManager = LineStatusTrackerManager.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                this.forEachTrackerUnder(file, (Function1<? super TrackerData, Unit>)((Function1)new Function1<TrackerData, Unit>(lineStatusTrackerManager){
                    final /* synthetic */ LineStatusTrackerManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull TrackerData data2) {
                        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                        LineStatusTrackerManager.releaseTracker$default(this.this$0, data2.getTracker().getDocument(), false, 2, null);
                    }
                }));
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void forEachTrackerUnder(VirtualFile file, Function1<? super TrackerData, Unit> action2) {
            if (file.isDirectory()) {
                void $this$filterTo$iv$iv;
                Collection collection = LineStatusTrackerManager.this.trackers.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"trackers.values");
                Iterable $this$filter$iv = collection;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    TrackerData it = (TrackerData)element$iv$iv;
                    boolean bl = false;
                    if (!VfsUtil.isAncestor((VirtualFile)file, (VirtualFile)it.getTracker().getVirtualFile(), (boolean)false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List affected = (List)destination$iv$iv;
                for (TrackerData data2 : affected) {
                    Intrinsics.checkNotNullExpressionValue((Object)data2, (String)"data");
                    action2.invoke((Object)data2);
                }
            } else {
                Document document2 = FileDocumentManager.getInstance().getCachedDocument(file);
                if (document2 == null) {
                    return;
                }
                Document document3 = document2;
                TrackerData trackerData = (TrackerData)LineStatusTrackerManager.this.trackers.get(document3);
                if (trackerData == null) {
                    return;
                }
                TrackerData data3 = trackerData;
                action2.invoke((Object)data3);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshData;", "", "content", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$TrackerContent;", "contentInfo", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$TrackerContent;Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;)V", "getContent", "()Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$TrackerContent;", "getContentInfo", "()Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;", "intellij.platform.vcs.impl"})
    private static final class RefreshData {
        @NotNull
        private final LineStatusTrackerContentLoader.TrackerContent content;
        @NotNull
        private final LineStatusTrackerContentLoader.ContentInfo contentInfo;

        public RefreshData(@NotNull LineStatusTrackerContentLoader.TrackerContent content, @NotNull LineStatusTrackerContentLoader.ContentInfo contentInfo) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)contentInfo, (String)"contentInfo");
            this.content = content;
            this.contentInfo = contentInfo;
        }

        @NotNull
        public final LineStatusTrackerContentLoader.TrackerContent getContent() {
            return this.content;
        }

        @NotNull
        public final LineStatusTrackerContentLoader.ContentInfo getContentInfo() {
            return this.contentInfo;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshRequest;", "", "document", "Lcom/intellij/openapi/editor/Document;", "loader", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader;)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getLoader", "()Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.vcs.impl"})
    private static final class RefreshRequest {
        @NotNull
        private final Document document;
        @NotNull
        private final LineStatusTrackerContentLoader loader;

        public RefreshRequest(@NotNull Document document2, @NotNull LineStatusTrackerContentLoader loader2) {
            Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
            Intrinsics.checkNotNullParameter((Object)loader2, (String)"loader");
            this.document = document2;
            this.loader = loader2;
        }

        @NotNull
        public final Document getDocument() {
            return this.document;
        }

        @NotNull
        public final LineStatusTrackerContentLoader getLoader() {
            return this.loader;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof RefreshRequest && Intrinsics.areEqual((Object)this.document, (Object)((RefreshRequest)other).document);
        }

        public int hashCode() {
            return this.document.hashCode();
        }

        @NotNull
        public String toString() {
            Object object = FileDocumentManager.getInstance().getFile(this.document);
            if (object == null || (object = object.getPath()) == null) {
                object = "unknown";
            }
            return "RefreshRequest: " + (String)object;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B)\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData;", "", "tracker", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "contentInfo", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;", "clmFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;Lcom/intellij/openapi/vcs/FilePath;)V", "getClmFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "setClmFilePath", "(Lcom/intellij/openapi/vcs/FilePath;)V", "getContentInfo", "()Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;", "setContentInfo", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;)V", "getTracker", "()Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "intellij.platform.vcs.impl"})
    private static final class TrackerData {
        @NotNull
        private final LocalLineStatusTracker<?> tracker;
        @Nullable
        private LineStatusTrackerContentLoader.ContentInfo contentInfo;
        @Nullable
        private FilePath clmFilePath;

        public TrackerData(@NotNull LocalLineStatusTracker<?> tracker, @Nullable LineStatusTrackerContentLoader.ContentInfo contentInfo, @Nullable FilePath clmFilePath) {
            Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
            this.tracker = tracker;
            this.contentInfo = contentInfo;
            this.clmFilePath = clmFilePath;
        }

        public /* synthetic */ TrackerData(LocalLineStatusTracker localLineStatusTracker, LineStatusTrackerContentLoader.ContentInfo contentInfo, FilePath filePath, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                contentInfo = null;
            }
            if ((n & 4) != 0) {
                filePath = null;
            }
            this(localLineStatusTracker, contentInfo, filePath);
        }

        @NotNull
        public final LocalLineStatusTracker<?> getTracker() {
            return this.tracker;
        }

        @Nullable
        public final LineStatusTrackerContentLoader.ContentInfo getContentInfo() {
            return this.contentInfo;
        }

        public final void setContentInfo(@Nullable LineStatusTrackerContentLoader.ContentInfo contentInfo) {
            this.contentInfo = contentInfo;
        }

        @Nullable
        public final FilePath getClmFilePath() {
            return this.clmFilePath;
        }

        public final void setClmFilePath(@Nullable FilePath filePath) {
            this.clmFilePath = filePath;
        }
    }
}

