/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.history.Label;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.PanelWithActionsAndCloseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.RefreshIncomingChangesAction;
import com.intellij.openapi.vcs.update.AbstractTreeNode;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.FileTreeNode;
import com.intellij.openapi.vcs.update.GroupTreeNode;
import com.intellij.openapi.vcs.update.UpdateRootNode;
import com.intellij.openapi.vcs.update.UpdateTreeCellRenderer;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SelectionSaver;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateInfoTree
extends PanelWithActionsAndCloseButton {
    public static final DataKey<FilePath> UPDATE_VIEW_SELECTED_PATH = DataKey.create((String)"AbstractCommonUpdateAction.UpdateViewSelectedPath");
    public static final DataKey<Iterable<Pair<FilePath, FileStatus>>> UPDATE_VIEW_FILES_ITERABLE = DataKey.create((String)"AbstractCommonUpdateAction.UpdatedFilesIterable");
    public static final DataKey<Label> LABEL_BEFORE = DataKey.create((String)"LABEL_BEFORE");
    public static final DataKey<Label> LABEL_AFTER = DataKey.create((String)"LABEL_AFTER");
    private final Tree myTree;
    @NotNull
    private final Project myProject;
    private final UpdatedFiles myUpdatedFiles;
    private final VcsConfiguration myVcsConfiguration;
    private UpdateRootNode myRoot;
    private DefaultTreeModel myTreeModel;
    private FileStatusListener myFileStatusListener;
    private final FileStatusManager myFileStatusManager;
    @Nls
    private final String myRootName;
    private final ActionInfo myActionInfo;
    private boolean myCanGroupByChangeList;
    private boolean myGroupByChangeList;
    private JLabel myLoadingChangeListsLabel;
    private List<? extends CommittedChangeList> myCommittedChangeLists;
    private final JPanel myCenterPanel;
    @NonNls
    private static final String CARD_STATUS = "Status";
    @NonNls
    private static final String CARD_CHANGES = "Changes";
    private CommittedChangesTreeBrowser myTreeBrowser;
    private final TreeExpander myTreeExpander;
    private final MyTreeIterable myTreeIterable;
    private Label myBefore;
    private Label myAfter;

    public UpdateInfoTree(@NotNull ContentManager contentManager, @NotNull Project project2, UpdatedFiles updatedFiles, @Nls String rootName, ActionInfo actionInfo) {
        if (contentManager == null) {
            UpdateInfoTree.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            UpdateInfoTree.$$$reportNull$$$0(1);
        }
        super(contentManager, "reference.versionControl.toolwindow.update");
        this.myTree = new Tree();
        this.myCanGroupByChangeList = false;
        this.myGroupByChangeList = false;
        this.myCenterPanel = new JPanel(new CardLayout());
        this.myActionInfo = actionInfo;
        this.myFileStatusListener = new FileStatusListener(){

            public void fileStatusesChanged() {
                UpdateInfoTree.this.myTree.repaint();
            }

            public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                UpdateInfoTree.this.myTree.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/update/UpdateInfoTree$1", "fileStatusChanged"));
            }
        };
        this.myProject = project2;
        this.myUpdatedFiles = updatedFiles;
        this.myRootName = rootName;
        this.myVcsConfiguration = VcsConfiguration.getInstance(this.myProject);
        this.myFileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        this.myFileStatusManager.addFileStatusListener(this.myFileStatusListener, (Disposable)this);
        this.createTree();
        this.init();
        this.myTreeExpander = new DefaultTreeExpander((JTree)this.myTree);
        this.myTreeIterable = new MyTreeIterable();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myRoot);
    }

    public void setCanGroupByChangeList(boolean canGroupByChangeList) {
        this.myCanGroupByChangeList = canGroupByChangeList;
        if (this.myCanGroupByChangeList) {
            this.myLoadingChangeListsLabel = new JLabel(VcsBundle.message("update.info.loading.changelists", new Object[0]));
            this.add(this.myLoadingChangeListsLabel, "South");
            this.myGroupByChangeList = this.myVcsConfiguration.UPDATE_GROUP_BY_CHANGELIST;
            if (this.myGroupByChangeList) {
                CardLayout cardLayout = (CardLayout)this.myCenterPanel.getLayout();
                cardLayout.show(this.myCenterPanel, CARD_CHANGES);
            }
        }
    }

    protected void addActionsTo(DefaultActionGroup group2) {
        group2.add((AnAction)new MyGroupByPackagesAction());
        group2.add((AnAction)new GroupByChangeListAction());
        group2.add((AnAction)new FilterAction());
        group2.add(ActionManager.getInstance().getAction("ExpandAll"));
        group2.add(ActionManager.getInstance().getAction("CollapseAll"));
        group2.add(ActionManager.getInstance().getAction("Diff.ShowDiff"));
    }

    protected JComponent createCenterPanel() {
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)1));
        this.myCenterPanel.add(CARD_STATUS, scrollPane);
        this.myTreeBrowser = new CommittedChangesTreeBrowser(this.myProject, Collections.emptyList());
        Disposer.register((Disposable)this, (Disposable)this.myTreeBrowser);
        this.myTreeBrowser.setHelpId(this.getHelpId());
        this.myCenterPanel.add(CARD_CHANGES, this.myTreeBrowser);
        return this.myCenterPanel;
    }

    private void createTree() {
        SmartExpander.installOn((JTree)this.myTree);
        SelectionSaver.installOn((JTree)this.myTree);
        this.createTreeModel();
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new UpdateTreeCellRenderer()));
        TreeUtil.installActions((JTree)this.myTree);
        TreeSpeedSearch.installOn((JTree)this.myTree, (boolean)true, path2 -> {
            Object last = path2.getLastPathComponent();
            if (last instanceof AbstractTreeNode) {
                return ((AbstractTreeNode)last).getText();
            }
            return (String)TreeSpeedSearch.NODE_PRESENTATION_FUNCTION.apply(path2);
        });
        PopupHandler.installPopupMenu((JComponent)this.myTree, (String)"UpdateActionGroup", (String)"UpdatePopup");
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
        EditSourceOnEnterKeyHandler.install((JTree)this.myTree);
        this.myTree.setSelectionRow(0);
    }

    private void createTreeModel() {
        this.myRoot = new UpdateRootNode(this.myUpdatedFiles, this.myProject, this.myRootName, this.myActionInfo);
        this.updateTreeModel();
        this.myTreeModel = new DefaultTreeModel(this.myRoot);
        this.myRoot.setTreeModel(this.myTreeModel);
        this.myTree.setModel((TreeModel)this.myTreeModel);
        this.myRoot.setTree((JTree)this.myTree);
    }

    private void updateTreeModel() {
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        this.myRoot.rebuild(this.myVcsConfiguration.UPDATE_GROUP_BY_PACKAGES, this.getScopeFilter(), this.myVcsConfiguration.UPDATE_FILTER_BY_SCOPE);
        if (this.myTreeModel != null) {
            this.myTreeModel.reload();
        }
    }

    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            UpdateInfoTree.$$$reportNull$$$0(2);
        }
        if (this.myTreeBrowser != null && this.myTreeBrowser.isVisible()) {
            return null;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            VirtualFilePointer pointer = this.getSelectedFilePointer();
            if (pointer == null || !pointer.isValid()) {
                return null;
            }
            VirtualFile selectedFile = pointer.getFile();
            return selectedFile != null ? new OpenFileDescriptor(this.myProject, selectedFile) : null;
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            return this.getVirtualFileArray();
        }
        if (VcsDataKeys.IO_FILE_ARRAY.is(dataId)) {
            return this.getFileArray();
        }
        if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
            if (this.myGroupByChangeList) {
                return this.myTreeBrowser != null ? this.myTreeBrowser.getTreeExpander() : null;
            }
            return this.myTreeExpander;
        }
        if (UPDATE_VIEW_SELECTED_PATH.is(dataId)) {
            VirtualFilePointer pointer = this.getSelectedFilePointer();
            return pointer != null ? UpdateInfoTree.getFilePath(pointer) : null;
        }
        if (UPDATE_VIEW_FILES_ITERABLE.is(dataId)) {
            return this.myTreeIterable;
        }
        if (LABEL_BEFORE.is(dataId)) {
            return this.myBefore;
        }
        if (LABEL_AFTER.is(dataId)) {
            return this.myAfter;
        }
        return super.getData(dataId);
    }

    @Nullable
    private VirtualFilePointer getSelectedFilePointer() {
        TreePath path2 = this.myTree.getSelectionPath();
        if (path2 == null) {
            return null;
        }
        AbstractTreeNode treeNode = (AbstractTreeNode)path2.getLastPathComponent();
        return treeNode instanceof FileTreeNode ? ((FileTreeNode)treeNode).getFilePointer() : null;
    }

    private VirtualFile[] getVirtualFileArray() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath selectionPath : selectionPaths) {
                AbstractTreeNode treeNode = (AbstractTreeNode)selectionPath.getLastPathComponent();
                result2.addAll(treeNode.getVirtualFiles());
            }
        }
        return VfsUtil.toVirtualFileArray(result2);
    }

    private File @Nullable [] getFileArray() {
        ArrayList<File> result2 = new ArrayList<File>();
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath selectionPath : selectionPaths) {
                AbstractTreeNode treeNode = (AbstractTreeNode)selectionPath.getLastPathComponent();
                result2.addAll(treeNode.getFiles());
            }
        }
        if (result2.isEmpty()) {
            return null;
        }
        return result2.toArray(new File[0]);
    }

    int getFilteredFilesCount() {
        Pair<PackageSetBase, NamedScopesHolder> scopeFilter = this.getScopeFilter();
        int[] result2 = new int[1];
        TreeUtil.traverse((TreeNode)this.myRoot, node -> {
            if (node instanceof FileTreeNode && ((FileTreeNode)node).acceptFilter(scopeFilter, true)) {
                result2[0] = result2[0] + 1;
            }
            return true;
        });
        return result2[0];
    }

    public void expandRootChildren() {
        TreeNode root = (TreeNode)this.myTreeModel.getRoot();
        if (root.getChildCount() == 1) {
            this.myTree.expandPath(new TreePath(new Object[]{root, root.getChildAt(0)}));
        }
    }

    public void setChangeLists(List<? extends CommittedChangeList> receivedChanges) {
        boolean hasEmptyCaches = CommittedChangesCache.getInstance(this.myProject).hasEmptyCaches();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (Disposer.isDisposed((Disposable)this)) {
                return;
            }
            if (this.myLoadingChangeListsLabel != null) {
                this.remove(this.myLoadingChangeListsLabel);
                this.myLoadingChangeListsLabel = null;
            }
            this.myCommittedChangeLists = receivedChanges;
            this.myTreeBrowser.setItems(this.myCommittedChangeLists, CommittedChangesBrowserUseCase.UPDATE);
            if (hasEmptyCaches) {
                StatusText statusText2 = this.myTreeBrowser.getEmptyText();
                statusText2.clear();
                statusText2.appendText(VcsBundle.message("update.info.click.status.text.prefix", new Object[0])).appendText(" ").appendText(VcsBundle.message("update.info.refresh.link.status.text", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RefreshIncomingChangesAction.doRefresh(UpdateInfoTree.this.myProject);
                    }
                }).appendText(" ").appendText(VcsBundle.message("update.info.to.initialize.status.text.suffix", new Object[0]));
            }
        }, this.myProject.getDisposed());
    }

    public void setBefore(Label before) {
        this.myBefore = before;
    }

    public void setAfter(Label after) {
        this.myAfter = after;
    }

    @Nullable
    private Pair<PackageSetBase, NamedScopesHolder> getScopeFilter() {
        String scopeName = this.getFilterScopeName();
        if (scopeName != null) {
            for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders((Project)this.myProject)) {
                PackageSet packageSet2;
                NamedScope scope2 = holder.getScope(scopeName);
                if (scope2 == null || !((packageSet2 = scope2.getValue()) instanceof PackageSetBase)) continue;
                return Pair.create((Object)((PackageSetBase)packageSet2), (Object)holder);
            }
        }
        return null;
    }

    @Nullable
    private String getFilterScopeName() {
        return this.myVcsConfiguration.UPDATE_FILTER_SCOPE_NAME;
    }

    @Nullable
    NamedScope getFilterScope() {
        Pair<PackageSetBase, NamedScopesHolder> filter2 = this.getScopeFilter();
        return filter2 == null ? null : ((NamedScopesHolder)filter2.second).getScope(this.getFilterScopeName());
    }

    @Nullable
    private static FilePath getFilePath(@NotNull VirtualFilePointer filePointer) {
        String path2;
        if (filePointer == null) {
            UpdateInfoTree.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)(path2 = VirtualFileManager.extractPath((String)filePointer.getUrl())))) {
            return null;
        }
        return VcsUtil.getFilePath(path2, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePointer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/update/UpdateInfoTree";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getFilePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyTreeIterable
    implements Iterable<Pair<FilePath, FileStatus>> {
        private MyTreeIterable() {
        }

        @Override
        public Iterator<Pair<FilePath, FileStatus>> iterator() {
            return new MyTreeIterator();
        }
    }

    private class MyGroupByPackagesAction
    extends ToggleAction
    implements DumbAware {
        MyGroupByPackagesAction() {
            super(VcsBundle.messagePointer("action.name.group.by.packages", new Object[0]), PlatformIcons.GROUP_BY_PACKAGES);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyGroupByPackagesAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MyGroupByPackagesAction.$$$reportNull$$$0(1);
            }
            return UpdateInfoTree.this.myVcsConfiguration.UPDATE_GROUP_BY_PACKAGES;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyGroupByPackagesAction.$$$reportNull$$$0(2);
            }
            UpdateInfoTree.this.myVcsConfiguration.UPDATE_GROUP_BY_PACKAGES = state;
            UpdateInfoTree.this.updateTreeModel();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyGroupByPackagesAction.$$$reportNull$$$0(3);
            }
            super.update(e);
            e.getPresentation().setEnabled(!UpdateInfoTree.this.myGroupByChangeList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/update/UpdateInfoTree$MyGroupByPackagesAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/update/UpdateInfoTree$MyGroupByPackagesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2, 3 -> new IllegalArgumentException(string2);
            };
        }
    }

    private class GroupByChangeListAction
    extends ToggleAction
    implements DumbAware {
        GroupByChangeListAction() {
            super(VcsBundle.messagePointer("update.info.group.by.changelist", new Object[0]), AllIcons.Actions.ShowAsTree);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                GroupByChangeListAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                GroupByChangeListAction.$$$reportNull$$$0(1);
            }
            return UpdateInfoTree.this.myGroupByChangeList;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                GroupByChangeListAction.$$$reportNull$$$0(2);
            }
            UpdateInfoTree.this.myVcsConfiguration.UPDATE_GROUP_BY_CHANGELIST = UpdateInfoTree.this.myGroupByChangeList = state;
            CardLayout cardLayout = (CardLayout)UpdateInfoTree.this.myCenterPanel.getLayout();
            if (!UpdateInfoTree.this.myGroupByChangeList) {
                cardLayout.show(UpdateInfoTree.this.myCenterPanel, UpdateInfoTree.CARD_STATUS);
            } else {
                cardLayout.show(UpdateInfoTree.this.myCenterPanel, UpdateInfoTree.CARD_CHANGES);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GroupByChangeListAction.$$$reportNull$$$0(3);
            }
            super.update(e);
            e.getPresentation().setVisible(UpdateInfoTree.this.myCanGroupByChangeList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/update/UpdateInfoTree$GroupByChangeListAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/update/UpdateInfoTree$GroupByChangeListAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2, 3 -> new IllegalArgumentException(string2);
            };
        }
    }

    private class FilterAction
    extends ToggleAction
    implements DumbAware {
        FilterAction() {
            super(VcsBundle.messagePointer("action.ToggleAction.text.scope.filter", new Object[0]), VcsBundle.messagePointer("settings.filter.update.project.info.by.scope", new Object[0]), AllIcons.General.Filter);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                FilterAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                FilterAction.$$$reportNull$$$0(1);
            }
            return UpdateInfoTree.this.myVcsConfiguration.UPDATE_FILTER_BY_SCOPE;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                FilterAction.$$$reportNull$$$0(2);
            }
            UpdateInfoTree.this.myVcsConfiguration.UPDATE_FILTER_BY_SCOPE = state;
            UpdateInfoTree.this.updateTreeModel();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                FilterAction.$$$reportNull$$$0(3);
            }
            super.update(e);
            e.getPresentation().setEnabled(!UpdateInfoTree.this.myGroupByChangeList && UpdateInfoTree.this.getFilterScopeName() != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/update/UpdateInfoTree$FilterAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/update/UpdateInfoTree$FilterAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2, 3 -> new IllegalArgumentException(string2);
            };
        }
    }

    private final class MyTreeIterator
    implements Iterator<Pair<FilePath, FileStatus>> {
        private final Enumeration myEnum;
        private FilePath myNext;
        private FileStatus myStatus;

        private MyTreeIterator() {
            this.myEnum = UpdateInfoTree.this.myRoot.depthFirstEnumeration();
            this.step();
        }

        @Override
        public boolean hasNext() {
            return this.myNext != null;
        }

        @Override
        public Pair<FilePath, FileStatus> next() {
            FilePath result2 = this.myNext;
            FileStatus status = this.myStatus;
            this.step();
            return Pair.create((Object)result2, (Object)status);
        }

        private void step() {
            this.myNext = null;
            while (this.myEnum.hasMoreElements()) {
                FileTreeNode treeNode;
                VirtualFilePointer filePointer;
                FilePath filePath;
                Object o = this.myEnum.nextElement();
                if (!(o instanceof FileTreeNode) || (filePath = UpdateInfoTree.getFilePath(filePointer = (treeNode = (FileTreeNode)o).getFilePointer())) == null) continue;
                this.myNext = filePath;
                this.myStatus = FileStatus.MODIFIED;
                GroupTreeNode parent = this.findParentGroupTreeNode(treeNode.getParent());
                if (parent == null) break;
                String id = parent.getFileGroupId();
                if ("CREATED".equals(id)) {
                    this.myStatus = FileStatus.ADDED;
                    break;
                }
                if (!"REMOVED_FROM_REPOSITORY".equals(id)) break;
                this.myStatus = FileStatus.DELETED;
                break;
            }
        }

        @Nullable
        private GroupTreeNode findParentGroupTreeNode(@NotNull TreeNode treeNode) {
            TreeNode currentNode;
            if (treeNode == null) {
                MyTreeIterator.$$$reportNull$$$0(0);
            }
            for (currentNode = treeNode; currentNode != null && !(currentNode instanceof GroupTreeNode); currentNode = currentNode.getParent()) {
            }
            return (GroupTreeNode)currentNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeNode", "com/intellij/openapi/vcs/update/UpdateInfoTree$MyTreeIterator", "findParentGroupTreeNode"));
        }
    }
}

