/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.xml.XmlTextImpl;
import com.intellij.psi.impl.source.xml.behavior.DefaultXmlPsiPolicy;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class XmlTagValueImpl
implements XmlTagValue {
    private static final Logger LOG = Logger.getInstance(XmlTagValueImpl.class);
    private final XmlTag myTag;
    private final XmlTagChild[] myElements;
    private volatile XmlText[] myTextElements;
    private volatile String myText;
    private volatile String myTrimmedText;

    public XmlTagValueImpl(XmlTagChild @NotNull [] bodyElements, @NotNull XmlTag tag) {
        if (tag == null) {
            XmlTagValueImpl.$$$reportNull$$$0(0);
        }
        if (bodyElements == null) {
            XmlTagValueImpl.$$$reportNull$$$0(1);
        }
        this.myTag = tag;
        this.myElements = bodyElements;
    }

    @Override
    public XmlTagChild @NotNull [] getChildren() {
        if (this.myElements == null) {
            XmlTagValueImpl.$$$reportNull$$$0(2);
        }
        return this.myElements;
    }

    @Override
    public XmlText @NotNull [] getTextElements() {
        XmlText[] textElements = this.myTextElements;
        if (textElements == null) {
            textElements = (XmlText[])Arrays.stream(this.myElements).filter(element -> element instanceof XmlText).map(element -> (XmlText)element).toArray(XmlText[]::new);
            textElements = textElements.length == 0 ? XmlText.EMPTY_ARRAY : textElements;
            this.myTextElements = textElements;
        }
        if (textElements == null) {
            XmlTagValueImpl.$$$reportNull$$$0(3);
        }
        return textElements;
    }

    @Override
    @NotNull
    public String getText() {
        String text2 = this.myText;
        if (text2 == null) {
            StringBuilder consolidatedText = new StringBuilder();
            for (XmlTagChild element : this.myElements) {
                consolidatedText.append(element.getText());
            }
            this.myText = text2 = consolidatedText.toString();
        }
        String string2 = text2;
        if (string2 == null) {
            XmlTagValueImpl.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        if (this.myElements.length == 0) {
            ASTNode child = XmlChildRole.START_TAG_END_FINDER.findChild(this.myTag.getNode());
            if (child != null) {
                return new TextRange(child.getStartOffset() + 1, child.getStartOffset() + 1);
            }
            return new TextRange(this.myTag.getTextRange().getEndOffset(), this.myTag.getTextRange().getEndOffset());
        }
        return new TextRange(this.myElements[0].getTextRange().getStartOffset(), this.myElements[this.myElements.length - 1].getTextRange().getEndOffset());
    }

    @Override
    @NotNull
    public String getTrimmedText() {
        String trimmedText = this.myTrimmedText;
        if (trimmedText == null) {
            XmlText[] textElements;
            StringBuilder consolidatedText = new StringBuilder();
            for (XmlText textElement : textElements = this.getTextElements()) {
                consolidatedText.append(textElement.getValue());
            }
            this.myTrimmedText = trimmedText = consolidatedText.toString().trim();
        }
        String string2 = trimmedText;
        if (string2 == null) {
            XmlTagValueImpl.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Override
    public void setText(String value2) {
        this.setText(value2, false);
    }

    @Override
    public void setEscapedText(String value2) {
        this.setText(value2, true);
    }

    private void setText(String value2, boolean defaultPolicy) {
        try {
            XmlText text2 = null;
            if (value2 != null) {
                XmlText[] texts = this.getTextElements();
                text2 = texts.length == 0 ? (XmlText)this.myTag.add(XmlElementFactory.getInstance(this.myTag.getProject()).createDisplayText("x")) : texts[0];
                if (StringUtil.isEmpty((String)value2)) {
                    text2.delete();
                } else if (defaultPolicy && text2 instanceof XmlTextImpl) {
                    ((XmlTextImpl)text2).doSetValue(value2, new DefaultXmlPsiPolicy());
                } else {
                    text2.setValue(value2);
                }
            }
            for (XmlTagChild child : this.myElements) {
                if (child == text2) continue;
                child.delete();
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public boolean hasCDATA() {
        for (XmlText xmlText : this.getTextElements()) {
            PsiElement[] children;
            for (PsiElement child : children = xmlText.getChildren()) {
                if (child.getNode().getElementType() != XmlElementType.XML_CDATA) continue;
                return true;
            }
        }
        return false;
    }

    public static XmlTagValue createXmlTagValue(XmlTag tag) {
        final ArrayList bodyElements = new ArrayList();
        tag.processElements(new PsiElementProcessor(){
            boolean insideBody;

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                ASTNode treeElement = element.getNode();
                if (this.insideBody) {
                    if (treeElement != null && treeElement.getElementType() == XmlTokenType.XML_END_TAG_START) {
                        return false;
                    }
                    if (!(element instanceof XmlTagChild)) {
                        return true;
                    }
                    bodyElements.add((XmlTagChild)element);
                } else if (treeElement != null && treeElement.getElementType() == XmlTokenType.XML_TAG_END) {
                    this.insideBody = true;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/xml/XmlTagValueImpl$1", "execute"));
            }
        }, tag);
        XmlTagChild[] tagChildren = bodyElements.toArray(XmlTagChild.EMPTY_ARRAY);
        return new XmlTagValueImpl(tagChildren, tag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyElements";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlTagValueImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlTagValueImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrimmedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4, 5 -> new IllegalStateException(string2);
        };
    }
}

