/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.xml;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IStubFileElementType;
import java.util.Arrays;

public class HtmlFileElementType
extends IStubFileElementType<PsiFileStub<?>> {
    private static volatile int stubVersion = -1;

    public HtmlFileElementType() {
        super("html", (Language)HTMLLanguage.INSTANCE);
    }

    public int getStubVersion() {
        return HtmlFileElementType.getHtmlStubVersion() + 3;
    }

    public static int getHtmlStubVersion() {
        int res;
        int version = stubVersion;
        if (version != -1) {
            return version;
        }
        IElementType[] dataElementTypes = IElementType.enumerate(elementType -> elementType instanceof IStubFileElementType && HtmlFileElementType.isAcceptable(elementType));
        stubVersion = res = Arrays.stream(dataElementTypes).mapToInt(e -> ((IStubFileElementType)e).getStubVersion()).sum();
        return res;
    }

    public static boolean isAcceptable(IElementType elementType) {
        String id = elementType.getLanguage().getID();
        return id.equals("JavaScript") || id.equals("CSS");
    }
}

