/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.structuralsearch.SpecialElementExtractor;
import com.intellij.util.SmartList;
import com.intellij.xml.util.XmlUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class XmlMatchUtil {
    private XmlMatchUtil() {
    }

    public static boolean isWhiteSpace(PsiElement element) {
        return element instanceof PsiWhiteSpace || element instanceof XmlText && element.getFirstChild() == element.getLastChild() && element.getFirstChild() instanceof PsiWhiteSpace;
    }

    public static List<XmlElement> getElementsToMatch(XmlTagChild[] elements) {
        SmartList list = new SmartList();
        for (XmlTagChild child : elements) {
            if (child instanceof XmlText) {
                for (PsiElement element : child.getChildren()) {
                    if (element instanceof PsiWhiteSpace || XmlMatchUtil.addSpecialXmlTags(element, (List<? super XmlElement>)list)) continue;
                    if (XmlUtil.isXmlToken(element, XmlTokenType.XML_DATA_CHARACTERS)) {
                        list.add((XmlToken)element);
                        continue;
                    }
                    if (!(element instanceof XmlComment)) continue;
                    list.add((XmlComment)element);
                }
                continue;
            }
            list.add(child);
        }
        return list;
    }

    public static PsiElement getElementToMatch(XmlAttributeValue attributeValue2) {
        PsiElement child = attributeValue2.getFirstChild();
        if (!(child instanceof XmlToken)) {
            return null;
        }
        XmlToken token = (XmlToken)child;
        if (token.getTokenType() != XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            return null;
        }
        PsiElement sibling = child.getNextSibling();
        if (!(sibling instanceof XmlToken)) {
            return sibling;
        }
        XmlToken secondToken = (XmlToken)sibling;
        return secondToken.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER ? null : secondToken;
    }

    private static boolean addSpecialXmlTags(@NotNull PsiElement element, List<? super XmlElement> list) {
        if (element == null) {
            XmlMatchUtil.$$$reportNull$$$0(0);
        }
        boolean result2 = false;
        for (SpecialElementExtractor extractor : SpecialElementExtractor.EP_NAME.getExtensionList()) {
            PsiElement[] elements;
            for (PsiElement specialElement : elements = extractor.extractSpecialElements(element)) {
                if (!(specialElement instanceof XmlTag)) continue;
                list.add((XmlElement)specialElement);
                result2 = true;
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/XmlMatchUtil", "addSpecialXmlTags"));
    }
}

