/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.AbstractMatchingVisitor;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.DelegatingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalMatchingVisitor
extends AbstractMatchingVisitor {
    private static final Logger LOG = Logger.getInstance(GlobalMatchingVisitor.class);
    public static final Key<List<? extends PsiElement>> UNMATCHED_ELEMENTS_KEY = Key.create((String)"UnmatchedElements");
    private PsiElement myElement;
    private boolean myResult;
    private final MatchContext matchContext = new MatchContext(this);

    public PsiElement getElement() {
        return this.myElement;
    }

    public <T extends PsiElement> T getElement(@NotNull Class<T> aClass) {
        if (aClass == null) {
            GlobalMatchingVisitor.$$$reportNull$$$0(0);
        }
        return (T)(this.setResult(aClass.isInstance(this.myElement)) ? (PsiElement)aClass.cast(this.myElement) : null);
    }

    public boolean getResult() {
        return this.myResult;
    }

    @Contract(value="true->true;false->false")
    public boolean setResult(boolean result2) {
        this.myResult = result2;
        return this.myResult;
    }

    @NotNull
    public MatchContext getMatchContext() {
        MatchContext matchContext = this.matchContext;
        if (matchContext == null) {
            GlobalMatchingVisitor.$$$reportNull$$$0(1);
        }
        return matchContext;
    }

    @Override
    protected boolean doMatchInAnyOrder(@NotNull NodeIterator elements, @NotNull NodeIterator elements2) {
        if (elements == null) {
            GlobalMatchingVisitor.$$$reportNull$$$0(2);
        }
        if (elements2 == null) {
            GlobalMatchingVisitor.$$$reportNull$$$0(3);
        }
        return MatchingHandler.matchInAnyOrder(elements, elements2, this.matchContext);
    }

    @Override
    public boolean matchOptionally(@Nullable PsiElement patternNode, @Nullable PsiElement matchNode) {
        if (patternNode == null) {
            return this.isLeftLooseMatching();
        }
        MatchingHandler handler2 = this.matchContext.getPattern().getHandler(patternNode);
        return matchNode != null ? handler2.match(patternNode, matchNode, this.matchContext) && handler2.validate(this.matchContext, 1) : handler2.validate(this.matchContext, 0);
    }

    @Override
    @NotNull
    protected NodeFilter getNodeFilter() {
        NodeFilter nodeFilter = LexicalNodesFilter.getInstance();
        if (nodeFilter == null) {
            GlobalMatchingVisitor.$$$reportNull$$$0(4);
        }
        return nodeFilter;
    }

    public final boolean handleTypedElement(PsiElement typedElement, PsiElement match2) {
        MatchingHandler initialHandler = this.matchContext.getPattern().getHandler(typedElement);
        MatchingHandler handler2 = initialHandler;
        if (handler2 instanceof DelegatingHandler) {
            handler2 = ((DelegatingHandler)((Object)handler2)).getDelegate();
        }
        assert (handler2 instanceof SubstitutionHandler) : typedElement + " has handler " + (Serializable)(handler2 != null ? handler2.getClass() : "null " + initialHandler.getClass());
        return ((SubstitutionHandler)handler2).handle(match2, this.matchContext);
    }

    public boolean allowsAbsenceOfMatch(PsiElement element) {
        MatchingHandler handler2 = this.getMatchContext().getPattern().getHandler(element);
        return handler2 instanceof SubstitutionHandler && ((SubstitutionHandler)handler2).getMinOccurs() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean match(PsiElement patternElement, PsiElement matchElement) {
        ProgressManager.checkCanceled();
        if (patternElement == matchElement) {
            return true;
        }
        if (patternElement == null) {
            return true;
        }
        if (matchElement == null) {
            return this.allowsAbsenceOfMatch(patternElement);
        }
        PsiElement prevElement = this.myElement;
        this.myElement = matchElement;
        try {
            PsiElementVisitor visitor = this.getVisitorForElement(patternElement);
            if (visitor != null) {
                patternElement.accept(visitor);
            }
        }
        catch (ClassCastException ex) {
            this.myResult = false;
        }
        finally {
            this.myElement = prevElement;
        }
        return this.myResult;
    }

    @Nullable
    private PsiElementVisitor getVisitorForElement(PsiElement element) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element);
        if (profile == null) {
            LOG.warn("No StructuralSearchProfile found for language " + element.getLanguage().getID());
            return null;
        }
        return profile.createMatchingVisitor(this);
    }

    @Override
    public boolean matchSequentially(@NotNull NodeIterator patternNodes, @NotNull NodeIterator matchNodes) {
        if (patternNodes == null) {
            GlobalMatchingVisitor.$$$reportNull$$$0(5);
        }
        if (matchNodes == null) {
            GlobalMatchingVisitor.$$$reportNull$$$0(6);
        }
        if (!patternNodes.hasNext()) {
            while (matchNodes.current() instanceof PsiComment) {
                matchNodes.advance();
            }
            return !matchNodes.hasNext();
        }
        PsiElement current = patternNodes.current();
        return this.matchContext.getPattern().getHandler(current).matchSequentially(patternNodes, matchNodes, this.matchContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void matchContext(@NotNull NodeIterator elements) {
        if (elements == null) {
            GlobalMatchingVisitor.$$$reportNull$$$0(7);
        }
        CompiledPattern pattern2 = this.matchContext.getPattern();
        NodeIterator patternNodes = pattern2.getNodes().clone();
        MatchResultImpl saveResult = this.matchContext.hasResult() ? this.matchContext.getResult() : null;
        this.matchContext.saveMatchedNodes();
        try {
            if (!patternNodes.hasNext()) {
                return;
            }
            MatchingHandler firstMatchingHandler = pattern2.getHandler(patternNodes.current());
            while (elements.hasNext()) {
                MatchingHandler matchingHandler;
                this.matchContext.setResult(null);
                this.matchContext.clearMatchedNodes();
                PsiElement elementNode = elements.current();
                boolean patternMatched = firstMatchingHandler.matchSequentially(patternNodes, elements, this.matchContext);
                boolean contextMatched = patternMatched ? (matchingHandler = pattern2.getHandler("__context__")) == null || ((SubstitutionHandler)matchingHandler).handle(elementNode, this.matchContext) : false;
                if (contextMatched) {
                    this.matchContext.dispatchMatched();
                }
                patternNodes.reset();
                if (patternMatched) {
                    elements.rewind();
                }
                elements.advance();
            }
        }
        finally {
            this.matchContext.setResult(saveResult);
            this.matchContext.restoreMatchedNodes();
        }
    }

    @Override
    public boolean isLeftLooseMatching() {
        return this.matchContext.getOptions().isLooseMatching();
    }

    @Override
    public boolean isRightLooseMatching() {
        return false;
    }

    public boolean matchText(@Nullable PsiElement left, @Nullable PsiElement right) {
        if (left == null) {
            return right == null;
        }
        return right != null && this.matchText(left.getText(), right.getText());
    }

    public boolean matchText(String left, String right) {
        return this.matchContext.getOptions().isCaseSensitiveMatch() ? left.equals(right) : left.equalsIgnoreCase(right);
    }

    public void scopeMatch(PsiElement patternNode, boolean typedVar, PsiElement matchNode) {
        MatchResultImpl ourResult = this.matchContext.hasResult() ? this.matchContext.getResult() : null;
        this.matchContext.popResult();
        if (this.myResult) {
            if (typedVar) {
                SubstitutionHandler handler2 = (SubstitutionHandler)this.matchContext.getPattern().getHandler(patternNode);
                if (ourResult != null) {
                    ourResult.setScopeMatch(true);
                }
                handler2.setNestedResult(ourResult);
                this.setResult(handler2.handle(matchNode, this.matchContext));
                MatchResultImpl nestedResult = handler2.getNestedResult();
                if (nestedResult != null) {
                    this.copyResults(nestedResult);
                    handler2.setNestedResult(null);
                }
            } else if (ourResult != null) {
                this.copyResults(ourResult);
            }
        }
    }

    private void copyResults(MatchResult source2) {
        MatchResultImpl result2 = this.matchContext.getResult();
        for (MatchResult child : source2.getChildren()) {
            result2.addChild(child);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/GlobalMatchingVisitor";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements2";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternNodes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/GlobalMatchingVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doMatchInAnyOrder";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "matchSequentially";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matchContext";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 4 -> new IllegalStateException(string2);
        };
    }
}

