/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerKt;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandlerKt;
import com.intellij.vcs.commit.CommitTabTitleUpdater;
import com.intellij.vcs.commit.CommitWorkflowUi;
import com.intellij.vcsUtil.VcsUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/vcs/commit/ChangesViewCommitTabTitleUpdater;", "Lcom/intellij/vcs/commit/CommitTabTitleUpdater;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentManagerListener;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "workflowUi", "Lcom/intellij/vcs/commit/CommitWorkflowUi;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Lcom/intellij/vcs/commit/CommitWorkflowUi;Lcom/intellij/openapi/Disposable;)V", "start", "", "toolWindowMappingChanged", "updateTab", "intellij.platform.vcs.impl"})
final class ChangesViewCommitTabTitleUpdater
extends CommitTabTitleUpdater
implements ChangesViewContentManagerListener {
    public ChangesViewCommitTabTitleUpdater(final @NotNull ChangesTree tree2, final @NotNull CommitWorkflowUi workflowUi, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree2), (String)"tree");
        Intrinsics.checkNotNullParameter((Object)workflowUi, (String)"workflowUi");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super(tree2, "Local Changes", (Function0<String>)((Function0)1.INSTANCE), (Function0<? extends Iterable<? extends FilePath>>)((Function0)new Function0<Iterable<? extends FilePath>>(){

            @NotNull
            public final Iterable<FilePath> invoke() {
                VirtualFile singleRoot;
                VirtualFile[] virtualFileArray = ProjectLevelVcsManager.getInstance(tree2.getProject()).getAllVersionedRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getInstance(tree.project).allVersionedRoots");
                VirtualFile virtualFile = singleRoot = (VirtualFile)ArraysKt.singleOrNull((Object[])virtualFileArray);
                return virtualFile != null ? (Iterable)CollectionsKt.listOf((Object)VcsUtil.getFilePath(virtualFile)) : (Iterable)AbstractCommitWorkflowHandlerKt.getDisplayedPaths(workflowUi);
            }
        }));
        Disposer.register((Disposable)disposable, (Disposable)this);
    }

    @Override
    public void start() {
        super.start();
        this.getProject().getMessageBus().connect((Disposable)this).subscribe(ChangesViewContentManagerListener.TOPIC, (Object)this);
    }

    @Override
    public void toolWindowMappingChanged() {
        this.updateTab();
    }

    @Override
    public void updateTab() {
        if (!ChangesViewContentManagerKt.isCommitToolWindowShown(this.getProject())) {
            return;
        }
        super.updateTab();
    }
}

