/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.util.NotNullFunction;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.NormalEdge;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public class GraphElementComparatorByLayoutIndex
implements Comparator<GraphElement> {
    @NotNull
    private final NotNullFunction<? super Integer, Integer> myLayoutIndexGetter;

    public GraphElementComparatorByLayoutIndex(@NotNull NotNullFunction<? super Integer, Integer> layoutIndexGetter) {
        if (layoutIndexGetter == null) {
            GraphElementComparatorByLayoutIndex.$$$reportNull$$$0(0);
        }
        this.myLayoutIndexGetter = layoutIndexGetter;
    }

    @Override
    public int compare(@NotNull GraphElement o1, @NotNull GraphElement o2) {
        if (o1 == null) {
            GraphElementComparatorByLayoutIndex.$$$reportNull$$$0(1);
        }
        if (o2 == null) {
            GraphElementComparatorByLayoutIndex.$$$reportNull$$$0(2);
        }
        if (o1 instanceof GraphEdge) {
            GraphEdge edge1 = (GraphEdge)o1;
            if (o2 instanceof GraphEdge) {
                GraphEdge edge2 = (GraphEdge)o2;
                NormalEdge normalEdge1 = LinearGraphUtils.asNormalEdge(edge1);
                NormalEdge normalEdge2 = LinearGraphUtils.asNormalEdge(edge2);
                if (normalEdge1 == null) {
                    return -this.compare2(edge2, new GraphNode(LinearGraphUtils.getNotNullNodeIndex(edge1)));
                }
                if (normalEdge2 == null) {
                    return this.compare2(edge1, new GraphNode(LinearGraphUtils.getNotNullNodeIndex(edge2)));
                }
                if (normalEdge1.up == normalEdge2.up) {
                    if (this.getLayoutIndex(normalEdge1.down) != this.getLayoutIndex(normalEdge2.down)) {
                        return this.getLayoutIndex(normalEdge1.down) - this.getLayoutIndex(normalEdge2.down);
                    }
                    return normalEdge1.down - normalEdge2.down;
                }
                if (normalEdge1.up < normalEdge2.up) {
                    return this.compare2(edge1, new GraphNode(normalEdge2.up));
                }
                return -this.compare2(edge2, new GraphNode(normalEdge1.up));
            }
        }
        if (o1 instanceof GraphEdge && o2 instanceof GraphNode) {
            return this.compare2((GraphEdge)o1, (GraphNode)o2);
        }
        if (o1 instanceof GraphNode && o2 instanceof GraphEdge) {
            return -this.compare2((GraphEdge)o2, (GraphNode)o1);
        }
        assert (false);
        return 0;
    }

    private int compare2(@NotNull GraphEdge edge, @NotNull GraphNode node) {
        NormalEdge normalEdge;
        if (edge == null) {
            GraphElementComparatorByLayoutIndex.$$$reportNull$$$0(3);
        }
        if (node == null) {
            GraphElementComparatorByLayoutIndex.$$$reportNull$$$0(4);
        }
        if ((normalEdge = LinearGraphUtils.asNormalEdge(edge)) == null) {
            return this.getLayoutIndex(LinearGraphUtils.getNotNullNodeIndex(edge)) - this.getLayoutIndex(node.getNodeIndex());
        }
        int upEdgeLI = this.getLayoutIndex(normalEdge.up);
        int downEdgeLI = this.getLayoutIndex(normalEdge.down);
        int nodeLI = this.getLayoutIndex(node.getNodeIndex());
        if (Math.max(upEdgeLI, downEdgeLI) != nodeLI) {
            return Math.max(upEdgeLI, downEdgeLI) - nodeLI;
        }
        return normalEdge.up - node.getNodeIndex();
    }

    private int getLayoutIndex(int nodeIndex) {
        return (Integer)this.myLayoutIndexGetter.fun((Object)nodeIndex);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutIndexGetter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/graph/impl/print/GraphElementComparatorByLayoutIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "compare";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "compare2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

