/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.tools.external.ExternalDiffTool;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChainBackedDiffPreviewProvider;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.EditorTabPreviewBase;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.ui.frame.EditorDiffPreview;
import com.intellij.vcs.log.ui.frame.VcsLogChangeProcessor;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0017\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogEditorDiffPreview;", "Lcom/intellij/vcs/log/ui/frame/EditorDiffPreview;", "Lcom/intellij/openapi/vcs/changes/ChainBackedDiffPreviewProvider;", "project", "Lcom/intellij/openapi/project/Project;", "changesBrowser", "Lcom/intellij/vcs/log/ui/frame/VcsLogChangesBrowser;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/ui/frame/VcsLogChangesBrowser;)V", "addSelectionListener", "", "listener", "Lkotlin/Function0;", "createDiffRequestChain", "Lcom/intellij/diff/chains/DiffRequestChain;", "createDiffRequestProcessor", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "getEditorTabName", "", "Lorg/jetbrains/annotations/Nls;", "processor", "getOwnerComponent", "Ljavax/swing/JComponent;", "performDiffAction", "", "intellij.platform.vcs.log.impl"})
public final class VcsLogEditorDiffPreview
extends EditorDiffPreview
implements ChainBackedDiffPreviewProvider {
    @NotNull
    private final VcsLogChangesBrowser changesBrowser;

    public VcsLogEditorDiffPreview(@NotNull Project project2, @NotNull VcsLogChangesBrowser changesBrowser) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)changesBrowser, (String)"changesBrowser");
        super(project2, changesBrowser);
        this.changesBrowser = changesBrowser;
        this.init();
    }

    @Override
    @NotNull
    public DiffRequestProcessor createDiffRequestProcessor() {
        VcsLogChangeProcessor preview = this.changesBrowser.createChangeProcessor(true);
        preview.updatePreview(true);
        return (DiffRequestProcessor)preview;
    }

    @Override
    @NotNull
    public String getEditorTabName(@Nullable DiffRequestProcessor processor2) {
        String string2;
        FilePath filePath;
        Object object = processor2 instanceof VcsLogChangeProcessor ? (VcsLogChangeProcessor)processor2 : null;
        FilePath filePath2 = object != null && (object = ((ChangeViewDiffRequestProcessor)object).getCurrentChange()) != null ? object.getFilePath() : (filePath = null);
        if (filePath == null) {
            String string3 = VcsLogBundle.message("vcs.log.diff.preview.editor.empty.tab.name", new Object[0]);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"vcs.log.diff.pr\u2026w.editor.empty.tab.name\")");
        } else {
            Object[] objectArray = new Object[]{filePath.getName()};
            String string4 = VcsLogBundle.message("vcs.log.diff.preview.editor.tab.name", objectArray);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"vcs.log.diff.pr\u2026tab.name\", filePath.name)");
        }
        return string2;
    }

    @Override
    @NotNull
    public JComponent getOwnerComponent() {
        JComponent jComponent = this.changesBrowser.getPreferredFocusedComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"changesBrowser.preferredFocusedComponent");
        return jComponent;
    }

    @Override
    public void addSelectionListener(@NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.changesBrowser.getViewer().addSelectionListener(() -> VcsLogEditorDiffPreview.addSelectionListener$lambda$0(this, listener2), this.getOwner());
        this.changesBrowser.addListener(() -> VcsLogEditorDiffPreview.addSelectionListener$lambda$1(this), this.getOwner());
    }

    @Override
    @Nullable
    public DiffRequestChain createDiffRequestChain() {
        ListSelection listSelection = VcsTreeModelData.getListSelectionOrAll((JTree)((Object)this.changesBrowser.getViewer())).map(arg_0 -> VcsLogEditorDiffPreview.createDiffRequestChain$lambda$2(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)listSelection, (String)"getListSelectionOrAll(ch\u2026Producer(it, false)\n    }");
        ListSelection producers = listSelection;
        return (DiffRequestChain)SimpleDiffRequestChain.fromProducers((ListSelection)producers);
    }

    @Override
    public boolean performDiffAction() {
        if (ExternalDiffTool.isEnabled()) {
            ListSelection listSelection = VcsTreeModelData.getListSelectionOrAll((JTree)((Object)this.changesBrowser.getViewer())).map(arg_0 -> VcsLogEditorDiffPreview.performDiffAction$lambda$3(this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)listSelection, (String)"getListSelectionOrAll(ch\u2026Producer(change, false) }");
            ListSelection diffProducers = listSelection;
            if (EditorTabPreviewBase.Companion.showExternalToolIfNeeded(this.getProject(), (ListSelection<? extends DiffRequestProducer>)diffProducers)) {
                return true;
            }
        }
        return super.performDiffAction();
    }

    private static final void addSelectionListener$lambda$0(VcsLogEditorDiffPreview this$0, Function0 $listener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        if (!((Collection)this$0.changesBrowser.getSelectedChanges()).isEmpty()) {
            $listener.invoke();
        }
    }

    private static final void addSelectionListener$lambda$1(VcsLogEditorDiffPreview this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updatePreview(true);
    }

    private static final ChangeDiffRequestChain.Producer createDiffRequestChain$lambda$2(VcsLogEditorDiffPreview this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        VcsLogChangesBrowser vcsLogChangesBrowser = this$0.changesBrowser;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return vcsLogChangesBrowser.getDiffRequestProducer(it, false);
    }

    private static final ChangeDiffRequestChain.Producer performDiffAction$lambda$3(VcsLogEditorDiffPreview this$0, Object change) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        VcsLogChangesBrowser vcsLogChangesBrowser = this$0.changesBrowser;
        Intrinsics.checkNotNullExpressionValue((Object)change, (String)"change");
        return vcsLogChangesBrowser.getDiffRequestProducer(change, false);
    }
}

