/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.dtd;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.xml.XmlContentParticle;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlElementsGroup;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class XmlElementsGroupImpl
implements XmlElementsGroup {
    private final XmlContentParticle myParticle;
    private final XmlElementsGroup myParent;
    private final NotNullLazyValue<List<XmlElementsGroup>> mySubGroups;

    public XmlElementsGroupImpl(@NotNull XmlContentParticle particle, XmlElementsGroup parent) {
        if (particle == null) {
            XmlElementsGroupImpl.$$$reportNull$$$0(0);
        }
        this.myParticle = particle;
        this.myParent = parent;
        this.mySubGroups = NotNullLazyValue.lazy(() -> ContainerUtil.map((Object[])this.myParticle.getSubParticles(), xmlContentParticle -> new XmlElementsGroupImpl((XmlContentParticle)xmlContentParticle, this)));
    }

    @Override
    public int getMinOccurs() {
        return switch (this.myParticle.getQuantifier()) {
            default -> throw new IncompatibleClassChangeError();
            case XmlContentParticle.Quantifier.ONE_OR_MORE, XmlContentParticle.Quantifier.REQUIRED -> 1;
            case XmlContentParticle.Quantifier.ZERO_OR_MORE, XmlContentParticle.Quantifier.OPTIONAL -> 0;
        };
    }

    @Override
    public int getMaxOccurs() {
        return switch (this.myParticle.getQuantifier()) {
            default -> throw new IncompatibleClassChangeError();
            case XmlContentParticle.Quantifier.ONE_OR_MORE, XmlContentParticle.Quantifier.ZERO_OR_MORE -> Integer.MAX_VALUE;
            case XmlContentParticle.Quantifier.REQUIRED, XmlContentParticle.Quantifier.OPTIONAL -> 1;
        };
    }

    @Override
    public XmlElementsGroup.Type getGroupType() {
        return switch (this.myParticle.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case XmlContentParticle.Type.SEQUENCE -> XmlElementsGroup.Type.SEQUENCE;
            case XmlContentParticle.Type.CHOICE -> XmlElementsGroup.Type.CHOICE;
            case XmlContentParticle.Type.ELEMENT -> XmlElementsGroup.Type.LEAF;
        };
    }

    @Override
    public XmlElementsGroup getParentGroup() {
        return this.myParent;
    }

    @Override
    public List<XmlElementsGroup> getSubGroups() {
        return (List)this.mySubGroups.getValue();
    }

    @Override
    public XmlElementDescriptor getLeafDescriptor() {
        return this.myParticle.getElementDescriptor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "particle", "com/intellij/xml/impl/dtd/XmlElementsGroupImpl", "<init>"));
    }
}

