/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.json.JsonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PairProcessor;
import com.intellij.util.PatternUtil;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.jsonSchema.JsonMappingKind;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="SchemaInfo")
public final class UserDefinedJsonSchemaConfiguration {
    private static final Comparator<Item> ITEM_COMPARATOR = (o1, o2) -> {
        if (o1.isPattern() != o2.isPattern()) {
            return o1.isPattern() ? -1 : 1;
        }
        if (o1.isDirectory() != o2.isDirectory()) {
            return o1.isDirectory() ? -1 : 1;
        }
        return o1.path.compareToIgnoreCase(o2.path);
    };
    @Nls
    private String name;
    @Nullable
    @Nls
    private String generatedName;
    public String relativePathToSchema;
    public JsonSchemaVersion schemaVersion;
    public boolean applicationDefined;
    public List<Item> patterns;
    public boolean isIgnoredFile;
    @Transient
    private final SynchronizedClearableLazy<List<PairProcessor<Project, VirtualFile>>> myCalculatedPatterns;

    public UserDefinedJsonSchemaConfiguration() {
        this.schemaVersion = JsonSchemaVersion.SCHEMA_4;
        this.patterns = new SmartList();
        this.isIgnoredFile = false;
        this.myCalculatedPatterns = new SynchronizedClearableLazy(this::recalculatePatterns);
    }

    public UserDefinedJsonSchemaConfiguration(@NotNull @NlsSafe String name, JsonSchemaVersion schemaVersion, @NotNull String relativePathToSchema, boolean applicationDefined, @Nullable List<Item> patterns) {
        if (name == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(0);
        }
        if (relativePathToSchema == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(1);
        }
        this.schemaVersion = JsonSchemaVersion.SCHEMA_4;
        this.patterns = new SmartList();
        this.isIgnoredFile = false;
        this.myCalculatedPatterns = new SynchronizedClearableLazy(this::recalculatePatterns);
        this.name = name;
        this.relativePathToSchema = relativePathToSchema;
        this.schemaVersion = schemaVersion;
        this.applicationDefined = applicationDefined;
        this.setPatterns(patterns);
    }

    public void setGeneratedName(@NotNull @Nls String generatedName) {
        if (generatedName == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(2);
        }
        this.generatedName = generatedName;
    }

    @Nls
    public String getGeneratedName() {
        return this.generatedName;
    }

    @Nls
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull @Nls String name) {
        if (name == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(3);
        }
        this.name = name;
    }

    public boolean isIgnoredFile() {
        return this.isIgnoredFile;
    }

    public void setIgnoredFile(boolean ignoredFile) {
        this.isIgnoredFile = ignoredFile;
    }

    public String getRelativePathToSchema() {
        return Item.normalizePath(this.relativePathToSchema);
    }

    public JsonSchemaVersion getSchemaVersion() {
        return this.schemaVersion;
    }

    public void setSchemaVersion(JsonSchemaVersion schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public void setRelativePathToSchema(String relativePathToSchema) {
        this.relativePathToSchema = Item.neutralizePath(relativePathToSchema);
    }

    public boolean isApplicationDefined() {
        return this.applicationDefined;
    }

    public void setApplicationDefined(boolean applicationDefined) {
        this.applicationDefined = applicationDefined;
    }

    public List<Item> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(@Nullable List<Item> patterns) {
        this.patterns.clear();
        if (patterns != null) {
            this.patterns.addAll(patterns);
        }
        this.patterns.sort(ITEM_COMPARATOR);
        this.myCalculatedPatterns.drop();
    }

    public void refreshPatterns() {
        this.myCalculatedPatterns.drop();
    }

    @NotNull
    public List<PairProcessor<Project, VirtualFile>> getCalculatedPatterns() {
        List list = (List)this.myCalculatedPatterns.getValue();
        if (list == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(4);
        }
        return list;
    }

    private List<PairProcessor<Project, VirtualFile>> recalculatePatterns() {
        SmartList result2 = new SmartList();
        for (Item patternText : this.patterns) {
            switch (patternText.mappingKind) {
                case File: {
                    result2.add((project2, vfile) -> vfile.equals(UserDefinedJsonSchemaConfiguration.getRelativeFile(project2, patternText)) || vfile.getUrl().equals(Item.neutralizePath(patternText.getPath())));
                    break;
                }
                case Pattern: {
                    String pathText = FileUtil.toSystemIndependentName((String)patternText.getPath());
                    Pattern pattern2 = pathText.isEmpty() ? PatternUtil.NOTHING : (pathText.indexOf(47) >= 0 ? PatternUtil.compileSafe((String)(".*/" + PatternUtil.convertToRegex((String)pathText)), (Pattern)PatternUtil.NOTHING) : PatternUtil.fromMask((String)pathText));
                    result2.add((project2, file) -> JsonSchemaObject.matchPattern(pattern2, pathText.indexOf(47) >= 0 ? file.getPath() : file.getName()));
                    break;
                }
                case Directory: {
                    result2.add((project2, vfile) -> {
                        VirtualFile relativeFile = UserDefinedJsonSchemaConfiguration.getRelativeFile(project2, patternText);
                        if (relativeFile == null || !VfsUtilCore.isAncestor((VirtualFile)relativeFile, (VirtualFile)vfile, (boolean)true)) {
                            return false;
                        }
                        JsonSchemaService service = JsonSchemaService.Impl.get(project2);
                        return service.isApplicableToFile((VirtualFile)vfile);
                    });
                }
            }
        }
        return result2;
    }

    @Nullable
    private static VirtualFile getRelativeFile(@NotNull Project project2, @NotNull Item pattern2) {
        if (project2 == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(5);
        }
        if (pattern2 == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(6);
        }
        if (project2.getBasePath() == null) {
            return null;
        }
        String path2 = FileUtilRt.toSystemIndependentName((String)StringUtil.notNullize((String)pattern2.path));
        List<String> parts = UserDefinedJsonSchemaConfiguration.pathToPartsList(path2);
        if (parts.isEmpty()) {
            return project2.getBaseDir();
        }
        return VfsUtil.findRelativeFile((VirtualFile)project2.getBaseDir(), (String[])ArrayUtilRt.toStringArray(parts));
    }

    @NotNull
    private static List<String> pathToPartsList(@NotNull String path2) {
        if (path2 == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(7);
        }
        List list = ContainerUtil.filter((Collection)StringUtil.split((String)path2, (String)"/"), s -> !".".equals(s));
        if (list == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static String @NotNull [] pathToParts(@NotNull String path2) {
        if (path2 == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(9);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(UserDefinedJsonSchemaConfiguration.pathToPartsList(path2));
        if (stringArray == null) {
            UserDefinedJsonSchemaConfiguration.$$$reportNull$$$0(10);
        }
        return stringArray;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDefinedJsonSchemaConfiguration info = (UserDefinedJsonSchemaConfiguration)o;
        if (this.applicationDefined != info.applicationDefined) {
            return false;
        }
        if (this.schemaVersion != info.schemaVersion) {
            return false;
        }
        if (!Objects.equals(this.name, info.name)) {
            return false;
        }
        if (!Objects.equals(this.relativePathToSchema, info.relativePathToSchema)) {
            return false;
        }
        return Objects.equals(this.patterns, info.patterns);
    }

    public int hashCode() {
        int result2 = this.name != null ? this.name.hashCode() : 0;
        result2 = 31 * result2 + (this.relativePathToSchema != null ? this.relativePathToSchema.hashCode() : 0);
        result2 = 31 * result2 + (this.applicationDefined ? 1 : 0);
        result2 = 31 * result2 + (this.patterns != null ? this.patterns.hashCode() : 0);
        result2 = 31 * result2 + this.schemaVersion.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePathToSchema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedName";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/UserDefinedJsonSchemaConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/UserDefinedJsonSchemaConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCalculatedPatterns";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "pathToPartsList";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "pathToParts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setGeneratedName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "pathToPartsList";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "pathToParts";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 8, 10 -> new IllegalStateException(string2);
        };
    }

    public static class Item {
        public String path;
        public JsonMappingKind mappingKind = JsonMappingKind.File;

        public Item() {
        }

        public Item(String path2, JsonMappingKind mappingKind) {
            this.path = Item.neutralizePath(path2);
            this.mappingKind = mappingKind;
        }

        public Item(String path2, boolean isPattern, boolean isDirectory) {
            this.path = Item.neutralizePath(path2);
            this.mappingKind = isPattern ? JsonMappingKind.Pattern : (isDirectory ? JsonMappingKind.Directory : JsonMappingKind.File);
        }

        @NotNull
        private static String normalizePath(@NotNull String path2) {
            if (path2 == null) {
                Item.$$$reportNull$$$0(0);
            }
            if (Item.preserveSlashes(path2)) {
                String string2 = path2;
                if (string2 == null) {
                    Item.$$$reportNull$$$0(1);
                }
                return string2;
            }
            String string3 = StringUtil.trimEnd((String)FileUtilRt.toSystemDependentName((String)path2), (char)File.separatorChar);
            if (string3 == null) {
                Item.$$$reportNull$$$0(2);
            }
            return string3;
        }

        private static boolean preserveSlashes(@NotNull String path2) {
            if (path2 == null) {
                Item.$$$reportNull$$$0(3);
            }
            return StringUtil.startsWith((CharSequence)path2, (CharSequence)"http:") || StringUtil.startsWith((CharSequence)path2, (CharSequence)"https:") || JsonFileResolver.isTempOrMockUrl(path2);
        }

        @NotNull
        public static String neutralizePath(@NotNull String path2) {
            if (path2 == null) {
                Item.$$$reportNull$$$0(4);
            }
            if (Item.preserveSlashes(path2)) {
                String string2 = path2;
                if (string2 == null) {
                    Item.$$$reportNull$$$0(5);
                }
                return string2;
            }
            String string3 = StringUtil.trimEnd((String)FileUtilRt.toSystemIndependentName((String)path2), (char)'/');
            if (string3 == null) {
                Item.$$$reportNull$$$0(6);
            }
            return string3;
        }

        public String getPath() {
            return Item.normalizePath(this.path);
        }

        public void setPath(String path2) {
            this.path = Item.neutralizePath(path2);
        }

        @NlsContexts.Tooltip
        public String getError() {
            return switch (this.mappingKind) {
                default -> throw new IncompatibleClassChangeError();
                case JsonMappingKind.File -> {
                    if (!StringUtil.isEmpty((String)this.path)) {
                        yield null;
                    }
                    yield JsonBundle.message("schema.configuration.error.empty.file.path", new Object[0]);
                }
                case JsonMappingKind.Pattern -> {
                    if (!StringUtil.isEmpty((String)this.path)) {
                        yield null;
                    }
                    yield JsonBundle.message("schema.configuration.error.empty.pattern", new Object[0]);
                }
                case JsonMappingKind.Directory -> null;
            };
        }

        public boolean isPattern() {
            return this.mappingKind == JsonMappingKind.Pattern;
        }

        public void setPattern(boolean pattern2) {
            this.mappingKind = pattern2 ? JsonMappingKind.Pattern : JsonMappingKind.File;
        }

        public boolean isDirectory() {
            return this.mappingKind == JsonMappingKind.Directory;
        }

        public void setDirectory(boolean directory) {
            this.mappingKind = directory ? JsonMappingKind.Directory : JsonMappingKind.File;
        }

        public String getPresentation() {
            if (this.mappingKind == JsonMappingKind.Directory && StringUtil.isEmpty((String)this.path)) {
                return JsonBundle.message("schema.configuration.project.directory", this.mappingKind.getPrefix());
            }
            return this.mappingKind.getPrefix() + this.getPath();
        }

        public String[] getPathParts() {
            return UserDefinedJsonSchemaConfiguration.pathToParts(this.path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item2 = (Item)o;
            if (this.mappingKind != item2.mappingKind) {
                return false;
            }
            return Objects.equals(this.path, item2.path);
        }

        public int hashCode() {
            int result2 = Objects.hashCode(this.path);
            result2 = 31 * result2 + Objects.hashCode((Object)this.mappingKind);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/UserDefinedJsonSchemaConfiguration$Item";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/UserDefinedJsonSchemaConfiguration$Item";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "normalizePath";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "neutralizePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "normalizePath";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "preserveSlashes";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "neutralizePath";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 2, 5, 6 -> new IllegalStateException(string2);
            };
        }
    }
}

