/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.util.Processor;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaTreeNode;
import com.jetbrains.jsonSchema.impl.SchemaResolveState;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class MatchResult {
    public final List<JsonSchemaObject> mySchemas;
    public final List<Collection<? extends JsonSchemaObject>> myExcludingSchemas;

    private MatchResult(@NotNull List<JsonSchemaObject> schemas, @NotNull List<Collection<? extends JsonSchemaObject>> excludingSchemas) {
        if (schemas == null) {
            MatchResult.$$$reportNull$$$0(0);
        }
        if (excludingSchemas == null) {
            MatchResult.$$$reportNull$$$0(1);
        }
        this.mySchemas = Collections.unmodifiableList(schemas);
        this.myExcludingSchemas = Collections.unmodifiableList(excludingSchemas);
    }

    public static MatchResult create(@NotNull JsonSchemaTreeNode root) {
        if (root == null) {
            MatchResult.$$$reportNull$$$0(2);
        }
        ArrayList<JsonSchemaObject> schemas = new ArrayList<JsonSchemaObject>();
        Int2ObjectOpenHashMap oneOfGroups = new Int2ObjectOpenHashMap();
        MatchResult.iterateTree(root, (Processor<? super JsonSchemaTreeNode>)((Processor)arg_0 -> MatchResult.lambda$create$1(schemas, (Int2ObjectMap)oneOfGroups, arg_0)));
        List<Collection<? extends JsonSchemaObject>> result2 = oneOfGroups.isEmpty() ? Collections.emptyList() : new ArrayList(oneOfGroups.values());
        return new MatchResult(schemas, result2);
    }

    public static void iterateTree(@NotNull JsonSchemaTreeNode root, @NotNull Processor<? super JsonSchemaTreeNode> processor2) {
        if (root == null) {
            MatchResult.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            MatchResult.$$$reportNull$$$0(4);
        }
        ArrayDeque<JsonSchemaTreeNode> queue2 = new ArrayDeque<JsonSchemaTreeNode>(root.getChildren());
        while (!queue2.isEmpty()) {
            JsonSchemaTreeNode node = queue2.removeFirst();
            if (node.getChildren().isEmpty()) {
                if (node.isNothing() || !SchemaResolveState.normal.equals((Object)node.getResolveState()) || processor2.process((Object)node)) continue;
                break;
            }
            queue2.addAll(node.getChildren());
        }
    }

    private static /* synthetic */ boolean lambda$create$1(List schemas, Int2ObjectMap oneOfGroups, JsonSchemaTreeNode node) {
        if (node.isAny()) {
            return true;
        }
        int groupNumber = node.getExcludingGroupNumber();
        if (groupNumber < 0) {
            schemas.add(node.getSchema());
        } else {
            ((List)oneOfGroups.computeIfAbsent(groupNumber, __ -> new ArrayList())).add(node.getSchema());
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemas";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludingSchemas";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/MatchResult";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateTree";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

