/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.json.JsonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RemoveProhibitedPropertyFix
implements LocalQuickFix {
    @FileModifier.SafeFieldForPreview
    private final JsonValidationError.ProhibitedPropertyIssueData myData;
    @FileModifier.SafeFieldForPreview
    private final JsonLikeSyntaxAdapter myQuickFixAdapter;

    public RemoveProhibitedPropertyFix(JsonValidationError.ProhibitedPropertyIssueData data2, JsonLikeSyntaxAdapter quickFixAdapter) {
        this.myData = data2;
        this.myQuickFixAdapter = quickFixAdapter;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string2 = JsonBundle.message("remove.prohibited.property", new Object[0]);
        if (string2 == null) {
            RemoveProhibitedPropertyFix.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string2 = this.getFamilyName() + " '" + this.myData.propertyName + "'";
        if (string2 == null) {
            RemoveProhibitedPropertyFix.$$$reportNull$$$0(1);
        }
        return string2;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            RemoveProhibitedPropertyFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            RemoveProhibitedPropertyFix.$$$reportNull$$$0(3);
        }
        PsiElement element = descriptor.getPsiElement();
        assert (this.myData.propertyName.equals(this.myQuickFixAdapter.getPropertyName(element)));
        PsiElement forward = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
        element.delete();
        this.myQuickFixAdapter.removeIfComma(forward);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/fixes/RemoveProhibitedPropertyFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/fixes/RemoveProhibitedPropertyFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3 -> new IllegalArgumentException(string2);
        };
    }
}

