/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.ValueNodeAsyncFunction;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.NonWatchableVariableContext;
import org.jetbrains.debugger.ObjectProperty;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.VariablesGroup;
import org.jetbrains.debugger.VariablesKt;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a>\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000bH\u0002\u001a6\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a*\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u001a\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\f\u001a\u00020\r\u001a\u001c\u0010\u0019\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0002\u001a,\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%\u001an\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e2\u0006\u0010#\u001a\u00020\u00172\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00120\u001e2\u0006\u0010'\u001a\u00020(2<\u0010)\u001a8\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(\f\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00020\u0012\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00070*\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"NATURAL_NAME_COMPARATOR", "Ljava/util/Comparator;", "Lorg/jetbrains/debugger/Variable;", "UNNAMED_FUNCTION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "addAditionalVariables", "", "additionalVariables", "", "result", "", "memberFilter", "Lorg/jetbrains/debugger/MemberFilter;", "functions", "createVariablesList", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "variables", "", "from", "", "to", "variableContext", "Lorg/jetbrains/debugger/VariableContext;", "filterAndSort", "naturalCompare", "string1", "", "string2", "processScopeVariables", "Lorg/jetbrains/concurrency/Promise;", "scope", "Lorg/jetbrains/debugger/Scope;", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "context", "isLast", "", "processVariables", "obsolescent", "Lorg/jetbrains/concurrency/Obsolescent;", "consumer", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "intellij.platform.scriptDebugger.ui"})
@SourceDebugExtension(value={"SMAP\nVariables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Variables.kt\norg/jetbrains/debugger/VariablesKt\n+ 2 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n*L\n1#1,282:1\n129#2,3:283\n*S KotlinDebug\n*F\n+ 1 Variables.kt\norg/jetbrains/debugger/VariablesKt\n*L\n41#1:283,3\n*E\n"})
public final class VariablesKt {
    private static final Pattern UNNAMED_FUNCTION_PATTERN = Pattern.compile("^function[\\t ]*\\(");
    @NotNull
    private static final Comparator<Variable> NATURAL_NAME_COMPARATOR = VariablesKt::NATURAL_NAME_COMPARATOR$lambda$0;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Promise<Unit> processVariables(@NotNull VariableContext context, @NotNull Promise<List<Variable>> variables, @NotNull Obsolescent obsolescent, @NotNull Function2<? super MemberFilter, ? super List<? extends Variable>, Unit> consumer) {
        void $this$thenAsync$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)obsolescent, (String)"obsolescent");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Promise<MemberFilter> promise = context.getMemberFilter();
        boolean $i$f$thenAsync = false;
        Promise promise2 = $this$thenAsync$iv.thenAsync((Function)new ValueNodeAsyncFunction<MemberFilter, Unit>(obsolescent, variables, obsolescent, consumer){
            final /* synthetic */ Promise $variables$inlined;
            final /* synthetic */ Obsolescent $obsolescent$inlined;
            final /* synthetic */ Function2 $consumer$inlined;
            {
                this.$variables$inlined = promise;
                this.$obsolescent$inlined = obsolescent;
                this.$consumer$inlined = function2;
                super($node);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            @NotNull
            public Promise fun(Object param) {
                void $this$then$iv;
                MemberFilter memberFilter = (MemberFilter)param;
                boolean bl = false;
                Promise promise = this.$variables$inlined;
                boolean $i$f$then = false;
                Promise promise2 = $this$then$iv.then((Function)new ObsolescentFunction<List<? extends Variable>, Unit>(this.$obsolescent$inlined, this.$consumer$inlined, memberFilter){
                    final /* synthetic */ Obsolescent $obsolescent;
                    final /* synthetic */ Function2 $consumer$inlined;
                    final /* synthetic */ MemberFilter $memberFilter$inlined;
                    {
                        this.$obsolescent = $obsolescent;
                        this.$consumer$inlined = function2;
                        this.$memberFilter$inlined = memberFilter;
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public Object fun(Object param) {
                        List it = (List)param;
                        boolean bl = false;
                        this.$consumer$inlined.invoke((Object)this.$memberFilter$inlined, (Object)it);
                        return Unit.INSTANCE;
                    }

                    public boolean isObsolete() {
                        return this.$obsolescent.isObsolete();
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"obsolescent: Obsolescent\u2026obsolescent.isObsolete\n})");
                return promise2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"node: Obsolescent, cross\u2026m: T) = handler(param)\n})");
        return promise2;
    }

    @NotNull
    public static final Promise<Unit> processScopeVariables(@NotNull Scope scope2, @NotNull XCompositeNode node, @NotNull VariableContext context, boolean isLast) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Promise<List<Variable>> promise = scope2.getVariablesHost().get();
        Intrinsics.checkNotNullExpressionValue(promise, (String)"scope.variablesHost.get()");
        return VariablesKt.processVariables(context, promise, (Obsolescent)node, (Function2<? super MemberFilter, ? super List<? extends Variable>, Unit>)((Function2)new Function2<MemberFilter, List<? extends Variable>, Unit>(context, node, isLast){
            final /* synthetic */ VariableContext $context;
            final /* synthetic */ XCompositeNode $node;
            final /* synthetic */ boolean $isLast;
            {
                this.$context = $context;
                this.$node = $node;
                this.$isLast = $isLast;
                super(2);
            }

            public final void invoke(@NotNull MemberFilter memberFilter, @NotNull List<? extends Variable> variables) {
                Intrinsics.checkNotNullParameter((Object)memberFilter, (String)"memberFilter");
                Intrinsics.checkNotNullParameter(variables, (String)"variables");
                Collection<Variable> additionalVariables = memberFilter.getAdditionalVariables();
                Object object = this.$context.getVm();
                Value exceptionValue = object != null && (object = object.getSuspendContextManager()) != null && (object = object.getContext()) != null && (object = object.getExceptionData()) != null ? object.getExceptionValue() : null;
                ArrayList<Variable> properties2 = new ArrayList<Variable>(variables.size() + additionalVariables.size() + (exceptionValue == null ? 0 : 1));
                Value value2 = exceptionValue;
                if (value2 != null) {
                    Value it = value2;
                    boolean bl = false;
                    properties2.add(new VariableImpl("Exception", it));
                }
                SmartList functions = new SmartList();
                for (Variable variable : variables) {
                    String stringValue;
                    Value value3;
                    if (!memberFilter.isMemberVisible(variable)) continue;
                    Value value4 = value3 = variable.getValue();
                    String string2 = stringValue = value4 != null ? value4.getValueString() : null;
                    if (value3 != null && value3.getType() == ValueType.FUNCTION && stringValue != null && !VariablesKt.access$getUNNAMED_FUNCTION_PATTERN$p().matcher(stringValue).lookingAt()) {
                        functions.add((Object)variable);
                        continue;
                    }
                    properties2.add(variable);
                }
                VariablesKt.addAditionalVariables$default(additionalVariables, properties2, memberFilter, null, 8, null);
                if (XDebuggerSettingsManager.getInstance().getDataViewSettings().isSortValues()) {
                    Comparator comparator2 = memberFilter.hasNameMappings() ? (arg_0, arg_1) -> processScopeVariables.1.invoke$lambda$1(memberFilter, arg_0, arg_1) : VariablesKt.access$getNATURAL_NAME_COMPARATOR$p();
                    CollectionsKt.sortWith((List)properties2, (Comparator)comparator2);
                    CollectionsKt.sortWith((List)((List)functions), (Comparator)comparator2);
                }
                if (!properties2.isEmpty()) {
                    this.$node.addChildren(VariablesKt.createVariablesList((List<? extends Variable>)properties2, this.$context, memberFilter), functions.isEmpty() && this.$isLast);
                }
                if (!functions.isEmpty()) {
                    this.$node.addChildren(XValueChildrenList.bottomGroup((XValueGroup)new VariablesGroup("Functions", (List)functions, this.$context)), this.$isLast);
                } else if (this.$isLast && properties2.isEmpty()) {
                    this.$node.addChildren(XValueChildrenList.EMPTY, true);
                }
            }

            private static final int invoke$lambda$1(MemberFilter $memberFilter, Variable o1, Variable o2) {
                Intrinsics.checkNotNullParameter((Object)$memberFilter, (String)"$memberFilter");
                Intrinsics.checkNotNullExpressionValue((Object)o1, (String)"o1");
                String string2 = $memberFilter.rawNameToSource(o1);
                Intrinsics.checkNotNullExpressionValue((Object)o2, (String)"o2");
                return VariablesKt.access$naturalCompare(string2, $memberFilter.rawNameToSource(o2));
            }
        }));
    }

    @NotNull
    public static final List<Variable> filterAndSort(@NotNull List<? extends Variable> variables, @NotNull MemberFilter memberFilter) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)memberFilter, (String)"memberFilter");
        if (variables.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Collection<Variable> additionalVariables = memberFilter.getAdditionalVariables();
        ArrayList<Variable> result2 = new ArrayList<Variable>(variables.size() + additionalVariables.size());
        for (Variable variable : variables) {
            if (!memberFilter.isMemberVisible(variable)) continue;
            result2.add(variable);
        }
        if (XDebuggerSettingsManager.getInstance().getDataViewSettings().isSortValues()) {
            CollectionsKt.sortWith((List)result2, NATURAL_NAME_COMPARATOR);
        }
        VariablesKt.addAditionalVariables$default(additionalVariables, result2, memberFilter, null, 8, null);
        return result2;
    }

    private static final void addAditionalVariables(Collection<? extends Variable> additionalVariables, List<Variable> result2, MemberFilter memberFilter, List<Variable> functions) {
        int oldSize = result2.size();
        block0: for (Variable variable : additionalVariables) {
            if (!memberFilter.isMemberVisible(variable)) continue;
            int i = 0;
            int n = oldSize - 1;
            if (i <= n) {
                while (true) {
                    Variable vmVariable;
                    if (Intrinsics.areEqual((Object)memberFilter.rawNameToSource(vmVariable = result2.get(i)), (Object)memberFilter.rawNameToSource(variable))) {
                        Value vmValue = vmVariable.getValue();
                        if (vmValue != null) {
                            variable.setValue(vmValue);
                        }
                        result2.set(i, variable);
                        continue block0;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            if (functions != null) {
                for (Variable function : functions) {
                    if (!Intrinsics.areEqual((Object)memberFilter.rawNameToSource(function), (Object)memberFilter.rawNameToSource(variable))) continue;
                    continue block0;
                }
            }
            result2.add(variable);
        }
    }

    static /* synthetic */ void addAditionalVariables$default(Collection collection, List list, MemberFilter memberFilter, List list2, int n, Object object) {
        if ((n & 8) != 0) {
            list2 = null;
        }
        VariablesKt.addAditionalVariables(collection, list, memberFilter, list2);
    }

    private static final int naturalCompare(String string1, String string2) {
        int j;
        if (string1 == string2) {
            return 0;
        }
        if (string1 == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        int string1Length = string1.length();
        int string2Length = string2.length();
        int i = 0;
        for (j = 0; i < string1Length && j < string2Length; ++i, ++j) {
            char ch1 = string1.charAt(i);
            char ch2 = string2.charAt(j);
            if ((StringUtil.isDecimalDigit((char)ch1) || ch1 == ' ') && (StringUtil.isDecimalDigit((char)ch2) || ch2 == ' ')) {
                int startNum1 = i;
                while ((ch1 == ' ' || ch1 == '0') && ++startNum1 < string1Length) {
                    ch1 = string1.charAt(startNum1);
                }
                int startNum2 = j;
                while ((ch2 == ' ' || ch2 == '0') && ++startNum2 < string2Length) {
                    ch2 = string2.charAt(startNum2);
                }
                j = startNum2;
                for (i = startNum1; i < string1Length && StringUtil.isDecimalDigit((char)string1.charAt(i)); ++i) {
                }
                while (j < string2Length && StringUtil.isDecimalDigit((char)string2.charAt(j))) {
                    ++j;
                }
                int lengthDiff = i - startNum1 - (j - startNum2);
                if (lengthDiff != 0) {
                    return lengthDiff;
                }
                while (startNum1 < i) {
                    int diff = string1.charAt(startNum1) - string2.charAt(startNum2);
                    if (diff != 0) {
                        return diff;
                    }
                    ++startNum1;
                    ++startNum2;
                }
                --i;
                --j;
                continue;
            }
            if (ch1 == ch2) continue;
            if (ch1 == '_') {
                return 1;
            }
            if (ch2 == '_') {
                return -1;
            }
            return VariablesKt.naturalCompare$reverseCase(ch1) - VariablesKt.naturalCompare$reverseCase(ch2);
        }
        if (i < string1Length) {
            return 1;
        }
        if (j < string2Length) {
            return -1;
        }
        return string1Length - string2Length;
    }

    @JvmOverloads
    @NotNull
    public static final XValueChildrenList createVariablesList(@NotNull List<? extends Variable> variables, @NotNull VariableContext variableContext, @Nullable MemberFilter memberFilter) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)variableContext, (String)"variableContext");
        return VariablesKt.createVariablesList(variables, 0, variables.size(), variableContext, memberFilter);
    }

    public static /* synthetic */ XValueChildrenList createVariablesList$default(List list, VariableContext variableContext, MemberFilter memberFilter, int n, Object object) {
        if ((n & 4) != 0) {
            memberFilter = null;
        }
        return VariablesKt.createVariablesList(list, variableContext, memberFilter);
    }

    @NotNull
    public static final XValueChildrenList createVariablesList(@NotNull List<? extends Variable> variables, int from, int to, @NotNull VariableContext variableContext, @Nullable MemberFilter memberFilter) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)variableContext, (String)"variableContext");
        XValueChildrenList list = new XValueChildrenList(to - from);
        VariableContext getterOrSetterContext = null;
        for (int i = from; i < to; ++i) {
            Variable variable = variables.get(i);
            Object object = memberFilter;
            if (object == null || (object = object.rawNameToSource(variable)) == null) {
                String string2 = variable.getName();
                object = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"variable.name");
            }
            Object normalizedName = object;
            list.add((XNamedValue)new VariableView((String)normalizedName, variable, variableContext));
            if (!(variable instanceof ObjectProperty)) continue;
            if (((ObjectProperty)variable).getGetter() != null) {
                if (getterOrSetterContext == null) {
                    getterOrSetterContext = new NonWatchableVariableContext(variableContext);
                }
                String string3 = "get " + (String)normalizedName;
                FunctionValue functionValue = ((ObjectProperty)variable).getGetter();
                Intrinsics.checkNotNull((Object)functionValue);
                list.add((XNamedValue)VariableViewKt.VariableView(new VariableImpl(string3, functionValue), getterOrSetterContext));
            }
            if (((ObjectProperty)variable).getSetter() == null) continue;
            if (getterOrSetterContext == null) {
                getterOrSetterContext = new NonWatchableVariableContext(variableContext);
            }
            String string4 = "set " + (String)normalizedName;
            FunctionValue functionValue = ((ObjectProperty)variable).getSetter();
            Intrinsics.checkNotNull((Object)functionValue);
            list.add((XNamedValue)VariableViewKt.VariableView(new VariableImpl(string4, functionValue), getterOrSetterContext));
        }
        return list;
    }

    @JvmOverloads
    @NotNull
    public static final XValueChildrenList createVariablesList(@NotNull List<? extends Variable> variables, @NotNull VariableContext variableContext) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)variableContext, (String)"variableContext");
        return VariablesKt.createVariablesList$default(variables, variableContext, null, 4, null);
    }

    private static final int NATURAL_NAME_COMPARATOR$lambda$0(Variable o1, Variable o2) {
        return VariablesKt.naturalCompare(o1.getName(), o2.getName());
    }

    private static final char naturalCompare$reverseCase(char ch) {
        return Character.isUpperCase(ch) ? Character.toLowerCase(ch) : (Character.isLowerCase(ch) ? Character.toUpperCase(ch) : ch);
    }

    public static final /* synthetic */ Pattern access$getUNNAMED_FUNCTION_PATTERN$p() {
        return UNNAMED_FUNCTION_PATTERN;
    }

    public static final /* synthetic */ Comparator access$getNATURAL_NAME_COMPARATOR$p() {
        return NATURAL_NAME_COMPARATOR;
    }

    public static final /* synthetic */ int access$naturalCompare(String string1, String string2) {
        return VariablesKt.naturalCompare(string1, string2);
    }
}

