/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.icons.AllIcons;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleGroovyProperty;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectAwareType;
import org.jetbrains.plugins.gradle.service.resolve.GradleVersionCatalogHandlerKt;
import org.jetbrains.plugins.gradle.service.resolve.PropertiesKt;
import org.jetbrains.plugins.gradle.settings.GradleExtensionsSettings;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightField;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyPropertyBase;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0014J2\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J0\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleExtensionsContributor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor;", "()V", "getClassNames", "", "", "processDynamicElements", "", "qualifierType", "Lcom/intellij/psi/PsiType;", "aClass", "Lcom/intellij/psi/PsiClass;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "place", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "processPropertiesFromFile", "", "Companion", "intellij.gradle.java"})
public final class GradleExtensionsContributor
extends NonCodeMembersContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PROPERTIES_FILE_ORIGINAL_INFO = "by gradle.properties";

    @NotNull
    protected Collection<String> getClassNames() {
        Object[] objectArray = new String[]{"org.gradle.api.plugins.ExtraPropertiesExtension", "org.gradle.api.Project"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void processDynamicElements(@NotNull PsiType qualifierType, @Nullable PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)qualifierType, (String)"qualifierType");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!(qualifierType instanceof GradleProjectAwareType) && !InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"org.gradle.api.plugins.ExtraPropertiesExtension")) {
            return;
        }
        if (!ResolveUtilKt.shouldProcessProperties((PsiScopeProcessor)processor)) {
            return;
        }
        PsiFile file = place.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        GradleExtensionsSettings.GradleExtensionsData gradleExtensionsData = Companion.getExtensionsFor((PsiElement)file);
        if (gradleExtensionsData == null) {
            return;
        }
        GradleExtensionsSettings.GradleExtensionsData data = gradleExtensionsData;
        String name = ResolveUtilKt.getName((PsiScopeProcessor)processor, (ResolveState)state);
        Set<String> resolvedProperties = this.processPropertiesFromFile(aClass, processor, place, state);
        Set<String> set = Companion.processPropertiesFromCatalog(name, place, processor, state);
        if (set == null) {
            return;
        }
        Set<String> versionCatalogProperties = set;
        String string = name;
        if (string == null) {
            Collection collection2 = data.findAllProperties();
            collection = collection2;
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"data.findAllProperties()");
        } else {
            collection = CollectionsKt.listOfNotNull((Object)data.findProperty(string));
        }
        Collection properties = collection;
        for (GradleExtensionsSettings.GradleProp property : properties) {
            if (resolvedProperties.contains(property.name) || versionCatalogProperties.contains(property.name)) continue;
            String string2 = property.name;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"property.name");
            String string3 = property.typeFqn;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"property.typeFqn");
            if (processor.execute((PsiElement)new GradleGroovyProperty(string2, string3, property.value, (PsiElement)file), state)) continue;
            return;
        }
    }

    private final Set<String> processPropertiesFromFile(PsiClass aClass, PsiScopeProcessor processor, PsiElement place, ResolveState state) {
        if (aClass == null) {
            return SetsKt.emptySet();
        }
        JavaPsiFacade factory = JavaPsiFacade.getInstance((Project)place.getProject());
        PsiClass psiClass = factory.findClass("java.lang.String", place.getResolveScope());
        if (psiClass == null || (psiClass = InferenceKt.type((PsiClass)psiClass)) == null) {
            return SetsKt.emptySet();
        }
        PsiClass stringType = psiClass;
        Sequence<PropertiesFile> properties = PropertiesKt.gradlePropertiesStream(place);
        String name = ResolveUtilKt.getName((PsiScopeProcessor)processor, (ResolveState)state);
        Set processedNames = new LinkedHashSet();
        for (PropertiesFile propertyFile : properties) {
            if (name == null) {
                for (IProperty property : propertyFile.getProperties()) {
                    String string = property.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.name");
                    if (StringsKt.contains$default((CharSequence)string, (CharSequence)".", (boolean)false, (int)2, null)) continue;
                    String string2 = property.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"property.name");
                    processedNames.add(string2);
                    Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property");
                    GrLightField newProperty = GradleExtensionsContributor.Companion.createGroovyProperty(aClass, property, (PsiClassType)stringType);
                    processor.execute((PsiElement)newProperty, state);
                }
                continue;
            }
            IProperty iProperty = propertyFile.findPropertyByKey(name);
            if (iProperty == null) continue;
            IProperty property = iProperty;
            GrLightField newProperty = GradleExtensionsContributor.Companion.createGroovyProperty(aClass, property, (PsiClassType)stringType);
            processor.execute((PsiElement)newProperty, state);
            String string = newProperty.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newProperty.name");
            return SetsKt.setOf((Object)string);
        }
        return processedNames;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J0\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleExtensionsContributor$Companion;", "", "()V", "PROPERTIES_FILE_ORIGINAL_INFO", "", "createGroovyProperty", "Lorg/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightField;", "aClass", "Lcom/intellij/psi/PsiClass;", "property", "Lcom/intellij/lang/properties/IProperty;", "stringType", "Lcom/intellij/psi/PsiClassType;", "getExtensionsFor", "Lorg/jetbrains/plugins/gradle/settings/GradleExtensionsSettings$GradleExtensionsData;", "psiElement", "Lcom/intellij/psi/PsiElement;", "processPropertiesFromCatalog", "", "name", "place", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "state", "Lcom/intellij/psi/ResolveState;", "StaticVersionCatalogProperty", "intellij.gradle.java"})
    @SourceDebugExtension(value={"SMAP\nGradleExtensionsContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleExtensionsContributor.kt\norg/jetbrains/plugins/gradle/service/resolve/GradleExtensionsContributor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n766#2:127\n857#2,2:128\n*S KotlinDebug\n*F\n+ 1 GradleExtensionsContributor.kt\norg/jetbrains/plugins/gradle/service/resolve/GradleExtensionsContributor$Companion\n*L\n105#1:127\n105#1:128,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final GrLightField createGroovyProperty(PsiClass aClass, IProperty property, PsiClassType stringType) {
            GrLightField newProperty = new GrLightField(aClass, property.getName(), (PsiType)stringType, property.getPsiElement());
            newProperty.setIcon(AllIcons.FileTypes.Properties);
            newProperty.setOriginInfo(GradleExtensionsContributor.PROPERTIES_FILE_ORIGINAL_INFO);
            return newProperty;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Set<String> processPropertiesFromCatalog(@Nullable String name, @NotNull PsiElement place, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
            Collection collection;
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Project project = place.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"place.project");
            Set<String> staticExtensions = GradleVersionCatalogHandlerKt.getGradleStaticallyHandledExtensions(project);
            String string = name;
            if (string == null) {
                collection = staticExtensions;
            } else {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = CollectionsKt.listOf((Object)string);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!staticExtensions.contains(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                collection = (List)destination$iv$iv;
            }
            Collection names = collection;
            Set properties = new LinkedHashSet();
            for (String extName : names) {
                PsiClass accessor;
                if (GradleVersionCatalogHandlerKt.getVersionCatalogAccessor(place, extName) == null || processor.execute((PsiElement)new StaticVersionCatalogProperty(place, extName, accessor), state)) continue;
                return null;
            }
            return properties;
        }

        @Nullable
        public final GradleExtensionsSettings.GradleExtensionsData getExtensionsFor(@NotNull PsiElement psiElement) {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            Project project = psiElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
            Project project2 = project;
            PsiFile psiFile = psiElement.getContainingFile();
            VirtualFile virtualFile = psiFile != null && (psiFile = psiFile.getOriginalFile()) != null ? psiFile.getVirtualFile() : null;
            if (virtualFile == null) {
                return null;
            }
            VirtualFile virtualFile2 = virtualFile;
            Module module = ProjectFileIndex.getInstance((Project)project2).getModuleForFile(virtualFile2);
            return GradleExtensionsSettings.getInstance((Project)project2).getExtensionsFor(module);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleExtensionsContributor$Companion$StaticVersionCatalogProperty;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyPropertyBase;", "place", "Lcom/intellij/psi/PsiElement;", "name", "", "clazz", "Lcom/intellij/psi/PsiClass;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/intellij/psi/PsiClass;)V", "getClazz", "()Lcom/intellij/psi/PsiClass;", "getPropertyType", "Lcom/intellij/psi/PsiType;", "intellij.gradle.java"})
        public static final class StaticVersionCatalogProperty
        extends GroovyPropertyBase {
            @NotNull
            private final PsiClass clazz;

            public StaticVersionCatalogProperty(@NotNull PsiElement place, @NotNull String name, @NotNull PsiClass clazz) {
                Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
                super(name, place);
                this.clazz = clazz;
            }

            @NotNull
            public final PsiClass getClazz() {
                return this.clazz;
            }

            @NotNull
            public PsiType getPropertyType() {
                PsiClassType psiClassType = PsiElementFactory.getInstance((Project)this.getProject()).createType(this.clazz, PsiSubstitutor.EMPTY);
                Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"getInstance(project).cre\u2026zz, PsiSubstitutor.EMPTY)");
                return (PsiType)psiClassType;
            }
        }
    }
}

