/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.toml;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.UseScopeEnlarger;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.GradleBuildscriptSearchScope;
import org.jetbrains.plugins.gradle.service.resolve.GradleVersionCatalogHandlerKt;
import org.toml.lang.psi.TomlElement;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/service/toml/GradleTomlUseScopeEnlarger;", "Lcom/intellij/psi/search/UseScopeEnlarger;", "()V", "getAdditionalUseScope", "Lcom/intellij/psi/search/SearchScope;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.gradle.java"})
public final class GradleTomlUseScopeEnlarger
extends UseScopeEnlarger {
    @Nullable
    public SearchScope getAdditionalUseScope(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof TomlElement)) {
            return null;
        }
        PsiFile psiFile = ((TomlElement)element).getContainingFile();
        Object object = psiFile != null ? psiFile.getVirtualFile() : null;
        if (object == null) {
            return null;
        }
        VirtualFile containingFile = object;
        Project project = ((TomlElement)element).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        Collection<VirtualFile> versionCatalogFiles = GradleVersionCatalogHandlerKt.getVersionCatalogFiles(project).values();
        if (!versionCatalogFiles.contains(containingFile)) {
            return null;
        }
        Project project2 = ((TomlElement)element).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
        return (SearchScope)new GradleBuildscriptSearchScope(project2);
    }
}

