/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import com.jetbrains.fus.reporting.model.lion3.LogEventAction;
import com.jetbrains.fus.reporting.model.lion3.LogEventGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventJsonDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "()V", "createAction", "Lcom/jetbrains/fus/reporting/model/lion3/LogEventAction;", "obj", "Lcom/fasterxml/jackson/databind/JsonNode;", "deserialize", "jsonParser", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "transformData", "", "value", "intellij.platform.statistics.uploader"})
@SourceDebugExtension(value={"SMAP\nLogEventSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogEventSerializer.kt\ncom/intellij/internal/statistic/eventLog/LogEventJsonDeserializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,260:1\n1549#2:261\n1620#2,3:262\n32#3,2:265\n*S KotlinDebug\n*F\n+ 1 LogEventSerializer.kt\ncom/intellij/internal/statistic/eventLog/LogEventJsonDeserializer\n*L\n220#1:261\n220#1:262,3\n223#1:265,2\n*E\n"})
public final class LogEventJsonDeserializer
extends JsonDeserializer<LogEvent> {
    @NotNull
    public LogEvent deserialize(@NotNull JsonParser jsonParser, @NotNull DeserializationContext context) throws JsonParseException {
        Intrinsics.checkNotNullParameter((Object)jsonParser, (String)"jsonParser");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TreeNode treeNode = jsonParser.getCodec().readTree(jsonParser);
        Intrinsics.checkNotNullExpressionValue((Object)treeNode, (String)"jsonParser.codec.readTree(jsonParser)");
        JsonNode node = (JsonNode)treeNode;
        String recorderVersion = node.get("recorder_version").asText();
        String session = node.get("session").asText();
        String build2 = node.get("build").asText();
        String bucket = node.get("bucket").asText();
        long time = node.get("time").asLong();
        JsonNode group = node.get("group");
        String groupId = group.get("id").asText();
        String groupVersion = group.get("version").asText();
        JsonNode actionObj = node.get("event");
        Intrinsics.checkNotNullExpressionValue((Object)actionObj, (String)"actionObj");
        LogEventAction action = this.createAction(actionObj);
        Intrinsics.checkNotNullExpressionValue((Object)session, (String)"session");
        Intrinsics.checkNotNullExpressionValue((Object)build2, (String)"build");
        Intrinsics.checkNotNullExpressionValue((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullExpressionValue((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullExpressionValue((Object)groupVersion, (String)"groupVersion");
        LogEventGroup logEventGroup = new LogEventGroup(groupId, groupVersion);
        Intrinsics.checkNotNullExpressionValue((Object)recorderVersion, (String)"recorderVersion");
        return new LogEvent(session, build2, bucket, time, logEventGroup, recorderVersion, action);
    }

    /*
     * WARNING - void declaration
     */
    private final Object transformData(JsonNode value) {
        Object object;
        JsonNode jsonNode = value;
        if (jsonNode instanceof TextNode) {
            object = value.textValue();
        } else if (jsonNode instanceof LongNode) {
            object = value.longValue();
        } else if (jsonNode instanceof ArrayNode) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)value;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object object2;
                void it;
                JsonNode jsonNode2 = (JsonNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                if (v1 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                    object2 = this.transformData((JsonNode)it);
                } else {
                    object2 = null;
                }
                collection.add(object2);
            }
            object = (List)destination$iv$iv;
        } else {
            if (jsonNode instanceof ObjectNode) {
                HashMap data = new HashMap();
                Iterator iterator = value.fields();
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"value.fields()");
                Iterator $this$forEach$iv = iterator;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv;
                while (iterator2.hasNext()) {
                    Object object3;
                    JsonNode entryValue;
                    Object element$iv = iterator2.next();
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(entryKey, entryValue)");
                    String entryKey = (String)entry.getKey();
                    JsonNode jsonNode3 = entryValue = (JsonNode)entry.getValue();
                    if (jsonNode3 != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)jsonNode3, (String)"entryValue");
                        object3 = this.transformData(entryValue);
                    } else {
                        object3 = null;
                    }
                    Object newValue = object3;
                    Map map = data;
                    Intrinsics.checkNotNullExpressionValue((Object)entryKey, (String)"entryKey");
                    map.put(entryKey, newValue);
                }
                return data;
            }
            if (jsonNode instanceof DoubleNode) {
                if (value.doubleValue() % 1.0 == 0.0) {
                    return MathKt.roundToLong((double)value.doubleValue());
                }
                return value.doubleValue();
            }
            object = jsonNode instanceof BooleanNode ? Boolean.valueOf(value.booleanValue()) : value;
        }
        String string = object;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when (value) {\n      is \u2026      else -> value\n    }");
        return string;
    }

    @NotNull
    public final LogEventAction createAction(@NotNull JsonNode obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        String id = obj.get("id").asText();
        boolean isState = obj.has("state") && obj.get("state").asBoolean();
        HashMap data = new HashMap();
        if (obj.has("data")) {
            JsonNode dataObj = obj.get("data");
            Iterator fields = dataObj.fields();
            while (fields.hasNext()) {
                Object k;
                Map.Entry field = (Map.Entry)fields.next();
                Map map = data;
                Intrinsics.checkNotNullExpressionValue(field.getKey(), (String)"field.key");
                Object v = field.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"field.value");
                Object object = this.transformData((JsonNode)v);
                map.put(k, object);
            }
        }
        if (obj.has("count") && obj.get("count").isNumber()) {
            int n = obj.get("count").asInt();
            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
            return new LogEventAction(id, isState, (Map)data, n);
        }
        Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
        return new LogEventAction(id, isState, (Map)data, 0, 8, null);
    }
}

