/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection.metadata;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import com.intellij.internal.statistic.config.SerializationHelper;
import com.intellij.internal.statistic.config.StatisticsStringUtil;
import com.intellij.internal.statistic.eventLog.EventLogBuild;
import com.intellij.internal.statistic.eventLog.connection.EventLogConnectionSettings;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupsFilterRules;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogBuildParser;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataLoadException;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataParseException;
import com.intellij.internal.statistic.eventLog.connection.request.StatsHttpRequests;
import com.intellij.internal.statistic.eventLog.connection.request.StatsRequestResult;
import com.intellij.internal.statistic.eventLog.connection.request.StatsResponseException;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventLogMetadataUtils {
    @NotNull
    public static EventGroupsFilterRules<EventLogBuild> loadAndParseGroupsFilterRules(@NotNull String serviceUrl, @NotNull EventLogConnectionSettings settings) {
        EventGroupsFilterRules eventGroupsFilterRules;
        if (serviceUrl == null) {
            EventLogMetadataUtils.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            EventLogMetadataUtils.$$$reportNull$$$0(1);
        }
        try {
            String content = EventLogMetadataUtils.loadMetadataFromServer(serviceUrl, settings);
            EventGroupRemoteDescriptors groups = EventLogMetadataUtils.parseGroupRemoteDescriptors(content);
            eventGroupsFilterRules = EventGroupsFilterRules.create((EventGroupRemoteDescriptors)groups, (EventLogBuildParser)EventLogBuild.EVENT_LOG_BUILD_PRODUCER);
        }
        catch (EventLogMetadataLoadException | EventLogMetadataParseException e) {
            EventGroupsFilterRules eventGroupsFilterRules2 = EventGroupsFilterRules.empty();
            if (eventGroupsFilterRules2 == null) {
                EventLogMetadataUtils.$$$reportNull$$$0(3);
            }
            return eventGroupsFilterRules2;
        }
        if (eventGroupsFilterRules == null) {
            EventLogMetadataUtils.$$$reportNull$$$0(2);
        }
        return eventGroupsFilterRules;
    }

    @NotNull
    public static EventGroupRemoteDescriptors parseGroupRemoteDescriptors(@Nullable String content) throws EventLogMetadataParseException {
        EventGroupRemoteDescriptors eventGroupRemoteDescriptors;
        if (StatisticsStringUtil.isEmptyOrSpaces(content)) {
            throw new EventLogMetadataParseException(EventLogMetadataParseException.EventLogMetadataParseErrorType.EMPTY_CONTENT);
        }
        try {
            EventGroupRemoteDescriptors groups = SerializationHelper.Companion.deserialize(content, EventGroupRemoteDescriptors.class);
            if (groups == null) {
                throw new EventLogMetadataParseException(EventLogMetadataParseException.EventLogMetadataParseErrorType.INVALID_JSON);
            }
            eventGroupRemoteDescriptors = groups;
        }
        catch (StreamReadException | DatabindException e) {
            throw new EventLogMetadataParseException(EventLogMetadataParseException.EventLogMetadataParseErrorType.INVALID_JSON, e);
        }
        catch (Exception e) {
            throw new EventLogMetadataParseException(EventLogMetadataParseException.EventLogMetadataParseErrorType.UNKNOWN, (Throwable)e);
        }
        if (eventGroupRemoteDescriptors == null) {
            EventLogMetadataUtils.$$$reportNull$$$0(4);
        }
        return eventGroupRemoteDescriptors;
    }

    @NotNull
    public static String loadMetadataFromServer(@Nullable String serviceUrl, @NotNull EventLogConnectionSettings settings) throws EventLogMetadataLoadException {
        StatsRequestResult<String> result;
        block6: {
            if (settings == null) {
                EventLogMetadataUtils.$$$reportNull$$$0(5);
            }
            if (StatisticsStringUtil.isEmptyOrSpaces(serviceUrl)) {
                throw new EventLogMetadataLoadException(EventLogMetadataLoadException.EventLogMetadataLoadErrorType.EMPTY_SERVICE_URL);
            }
            result = StatsHttpRequests.request(serviceUrl, settings).send(r -> r.readAsString());
            if (!result.isSucceed()) break block6;
            String string = result.getResult();
            if (string == null) {
                EventLogMetadataUtils.$$$reportNull$$$0(6);
            }
            return string;
        }
        try {
            throw new EventLogMetadataLoadException(EventLogMetadataLoadException.EventLogMetadataLoadErrorType.UNREACHABLE_SERVICE, result.getError());
        }
        catch (StatsResponseException | IOException e) {
            throw new EventLogMetadataLoadException(EventLogMetadataLoadException.EventLogMetadataLoadErrorType.ERROR_ON_LOAD, (Throwable)e);
        }
    }

    public static long lastModifiedMetadata(@Nullable String serviceUrl, @NotNull EventLogConnectionSettings settings) {
        if (settings == null) {
            EventLogMetadataUtils.$$$reportNull$$$0(7);
        }
        if (StatisticsStringUtil.isEmptyOrSpaces(serviceUrl)) {
            return 0L;
        }
        try {
            StatsRequestResult<Long> result = StatsHttpRequests.head(serviceUrl, settings).send(r -> r.lastModified());
            return result.getResult() != null ? result.getResult() : 0L;
        }
        catch (StatsResponseException | IOException e) {
            return 0L;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceUrl";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/connection/metadata/EventLogMetadataUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/connection/metadata/EventLogMetadataUtils";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAndParseGroupsFilterRules";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseGroupRemoteDescriptors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadMetadataFromServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadAndParseGroupsFilterRules";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadMetadataFromServer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lastModifiedMetadata";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

