/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012 \u0010\u0005\u001a\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00070\u0006\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\t\u0010\u0018\u001a\u00020\u0004H\u00c6\u0003J#\u0010\u0019\u001a\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00070\u0006H\u00c6\u0003J=\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\"\b\u0002\u0010\u0005\u001a\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00070\u0006H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0004H\u00d6\u0001R+\u0010\u0005\u001a\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/intellij/internal/statistic/eventLog/events/DatedShortAnonymizedEventField;", "T", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "name", "", "dateAndValueProvider", "Lkotlin/Function1;", "Lkotlin/Pair;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getDateAndValueProvider", "()Lkotlin/jvm/functions/Function1;", "getName", "()Ljava/lang/String;", "validationRule", "", "getValidationRule", "()Ljava/util/List;", "addData", "", "fuData", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "value", "(Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;Ljava/lang/Object;)V", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.statistics"})
public final class DatedShortAnonymizedEventField<T>
extends PrimitiveEventField<T> {
    @NotNull
    private final String name;
    @NotNull
    private final Function1<T, Pair<Long, String>> dateAndValueProvider;

    public DatedShortAnonymizedEventField(@NotNull String name, @NotNull Function1<? super T, Pair<Long, String>> dateAndValueProvider) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(dateAndValueProvider, (String)"dateAndValueProvider");
        this.name = name;
        this.dateAndValueProvider = dateAndValueProvider;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final Function1<T, Pair<Long, String>> getDateAndValueProvider() {
        return this.dateAndValueProvider;
    }

    @Override
    @NotNull
    public List<String> getValidationRule() {
        return CollectionsKt.listOf((Object)"{regexp#date_short_hash}");
    }

    @Override
    public void addData(@NotNull FeatureUsageData fuData, T value) {
        Intrinsics.checkNotNullParameter((Object)fuData, (String)"fuData");
        Pair pair = (Pair)this.dateAndValueProvider.invoke(value);
        long timestamp = ((Number)pair.component1()).longValue();
        String toHash = (String)pair.component2();
        fuData.addDatedShortAnonymizedValue(this.getName(), timestamp, toHash);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Function1<T, Pair<Long, String>> component2() {
        return this.dateAndValueProvider;
    }

    @NotNull
    public final DatedShortAnonymizedEventField<T> copy(@NotNull String name, @NotNull Function1<? super T, Pair<Long, String>> dateAndValueProvider) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(dateAndValueProvider, (String)"dateAndValueProvider");
        return new DatedShortAnonymizedEventField<T>(name, dateAndValueProvider);
    }

    public static /* synthetic */ DatedShortAnonymizedEventField copy$default(DatedShortAnonymizedEventField datedShortAnonymizedEventField, String string, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = datedShortAnonymizedEventField.name;
        }
        if ((n & 2) != 0) {
            function1 = datedShortAnonymizedEventField.dateAndValueProvider;
        }
        return datedShortAnonymizedEventField.copy(string, function1);
    }

    @NotNull
    public String toString() {
        return "DatedShortAnonymizedEventField(name=" + this.name + ", dateAndValueProvider=" + this.dateAndValueProvider + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.dateAndValueProvider.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DatedShortAnonymizedEventField)) {
            return false;
        }
        DatedShortAnonymizedEventField datedShortAnonymizedEventField = (DatedShortAnonymizedEventField)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)datedShortAnonymizedEventField.name)) {
            return false;
        }
        return Intrinsics.areEqual(this.dateAndValueProvider, datedShortAnonymizedEventField.dateAndValueProvider);
    }
}

