/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AllowedItemsResourceWeakRefStorage {
    private static final Logger LOG = Logger.getInstance(AllowedItemsResourceWeakRefStorage.class);
    private final Class<?> resourceHolder;
    private final String relativePath;
    @NotNull
    private WeakReference<Set<String>> itemsRef;

    public AllowedItemsResourceWeakRefStorage(@NotNull Class<?> holder, @NotNull String path) {
        if (holder == null) {
            AllowedItemsResourceWeakRefStorage.$$$reportNull$$$0(0);
        }
        if (path == null) {
            AllowedItemsResourceWeakRefStorage.$$$reportNull$$$0(1);
        }
        this.itemsRef = new WeakReference<Object>(null);
        this.resourceHolder = holder;
        this.relativePath = path;
    }

    @Nullable
    protected String createValue(@NotNull String value) {
        if (value == null) {
            AllowedItemsResourceWeakRefStorage.$$$reportNull$$$0(2);
        }
        return value.trim();
    }

    /*
     * Loose catch block
     */
    @NotNull
    protected Set<String> readItems() {
        block11: {
            BufferedReader reader;
            block10: {
                InputStream resourceStream = this.resourceHolder.getResourceAsStream(this.relativePath);
                if (resourceStream == null) {
                    throw new IOException("Resource " + this.relativePath + " not found");
                }
                reader = new BufferedReader(new InputStreamReader(resourceStream, StandardCharsets.UTF_8));
                List values = FileUtil.loadLines((BufferedReader)reader);
                if (values.isEmpty()) break block10;
                Set set = ContainerUtil.map2SetNotNull((Collection)values, s -> this.createValue((String)s));
                reader.close();
                Set set2 = set;
                if (set2 == null) {
                    AllowedItemsResourceWeakRefStorage.$$$reportNull$$$0(3);
                }
                return set2;
            }
            try {
                reader.close();
                break block11;
                {
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            AllowedItemsResourceWeakRefStorage.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public synchronized Set<String> getItems() {
        Set<String> items = (Set<String>)this.itemsRef.get();
        if (items == null) {
            items = Collections.unmodifiableSet(this.readItems());
            this.itemsRef = new WeakReference<Set<String>>(items);
        }
        Set<String> set = items;
        if (set == null) {
            AllowedItemsResourceWeakRefStorage.$$$reportNull$$$0(5);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/AllowedItemsResourceWeakRefStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/rules/impl/AllowedItemsResourceWeakRefStorage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readItems";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

