/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api;

import circlet.client.api.PermissionContextIdentifier;
import circlet.client.api.ProfileIdentifier;
import circlet.client.api.ProjectIdentifier;
import circlet.client.api.RightDTO;
import circlet.client.api.RightDescriptorDTO;
import circlet.client.api.RightUpdateDTO;
import circlet.client.api.RoleDTO;
import circlet.client.api.TD_MemberProfile;
import circlet.client.api.TD_Team;
import circlet.client.api.XScopeApi;
import circlet.client.api.td.TeamIdentifier;
import circlet.common.permissions.AdminChannel;
import circlet.common.permissions.AdminProject;
import circlet.common.permissions.Superadmin;
import circlet.common.permissions.ViewChannel;
import circlet.common.permissions.ViewProject;
import circlet.platform.api.Api;
import circlet.platform.api.Ref;
import circlet.platform.api.annotations.DefaultParameterValues;
import circlet.platform.api.annotations.Http;
import circlet.platform.api.annotations.HttpApi;
import circlet.platform.api.annotations.HttpApiDoc;
import circlet.platform.api.annotations.Rest;
import circlet.platform.api.annotations.Rights;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@HttpApi(resource="permission-roles")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J%\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ%\u0010\n\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u000b\u001a\u00020\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ!\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J!\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\bH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ)\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001c2\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J#\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001c2\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J)\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u001d0\u001c2\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u001f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001c2\u0006\u0010\u0010\u001a\u00020\u0011H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J+\u0010%\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J%\u0010(\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ%\u0010)\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u000b\u001a\u00020\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u001d\u0010*\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0019\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0005H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J+\u0010.\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J\u001f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u001c2\u0006\u0010\u0010\u001a\u00020\u0011H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J%\u00101\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u0012\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102J+\u00103\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\f\u00104\u001a\b\u0012\u0004\u0012\u0002050\u001cH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00066"}, d2={"Lcirclet/client/api/PermissionEditor;", "Lcirclet/platform/api/Api;", "addRoleMember", "", "roleId", "", "Lcirclet/platform/api/TID;", "profile", "Lcirclet/client/api/ProfileIdentifier;", "(Ljava/lang/String;Lcirclet/client/api/ProfileIdentifier;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addRoleTeam", "team", "Lcirclet/client/api/td/TeamIdentifier;", "(Ljava/lang/String;Lcirclet/client/api/td/TeamIdentifier;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createRole", "Lcirclet/client/api/RoleDTO;", "contextIdentifier", "Lcirclet/client/api/PermissionContextIdentifier;", "name", "(Lcirclet/client/api/PermissionContextIdentifier;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteRole", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getGuestRole", "projectIdentifier", "Lcirclet/client/api/ProjectIdentifier;", "profileIdentifier", "(Lcirclet/client/api/ProjectIdentifier;Lcirclet/client/api/ProfileIdentifier;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getRoleMembers", "", "Lcirclet/platform/api/Ref;", "Lcirclet/client/api/TD_MemberProfile;", "getRolePermissions", "Lcirclet/client/api/RightDTO;", "getRoleTeams", "Lcirclet/client/api/TD_Team;", "getRoles", "(Lcirclet/client/api/PermissionContextIdentifier;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "grantRolePermissions", "rightCodes", "(Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeRoleMember", "removeRoleTeam", "resetRolePermissionsToDefault", "resolveScope", "Lcirclet/client/api/XScopeApi;", "scope", "revokeRolePermissions", "rightsAvailableForScopeInContext", "Lcirclet/client/api/RightDescriptorDTO;", "updateRole", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateRoleRights", "updates", "Lcirclet/client/api/RightUpdateDTO;", "client-api"})
public interface PermissionEditor
extends Api {
    @HttpApiDoc(doc="Create new custom permission role in specified permission context")
    @Http.Post(path="create", displayName="Create role")
    @Rights(rights={Superadmin.class, AdminProject.class, AdminChannel.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object createRole(@NotNull PermissionContextIdentifier var1, @NotNull String var2, @NotNull Continuation<? super RoleDTO> var3);

    @HttpApiDoc(doc="List all permission roles in permission context")
    @Http.Post(path="get", displayName="Get roles")
    @Rights(rights={Superadmin.class, ViewProject.class, ViewChannel.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object getRoles(@NotNull PermissionContextIdentifier var1, @NotNull Continuation<? super List<RoleDTO>> var2);

    @HttpApiDoc(doc="Update custom permission role name")
    @Rest.Update(path="{roleId}", displayName="Update role")
    @Rights(rights={Superadmin.class, AdminProject.class, AdminChannel.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object updateRole(@NotNull String var1, @NotNull String var2, @NotNull Continuation<? super Unit> var3);

    @HttpApiDoc(doc="Delete custom permission role")
    @Rest.Delete(path="{roleId}", displayName="Delete role")
    @Rights(rights={Superadmin.class, AdminProject.class, AdminChannel.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object deleteRole(@NotNull String var1, @NotNull Continuation<? super Unit> var2);

    @HttpApiDoc(doc="Get role permissions")
    @Rest.Query(path="{roleId}/permissions", displayName="Get role permissions")
    @Rights(rights={Superadmin.class, ViewProject.class, ViewChannel.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object getRolePermissions(@NotNull String var1, @NotNull Continuation<? super List<RightDTO>> var2);

    @HttpApiDoc(doc="Grant permissions to the specified role. You can get the list of all permissions applicable to the role using \"Get all\" method.")
    @Rest.Create(path="{roleId}/permissions", displayName="Grant role permissions")
    @Rights(rights={Superadmin.class, AdminProject.class, AdminChannel.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object grantRolePermissions(@NotNull String var1, @NotNull List<String> var2, @NotNull Continuation<? super Unit> var3);

    @HttpApiDoc(doc="Revoke permissions from the specified role.")
    @Rest.Delete(path="{roleId}/permissions", displayName="Revoke role permissions")
    @Rights(rights={Superadmin.class, AdminProject.class, AdminChannel.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object revokeRolePermissions(@NotNull String var1, @NotNull List<String> var2, @NotNull Continuation<? super Unit> var3);

    @Nullable
    public Object updateRoleRights(@NotNull String var1, @NotNull List<RightUpdateDTO> var2, @NotNull Continuation<? super Unit> var3);

    @HttpApiDoc(doc="Reset permissions for the role to the standard ones. Only applicable to roles with PermissionRoleType = PREDEFINED, not applicable to custom roles.")
    @Http.Post(path="{roleId}/reset-role-permissions-to-default", displayName="Reset role permissions to default")
    @Rights(rights={Superadmin.class, AdminProject.class, AdminChannel.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object resetRolePermissionsToDefault(@NotNull String var1, @NotNull Continuation<? super Unit> var2);

    @HttpApiDoc(doc="Get list of teams with the specified role")
    @Rest.Query(path="{roleId}/teams", displayName="Get role teams")
    @Rights(rights={Superadmin.class, ViewProject.class, ViewChannel.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object getRoleTeams(@NotNull String var1, @NotNull Continuation<? super List<Ref<TD_Team>>> var2);

    @HttpApiDoc(doc="Assign permission role to the team")
    @Rest.Create(path="{roleId}/teams/{team}", displayName="Add role team")
    @Rights(rights={Superadmin.class, AdminProject.class, AdminChannel.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object addRoleTeam(@NotNull String var1, @NotNull TeamIdentifier var2, @NotNull Continuation<? super Unit> var3);

    @HttpApiDoc(doc="Remove permission role from the team")
    @Rest.Delete(path="{roleId}/teams/{team}", displayName="Remove role team")
    @Rights(rights={Superadmin.class, AdminProject.class, AdminChannel.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object removeRoleTeam(@NotNull String var1, @NotNull TeamIdentifier var2, @NotNull Continuation<? super Unit> var3);

    @HttpApiDoc(doc="Get list of profiles with the specified role")
    @Rest.Query(path="{roleId}/profiles", displayName="Get role members")
    @Rights(rights={Superadmin.class, ViewProject.class, ViewChannel.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object getRoleMembers(@NotNull String var1, @NotNull Continuation<? super List<Ref<TD_MemberProfile>>> var2);

    @HttpApiDoc(doc="Assign permission role to the profile")
    @Rest.Create(path="{roleId}/profiles/{profile}", displayName="Add role member")
    @Rights(rights={Superadmin.class, AdminProject.class, AdminChannel.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object addRoleMember(@NotNull String var1, @NotNull ProfileIdentifier var2, @NotNull Continuation<? super Unit> var3);

    @HttpApiDoc(doc="Remove permission role from the profile")
    @Rest.Delete(path="{roleId}/profiles/{profile}", displayName="Remove role member")
    @Rights(rights={Superadmin.class, AdminProject.class, AdminChannel.class})
    @DefaultParameterValues(params={})
    @Nullable
    public Object removeRoleMember(@NotNull String var1, @NotNull ProfileIdentifier var2, @NotNull Continuation<? super Unit> var3);

    @Nullable
    public Object rightsAvailableForScopeInContext(@NotNull PermissionContextIdentifier var1, @NotNull Continuation<? super List<RightDescriptorDTO>> var2);

    @Nullable
    public Object resolveScope(@NotNull String var1, @NotNull Continuation<? super XScopeApi> var2);

    @Nullable
    public Object getGuestRole(@NotNull ProjectIdentifier var1, @NotNull ProfileIdentifier var2, @NotNull Continuation<? super RoleDTO> var3);
}

