/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.calendar;

import circlet.common.calendar.EventCounter;
import circlet.common.calendar.RecurrenceRuleFreq;
import circlet.common.calendar.RegularEventCounter;
import circlet.common.calendar.RelativeDate;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.KotlinXDate;
import circlet.platform.api.Weekday;
import circlet.platform.api.WorkingDaysKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u00020\u00132\n\u0010\u0015\u001a\u00060\nj\u0002`\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcirclet/common/calendar/RelativeEventCounter;", "Lcirclet/common/calendar/EventCounter;", "original", "Lcirclet/common/calendar/RegularEventCounter;", "relativity", "Lcirclet/common/calendar/RelativeDate;", "(Lcirclet/common/calendar/RegularEventCounter;Lcirclet/common/calendar/RelativeDate;)V", "getOriginal", "()Lcirclet/common/calendar/RegularEventCounter;", "getCurrentDate", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "getFrequency", "Lcirclet/common/calendar/RecurrenceRuleFreq;", "getRelativity", "getWeekdays", "", "Lcirclet/platform/api/Weekday;", "toNextEvent", "", "toNextEventAfterDate", "targetDate", "common"})
@SourceDebugExtension(value={"SMAP\nEventCounters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventCounters.kt\ncirclet/common/calendar/RelativeEventCounter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,876:1\n1549#2:877\n1620#2,3:878\n*S KotlinDebug\n*F\n+ 1 EventCounters.kt\ncirclet/common/calendar/RelativeEventCounter\n*L\n352#1:877\n352#1:878,3\n*E\n"})
public final class RelativeEventCounter
implements EventCounter {
    @NotNull
    private final RegularEventCounter original;
    @NotNull
    private final RelativeDate relativity;

    public RelativeEventCounter(@NotNull RegularEventCounter original, @NotNull RelativeDate relativity) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)((Object)relativity), (String)"relativity");
        this.original = original;
        this.relativity = relativity;
    }

    @NotNull
    public final RegularEventCounter getOriginal() {
        return this.original;
    }

    @Override
    public void toNextEvent() {
        this.original.toNextEvent();
    }

    @Override
    public void toNextEventAfterDate(@NotNull KotlinXDate targetDate) {
        Intrinsics.checkNotNullParameter((Object)targetDate, (String)"targetDate");
        this.original.toNextEventAfterDate(ADateJvmKt.plusDays(targetDate, -1 * this.relativity.getDateShift()));
    }

    @Override
    @NotNull
    public KotlinXDate getCurrentDate() {
        return ADateJvmKt.plusDays(this.original.getDate(), this.relativity.getDateShift());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Weekday> getWeekdays() {
        void $this$mapTo$iv$iv;
        List<Weekday> originalWeekdays = this.original.getWeekdays();
        Iterable $this$map$iv = originalWeekdays;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Weekday weekday = (Weekday)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WorkingDaysKt.weekday(it.getOrderNumber() + this.relativity.getDateShift()));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public RecurrenceRuleFreq getFrequency() {
        return this.original.getFrequency();
    }

    @Override
    @NotNull
    public RelativeDate getRelativity() {
        return this.relativity;
    }

    @Override
    public boolean haveCommonWeekdays(@NotNull EventCounter event2) {
        return EventCounter.DefaultImpls.haveCommonWeekdays(this, event2);
    }

    @Override
    public int getFrequencyOrder() {
        return EventCounter.DefaultImpls.getFrequencyOrder(this);
    }
}

