/*
 * Decompiled with CFR 0.152.
 */
package circlet.platform.api;

import circlet.platform.api.oauth.OpenSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcirclet/platform/api/IndicesCoder;", "", "()V", "MASK", "", "decode", "Lcirclet/platform/api/oauth/OpenSet;", "", "set", "", "encode", "parsePrefix", "array", "prefix", "size", "platform-api"})
@SourceDebugExtension(value={"SMAP\nClientSupportFlags.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientSupportFlags.kt\ncirclet/platform/api/IndicesCoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1855#2,2:149\n731#2,9:151\n*S KotlinDebug\n*F\n+ 1 ClientSupportFlags.kt\ncirclet/platform/api/IndicesCoder\n*L\n107#1:149,2\n111#1:151,9\n*E\n"})
public final class IndicesCoder {
    @NotNull
    public static final IndicesCoder INSTANCE = new IndicesCoder();
    private static final byte MASK = -1;

    private IndicesCoder() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] encode(@NotNull OpenSet<Integer> set) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(set, (String)"set");
        OpenSet<Integer> openSet = set;
        if (openSet instanceof OpenSet.All) {
            byte[] byArray2 = new byte[]{-1, -1};
            byArray = byArray2;
        } else if (openSet instanceof OpenSet.None) {
            byte[] byArray3 = new byte[]{0, 0};
            byArray = byArray3;
        } else if (openSet instanceof OpenSet.Specific) {
            Set entries = ((OpenSet.Specific)set).getValues();
            if (entries.isEmpty()) {
                byte[] byArray4 = new byte[]{0, 0};
                byArray = byArray4;
            } else {
                List list2;
                void $this$dropLastWhile$iv;
                Comparable comparable = CollectionsKt.maxOrNull((Iterable)entries);
                Intrinsics.checkNotNull((Object)comparable);
                int size2 = ((Number)((Object)comparable)).intValue() / 8 + 1;
                Comparable comparable2 = CollectionsKt.minOrNull((Iterable)entries);
                Intrinsics.checkNotNull((Object)comparable2);
                if (!(((Number)((Object)comparable2)).intValue() >= 0)) {
                    boolean $i$a$-require-IndicesCoder$encode$22 = false;
                    String $i$a$-require-IndicesCoder$encode$22 = "All entries must be non-negative";
                    throw new IllegalArgumentException($i$a$-require-IndicesCoder$encode$22.toString());
                }
                int constraint = 65535;
                if (size2 > constraint) {
                    throw new IllegalStateException(("Max index is too big (index=" + CollectionsKt.maxOrNull((Iterable)entries) + ")").toString());
                }
                byte[] result2 = new byte[size2];
                Iterable $this$forEach$iv = entries;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    int it = ((Number)element$iv).intValue();
                    boolean bl = false;
                    int ind = it / 8;
                    result2[ind] = (byte)(result2[ind] | 1 << it - ind * 8);
                }
                $this$forEach$iv = ArraysKt.reversed((byte[])result2);
                byte[] byArray5 = this.prefix(size2);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        byte it = ((Number)iterator$iv.previous()).byteValue();
                        boolean bl = false;
                        if (it == 0) continue;
                        list2 = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                byArray = ArraysKt.plus((byte[])byArray5, (byte[])CollectionsKt.toByteArray((Collection)list2));
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return byArray;
    }

    @NotNull
    public final OpenSet<Integer> decode(@NotNull byte[] set) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        if (set.length < 2) {
            return OpenSet.None.INSTANCE;
        }
        if (set[0] == -1 && set[1] == -1) {
            return OpenSet.All.INSTANCE;
        }
        int size2 = this.parsePrefix(set);
        if (size2 <= 0) {
            return OpenSet.None.INSTANCE;
        }
        Set indices = new LinkedHashSet();
        for (IndexedValue i : CollectionsKt.withIndex((Iterable)ArraysKt.drop((byte[])set, (int)2))) {
            for (int j = 0; j < 8; ++j) {
                if ((((Number)i.getValue()).byteValue() & 1 << j) == 0) continue;
                ((Collection)indices).add((size2 - i.getIndex() - 1) * 8 + j);
            }
        }
        return new OpenSet.Specific(indices);
    }

    private final byte[] prefix(int size2) {
        byte[] byArray = new byte[]{(byte)(size2 >>> 8), (byte)(size2 & 0xFFFFFFFF)};
        return byArray;
    }

    private final int parsePrefix(byte[] array) {
        return array[0] << 8 | array[1];
    }
}

