/*
 * Decompiled with CFR 0.152.
 */
package circlet.todo;

import circlet.common.calendar.SpecIntersectsKt;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.KotlinXDate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005J\u0016\u0010\u0007\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005J\u0016\u0010\b\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005J\u0016\u0010\t\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005\u00a8\u0006\n"}, d2={"Lcirclet/todo/TodoPostponeDateCalculator;", "", "()V", "inTwoWeeks", "Lcirclet/platform/api/KotlinXDate;", "Lcirclet/platform/api/ADate;", "date", "nextMonth", "nextWeek", "nextWeekend", "app-state"})
public final class TodoPostponeDateCalculator {
    @NotNull
    public final KotlinXDate nextWeekend(@NotNull KotlinXDate date2) {
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        int weekDay = ADateJvmKt.getWeekday(date2).getOrderNumber();
        int diff = (13 - weekDay) % 7;
        return ADateJvmKt.plusDays(date2, diff == 0 ? 7 : diff);
    }

    @NotNull
    public final KotlinXDate nextWeek(@NotNull KotlinXDate date2) {
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        int weekDay = ADateJvmKt.getWeekday(date2).getOrderNumber();
        int diff = (8 - weekDay) % 7;
        return ADateJvmKt.plusDays(date2, diff == 0 ? 7 : diff);
    }

    @NotNull
    public final KotlinXDate inTwoWeeks(@NotNull KotlinXDate date2) {
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        return ADateJvmKt.plusDays(this.nextWeek(date2), 7);
    }

    @NotNull
    public final KotlinXDate nextMonth(@NotNull KotlinXDate date2) {
        Intrinsics.checkNotNullParameter((Object)date2, (String)"date");
        return ADateJvmKt.plusMonths(SpecIntersectsKt.monthStart(date2), 1);
    }
}

