/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import java.io.IOException;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;

public class LocalDateTimeDeserializer
extends JodaDateDeserializerBase<LocalDateTime> {
    private static final long serialVersionUID = 1L;

    public LocalDateTimeDeserializer() {
        this(FormatConfig.DEFAULT_LOCAL_DATETIME_PARSER);
    }

    public LocalDateTimeDeserializer(JacksonJodaDateFormat format2) {
        super(LocalDateTime.class, format2);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format2) {
        return new LocalDateTimeDeserializer(format2);
    }

    public LocalDateTime deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        switch (p2.currentTokenId()) {
            case 7: {
                return this._fromTimestamp(ctxt, p2.getLongValue());
            }
            case 6: {
                return this._fromString(p2, ctxt, p2.getText());
            }
            case 1: {
                return this._fromString(p2, ctxt, ctxt.extractScalarFromObject(p2, (JsonDeserializer)this, this.handledType()));
            }
        }
        if (p2.isExpectedStartArrayToken()) {
            return this._fromArray(p2, ctxt);
        }
        return (LocalDateTime)ctxt.handleUnexpectedToken(this.handledType(), p2.currentToken(), p2, "expected String, Number or JSON Array", new Object[0]);
    }

    protected LocalDateTime _fromString(JsonParser p2, DeserializationContext ctxt, String value2) throws IOException {
        if ((value2 = value2.trim()).isEmpty()) {
            return (LocalDateTime)this._fromEmptyString(p2, ctxt, value2);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value2)) {
            return this._fromTimestamp(ctxt, NumberInput.parseLong((String)value2));
        }
        return this._format.createParser(ctxt).parseLocalDateTime(value2);
    }

    protected LocalDateTime _fromArray(JsonParser p2, DeserializationContext ctxt) throws IOException {
        JsonToken t = p2.nextToken();
        LocalDateTime dt = null;
        if (t.isNumeric()) {
            int year = p2.getIntValue();
            t = p2.nextToken();
            if (t.isNumeric()) {
                int month = p2.getIntValue();
                t = p2.nextToken();
                if (t.isNumeric()) {
                    int day = p2.getIntValue();
                    t = p2.nextToken();
                    if (t.isNumeric()) {
                        int hour = p2.getIntValue();
                        t = p2.nextToken();
                        if (t.isNumeric()) {
                            int minute = p2.getIntValue();
                            t = p2.nextToken();
                            if (t.isNumeric()) {
                                int second = p2.getIntValue();
                                t = p2.nextToken();
                                int millisecond = 0;
                                if (t.isNumeric()) {
                                    millisecond = p2.getIntValue();
                                    t = p2.nextToken();
                                }
                                dt = new LocalDateTime(year, month, day, hour, minute, second, millisecond);
                            }
                        }
                    }
                }
            }
        }
        if (t == JsonToken.END_ARRAY) {
            return dt;
        }
        throw ctxt.wrongTokenException(p2, this.handledType(), JsonToken.END_ARRAY, "after LocalDateTime ints");
    }

    protected LocalDateTime _fromTimestamp(DeserializationContext ctxt, long ts) {
        DateTimeZone tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : DateTimeZone.forTimeZone(ctxt.getTimeZone());
        return new LocalDateTime(ts, tz);
    }
}

