/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.gateway.rd.devfile;

import circlet.rd.api.devconfig.ParsedDevfile;
import com.intellij.space.gateway.messages.SpaceGatewayBundle;
import com.intellij.space.gateway.rd.devfile.SpaceRdDevFileComboboxModel;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import javax.swing.Icon;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0014J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0011\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013*\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/space/gateway/rd/devfile/SpaceRdDevFileSelectorRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/intellij/space/gateway/rd/devfile/SpaceRdDevFileComboboxModel$Item;", "()V", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "showDevFileInfo", "file", "Lcirclet/rd/api/devconfig/ParsedDevfile;", "extractFileName", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lcirclet/rd/api/devconfig/ParsedDevfile$ParsedWithErrors;", "intellij.space.gateway"})
public final class SpaceRdDevFileSelectorRenderer
extends ColoredListCellRenderer<SpaceRdDevFileComboboxModel.Item> {
    protected void customizeCellRenderer(@NotNull JList<? extends SpaceRdDevFileComboboxModel.Item> list2, @Nullable SpaceRdDevFileComboboxModel.Item value2, int index2, boolean selected2, boolean hasFocus) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        SpaceRdDevFileComboboxModel.Item item2 = value2;
        if (item2 instanceof SpaceRdDevFileComboboxModel.Item.DevFile) {
            this.showDevFileInfo(((SpaceRdDevFileComboboxModel.Item.DevFile)value2).getFile());
        } else if (Intrinsics.areEqual((Object)item2, (Object)SpaceRdDevFileComboboxModel.Item.Empty.INSTANCE)) {
            this.append(SpaceGatewayBundle.message("dev.file.no.files.text", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (Intrinsics.areEqual((Object)item2, (Object)SpaceRdDevFileComboboxModel.Item.NoDevFile.INSTANCE)) {
            this.append(SpaceGatewayBundle.message("dev.files.selector.no.devfile.text", new Object[0]));
        } else if (Intrinsics.areEqual((Object)item2, (Object)SpaceRdDevFileComboboxModel.Item.Loading.INSTANCE)) {
            this.setIcon((Icon)AnimatedIcon.Default.INSTANCE);
        } else if (item2 == null) {
            // empty if block
        }
    }

    private final void showDevFileInfo(ParsedDevfile file2) {
        String string2;
        ParsedDevfile parsedDevfile = file2;
        if (parsedDevfile instanceof ParsedDevfile.ParsedWithErrors) {
            string2 = this.extractFileName((ParsedDevfile.ParsedWithErrors)file2);
        } else if (parsedDevfile instanceof ParsedDevfile.ParsedSuccessfully) {
            string2 = ((ParsedDevfile.ParsedSuccessfully)file2).getName();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String name2 = string2;
        this.append(name2);
        this.append(FontUtil.spaceAndThinSpace());
        this.append(file2.getPath(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    private final String extractFileName(ParsedDevfile.ParsedWithErrors $this$extractFileName) {
        return StringsKt.substringAfterLast$default((String)$this$extractFileName.getPath(), (char)'/', null, (int)2, null);
    }
}

