/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.promo;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.space.SpaceIcons;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.promo.ImageLoader;
import com.intellij.space.promo.PromoKt;
import com.intellij.space.promo.SpaceExplorePlace;
import com.intellij.space.promo.SpaceOverviewPlace;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.ui.VideoPromoComponent;
import com.intellij.ui.components.BrowserLink;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0007\u001a\"\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u000eH\u0007\u001a\b\u0010\u0017\u001a\u00020\u0012H\u0007\u001a\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\nH\u0007\u001a\u0006\u0010\u001b\u001a\u00020\u0001\u001a\n\u0010\u001c\u001a\u0004\u0018\u00010\u0012H\u0007\u001a\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002\u001a,\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\"H\u0007\u001a\u0014\u0010$\u001a\u00020\u001e*\u00020%2\u0006\u0010\u001a\u001a\u00020\nH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\t\u001a\u00020\u0001*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0018\u0010\r\u001a\u00020\u0001*\u00020\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006&"}, d2={"DARK_POSTFIX", "", "HIDPI_POSTFIX", "SIGN_UP_SPACE_URL", "getSIGN_UP_SPACE_URL", "()Ljava/lang/String;", "SPACE_BIG_PROMO_BANNER_NAME", "SPACE_TOOLBAR_PROMO_BANNER_PATH", "SPACE_TOOLBAR_PROMO_BANNER_PATH_RETINA", "exploreUrl", "Lcom/intellij/space/promo/SpaceExplorePlace;", "getExploreUrl", "(Lcom/intellij/space/promo/SpaceExplorePlace;)Ljava/lang/String;", "overviewUrl", "Lcom/intellij/space/promo/SpaceOverviewPlace;", "getOverviewUrl", "(Lcom/intellij/space/promo/SpaceOverviewPlace;)Ljava/lang/String;", "bigPromoBanner", "Ljavax/swing/JComponent;", "overviewPlace", "width", "", "height", "createSpaceByJetbrainsLabel", "exploreSpaceLink", "Lcom/intellij/ui/components/BrowserLink;", "explorePlace", "getIdePromoUtmParameter", "toolbarPromoBanner", "watchPromoVideo", "", "wrapWithWatchSpaceOverviewLabelOverlay", "component", "alwaysDisplayLabel", "", "useDarkLabel", "promoPanel", "Lcom/intellij/ui/dsl/builder/Panel;", "intellij.space"})
public final class PromoKt {
    @NotNull
    public static final String SPACE_TOOLBAR_PROMO_BANNER_PATH = "/images/spacePromo.png";
    @NotNull
    public static final String SPACE_TOOLBAR_PROMO_BANNER_PATH_RETINA = "/images/spacePromo@2x.png";
    @NotNull
    public static final String SPACE_BIG_PROMO_BANNER_NAME = "/images/spaceVideoPreview";
    @NotNull
    public static final String DARK_POSTFIX = "_dark";
    @NotNull
    public static final String HIDPI_POSTFIX = "@2x";

    @NotNull
    public static final String getSIGN_UP_SPACE_URL() {
        return "https://www.jetbrains.com/space/?utm_source=product&utm_medium=link&" + PromoKt.getIdePromoUtmParameter() + "&utm_content=13362-space&utm_term=main_signup#sign-up";
    }

    @ApiStatus.Internal
    public static final void promoPanel(@NotNull Panel $this$promoPanel, @NotNull SpaceExplorePlace explorePlace) {
        Intrinsics.checkNotNullParameter((Object)$this$promoPanel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)explorePlace), (String)"explorePlace");
        Panel.row$default((Panel)$this$promoPanel, null, (Function1)promoPanel.1.INSTANCE, (int)1, null);
        Panel.row$default((Panel)$this$promoPanel, null, (Function1)promoPanel.2.INSTANCE, (int)1, null);
        Panel.row$default((Panel)$this$promoPanel, null, (Function1)((Function1)new Function1<Row, Unit>(explorePlace){
            final /* synthetic */ SpaceExplorePlace $explorePlace;
            {
                this.$explorePlace = $explorePlace;
                super(1);
            }

            public final void invoke(@NotNull Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                $this$row.cell((JComponent)PromoKt.exploreSpaceLink(this.$explorePlace));
            }
        }), (int)1, null).bottomGap(BottomGap.SMALL);
    }

    @ApiStatus.Internal
    @Nullable
    public static final JComponent toolbarPromoBanner() {
        String imagePath = StartupUiUtil.isJreHiDPI() ? SPACE_TOOLBAR_PROMO_BANNER_PATH_RETINA : SPACE_TOOLBAR_PROMO_BANNER_PATH;
        Image image = ImageLoader.INSTANCE.loadImage(imagePath, 364, 200);
        if (image == null) {
            return null;
        }
        Image image2 = image;
        return PromoKt.wrapWithWatchSpaceOverviewLabelOverlay$default(new JLabel((Icon)new JBImageIcon(image2)), SpaceOverviewPlace.MAIN_TOOLBAR, false, false, 12, null);
    }

    @ApiStatus.Internal
    @Nullable
    public static final JComponent bigPromoBanner(@NotNull SpaceOverviewPlace overviewPlace) {
        Intrinsics.checkNotNullParameter((Object)((Object)overviewPlace), (String)"overviewPlace");
        return PromoKt.bigPromoBanner(500, 285, overviewPlace);
    }

    @ApiStatus.Internal
    @Nullable
    public static final JComponent bigPromoBanner(int width, int height, @NotNull SpaceOverviewPlace overviewPlace) {
        Intrinsics.checkNotNullParameter((Object)((Object)overviewPlace), (String)"overviewPlace");
        boolean isDarcula = StartupUiUtil.isUnderDarcula();
        String themePart = isDarcula ? DARK_POSTFIX : "";
        String retinaPart = StartupUiUtil.isJreHiDPI() ? HIDPI_POSTFIX : "";
        String imagePath = SPACE_BIG_PROMO_BANNER_NAME + retinaPart + themePart + ".png";
        Image image = ImageLoader.INSTANCE.loadImage(imagePath, width, height);
        if (image == null) {
            return null;
        }
        Image image2 = image;
        return PromoKt.wrapWithWatchSpaceOverviewLabelOverlay(new JLabel((Icon)new JBImageIcon(image2)), overviewPlace, true, isDarcula);
    }

    @ApiStatus.Internal
    @NotNull
    public static final BrowserLink exploreSpaceLink(@NotNull SpaceExplorePlace explorePlace) {
        BrowserLink browserLink;
        Intrinsics.checkNotNullParameter((Object)((Object)explorePlace), (String)"explorePlace");
        String string2 = SpaceBundle.message("space.promo.explore.space.button", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"space.promo.explore.space.button\")");
        BrowserLink $this$exploreSpaceLink_u24lambda_u241 = browserLink = new BrowserLink(string2, PromoKt.getExploreUrl(explorePlace));
        boolean bl = false;
        $this$exploreSpaceLink_u24lambda_u241.addActionListener(arg_0 -> PromoKt.exploreSpaceLink$lambda$1$lambda$0(explorePlace, arg_0));
        $this$exploreSpaceLink_u24lambda_u241.setFocusPainted(false);
        return browserLink;
    }

    @ApiStatus.Internal
    @NotNull
    public static final JComponent wrapWithWatchSpaceOverviewLabelOverlay(@NotNull JComponent component2, @NotNull SpaceOverviewPlace overviewPlace, boolean alwaysDisplayLabel, boolean useDarkLabel) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)((Object)overviewPlace), (String)"overviewPlace");
        return (JComponent)new VideoPromoComponent(component2, SpaceBundle.message("space.promo.watch.space.overview.label", new Object[0]), alwaysDisplayLabel, useDarkLabel, () -> PromoKt.wrapWithWatchSpaceOverviewLabelOverlay$lambda$2(overviewPlace));
    }

    public static /* synthetic */ JComponent wrapWithWatchSpaceOverviewLabelOverlay$default(JComponent jComponent, SpaceOverviewPlace spaceOverviewPlace, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return PromoKt.wrapWithWatchSpaceOverviewLabelOverlay(jComponent, spaceOverviewPlace, bl, bl2);
    }

    @ApiStatus.Internal
    @NotNull
    public static final JComponent createSpaceByJetbrainsLabel() {
        JLabel jLabel;
        JLabel $this$createSpaceByJetbrainsLabel_u24lambda_u243 = jLabel = new JLabel();
        boolean bl = false;
        Icon icon2 = SpaceIcons.Images.JetbrainsSpace;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"JetbrainsSpace");
        Icon jbSpaceSvgLogo = icon2;
        if (jbSpaceSvgLogo != null) {
            $this$createSpaceByJetbrainsLabel_u24lambda_u243.setIcon(jbSpaceSvgLogo);
        } else {
            $this$createSpaceByJetbrainsLabel_u24lambda_u243.setIcon(SpaceIcons.Icons.Main);
            $this$createSpaceByJetbrainsLabel_u24lambda_u243.setText(SpaceBundle.message("product.name.jetbrains.space", new Object[0]));
        }
        return jLabel;
    }

    private static final void watchPromoVideo(SpaceOverviewPlace overviewPlace) {
        BrowserUtil.browse((String)PromoKt.getOverviewUrl(overviewPlace));
    }

    @NotNull
    public static final String getOverviewUrl(@NotNull SpaceOverviewPlace $this$overviewUrl) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$overviewUrl), (String)"<this>");
        String placeUtm = switch (WhenMappings.$EnumSwitchMapping$0[$this$overviewUrl.ordinal()]) {
            case 1 -> "main_toolbar-overview";
            case 2 -> "main_ide-settings-overview";
            case 3 -> "main_clone-repo-overview";
            default -> throw new NoWhenBranchMatchedException();
        };
        return "https://www.jetbrains.com/space/?show-overview=from-ide&utm_source=product&utm_medium=link&" + PromoKt.getIdePromoUtmParameter() + "&utm_content=13362-space&utm_term=" + placeUtm;
    }

    @NotNull
    public static final String getExploreUrl(@NotNull SpaceExplorePlace $this$exploreUrl) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$exploreUrl), (String)"<this>");
        String placeUtm = switch (WhenMappings.$EnumSwitchMapping$1[$this$exploreUrl.ordinal()]) {
            case 1 -> "main_toolbar-explore";
            case 2 -> "main_ide-settings-explore";
            case 3 -> "main_share-proj-explore";
            case 4 -> "main_clone-repo-explore";
            default -> throw new NoWhenBranchMatchedException();
        };
        return "https://www.jetbrains.com/space/?utm_source=product&utm_medium=link&" + PromoKt.getIdePromoUtmParameter() + "&utm_content=13362-space&utm_term=" + placeUtm;
    }

    @NotNull
    public static final String getIdePromoUtmParameter() {
        return "utm_campaign=" + ApplicationInfo.getInstance().getBuild().getProductCode();
    }

    private static final void exploreSpaceLink$lambda$1$lambda$0(SpaceExplorePlace $explorePlace, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$explorePlace), (String)"$explorePlace");
        SpaceStatsCounterCollector.EXPLORE_SPACE.log((Object)$explorePlace);
    }

    private static final void wrapWithWatchSpaceOverviewLabelOverlay$lambda$2(SpaceOverviewPlace $overviewPlace) {
        Intrinsics.checkNotNullParameter((Object)((Object)$overviewPlace), (String)"$overviewPlace");
        SpaceStatsCounterCollector.WATCH_OVERVIEW.log((Object)$overviewPlace);
        PromoKt.watchPromoVideo($overviewPlace);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SpaceOverviewPlace.values().length];
            try {
                nArray[SpaceOverviewPlace.MAIN_TOOLBAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpaceOverviewPlace.SETTINGS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpaceOverviewPlace.CLONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SpaceExplorePlace.values().length];
            try {
                nArray[SpaceExplorePlace.MAIN_TOOLBAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpaceExplorePlace.SETTINGS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpaceExplorePlace.SHARE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpaceExplorePlace.CLONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

