/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.chat.markdown;

import com.intellij.markdown.utils.CodeFenceSyntaxHighlighterGeneratingProvider;
import com.intellij.markdown.utils.lang.HtmlSyntaxHighlighter;
import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.flavours.gfm.StrikeThroughParser;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.SimpleInlineTagProvider;
import org.intellij.markdown.parser.LinkMap;
import org.intellij.markdown.parser.sequentialparsers.RangesListBuilder;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserManager;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.intellij.markdown.parser.sequentialparsers.impl.AutolinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.BacktickParser;
import org.intellij.markdown.parser.sequentialparsers.impl.EmphStrongParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ImageParser;
import org.intellij.markdown.parser.sequentialparsers.impl.InlineLinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ReferenceLinkParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/space/vcs/chat/markdown/SpaceFlavourDescriptor;", "Lorg/intellij/markdown/flavours/gfm/GFMFlavourDescriptor;", "htmlSyntaxHighlighter", "Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter;", "(Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter;)V", "sequentialParserManager", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "getSequentialParserManager", "()Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "createHtmlGeneratingProviders", "", "Lorg/intellij/markdown/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "LineBreaksParser", "intellij.space.vcs"})
public final class SpaceFlavourDescriptor
extends GFMFlavourDescriptor {
    @NotNull
    private final HtmlSyntaxHighlighter htmlSyntaxHighlighter;
    @NotNull
    private final SequentialParserManager sequentialParserManager;

    public SpaceFlavourDescriptor(@NotNull HtmlSyntaxHighlighter htmlSyntaxHighlighter) {
        Intrinsics.checkNotNullParameter((Object)htmlSyntaxHighlighter, (String)"htmlSyntaxHighlighter");
        super(false, false, false, 7, null);
        this.htmlSyntaxHighlighter = htmlSyntaxHighlighter;
        this.sequentialParserManager = new SequentialParserManager(){

            @NotNull
            public List<SequentialParser> getParserSequence() {
                Object[] objectArray = new SequentialParser[8];
                Object[] objectArray2 = new IElementType[]{MarkdownTokenTypes.AUTOLINK, GFMTokenTypes.GFM_AUTOLINK};
                objectArray[0] = new AutolinkParser(CollectionsKt.listOf((Object[])objectArray2));
                objectArray[1] = new BacktickParser();
                objectArray[2] = new ImageParser();
                objectArray[3] = new InlineLinkParser();
                objectArray[4] = new ReferenceLinkParser();
                objectArray[5] = new LineBreaksParser();
                objectArray[6] = new StrikeThroughParser();
                objectArray[7] = new EmphStrongParser();
                return CollectionsKt.listOf((Object[])objectArray);
            }
        };
    }

    @NotNull
    public SequentialParserManager getSequentialParserManager() {
        return this.sequentialParserManager;
    }

    @NotNull
    public Map<IElementType, GeneratingProvider> createHtmlGeneratingProviders(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
        Intrinsics.checkNotNullParameter((Object)linkMap, (String)"linkMap");
        Map parentProviders = MapsKt.toMutableMap((Map)super.createHtmlGeneratingProviders(linkMap, baseURI));
        parentProviders.put(MarkdownElementTypes.EMPH, new SimpleInlineTagProvider("i", 1, -1));
        parentProviders.put(MarkdownElementTypes.STRONG, new SimpleInlineTagProvider("b", 2, -2));
        parentProviders.put(GFMElementTypes.STRIKETHROUGH, new SimpleInlineTagProvider("strike", 2, -2));
        parentProviders.put(MarkdownElementTypes.CODE_FENCE, new CodeFenceSyntaxHighlighterGeneratingProvider(this.htmlSyntaxHighlighter));
        return parentProviders;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/space/vcs/chat/markdown/SpaceFlavourDescriptor$LineBreaksParser;", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser;", "()V", "parse", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResult;", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "rangesToGlue", "", "Lkotlin/ranges/IntRange;", "intellij.space.vcs"})
    private static final class LineBreaksParser
    implements SequentialParser {
        @NotNull
        public SequentialParser.ParsingResult parse(@NotNull TokensCache tokens2, @NotNull List<IntRange> rangesToGlue) {
            Intrinsics.checkNotNullParameter((Object)tokens2, (String)"tokens");
            Intrinsics.checkNotNullParameter(rangesToGlue, (String)"rangesToGlue");
            SequentialParser.ParsingResultBuilder result2 = new SequentialParser.ParsingResultBuilder();
            RangesListBuilder delegateIndices = new RangesListBuilder();
            TokensCache.RangesListIterator iterator2 = new TokensCache.RangesListIterator(tokens2, rangesToGlue);
            while (iterator2.getType() != null) {
                if (Intrinsics.areEqual((Object)iterator2.getType(), (Object)MarkdownTokenTypes.EOL)) {
                    result2.withNode(new SequentialParser.Node(new IntRange(iterator2.getIndex(), iterator2.getIndex() + 1), MarkdownTokenTypes.HARD_LINE_BREAK));
                } else {
                    delegateIndices.put(iterator2.getIndex());
                }
                iterator2 = iterator2.advance();
            }
            return (SequentialParser.ParsingResult)result2.withFurtherProcessing(delegateIndices.get());
        }
    }
}

