/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.editor;

import com.intellij.diff.editor.DiffVirtualFileBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.space.vcs.chat.editor.SpaceChatFile;
import com.intellij.space.vcs.chat.model.api.SpaceChatCreationDetails;
import com.intellij.space.vcs.chat.ui.SpaceChatUiDetails;
import com.intellij.space.vcs.diff.SpaceDiffFile;
import com.intellij.space.vcs.diff.SpaceDiffPreviewFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0007J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u0007J>\u0010\u0015\u001a\u00020\t2\b\b\u0001\u0010\u0012\u001a\u00020\u00072\b\b\u0001\u0010\u0016\u001a\u00020\u00072\b\b\u0001\u0010\u0017\u001a\u00020\u00072\b\b\u0001\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ \u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\b\b\u0003\u0010\u001f\u001a\u00020\u0007RP\u0010\u0005\u001aD\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n* \u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u000b\u00a2\u0006\u0002\b\b0\u0006\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RP\u0010\f\u001aD\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b\u0012\f\u0012\n \n*\u0004\u0018\u00010\r0\r \n* \u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b\u0012\f\u0012\n \n*\u0004\u0018\u00010\r0\r0\u000b\u00a2\u0006\u0002\b\b0\u0006\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/space/vcs/editor/SpaceVirtualFilesManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "chatFiles", "", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/space/vcs/chat/editor/SpaceChatFile;", "kotlin.jvm.PlatformType", "", "diffFiles", "Lcom/intellij/diff/editor/DiffVirtualFileBase;", "sessionId", "dispose", "", "findChatFile", "id", "findDiffFile", "fileId", "findOrCreateChatFile", "path", "displayName", "tabTooltip", "chatCreationDetails", "Lcom/intellij/space/vcs/chat/model/api/SpaceChatCreationDetails;", "chatUiDetails", "Lcom/intellij/space/vcs/chat/ui/SpaceChatUiDetails;", "findOrCreateDiffFile", "sourceId", "fileName", "intellij.space.vcs"})
@SourceDebugExtension(value={"SMAP\nSpaceVirtualFilesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceVirtualFilesManager.kt\ncom/intellij/space/vcs/editor/SpaceVirtualFilesManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n361#2,7:55\n361#2,7:63\n1#3:62\n*S KotlinDebug\n*F\n+ 1 SpaceVirtualFilesManager.kt\ncom/intellij/space/vcs/editor/SpaceVirtualFilesManager\n*L\n36#1:55,7\n41#1:63,7\n*E\n"})
public final class SpaceVirtualFilesManager
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final String sessionId;
    @NotNull
    private final Map<String, SpaceChatFile> chatFiles;
    @NotNull
    private final Map<String, DiffVirtualFileBase> diffFiles;

    public SpaceVirtualFilesManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.sessionId = String.valueOf(System.currentTimeMillis());
        Map map2 = ContainerUtil.createWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createWeakValueMap<String, SpaceChatFile>()");
        this.chatFiles = map2;
        Map map3 = ContainerUtil.createWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"createWeakValueMap<String, DiffVirtualFileBase>()");
        this.diffFiles = map3;
    }

    @Nullable
    public final SpaceChatFile findChatFile(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return this.chatFiles.get(id2);
    }

    @Nullable
    public final DiffVirtualFileBase findDiffFile(@NotNull String fileId) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        return this.diffFiles.get(fileId);
    }

    @NotNull
    public final SpaceChatFile findOrCreateChatFile(@NlsSafe @NotNull String id2, @NlsSafe @NotNull String path2, @NlsContexts.TabTitle @NotNull String displayName, @NlsContexts.Tooltip @NotNull String tabTooltip, @NotNull SpaceChatCreationDetails chatCreationDetails2, @NotNull SpaceChatUiDetails chatUiDetails) {
        SpaceChatFile spaceChatFile;
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)tabTooltip, (String)"tabTooltip");
        Intrinsics.checkNotNullParameter((Object)chatCreationDetails2, (String)"chatCreationDetails");
        Intrinsics.checkNotNullParameter((Object)chatUiDetails, (String)"chatUiDetails");
        Map<String, SpaceChatFile> $this$getOrPut$iv = this.chatFiles;
        boolean $i$f$getOrPut = false;
        SpaceChatFile value$iv = $this$getOrPut$iv.get(id2);
        if (value$iv == null) {
            boolean bl = false;
            String string2 = this.project.getLocationHash();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.locationHash");
            SpaceChatFile answer$iv = new SpaceChatFile(this.sessionId, string2, id2, path2, displayName, tabTooltip, chatCreationDetails2, chatUiDetails);
            $this$getOrPut$iv.put(id2, answer$iv);
            spaceChatFile = answer$iv;
        } else {
            spaceChatFile = value$iv;
        }
        return spaceChatFile;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DiffVirtualFileBase findOrCreateDiffFile(@NotNull String sourceId, @NotNull String fileId, @Nls @NotNull String fileName) {
        Object object;
        void key$iv;
        void $this$getOrPut$iv;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Map<String, DiffVirtualFileBase> map2 = this.diffFiles;
        CharSequence charSequence2 = sourceId;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = fileId;
        } else {
            charSequence = charSequence2;
        }
        charSequence2 = charSequence;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            VirtualFilePathWrapper virtualFilePathWrapper;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)sourceId)) {
                String string2 = this.project.getLocationHash();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.locationHash");
                virtualFilePathWrapper = new SpaceDiffPreviewFile(sourceId, this.sessionId, string2, fileId, fileName);
            } else {
                String string3 = this.project.getLocationHash();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"project.locationHash");
                virtualFilePathWrapper = new SpaceDiffFile(this.sessionId, string3, fileId, fileName);
            }
            DiffVirtualFileBase answer$iv = (DiffVirtualFileBase)virtualFilePathWrapper;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (DiffVirtualFileBase)object;
    }

    public static /* synthetic */ DiffVirtualFileBase findOrCreateDiffFile$default(SpaceVirtualFilesManager spaceVirtualFilesManager, String string2, String string3, String string4, int n, Object object) {
        if ((n & 4) != 0) {
            string4 = string3;
        }
        return spaceVirtualFilesManager.findOrCreateDiffFile(string2, string3, string4);
    }

    public void dispose() {
        this.chatFiles.clear();
        this.diffFiles.clear();
    }
}

