/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.review;

import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.collaboration.ui.toolwindow.ReviewTabsComponentFactory;
import com.intellij.collaboration.ui.toolwindow.ReviewTabsController;
import com.intellij.collaboration.ui.toolwindow.ReviewToolwindowTabsManagerKt;
import com.intellij.collaboration.ui.toolwindow.ReviewToolwindowViewModel;
import com.intellij.collaboration.ui.toolwindow.ToolwindowUtilsKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.vcs.SpaceProjectContext;
import com.intellij.space.vcs.review.SpaceReviewSwitchProjectActionGroup;
import com.intellij.space.vcs.review.SpaceReviewTabComponentFactory;
import com.intellij.space.vcs.review.SpaceReviewTabsController;
import com.intellij.space.vcs.review.SpaceReviewToolWindowVm;
import com.intellij.ui.content.ContentManager;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import libraries.coroutines.extra.CoroutineBuildersCommonKt;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.DispatchJvmKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/space/vcs/review/SpaceReviewToolWindowFactory;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "init", "manageSpaceReviewTabs", "toolwindow", "shouldBeAvailable", "", "Companion", "intellij.space.vcs"})
@SourceDebugExtension(value={"SMAP\nSpaceReviewToolWindowFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceReviewToolWindowFactory.kt\ncom/intellij/space/vcs/review/SpaceReviewToolWindowFactory\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,76:1\n29#2,3:77\n*S KotlinDebug\n*F\n+ 1 SpaceReviewToolWindowFactory.kt\ncom/intellij/space/vcs/review/SpaceReviewToolWindowFactory\n*L\n25#1:77,3\n*E\n"})
public final class SpaceReviewToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "Space Code Reviews";

    public void init(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Project project2 = toolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"toolWindow.project");
        Project project3 = project2;
        ComponentManager $this$service$iv = (ComponentManager)project3;
        boolean $i$f$service = false;
        Class<SpaceProjectContext> serviceClass$iv = SpaceProjectContext.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        SpaceProjectContext projectContext2 = (SpaceProjectContext)object;
        Lifetime lifetime = projectContext2.getLifetime();
        projectContext2.getProbablyContainsSpaceRepo().forEach(lifetime, (Function1<Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(lifetime, toolWindow){
            final /* synthetic */ Lifetime $lifetime;
            final /* synthetic */ ToolWindow $toolWindow;
            {
                this.$lifetime = $lifetime;
                this.$toolWindow = $toolWindow;
                super(1);
            }

            public final void invoke(boolean it) {
                CoroutineBuildersCommonKt.launch$default(this.$lifetime, DispatchJvmKt.getUi(), null, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$toolWindow, it, null){
                    int label;
                    final /* synthetic */ ToolWindow $toolWindow;
                    final /* synthetic */ boolean $it;
                    {
                        this.$toolWindow = $toolWindow;
                        this.$it = $it;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.$toolWindow.setAvailable(this.$it);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 12, null);
            }
        }));
    }

    public void createToolWindowContent(@NotNull Project project2, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        toolWindow.getComponent().putClientProperty("HideIdLabel", "true");
        ToolwindowUtilsKt.dontHideOnEmptyContent((ToolWindow)toolWindow);
        ActionManager actionManager = ActionManager.getInstance();
        AnAction createMrAction = actionManager.getAction("com.intellij.space.vcs.review.create.SpaceCreateMergeRequestAction");
        AnAction createCrAction = actionManager.getAction("com.intellij.space.vcs.review.create.SpaceCreateCommitSetReviewAction");
        AnAction[] anActionArray = new AnAction[]{createMrAction, createCrAction};
        AnAction[] anActionArray2 = anActionArray;
        DumbAware createReviewActionGroup2 = new DumbAware(anActionArray2){
            {
                this.getTemplatePresentation().setPopupGroup(true);
                this.getTemplatePresentation().setHideGroupIfEmpty(true);
                this.getTemplatePresentation().setIcon(AllIcons.General.Add);
                this.setShortcutSet(CommonShortcuts.getNew());
                this.setSearchable(false);
            }
        };
        this.manageSpaceReviewTabs(project2, toolWindow);
        toolWindow.setTitleActions(CollectionsKt.listOf((Object)createReviewActionGroup2));
        toolWindow.setAdditionalGearActions((ActionGroup)new SpaceReviewSwitchProjectActionGroup());
    }

    private final void manageSpaceReviewTabs(Project project2, ToolWindow toolwindow) {
        ContentManager contentManager = toolwindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolwindow.contentManager");
        CoroutineScope cs = CoroutineUtilKt.disposingScope((Disposable)((Disposable)contentManager), (CoroutineContext)DispatchJvmKt.getUi());
        SpaceReviewToolWindowVm toolwindowVm = new SpaceReviewToolWindowVm(cs, project2);
        SpaceReviewTabsController reviewTabsController = new SpaceReviewTabsController();
        SpaceReviewTabComponentFactory tabComponentFactory = new SpaceReviewTabComponentFactory(project2, reviewTabsController);
        ReviewToolwindowViewModel reviewToolwindowViewModel = toolwindowVm;
        ReviewTabsController reviewTabsController2 = reviewTabsController;
        ReviewTabsComponentFactory reviewTabsComponentFactory = tabComponentFactory;
        String string2 = SpaceBundle.message("review.toolwindow.tab.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"review.toolwindow.tab.title\")");
        ReviewToolwindowTabsManagerKt.manageReviewToolwindowTabs((CoroutineScope)cs, (ToolWindow)toolwindow, (ReviewToolwindowViewModel)reviewToolwindowViewModel, (ReviewTabsController)reviewTabsController2, (ReviewTabsComponentFactory)reviewTabsComponentFactory, (String)string2);
    }

    public boolean shouldBeAvailable(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return false;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/space/vcs/review/SpaceReviewToolWindowFactory$Companion;", "", "()V", "ID", "", "intellij.space.vcs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

