/*
 * Decompiled with CFR 0.152.
 */
package libraries.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.AbstractMutableSet;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.collections.HashCommon;
import libraries.collections.MutableLongIterator;
import libraries.collections.MutableLongSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u0000 92\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u00029:B\u0019\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u0002H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0011\u0010)\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u0002H\u0096\u0002J\u000e\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u0000J\b\u0010,\u001a\u00020\nH\u0016J\t\u0010-\u001a\u00020.H\u0096\u0002J\b\u0010/\u001a\u00020\u0005H\u0002J\u0010\u00100\u001a\u00020(2\u0006\u00101\u001a\u00020\u0005H\u0004J\u0010\u00102\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u0002H\u0016J\u0010\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\u0005H\u0002J\b\u00105\u001a\u00020\nH\u0002J\u0010\u00106\u001a\u00020(2\u0006\u00107\u001a\u00020\u0005H\u0004J\b\u00108\u001a\u00020\u0010H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u001a\u0010\u001f\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0019\"\u0004\b!\u0010\u001bR\u001e\u0010#\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0019\u00a8\u0006;"}, d2={"Llibraries/collections/LongOpenHashSet;", "Lkotlin/collections/AbstractMutableSet;", "", "Llibraries/collections/MutableLongSet;", "expected", "", "loadFactor", "", "(IF)V", "containsNull", "", "getContainsNull", "()Z", "setContainsNull", "(Z)V", "key", "", "getKey", "()[J", "setKey", "([J)V", "getLoadFactor", "()F", "mask", "getMask", "()I", "setMask", "(I)V", "maxFill", "minN", "getMinN", "n", "getN", "setN", "<set-?>", "size", "getSize", "add", "element", "clear", "", "contains", "fastEquals", "other", "isEmpty", "iterator", "Llibraries/collections/MutableLongIterator;", "realSize", "rehash", "newN", "remove", "removeEntry", "pos", "removeNullEntry", "shiftKeys", "startAt", "toLongArray", "Companion", "SetIterator", "libraries-collections"})
@SourceDebugExtension(value={"SMAP\nLongOpenHashSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongOpenHashSet.kt\nlibraries/collections/LongOpenHashSet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,286:1\n1#2:287\n*E\n"})
public class LongOpenHashSet
extends AbstractMutableSet<Long>
implements MutableLongSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float loadFactor;
    @NotNull
    private long[] key;
    private int mask;
    private boolean containsNull;
    private int n;
    private int maxFill;
    private final int minN;
    private int size;
    private static int DEFAULT_INITIAL_SIZE = 16;
    private static float DEFAULT_LOAD_FACTOR = 0.75f;

    public LongOpenHashSet(int expected, float loadFactor) {
        this.loadFactor = loadFactor;
        if (!(!(this.loadFactor <= 0.0f) && !(this.loadFactor >= 1.0f))) {
            boolean $i$a$-require-LongOpenHashSet$32 = false;
            String $i$a$-require-LongOpenHashSet$32 = "Load factor must be greater than 0 and smaller than 1";
            throw new IllegalArgumentException($i$a$-require-LongOpenHashSet$32.toString());
        }
        if (!(expected >= 0)) {
            boolean bl = false;
            String string2 = "The expected number of elements must not be negative";
            throw new IllegalArgumentException(string2.toString());
        }
        this.minN = this.n = HashCommon.INSTANCE.arraySize(expected, this.loadFactor);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.INSTANCE.maxFill(this.n, this.loadFactor);
        this.key = new long[this.n + 1];
    }

    public /* synthetic */ LongOpenHashSet(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = DEFAULT_INITIAL_SIZE;
        }
        if ((n2 & 2) != 0) {
            f = DEFAULT_LOAD_FACTOR;
        }
        this(n, f);
    }

    protected final float getLoadFactor() {
        return this.loadFactor;
    }

    @NotNull
    protected final long[] getKey() {
        return this.key;
    }

    protected final void setKey(@NotNull long[] lArray) {
        Intrinsics.checkNotNullParameter((Object)lArray, (String)"<set-?>");
        this.key = lArray;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    protected final boolean getContainsNull() {
        return this.containsNull;
    }

    protected final void setContainsNull(boolean bl) {
        this.containsNull = bl;
    }

    protected final int getN() {
        return this.n;
    }

    protected final void setN(int n) {
        this.n = n;
    }

    protected final int getMinN() {
        return this.minN;
    }

    public final int getSize() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(long element) {
        int pos = 0;
        if (element == 0L) {
            if (this.containsNull) {
                return false;
            }
            this.containsNull = true;
        } else {
            block7: {
                long l;
                void it;
                int n;
                long curr = 0L;
                long[] key2 = this.key;
                int n2 = n = (int)HashCommon.INSTANCE.mix(element) & this.mask;
                long[] lArray = key2;
                boolean bl = false;
                pos = it;
                long it32 = l = lArray[n];
                boolean bl2 = false;
                curr = it32;
                if (l != 0L) {
                    if (curr == element) {
                        return false;
                    }
                    do {
                        int n3;
                        int it32 = n3 = pos + 1 & this.mask;
                        lArray = key2;
                        boolean bl3 = false;
                        pos = it32;
                        it32 = l = lArray[n3];
                        boolean bl4 = false;
                        curr = it32;
                        if (l == 0L) break block7;
                    } while (curr != element);
                    return false;
                }
            }
            key2[pos] = element;
        }
        int n = this.size;
        this.size = n + 1;
        if (n >= this.maxFill) {
            this.rehash(HashCommon.INSTANCE.arraySize(this.size + 1, this.loadFactor));
        }
        return true;
    }

    protected final void shiftKeys(int startAt) {
        int pos = startAt;
        int last = 0;
        int slot = 0;
        long curr = 0L;
        long[] key2 = this.key;
        while (true) {
            int n;
            int it = n = pos;
            boolean bl = false;
            last = it;
            pos = n + 1 & this.mask;
            while (true) {
                long l;
                long it2 = l = key2[pos];
                boolean bl2 = false;
                curr = it2;
                if (l == 0L) {
                    key2[last] = 0L;
                    return;
                }
                slot = (int)HashCommon.INSTANCE.mix(curr) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            key2[last] = curr;
        }
    }

    private final int realSize() {
        return this.containsNull ? this.size - 1 : this.size;
    }

    private final boolean removeEntry(int pos) {
        int n = this.size;
        this.size = n + -1;
        this.shiftKeys(pos);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > DEFAULT_INITIAL_SIZE) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    private final boolean removeNullEntry() {
        this.containsNull = false;
        this.key[this.n] = 0L;
        int n = this.size;
        this.size = n + -1;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > DEFAULT_INITIAL_SIZE) {
            this.rehash(this.n / 2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(long element) {
        long l;
        void it;
        int n;
        if (element == 0L) {
            return this.containsNull ? this.removeNullEntry() : false;
        }
        long curr = 0L;
        long[] key2 = this.key;
        int pos = 0;
        int n2 = n = (int)HashCommon.INSTANCE.mix(element) & this.mask;
        long[] lArray = key2;
        boolean bl = false;
        pos = it;
        long it32 = l = lArray[n];
        boolean bl2 = false;
        curr = it32;
        if (l == 0L) {
            return false;
        }
        if (element == curr) {
            return this.removeEntry(pos);
        }
        do {
            int n3;
            int it32 = n3 = pos + 1 & this.mask;
            lArray = key2;
            boolean bl3 = false;
            pos = it32;
            it32 = l = lArray[n3];
            boolean bl4 = false;
            curr = it32;
            if (l != 0L) continue;
            return false;
        } while (element != curr);
        return this.removeEntry(pos);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(long element) {
        long l;
        void it;
        int n;
        if (element == 0L) {
            return this.containsNull;
        }
        long curr = 0L;
        long[] key2 = this.key;
        int pos = 0;
        int n2 = n = (int)HashCommon.INSTANCE.mix(element) & this.mask;
        long[] lArray = key2;
        boolean bl = false;
        pos = it;
        long it32 = l = lArray[n];
        boolean bl2 = false;
        curr = it32;
        if (l == 0L) {
            return false;
        }
        if (element == curr) {
            return true;
        }
        do {
            int n3;
            int it32 = n3 = pos + 1 & this.mask;
            lArray = key2;
            boolean bl3 = false;
            pos = it32;
            it32 = l = lArray[n3];
            boolean bl4 = false;
            curr = it32;
            if (l != 0L) continue;
            return false;
        } while (element != curr);
        return true;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNull = false;
        ArraysKt.fill$default((long[])this.key, (long)0L, (int)0, (int)0, (int)6, null);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    @NotNull
    public long[] toLongArray() {
        String string2 = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    @NotNull
    public MutableLongIterator iterator() {
        return new SetIterator();
    }

    protected final void rehash(int newN) {
        long[] key2 = this.key;
        int mask = newN - 1;
        long[] newKey = new long[newN + 1];
        int i = this.n;
        int pos = 0;
        int j = this.realSize();
        while (j-- != 0) {
            int it;
            int n;
            while (key2[--i] == 0L) {
            }
            int n2 = n = (int)HashCommon.INSTANCE.mix(key2[i]) & mask;
            long[] lArray = newKey;
            boolean bl = false;
            pos = it;
            if (lArray[n] != 0L) {
                do {
                    it = n = pos + 1 & mask;
                    lArray = newKey;
                    boolean bl2 = false;
                    pos = it;
                } while (lArray[n] != 0L);
            }
            newKey[pos] = key2[i];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.INSTANCE.maxFill(this.n, this.loadFactor);
        this.key = newKey;
    }

    public final boolean fastEquals(@NotNull LongOpenHashSet other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.size != other.size) {
            return false;
        }
        if (this.mask == other.mask && this.containsNull == other.containsNull && this.n == other.n && Arrays.equals(this.key, other.key)) {
            return true;
        }
        return this.equals(other);
    }

    public LongOpenHashSet() {
        this(0, 0.0f, 3, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Llibraries/collections/LongOpenHashSet$Companion;", "", "()V", "DEFAULT_INITIAL_SIZE", "", "getDEFAULT_INITIAL_SIZE", "()I", "setDEFAULT_INITIAL_SIZE", "(I)V", "DEFAULT_LOAD_FACTOR", "", "getDEFAULT_LOAD_FACTOR", "()F", "setDEFAULT_LOAD_FACTOR", "(F)V", "libraries-collections"})
    public static final class Companion {
        private Companion() {
        }

        public final int getDEFAULT_INITIAL_SIZE() {
            return DEFAULT_INITIAL_SIZE;
        }

        public final void setDEFAULT_INITIAL_SIZE(int n) {
            DEFAULT_INITIAL_SIZE = n;
        }

        public final float getDEFAULT_LOAD_FACTOR() {
            return DEFAULT_LOAD_FACTOR;
        }

        public final void setDEFAULT_LOAD_FACTOR(float f) {
            DEFAULT_LOAD_FACTOR = f;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u001d\u001a\u00020\rH\u0096\u0002J\u000e\u0010\u001e\u001a\u00020\u0017H\u0096\u0002\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u0017H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0004H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR.\u0010\u0015\u001a\u0016\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016j\n\u0012\u0004\u0012\u00020\u0017\u0018\u0001`\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006%"}, d2={"Llibraries/collections/LongOpenHashSet$SetIterator;", "Llibraries/collections/MutableLongIterator;", "(Llibraries/collections/LongOpenHashSet;)V", "c", "", "getC", "()I", "setC", "(I)V", "last", "getLast", "setLast", "mustReturnNull", "", "getMustReturnNull", "()Z", "setMustReturnNull", "(Z)V", "pos", "getPos", "setPos", "wrapped", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getWrapped", "()Ljava/util/ArrayList;", "setWrapped", "(Ljava/util/ArrayList;)V", "hasNext", "next", "()Ljava/lang/Long;", "nextLong", "remove", "", "shiftKeys", "startAt", "libraries-collections"})
    @SourceDebugExtension(value={"SMAP\nLongOpenHashSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongOpenHashSet.kt\nlibraries/collections/LongOpenHashSet$SetIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,286:1\n1#2:287\n*E\n"})
    private final class SetIterator
    implements MutableLongIterator {
        private int pos;
        private int last;
        private int c;
        private boolean mustReturnNull;
        @Nullable
        private ArrayList<Long> wrapped;

        public SetIterator() {
            this.pos = LongOpenHashSet.this.getN();
            this.last = -1;
            this.c = LongOpenHashSet.this.size();
            this.mustReturnNull = LongOpenHashSet.this.getContainsNull();
        }

        public final int getPos() {
            return this.pos;
        }

        public final void setPos(int n) {
            this.pos = n;
        }

        public final int getLast() {
            return this.last;
        }

        public final void setLast(int n) {
            this.last = n;
        }

        public final int getC() {
            return this.c;
        }

        public final void setC(int n) {
            this.c = n;
        }

        public final boolean getMustReturnNull() {
            return this.mustReturnNull;
        }

        public final void setMustReturnNull(boolean bl) {
            this.mustReturnNull = bl;
        }

        @Nullable
        public final ArrayList<Long> getWrapped() {
            return this.wrapped;
        }

        public final void setWrapped(@Nullable ArrayList<Long> arrayList) {
            this.wrapped = arrayList;
        }

        @Override
        public boolean hasNext() {
            return this.c != 0;
        }

        @Override
        @NotNull
        public Long next() {
            return this.nextLong();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long nextLong() {
            void it;
            int n;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n2 = this.c;
            this.c = n2 + -1;
            if (this.mustReturnNull) {
                this.mustReturnNull = false;
                this.last = LongOpenHashSet.this.getN();
                return LongOpenHashSet.this.getKey()[LongOpenHashSet.this.getN()];
            }
            long[] key2 = LongOpenHashSet.this.getKey();
            do {
                this.pos += -1;
                if (this.pos >= 0) continue;
                this.last = Integer.MIN_VALUE;
                ArrayList<Long> arrayList = this.wrapped;
                Intrinsics.checkNotNull(arrayList);
                Long l = arrayList.get(-this.pos - 1);
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"wrapped!![-pos - 1]");
                return ((Number)l).longValue();
            } while (key2[this.pos] == 0L);
            int n3 = n = this.pos;
            long[] lArray = key2;
            boolean bl = false;
            this.last = it;
            return lArray[n];
        }

        private final void shiftKeys(int startAt) {
            int pos = startAt;
            int last = 0;
            int slot = 0;
            long curr = 0L;
            long[] key2 = LongOpenHashSet.this.getKey();
            while (true) {
                int n;
                int it = n = pos;
                boolean bl = false;
                last = it;
                pos = n + 1 & LongOpenHashSet.this.getMask();
                while (true) {
                    long l;
                    long it2 = l = key2[pos];
                    boolean bl2 = false;
                    curr = it2;
                    if (l == 0L) {
                        key2[last] = 0L;
                        return;
                    }
                    slot = (int)HashCommon.INSTANCE.mix(curr) & LongOpenHashSet.this.getMask();
                    if (last <= pos ? last >= slot || slot > pos : (pos + 1 <= slot ? slot <= last : false)) break;
                    pos = pos + 1 & LongOpenHashSet.this.getMask();
                }
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new ArrayList(2);
                    }
                    ArrayList<Long> arrayList = this.wrapped;
                    Intrinsics.checkNotNull(arrayList);
                    arrayList.add(key2[pos]);
                }
                key2[last] = curr;
            }
        }

        @Override
        public void remove() {
            if (!(this.last != -1)) {
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            if (this.last == LongOpenHashSet.this.getN()) {
                LongOpenHashSet.this.setContainsNull(false);
                LongOpenHashSet.this.getKey()[LongOpenHashSet.this.getN()] = 0L;
            } else if (this.pos >= 0) {
                this.shiftKeys(this.last);
            } else {
                ArrayList<Long> arrayList = this.wrapped;
                Intrinsics.checkNotNull(arrayList);
                LongOpenHashSet.this.remove(arrayList.get(-this.pos - 1));
                this.last = -1;
                return;
            }
            LongOpenHashSet longOpenHashSet = LongOpenHashSet.this;
            int n = longOpenHashSet.size();
            longOpenHashSet.size = n + -1;
            this.last = -1;
        }
    }
}

