/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.pack;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.ivy.core.pack.ArchivePacking;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;

public class ZipPacking
extends ArchivePacking {
    private static final String[] NAMES = new String[]{"zip", "jar", "war"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getUnpackedExtension(String ext2) {
        if ((ext2.endsWith("zip") || ext2.endsWith("jar") || ext2.endsWith("war")) && (ext2 = ext2.substring(0, ext2.length() - 3)).endsWith(".")) {
            ext2 = ext2.substring(0, ext2.length() - 1);
        }
        return ext2;
    }

    @Override
    public void unpack(InputStream packed, File dest) throws IOException {
        try (ZipInputStream zip = new ZipInputStream(packed);){
            ZipEntry entry = null;
            while ((entry = zip.getNextEntry()) != null) {
                File f = new File(dest, entry.getName());
                Message.verbose("\t\texpanding " + entry.getName() + " to " + f);
                File dirF = f.getParentFile();
                if (dirF != null) {
                    dirF.mkdirs();
                }
                if (entry.isDirectory()) {
                    f.mkdirs();
                } else {
                    this.writeFile(zip, f);
                }
                f.setLastModified(entry.getTime());
            }
        }
    }

    protected void writeFile(InputStream zip, File f) throws IOException {
        try (FileOutputStream out = new FileOutputStream(f);){
            FileUtil.copy(zip, out, null, false);
        }
    }
}

