/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.repo.ModuleDescriptorWrapper;
import org.apache.ivy.osgi.repo.RepoDescriptor;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.util.Message;

public class EditableRepoDescriptor
extends RepoDescriptor {
    private final Map<String, Map<String, Set<ModuleDescriptorWrapper>>> moduleByCapabilities = new HashMap<String, Map<String, Set<ModuleDescriptorWrapper>>>();
    private final Set<ModuleDescriptorWrapper> modules = new HashSet<ModuleDescriptorWrapper>();
    private final ExecutionEnvironmentProfileProvider profileProvider;
    private final URI baseUri;
    private int logLevel = 2;

    public EditableRepoDescriptor(URI baseUri, ExecutionEnvironmentProfileProvider profileProvider) {
        this.baseUri = baseUri;
        this.profileProvider = profileProvider;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public Iterator<ModuleDescriptorWrapper> getModules() {
        return this.modules.iterator();
    }

    @Override
    public Set<String> getCapabilities() {
        return this.moduleByCapabilities.keySet();
    }

    @Override
    public Set<ModuleDescriptorWrapper> findModules(String requirement, String value2) {
        Map<String, Set<ModuleDescriptorWrapper>> modules = this.moduleByCapabilities.get(requirement);
        if (modules == null) {
            return null;
        }
        return modules.get(value2);
    }

    public ModuleDescriptorWrapper findModule(String symbolicName, Version version) {
        Set<ModuleDescriptorWrapper> modules = this.findModules("bundle", symbolicName);
        if (modules == null) {
            return null;
        }
        for (ModuleDescriptorWrapper module2 : modules) {
            if (!module2.getBundleInfo().getVersion().equals(version)) continue;
            return module2;
        }
        return null;
    }

    @Override
    public Set<String> getCapabilityValues(String capabilityName) {
        Map<String, Set<ModuleDescriptorWrapper>> modules = this.moduleByCapabilities.get(capabilityName);
        if (modules == null) {
            return Collections.emptySet();
        }
        return modules.keySet();
    }

    private void add(String type2, String value2, ModuleDescriptorWrapper md) {
        Set<ModuleDescriptorWrapper> bundleReferences;
        this.modules.add(md);
        Map<String, Set<ModuleDescriptorWrapper>> map2 = this.moduleByCapabilities.get(type2);
        if (map2 == null) {
            map2 = new HashMap<String, Set<ModuleDescriptorWrapper>>();
            this.moduleByCapabilities.put(type2, map2);
        }
        if ((bundleReferences = map2.get(value2)) == null) {
            bundleReferences = new HashSet<ModuleDescriptorWrapper>();
            map2.put(value2, bundleReferences);
        }
        if (!bundleReferences.add(md) && this.logLevel <= 4) {
            Message.debug("Duplicate module in the repo " + this.baseUri + " for " + type2 + " " + value2 + ": " + md.getBundleInfo().getSymbolicName() + "#" + md.getBundleInfo().getVersion());
        }
    }

    public void addBundle(BundleInfo bundleInfo) {
        ModuleDescriptorWrapper module2 = this.findModule(bundleInfo.getSymbolicName(), bundleInfo.getVersion());
        if (module2 != null) {
            Message.debug("Duplicate module " + bundleInfo.getSymbolicName() + "@" + bundleInfo.getVersion());
            return;
        }
        ModuleDescriptorWrapper md = new ModuleDescriptorWrapper(bundleInfo, this.baseUri, this.profileProvider);
        this.add("bundle", bundleInfo.getSymbolicName(), md);
        for (BundleCapability capability : bundleInfo.getCapabilities()) {
            this.add(capability.getType(), capability.getName(), md);
        }
    }

    public String toString() {
        return this.modules.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.modules == null ? 0 : this.modules.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EditableRepoDescriptor)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        EditableRepoDescriptor other = (EditableRepoDescriptor)obj;
        return this.modules == null ? other.modules == null : this.modules.equals(other.modules);
    }
}

