/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.updatesite.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.osgi.updatesite.xml.EclipseFeature;
import org.apache.ivy.osgi.updatesite.xml.UpdateSite;
import org.apache.ivy.osgi.util.DelegatingHandler;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EclipseUpdateSiteParser {
    public static UpdateSite parse(InputStream in) throws IOException, SAXException {
        SiteHandler handler = new SiteHandler();
        try {
            XMLHelper.parse(in, null, (DefaultHandler)handler, null);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        return handler.updatesite;
    }

    private static class CategoryHandler
    extends DelegatingHandler {
        private static final String CATEGORY = "category";
        private static final String NAME = "name";
        String name;

        public CategoryHandler() {
            super(CATEGORY);
        }

        @Override
        protected void handleAttributes(Attributes atts) throws SAXException {
            this.name = atts.getValue(NAME);
        }
    }

    private static class FeatureHandler
    extends DelegatingHandler {
        private static final String FEATURE = "feature";
        private static final String VERSION = "version";
        private static final String ID = "id";
        private static final String URL = "url";
        private static final String PATCH = "patch";
        private static final String ARCH = "arch";
        private static final String NL = "nl";
        private static final String WS = "ws";
        private static final String OS = "os";
        private static final String LABEL = "label";
        private static final String TYPE = "type";
        private EclipseFeature feature;

        public FeatureHandler() {
            super(FEATURE);
            this.addChild(new CategoryHandler(), new DelegatingHandler.ChildElementHandler<CategoryHandler>(){

                @Override
                public void childHandled(CategoryHandler child) {
                    FeatureHandler.this.feature.addCategory(child.name);
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes atts) throws SAXException {
            String id2 = atts.getValue(ID);
            String version = atts.getValue(VERSION);
            this.feature = new EclipseFeature(id2, new Version(version));
            String url2 = atts.getValue(URL);
            if (url2 != null) {
                this.feature.setURL(url2);
            }
            this.feature.setType(atts.getValue(TYPE));
            this.feature.setLabel(atts.getValue(LABEL));
            this.feature.setOS(atts.getValue(OS));
            this.feature.setWS(atts.getValue(WS));
            this.feature.setNL(atts.getValue(NL));
            this.feature.setArch(atts.getValue(ARCH));
            this.feature.setPatch(atts.getValue(PATCH));
        }
    }

    private static class SiteHandler
    extends DelegatingHandler {
        private static final String SITE = "site";
        private static final String URL = "url";
        private static final String PACK200 = "pack200";
        private static final String MIRRORS_URL = "mirrorsURL";
        private static final String ASSOCIATE_SITES_URL = "associateSitesURL";
        private static final String DIGEST_URL = "digestURL";
        UpdateSite updatesite;

        public SiteHandler() {
            super(SITE);
            this.addChild(new FeatureHandler(), new DelegatingHandler.ChildElementHandler<FeatureHandler>(){

                @Override
                public void childHandled(FeatureHandler child) {
                    SiteHandler.this.updatesite.addFeature(child.feature);
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes atts) {
            String associateSitesURL;
            String digestURL;
            String pack200;
            String mirrorsURL;
            this.updatesite = new UpdateSite();
            String url2 = atts.getValue(URL);
            if (!StringUtils.isNullOrEmpty(url2)) {
                if (!url2.endsWith("/") && !url2.endsWith(File.separator)) {
                    url2 = url2 + "/";
                }
                try {
                    this.updatesite.setUri(new URI(url2));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("illegal url", e);
                }
            }
            if (!StringUtils.isNullOrEmpty(mirrorsURL = atts.getValue(MIRRORS_URL))) {
                this.updatesite.setMirrorsURL(mirrorsURL);
            }
            if ((pack200 = atts.getValue(PACK200)) != null && Boolean.parseBoolean(pack200)) {
                this.updatesite.setPack200(true);
            }
            if ((digestURL = atts.getValue(DIGEST_URL)) != null) {
                try {
                    this.updatesite.setDigestUri(new URI(digestURL));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("illegal url", e);
                }
            }
            if ((associateSitesURL = atts.getValue(ASSOCIATE_SITES_URL)) != null) {
                this.updatesite.setAssociateSitesURL(associateSitesURL);
            }
        }
    }
}

