/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.ivy.core.settings.TimeoutConstraint;
import org.apache.ivy.plugins.repository.BasicResource;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.sftp.SFTPResource;
import org.apache.ivy.plugins.repository.ssh.AbstractSshBasedRepository;
import org.apache.ivy.plugins.repository.ssh.SshCache;
import org.apache.ivy.util.Message;

public class SFTPRepository
extends AbstractSshBasedRepository {
    private static final long MILLIS_PER_SECOND = 1000L;

    public SFTPRepository() {
    }

    public SFTPRepository(TimeoutConstraint timeoutConstraint) {
        super(timeoutConstraint);
    }

    @Override
    public Resource getResource(String source2) {
        return new SFTPResource(this, source2);
    }

    public Resource resolveResource(String path2) {
        try {
            Vector r = this.getSftpChannel(path2).ls(this.getPath(path2));
            if (r != null) {
                SftpATTRS attrs = ((ChannelSftp.LsEntry)r.get(0)).getAttrs();
                return new BasicResource(path2, true, attrs.getSize(), (long)attrs.getMTime() * 1000L, false);
            }
        }
        catch (Exception e) {
            Message.debug("Error while resolving resource " + path2, e);
        }
        return new BasicResource(path2, false, 0L, 0L, false);
    }

    public InputStream openStream(SFTPResource resource) throws IOException {
        ChannelSftp c = this.getSftpChannel(resource.getName());
        try {
            String path2 = this.getPath(resource.getName());
            return c.get(path2);
        }
        catch (SftpException | URISyntaxException e) {
            throw new IOException("impossible to open stream for " + resource + " on " + this.getHost() + (e.getMessage() != null ? ": " + e.getMessage() : ""), e);
        }
    }

    @Override
    public void get(String source2, File destination) throws IOException {
        this.fireTransferInitiated(this.getResource(source2), 5);
        ChannelSftp c = this.getSftpChannel(source2);
        try {
            String path2 = this.getPath(source2);
            c.get(path2, destination.getAbsolutePath(), (SftpProgressMonitor)new MyProgressMonitor());
        }
        catch (SftpException | URISyntaxException e) {
            throw new IOException("impossible to get " + source2 + " on " + this.getHost() + (e.getMessage() != null ? ": " + e.getMessage() : ""), e);
        }
    }

    @Override
    public void put(File source2, String destination, boolean overwrite) throws IOException {
        this.fireTransferInitiated(this.getResource(destination), 6);
        ChannelSftp c = this.getSftpChannel(destination);
        try {
            String path2 = this.getPath(destination);
            if (!overwrite && this.checkExistence(path2, c)) {
                throw new IOException("destination file exists and overwrite == false");
            }
            if (path2.indexOf(47) != -1) {
                this.mkdirs(path2.substring(0, path2.lastIndexOf(47)), c);
            }
            c.put(source2.getAbsolutePath(), path2, (SftpProgressMonitor)new MyProgressMonitor());
        }
        catch (SftpException | URISyntaxException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private void mkdirs(String directory, ChannelSftp c) throws SftpException {
        try {
            SftpATTRS att = c.stat(directory);
            if (att != null && att.isDir()) {
                return;
            }
        }
        catch (SftpException ex) {
            if (directory.indexOf(47) != -1) {
                this.mkdirs(directory.substring(0, directory.lastIndexOf(47)), c);
            }
            c.mkdir(directory);
        }
    }

    private String getPath(String sftpURI) throws URISyntaxException {
        String result2 = null;
        URI uri = new URI(sftpURI);
        result2 = uri.getPath();
        if (result2 == null) {
            throw new URISyntaxException(sftpURI, "Missing path in URI.");
        }
        return result2;
    }

    @Override
    public List<String> list(String parent) throws IOException {
        try {
            ChannelSftp c = this.getSftpChannel(parent);
            String path2 = this.getPath(parent);
            Vector r = c.ls(path2);
            if (r != null) {
                if (!path2.endsWith("/")) {
                    path2 = parent + "/";
                }
                ArrayList<String> result2 = new ArrayList<String>();
                for (ChannelSftp.LsEntry entry : r) {
                    if (".".equals(entry.getFilename()) || "..".equals(entry.getFilename())) continue;
                    result2.add(path2 + entry.getFilename());
                }
                return result2;
            }
        }
        catch (SftpException | URISyntaxException e) {
            throw new IOException("Failed to return a listing for '" + parent + "'", e);
        }
        return null;
    }

    private boolean checkExistence(String file2, ChannelSftp channel2) {
        try {
            return channel2.stat(file2) != null;
        }
        catch (SftpException ex) {
            return false;
        }
    }

    private ChannelSftp getSftpChannel(String pathOrUri) throws IOException {
        Session session = this.getSession(pathOrUri);
        String host = session.getHost();
        ChannelSftp channel2 = SshCache.getInstance().getChannelSftp(session);
        if (channel2 == null) {
            try {
                channel2 = (ChannelSftp)session.openChannel("sftp");
                channel2.connect();
                Message.verbose(":: SFTP :: connected to " + host + "!");
                SshCache.getInstance().attachChannelSftp(session, channel2);
            }
            catch (JSchException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        return channel2;
    }

    @Override
    protected String getRepositoryScheme() {
        return "sftp";
    }

    private final class MyProgressMonitor
    implements SftpProgressMonitor {
        private long totalLength;

        private MyProgressMonitor() {
        }

        public void init(int op, String src, String dest, long max) {
            this.totalLength = max;
            SFTPRepository.this.fireTransferStarted(max);
        }

        public void end() {
            SFTPRepository.this.fireTransferCompleted(this.totalLength);
        }

        public boolean count(long count2) {
            SFTPRepository.this.fireTransferProgress(count2);
            return true;
        }
    }
}

