/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.settings.TimeoutConstraint;
import org.apache.ivy.util.url.URLHandler;

public abstract class AbstractURLHandler
implements URLHandler {
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("%25([0-9a-fA-F][0-9a-fA-F])");
    private static int requestMethod = 2;

    @Override
    public boolean isReachable(URL url2) {
        return this.getURLInfo(url2).isReachable();
    }

    @Override
    public boolean isReachable(URL url2, int timeout) {
        return this.getURLInfo(url2, timeout).isReachable();
    }

    @Override
    public long getContentLength(URL url2) {
        return this.getURLInfo(url2).getContentLength();
    }

    @Override
    public long getContentLength(URL url2, int timeout) {
        return this.getURLInfo(url2, timeout).getContentLength();
    }

    @Override
    public long getLastModified(URL url2) {
        return this.getURLInfo(url2).getLastModified();
    }

    @Override
    public long getLastModified(URL url2, int timeout) {
        return this.getURLInfo(url2, timeout).getLastModified();
    }

    protected String getUserAgent() {
        return System.getProperty("http.agent", "Apache Ivy/" + Ivy.getIvyVersion());
    }

    protected void validatePutStatusCode(URL dest, int statusCode, String statusMessage) throws IOException {
        switch (statusCode) {
            case 200: 
            case 201: 
            case 202: 
            case 204: {
                break;
            }
            case 401: 
            case 403: {
                throw new IOException("Access to URL " + dest + " was refused by the server" + (statusMessage == null ? "" : ": " + statusMessage));
            }
            default: {
                throw new IOException("PUT operation to URL " + dest + " failed with status code " + statusCode + (statusMessage == null ? "" : ": " + statusMessage));
            }
        }
    }

    @Override
    public void setRequestMethod(int requestMethod) {
        AbstractURLHandler.requestMethod = requestMethod;
    }

    public int getRequestMethod() {
        return requestMethod;
    }

    protected String normalizeToString(URL url2) throws IOException {
        if (!"http".equals(url2.getProtocol()) && !"https".equals(url2.getProtocol())) {
            return url2.toExternalForm();
        }
        try {
            URI uri = new URI(url2.getProtocol(), url2.getAuthority(), url2.getPath(), url2.getQuery(), url2.getRef());
            String uriString = uri.normalize().toASCIIString();
            uriString = uriString.replaceAll("\\+", "%2B");
            return ESCAPE_PATTERN.matcher(uriString).replaceAll("%$1");
        }
        catch (URISyntaxException e) {
            MalformedURLException ioe = new MalformedURLException("Couldn't convert '" + url2.toString() + "' to a valid URI");
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected URL normalizeToURL(URL url2) throws IOException {
        if (!"http".equals(url2.getProtocol()) && !"https".equals(url2.getProtocol())) {
            return url2;
        }
        return new URL(this.normalizeToString(url2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getDecodingInputStream(String encoding, InputStream in) throws IOException {
        if (encoding == null) {
            return in;
        }
        InputStream result2 = null;
        switch (encoding) {
            case "deflate": {
                BufferedInputStream bStream = new BufferedInputStream(in);
                bStream.mark(100);
                byte[] bytes = new byte[100];
                int nbBytes = bStream.read(bytes);
                bStream.reset();
                Inflater inflater = new Inflater();
                inflater.setInput(bytes, 0, nbBytes);
                try {
                    inflater.inflate(new byte[1000]);
                    result2 = new InflaterInputStream(bStream);
                    break;
                }
                catch (DataFormatException e) {
                    result2 = new InflaterInputStream(bStream, new Inflater(true));
                    break;
                }
                finally {
                    inflater.end();
                }
            }
            case "gzip": 
            case "x-gzip": {
                result2 = new GZIPInputStream(in);
                break;
            }
            default: {
                result2 = in;
            }
        }
        return result2;
    }

    protected static TimeoutConstraint createTimeoutConstraints(final int connectionTimeout) {
        return new TimeoutConstraint(){

            @Override
            public int getConnectionTimeout() {
                return connectionTimeout;
            }

            @Override
            public int getReadTimeout() {
                return -1;
            }
        };
    }
}

