/*
 * Decompiled with CFR 0.152.
 */
package platform.common;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\f\u001a$\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u001a0\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0002\u001a \u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0011H\u0002\u001a.\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u001a(\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0011H\u0002\u001a \u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0002\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001d"}, d2={"naturalComparator", "Ljava/util/Comparator;", "", "getNaturalComparator", "()Ljava/util/Comparator;", "compare", "", "s1", "s2", "ignoreCase", "", "compareCharRange", "offset1", "offset2", "end1", "compareChars", "ch1", "", "ch2", "isDecimalDigit", "c", "naturalCompare", "length1", "length2", "skipChar", "s", "start", "end", "skipDigits", "platform-common"})
public final class NaturalComparatorKt {
    @NotNull
    private static final Comparator<String> naturalComparator = NaturalComparatorKt::naturalComparator$lambda$0;

    @NotNull
    public static final Comparator<String> getNaturalComparator() {
        return naturalComparator;
    }

    public static final int naturalCompare(@NotNull String s1, @NotNull String s2, int length1, int length2, boolean ignoreCase) {
        int j;
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        int i = 0;
        for (j = 0; i < length1 && j < length2; ++i, ++j) {
            char ch1 = s1.charAt(i);
            char ch2 = s2.charAt(j);
            if ((NaturalComparatorKt.isDecimalDigit(ch1) || ch1 == ' ') && (NaturalComparatorKt.isDecimalDigit(ch2) || ch2 == ' ')) {
                int end2;
                int start1 = NaturalComparatorKt.skipChar(s1, NaturalComparatorKt.skipChar(s1, i, length1, ' '), length1, '0');
                int start2 = NaturalComparatorKt.skipChar(s2, NaturalComparatorKt.skipChar(s2, j, length2, ' '), length2, '0');
                int end1 = NaturalComparatorKt.skipDigits(s1, start1, length1);
                int lengthDiff = end1 - start1 - ((end2 = NaturalComparatorKt.skipDigits(s2, start2, length2)) - start2);
                if (lengthDiff != 0) {
                    return lengthDiff;
                }
                int numberDiff = NaturalComparatorKt.compareCharRange(s1, s2, start1, start2, end1);
                if (numberDiff != 0) {
                    return numberDiff;
                }
                int fullLengthDiff = end1 - i - (end2 - j);
                if (fullLengthDiff != 0) {
                    return fullLengthDiff;
                }
                int leadingDiff = NaturalComparatorKt.compareCharRange(s1, s2, i, j, start1);
                if (leadingDiff != 0) {
                    return leadingDiff;
                }
                i = end1 - 1;
                j = end2 - 1;
                continue;
            }
            int diff = NaturalComparatorKt.compareChars(ch1, ch2, ignoreCase);
            if (diff == 0) continue;
            return diff;
        }
        if (i < length1) {
            return 1;
        }
        if (j < length2) {
            return -1;
        }
        if (length1 != length2) {
            return length1 - length2;
        }
        return ignoreCase ? NaturalComparatorKt.naturalCompare(s1, s2, length1, length2, false) : 0;
    }

    private static final int compareCharRange(String s1, String s2, int offset1, int offset2, int end1) {
        int i = offset1;
        int j = offset2;
        while (i < end1) {
            int diff = s1.charAt(i) - s2.charAt(j);
            if (diff != 0) {
                return diff;
            }
            ++i;
            ++j;
        }
        return 0;
    }

    private static final int compareChars(char ch1, char ch2, boolean ignoreCase) {
        if (ch1 == ' ' && Intrinsics.compare((int)ch2, (int)32) > 0 && Intrinsics.compare((int)ch2, (int)48) < 0) {
            return 1;
        }
        return ch2 == ' ' && Intrinsics.compare((int)ch1, (int)32) > 0 && Intrinsics.compare((int)ch1, (int)48) < 0 ? -1 : NaturalComparatorKt.compare(String.valueOf(ch1), String.valueOf(ch2), ignoreCase);
    }

    private static final int skipDigits(String s, int start2, int end) {
        int start3;
        for (start3 = start2; start3 < end && NaturalComparatorKt.isDecimalDigit(s.charAt(start3)); ++start3) {
        }
        return start3;
    }

    private static final int skipChar(String s, int start2, int end, char c) {
        int start3;
        for (start3 = start2; start3 < end && s.charAt(start3) == c; ++start3) {
        }
        return start3;
    }

    private static final boolean isDecimalDigit(char c) {
        return '0' <= c ? c < ':' : false;
    }

    private static final int compare(String s1, String s2, boolean ignoreCase) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return ignoreCase ? StringsKt.compareTo((String)s1, (String)s2, (boolean)true) : s1.compareTo(s2);
    }

    private static final int naturalComparator$lambda$0(String s1, String s2) {
        Intrinsics.checkNotNullExpressionValue((Object)s1, (String)"s1");
        Intrinsics.checkNotNullExpressionValue((Object)s2, (String)"s2");
        return NaturalComparatorKt.naturalCompare(s1, s2, s1.length(), s2.length(), true);
    }
}

