/*
 * Decompiled with CFR 0.152.
 */
package runtime.net;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import libraries.collections.MultiMap;
import libraries.collections.MultiMapKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.net.EncodingKt;
import runtime.net.Uri;
import runtime.net.UriKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\nJ\u001f\u0010\u000b\u001a\u00020\u00072\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\r\"\u00020\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007J\u0014\u0010\u000b\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0007J\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00152\u0006\u0010\u0016\u001a\u00020\u0007J\u000e\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lruntime/net/Uri;", "", "()V", "FRAGMENT_SEPARATOR", "", "QUERY_SEPARATOR", "buildUrl", "", "path", "queryParameters", "", "combineUrls", "urls", "", "([Ljava/lang/String;)Ljava/lang/String;", "baseUrl", "toAdd", "", "extractQuery", "uriString", "parseQuery", "Llibraries/collections/MultiMap;", "query", "stripQuery", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nUri.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uri.kt\nruntime/net/Uri\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,78:1\n1295#2,2:79\n*S KotlinDebug\n*F\n+ 1 Uri.kt\nruntime/net/Uri\n*L\n35#1:79,2\n*E\n"})
public final class Uri {
    @NotNull
    public static final Uri INSTANCE = new Uri();
    private static final char FRAGMENT_SEPARATOR = '#';
    private static final char QUERY_SEPARATOR = '?';

    private Uri() {
    }

    @NotNull
    public final String buildUrl(@NotNull String path2, @NotNull Map<String, String> queryParameters) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(queryParameters, (String)"queryParameters");
        String query2 = SequencesKt.joinToString$default((Sequence)SequencesKt.mapNotNull((Sequence)MapsKt.asSequence(queryParameters), (Function1)buildUrl.query.1.INSTANCE), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        return ((CharSequence)query2).length() > 0 ? (StringsKt.contains$default((CharSequence)query2, (char)'?', (boolean)false, (int)2, null) ? path2 + "&" + query2 : path2 + "?" + query2) : path2;
    }

    @NotNull
    public final MultiMap<String, String> parseQuery(@NotNull String query2) {
        MultiMap multiMap;
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        MultiMap $this$parseQuery_u24lambda_u241 = multiMap = MultiMapKt.linkedMultiMap$default(null, 1, null);
        boolean bl = false;
        char[] cArray = new char[]{'&'};
        Sequence $this$forEach$iv = StringsKt.splitToSequence$default((CharSequence)query2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            String name2 = EncodingKt.urlDecode(StringsKt.substringBefore$default((String)it, (String)"=", null, (int)2, null));
            String value2 = EncodingKt.urlDecode(StringsKt.substringAfter((String)it, (String)"=", (String)""));
            $this$parseQuery_u24lambda_u241.put(name2, value2);
        }
        return multiMap;
    }

    @Nullable
    public final String extractQuery(@NotNull String uriString) {
        Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
        Pair prefixFragment = UriKt.access$splitOnLast(uriString, '#');
        Pair prefixQuery = UriKt.access$splitOnLast((String)prefixFragment.getFirst(), '?');
        return (String)prefixQuery.getSecond();
    }

    @NotNull
    public final String stripQuery(@NotNull String uriString) {
        Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
        return StringsKt.substringBefore$default((String)uriString, (char)'?', null, (int)2, null);
    }

    @NotNull
    public final String combineUrls(@NotNull String baseUrl, @NotNull String toAdd) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)toAdd, (String)"toAdd");
        CharSequence charSequence = baseUrl;
        Regex regex2 = new Regex("/+$");
        String string2 = "";
        String string3 = regex2.replace(charSequence, string2);
        charSequence = toAdd;
        regex2 = new Regex("^/+");
        string2 = "";
        return string3 + "/" + regex2.replace(charSequence, string2);
    }

    @NotNull
    public final String combineUrls(String ... urls) {
        Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
        return this.combineUrls(ArraysKt.toList((Object[])urls));
    }

    @NotNull
    public final String combineUrls(@NotNull List<String> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        if (urls.size() == 0) {
            throw new Error("urls must not be empty");
        }
        String base = urls.get(0);
        int n = urls.size();
        for (int i = 1; i < n; ++i) {
            base = this.combineUrls(base, urls.get(i));
        }
        return base;
    }
}

