/*
 * Decompiled with CFR 0.152.
 */
package runtime.ui;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.ui.GroupId;
import runtime.ui.TocGroup;
import runtime.ui.TocNode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J.\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\u000e0\r\"\u0004\b\u0000\u0010\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\u000e0\rH\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0011"}, d2={"Lruntime/ui/DirectoryGroupId;", "Lruntime/ui/GroupId;", "name", "", "fullPath", "repositoryName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFullPath", "()Ljava/lang/String;", "key", "getKey", "getRepositoryName", "build", "", "Lruntime/ui/TocNode;", "T", "children", "platform-ui"})
public final class DirectoryGroupId
extends GroupId {
    @NotNull
    private final String fullPath;
    @Nullable
    private final String repositoryName;
    @NotNull
    private final String key;

    public DirectoryGroupId(@NotNull String name2, @NotNull String fullPath, @Nullable String repositoryName) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        super(name2);
        this.fullPath = fullPath;
        this.repositoryName = repositoryName;
        String string2 = this.repositoryName;
        if (string2 == null) {
            string2 = "";
        }
        this.key = string2 + ":" + this.fullPath;
    }

    @NotNull
    public final String getFullPath() {
        return this.fullPath;
    }

    @Nullable
    public final String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    @NotNull
    public <T> List<TocNode<T>> build(@NotNull List<? extends TocNode<T>> children2) {
        TocGroup child;
        Intrinsics.checkNotNullParameter(children2, (String)"children");
        Object object = CollectionsKt.singleOrNull(children2);
        TocGroup tocGroup = child = object instanceof TocGroup ? (TocGroup)object : null;
        if (child != null && child.getId() instanceof DirectoryGroupId) {
            return CollectionsKt.listOf(new TocGroup(new DirectoryGroupId(this.getName() + "/" + child.getId().getName(), this.fullPath + "/" + ((DirectoryGroupId)child.getId()).fullPath, this.repositoryName), child.getChildren()));
        }
        return CollectionsKt.listOf(new TocGroup(this, children2));
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }
}

