/*
 * Decompiled with CFR 0.152.
 */
package runtime.x;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.MutableProperty;
import runtime.reactive.PropertyKt;
import runtime.text.TextRange;
import runtime.text.TextRangeKt;
import runtime.x.SelectionVM;
import runtime.x.XTextModel;
import runtime.x.primitives.FocusKt;
import runtime.x.primitives.FocusVM;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u000fH\u0002J\b\u0010#\u001a\u00020 H\u0016J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020\u0003H\u0016J \u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010*\u001a\u00020 H\u0016J\b\u0010+\u001a\u00020%H\u0016J\u0010\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020\u001eH\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006."}, d2={"Lruntime/x/XTextModelImpl;", "Lruntime/x/XTextModel;", "initialText", "", "(Ljava/lang/String;)V", "textState", "Lruntime/reactive/MutableProperty;", "focusVM", "Lruntime/x/primitives/FocusVM;", "(Lruntime/reactive/MutableProperty;Lruntime/x/primitives/FocusVM;)V", "getFocusVM", "()Lruntime/x/primitives/FocusVM;", "setFocusVM", "(Lruntime/x/primitives/FocusVM;)V", "lastIdx", "", "getLastIdx", "()I", "selectedText", "getSelectedText", "()Ljava/lang/String;", "selectionVM", "Lruntime/x/SelectionVM;", "getSelectionVM", "()Lruntime/x/SelectionVM;", "setSelectionVM", "(Lruntime/x/SelectionVM;)V", "getTextState", "()Lruntime/reactive/MutableProperty;", "getSelectionRange", "Lruntime/text/TextRange;", "isSelectionAtEndOfContent", "", "isSelectionAtPoint", "value", "isSelectionAtStartOfContent", "moveCaretToEnd", "", "replaceAll", "result", "replaceRange", "selectionToReplace", "selectAfterReplaced", "selectEntireText", "setSelectionRange", "range", "platform-ui"})
public final class XTextModelImpl
implements XTextModel {
    @NotNull
    private final MutableProperty<String> textState;
    @NotNull
    private FocusVM focusVM;
    @NotNull
    private SelectionVM selectionVM;

    public XTextModelImpl(@NotNull MutableProperty<String> textState, @NotNull FocusVM focusVM) {
        Intrinsics.checkNotNullParameter(textState, (String)"textState");
        Intrinsics.checkNotNullParameter((Object)focusVM, (String)"focusVM");
        this.textState = textState;
        this.focusVM = focusVM;
        this.selectionVM = new SelectionVM();
    }

    public /* synthetic */ XTextModelImpl(MutableProperty mutableProperty2, FocusVM focusVM, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            focusVM = FocusKt.focusVM();
        }
        this(mutableProperty2, focusVM);
    }

    @Override
    @NotNull
    public MutableProperty<String> getTextState() {
        return this.textState;
    }

    @Override
    @NotNull
    public FocusVM getFocusVM() {
        return this.focusVM;
    }

    @Override
    public void setFocusVM(@NotNull FocusVM focusVM) {
        Intrinsics.checkNotNullParameter((Object)focusVM, (String)"<set-?>");
        this.focusVM = focusVM;
    }

    public XTextModelImpl(@NotNull String initialText) {
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        this(PropertyKt.mutableProperty(initialText), null, 2, null);
    }

    public /* synthetic */ XTextModelImpl(String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string2 = "";
        }
        this(string2);
    }

    @Override
    @NotNull
    public SelectionVM getSelectionVM() {
        return this.selectionVM;
    }

    @Override
    public void setSelectionVM(@NotNull SelectionVM selectionVM) {
        Intrinsics.checkNotNullParameter((Object)selectionVM, (String)"<set-?>");
        this.selectionVM = selectionVM;
    }

    @Override
    @NotNull
    public String getSelectedText() {
        String string2 = this.getTextState().getValue().substring(((TextRange)this.getSelectionVM().getSelection().getValue()).getStart(), TextRangeKt.getEnd((TextRange)this.getSelectionVM().getSelection().getValue()));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string2;
    }

    private final int getLastIdx() {
        return this.getTextState().getValue().length();
    }

    @Override
    @NotNull
    public TextRange getSelectionRange() {
        return (TextRange)this.getSelectionVM().getSelection().getValue();
    }

    @Override
    public void setSelectionRange(@NotNull TextRange range3) {
        Intrinsics.checkNotNullParameter((Object)range3, (String)"range");
        this.getSelectionVM().setSelection(range3);
    }

    @Override
    public void replaceAll(@NotNull String result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.getTextState().setValue(result2);
    }

    @Override
    public void replaceRange(@NotNull TextRange selectionToReplace, @NotNull String result2, boolean selectAfterReplaced) {
        Intrinsics.checkNotNullParameter((Object)selectionToReplace, (String)"selectionToReplace");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        String text2 = this.getTextState().getValue();
        String string2 = text2.substring(0, selectionToReplace.getStart());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String prefix = string2 + result2;
        String string3 = text2.substring(TextRangeKt.getEnd(selectionToReplace));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        String newText2 = prefix + string3;
        this.replaceAll(newText2);
        if (selectAfterReplaced) {
            this.getSelectionVM().setSelection(TextRangeKt.rangeBetween(prefix.length(), prefix.length()));
        }
    }

    private final boolean isSelectionAtPoint(int value2) {
        return Intrinsics.areEqual((Object)this.getSelectionRange(), (Object)TextRangeKt.rangeBetween(value2, value2));
    }

    @Override
    public boolean isSelectionAtStartOfContent() {
        return this.isSelectionAtPoint(0);
    }

    @Override
    public boolean isSelectionAtEndOfContent() {
        return this.isSelectionAtPoint(this.getLastIdx());
    }

    @Override
    public void moveCaretToEnd() {
        this.setSelectionRange(TextRangeKt.rangeBetween(this.getLastIdx(), this.getLastIdx()));
    }

    @Override
    public void selectEntireText() {
        this.setSelectionRange(TextRangeKt.rangeBetween(0, this.getLastIdx()));
    }
}

