/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.io.HttpRequests;
import git4idea.config.ErrorNotifier;
import git4idea.config.GitDownloadAndInstallKt;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitInstaller;
import git4idea.config.MacExecutableProblemHandler;
import git4idea.config.NotificationErrorNotifier;
import git4idea.config.WindowsExecutableProblemHandler;
import git4idea.i18n.GitBundle;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tukaani.xz.XZInputStream;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u001a(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\b\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016H\u0002\u001a&\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\u0019H\u0000\u001a\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0014H\u0002\u001a\u0018\u0010\u001f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0010H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "feedUrl", "", "downloadAndInstallGit", "", "project", "Lcom/intellij/openapi/project/Project;", "onSuccess", "Lkotlin/Function0;", "downloadGit", "", "installer", "Lgit4idea/config/GitInstaller;", "fileToSave", "Ljava/io/File;", "errorNotifier", "Lgit4idea/config/ErrorNotifier;", "downloadGitJson", "", "downloadListOfGitInstallers", "", "fetchInstaller", "condition", "Lkotlin/Function1;", "parse", "node", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "readTree", "rawData", "verifyHashCode", "downloadedFile", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitDownloadAndInstall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitDownloadAndInstall.kt\ngit4idea/config/GitDownloadAndInstallKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n800#2,11:136\n*S KotlinDebug\n*F\n+ 1 GitDownloadAndInstall.kt\ngit4idea/config/GitDownloadAndInstallKt\n*L\n96#1:136,11\n*E\n"})
public final class GitDownloadAndInstallKt {
    @NotNull
    private static final String feedUrl = "https://download.jetbrains.com/jdk/feed/v1/gits.json.xz";
    @NotNull
    private static final Logger LOG;

    public static final void downloadAndInstallGit(@NotNull Project project, @NotNull Function0<Unit> onSuccess2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(onSuccess2, (String)"onSuccess");
        NotificationErrorNotifier errorNotifier = new NotificationErrorNotifier(project);
        if (SystemInfo.isWindows) {
            new WindowsExecutableProblemHandler(project).downloadAndInstall$intellij_vcs_git(errorNotifier, onSuccess2);
        } else if (SystemInfo.isMac) {
            new MacExecutableProblemHandler(project).downloadAndInstall$intellij_vcs_git(errorNotifier, onSuccess2);
        }
    }

    public static /* synthetic */ void downloadAndInstallGit$default(Project project, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = downloadAndInstallGit.1.INSTANCE;
        }
        GitDownloadAndInstallKt.downloadAndInstallGit(project, (Function0<Unit>)function0);
    }

    @Nullable
    public static final GitInstaller fetchInstaller(@NotNull ErrorNotifier errorNotifier, @NotNull Function1<? super GitInstaller, Boolean> condition) {
        Object v1;
        List<GitInstaller> installers;
        block4: {
            List<GitInstaller> list2;
            Intrinsics.checkNotNullParameter((Object)errorNotifier, (String)"errorNotifier");
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            try {
                list2 = GitDownloadAndInstallKt.downloadListOfGitInstallers();
            }
            catch (Throwable t) {
                LOG.warn(t);
                String string = GitBundle.message("install.general.error", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"install.general.error\")");
                errorNotifier.showError(string);
                return null;
            }
            installers = list2;
            Iterable iterable = installers;
            for (Object t : iterable) {
                if (!((Boolean)condition.invoke(t)).booleanValue()) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        GitInstaller matchingInstaller = v1;
        if (matchingInstaller != null) {
            return matchingInstaller;
        }
        LOG.warn("Couldn't find installer among " + installers);
        String string = GitBundle.message("install.general.error", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"install.general.error\")");
        errorNotifier.showError(string);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<GitInstaller> downloadListOfGitInstallers() {
        List<GitInstaller> list2;
        byte[] compressedJson = GitDownloadAndInstallKt.downloadGitJson();
        try {
            byte[] byArray;
            list2 = new ByteArrayInputStream(compressedJson);
            Throwable throwable = null;
            try {
                byte[] byArray2;
                ByteArrayInputStream input = (ByteArrayInputStream)((Object)list2);
                boolean bl = false;
                Closeable closeable = (Closeable)new XZInputStream((InputStream)input);
                Throwable throwable2 = null;
                try {
                    XZInputStream it = (XZInputStream)closeable;
                    boolean bl2 = false;
                    byArray2 = ByteStreamsKt.readBytes((InputStream)((InputStream)it));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                byArray = byArray2;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)((Object)list2), (Throwable)throwable);
            }
            list2 = (List<GitInstaller>)byArray;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to unpack the list of available Gits from https://download.jetbrains.com/jdk/feed/v1/gits.json.xz. " + t.getMessage(), t);
        }
        List<GitInstaller> jsonBytes = list2;
        try {
            list2 = GitDownloadAndInstallKt.parse(GitDownloadAndInstallKt.readTree((byte[])jsonBytes));
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to parse the downloaded list of available Gits. " + t.getMessage(), t);
        }
        return list2;
    }

    private static final byte[] downloadGitJson() {
        byte[] byArray = HttpRequests.request((String)feedUrl).productNameAsUserAgent().readBytes(ProgressManager.getInstance().getProgressIndicator());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"request(feedUrl)\n    .pr\u2026ance().progressIndicator)");
        return byArray;
    }

    private static final ObjectNode readTree(byte[] rawData) {
        JsonNode jsonNode = new ObjectMapper().readTree(rawData);
        ObjectNode objectNode = jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
        if (objectNode == null) {
            throw new IllegalStateException("Unexpected JSON data".toString());
        }
        return objectNode;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<GitInstaller> parse(ObjectNode node) {
        void $this$filterIsInstanceTo$iv$iv;
        JsonNode jsonNode = node.get("gits");
        ArrayNode arrayNode = jsonNode instanceof ArrayNode ? (ArrayNode)jsonNode : null;
        if (arrayNode == null) {
            throw new IllegalStateException("`gits` element is missing in JSON".toString());
        }
        ArrayNode items = arrayNode;
        List result2 = new ArrayList();
        Iterable $this$filterIsInstance$iv = (Iterable)items;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ObjectNode)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (ObjectNode item : (List)destination$iv$iv) {
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            JsonNode jsonNode2 = item.get("os");
            if ((jsonNode2 != null ? jsonNode2.asText() : null) == null) continue;
            JsonNode jsonNode3 = item.get("arch");
            if ((jsonNode3 != null ? jsonNode3.asText() : null) == null) continue;
            JsonNode jsonNode4 = item.get("version");
            if ((jsonNode4 != null ? jsonNode4.asText() : null) == null) continue;
            JsonNode jsonNode5 = item.get("url");
            if ((jsonNode5 != null ? jsonNode5.asText() : null) == null) continue;
            JsonNode jsonNode6 = item.get("fileName");
            if ((jsonNode6 != null ? jsonNode6.asText() : null) == null) continue;
            JsonNode jsonNode7 = item.get("pkgFileName");
            JsonNode jsonNode8 = item.get("sha256");
            if ((jsonNode8 != null ? jsonNode8.asText() : null) == null) continue;
            string6 = string6;
            String string7 = jsonNode7 != null ? jsonNode7.asText() : null;
            string5 = string5;
            string4 = string4;
            string3 = string3;
            string2 = string2;
            string = string;
            result2.add(new GitInstaller(string, string2, string3, string4, string5, string7, string6));
        }
        return result2;
    }

    public static final boolean downloadGit(@NotNull GitInstaller installer2, @NotNull File fileToSave, @NotNull Project project, @NotNull ErrorNotifier errorNotifier) {
        Intrinsics.checkNotNullParameter((Object)installer2, (String)"installer");
        Intrinsics.checkNotNullParameter((Object)fileToSave, (String)"fileToSave");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)errorNotifier, (String)"errorNotifier");
        try {
            HttpRequests.request((String)installer2.getUrl()).productNameAsUserAgent().saveToFile(fileToSave, ProgressManager.getInstance().getProgressIndicator());
            GitDownloadAndInstallKt.verifyHashCode(installer2, fileToSave);
            return true;
        }
        catch (Exception e) {
            LOG.warn("Couldn't download " + installer2.getFileName() + " from " + installer2.getUrl(), (Throwable)e);
            String string = GitBundle.message("install.general.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"install.general.error\")");
            errorNotifier.showError(string, GitExecutableProblemHandlersKt.getLinkToConfigure(project));
            return false;
        }
    }

    private static final void verifyHashCode(GitInstaller installer2, File downloadedFile) {
        String string = Files.asByteSource((File)downloadedFile).hash(Hashing.sha256()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asByteSource(downloadedF\u2026hing.sha256()).toString()");
        String actualHashCode = string;
        if (!StringsKt.equals((String)actualHashCode, (String)installer2.getSha256(), (boolean)true)) {
            throw new IllegalStateException("SHA-256 checksums does not match. Actual value is " + actualHashCode + ", expected " + installer2.getSha256());
        }
    }

    static {
        Logger logger = Logger.getInstance((String)"#git4idea.config.GitDownloadAndInstall");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(\"#git4idea.c\u2026g.GitDownloadAndInstall\")");
        LOG = logger;
    }
}

