/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.repo.Repository;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.util.VcsLogUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationListener;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.config.GitVcsSettings;
import git4idea.config.UpdateMethod;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.merge.MergeChangeCollector;
import git4idea.push.GitPushNativeResult;
import git4idea.push.GitPushNativeResultParser;
import git4idea.push.GitPushParams;
import git4idea.push.GitPushParamsImpl;
import git4idea.push.GitPushRepoResult;
import git4idea.push.GitPushResult;
import git4idea.push.GitPushSource;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTagMode;
import git4idea.push.GitPushTarget;
import git4idea.push.GitRejectedPushUpdateDialog;
import git4idea.push.GroupedPushResult;
import git4idea.push.PushUpdateSettings;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitRebaseOverMergeProblem;
import git4idea.update.GitUpdateProcess;
import git4idea.update.GitUpdateResult;
import git4idea.update.GitUpdater;
import git4idea.update.HashRange;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushOperation {
    private static final Logger LOG = Logger.getInstance(GitPushOperation.class);
    private static final int MAX_PUSH_ATTEMPTS = 10;
    private final Project myProject;
    @NotNull
    private final GitPushSupport myPushSupport;
    private final Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> myPushSpecs;
    @Nullable
    private final GitPushTagMode myTagMode;
    private final ForceMode myForceMode;
    private final boolean mySkipHook;
    private final Git myGit;
    private final ProgressIndicator myProgressIndicator;
    private final GitVcsSettings mySettings;
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final Map<GitRepository, HashRange> myUpdatedRanges;

    public GitPushOperation(@NotNull Project project, @NotNull GitPushSupport pushSupport, @NotNull Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> pushSpecs, @Nullable GitPushTagMode tagMode, boolean force, boolean skipHook) {
        if (project == null) {
            GitPushOperation.$$$reportNull$$$0(0);
        }
        if (pushSupport == null) {
            GitPushOperation.$$$reportNull$$$0(1);
        }
        if (pushSpecs == null) {
            GitPushOperation.$$$reportNull$$$0(2);
        }
        this(project, pushSupport, pushSpecs, tagMode, GitPushOperation.getForceMode(force), skipHook);
    }

    @NotNull
    private static ForceMode getForceMode(boolean force) {
        if (force) {
            ForceMode forceMode = AdvancedSettings.getBoolean((String)"git.use.push.force.with.lease") ? ForceMode.FORCE_WITH_LEASE : ForceMode.FORCE;
            if (forceMode == null) {
                GitPushOperation.$$$reportNull$$$0(3);
            }
            return forceMode;
        }
        ForceMode forceMode = ForceMode.NONE;
        if (forceMode == null) {
            GitPushOperation.$$$reportNull$$$0(4);
        }
        return forceMode;
    }

    public GitPushOperation(@NotNull Project project, @NotNull GitPushSupport pushSupport, @NotNull Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>> pushSpecs, @Nullable GitPushTagMode tagMode, @NotNull ForceMode forceMode, boolean skipHook) {
        if (project == null) {
            GitPushOperation.$$$reportNull$$$0(5);
        }
        if (pushSupport == null) {
            GitPushOperation.$$$reportNull$$$0(6);
        }
        if (pushSpecs == null) {
            GitPushOperation.$$$reportNull$$$0(7);
        }
        if (forceMode == null) {
            GitPushOperation.$$$reportNull$$$0(8);
        }
        this.myUpdatedRanges = new LinkedHashMap<GitRepository, HashRange>();
        this.myProject = project;
        this.myPushSupport = pushSupport;
        this.myPushSpecs = pushSpecs;
        this.myTagMode = tagMode;
        this.myForceMode = forceMode;
        this.mySkipHook = skipHook;
        this.myGit = Git.getInstance();
        this.myProgressIndicator = (ProgressIndicator)ObjectUtils.notNull((Object)ProgressManager.getInstance().getProgressIndicator(), (Object)new EmptyProgressIndicator());
        this.mySettings = GitVcsSettings.getInstance(this.myProject);
        this.myRepositoryManager = GitRepositoryManager.getInstance(this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public GitPushResult execute() {
        PushUpdateSettings updateSettings = this.readPushUpdateSettings();
        Label beforePushLabel = null;
        Label afterPushLabel = null;
        Map<GitRepository, String> preUpdatePositions = this.updateRootInfoAndRememberPositions();
        Boolean rebaseOverMergeProblemDetected = null;
        HashMap<GitRepository, GitPushRepoResult> results = new HashMap<GitRepository, GitPushRepoResult>();
        HashMap<GitRepository, GitUpdateResult> updatedRoots = new HashMap<GitRepository, GitUpdateResult>();
        try {
            Collection<GitRepository> remainingRoots = this.myPushSpecs.keySet();
            for (int pushAttempt = 0; pushAttempt < 10 && !remainingRoots.isEmpty(); ++pushAttempt) {
                LOG.debug("Starting push attempt #" + pushAttempt);
                Map<GitRepository, GitPushRepoResult> resultMap = this.push(this.myRepositoryManager.sortByDependency(remainingRoots));
                results.putAll(resultMap);
                GroupedPushResult result2 = GroupedPushResult.group(resultMap);
                if (!result2.errors.isEmpty()) break;
                if (!result2.customRejected.isEmpty()) {
                    break;
                }
                if (!result2.rejected.isEmpty()) {
                    if (this.myForceMode.isForce() || GitPushOperation.pushingToNotTrackedBranch(result2.rejected)) break;
                    if (GitPushOperation.pushingNotCurrentBranch(result2.rejected)) {
                        break;
                    }
                    if (pushAttempt == 0 && !this.mySettings.autoUpdateIfPushRejected()) {
                        rebaseOverMergeProblemDetected = !this.findRootsWithMergeCommits(this.myRepositoryManager.getRepositories()).isEmpty();
                        updateSettings = this.showDialogAndGetExitCode(result2.rejected.keySet(), updateSettings, rebaseOverMergeProblemDetected);
                        if (updateSettings == null) {
                            break;
                        }
                        this.savePushUpdateSettings(updateSettings, rebaseOverMergeProblemDetected);
                    }
                    if (beforePushLabel == null) {
                        beforePushLabel = LocalHistory.getInstance().putSystemLabel(this.myProject, GitBundle.message("push.local.history.system.label.before", new Object[0]));
                    }
                    List<GitRepository> rootsToUpdate = this.myRepositoryManager.getRepositories();
                    LOG.debug("roots to update: " + rootsToUpdate);
                    GitUpdateResult updateResult = this.update(rootsToUpdate, updateSettings.getUpdateMethod(), rebaseOverMergeProblemDetected == null);
                    for (GitRepository repository : rootsToUpdate) {
                        updatedRoots.put(repository, updateResult);
                    }
                    if (!updateResult.isSuccess() || updateResult == GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS) break;
                    if (updateResult == GitUpdateResult.INCOMPLETE) {
                        break;
                    }
                }
                remainingRoots = GitPushOperation.getRejectedAndNotPushed(results);
            }
        }
        finally {
            if (beforePushLabel != null) {
                afterPushLabel = LocalHistory.getInstance().putSystemLabel(this.myProject, GitBundle.message("push.local.history.system.label.after", new Object[0]));
            }
            for (GitRepository repository : this.myPushSpecs.keySet()) {
                repository.update();
            }
        }
        return this.prepareCombinedResult(results, updatedRoots, preUpdatePositions, beforePushLabel, afterPushLabel);
    }

    @NotNull
    private Collection<VirtualFile> findRootsWithMergeCommits(@NotNull Collection<? extends GitRepository> rootsToSearch) {
        if (rootsToSearch == null) {
            GitPushOperation.$$$reportNull$$$0(9);
        }
        List list2 = ContainerUtil.mapNotNull(rootsToSearch, repo -> {
            PushSpec pushSpec = this.myPushSpecs.get(repo);
            if (pushSpec == null) {
                GitPushSource source = this.myPushSupport.getSource((GitRepository)repo);
                GitPushTarget target = this.myPushSupport.getDefaultTarget((GitRepository)repo);
                if (target == null) {
                    return null;
                }
                pushSpec = new PushSpec((PushSource)source, (PushTarget)target);
            }
            String baseRef = ((GitPushTarget)pushSpec.getTarget()).getBranch().getFullName();
            String currentRef = ((GitPushSource)pushSpec.getSource()).getRevision();
            return GitRebaseOverMergeProblem.hasProblem(this.myProject, repo.getRoot(), baseRef, currentRef) ? repo.getRoot() : null;
        });
        if (list2 == null) {
            GitPushOperation.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NotNull
    public GitPushOperation deriveForceWithoutLease(@NotNull List<GitRepository> newRepositories) {
        if (newRepositories == null) {
            GitPushOperation.$$$reportNull$$$0(11);
        }
        Map newPushSpec = ContainerUtil.filter(this.myPushSpecs, repo -> newRepositories.contains(repo));
        return new GitPushOperation(this.myProject, this.myPushSupport, (Map<GitRepository, PushSpec<GitPushSource, GitPushTarget>>)newPushSpec, this.myTagMode, ForceMode.FORCE, this.mySkipHook);
    }

    private static boolean pushingToNotTrackedBranch(@NotNull Map<GitRepository, GitPushRepoResult> rejected) {
        if (rejected == null) {
            GitPushOperation.$$$reportNull$$$0(12);
        }
        boolean pushingToNotTrackedBranch = ContainerUtil.exists(rejected.entrySet(), entry -> {
            GitRepository repository = (GitRepository)entry.getKey();
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            if (currentBranch == null) {
                return true;
            }
            GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository, currentBranch);
            return trackInfo == null || !trackInfo.getRemoteBranch().getFullName().equals(((GitPushRepoResult)entry.getValue()).getTargetBranch());
        });
        LOG.debug("Pushing to not tracked branch condition is [" + pushingToNotTrackedBranch + "]");
        return pushingToNotTrackedBranch;
    }

    private static boolean pushingNotCurrentBranch(@NotNull Map<GitRepository, GitPushRepoResult> rejected) {
        if (rejected == null) {
            GitPushOperation.$$$reportNull$$$0(13);
        }
        boolean pushingNotCurrentBranch = ContainerUtil.exists(rejected.entrySet(), entry -> {
            GitRepository repository = (GitRepository)entry.getKey();
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            String pushedBranch = ((GitPushRepoResult)entry.getValue()).getSourceBranch();
            return currentBranch == null || !StringUtil.equals((CharSequence)currentBranch.getFullName(), (CharSequence)pushedBranch);
        });
        LOG.debug("Pushing non current branch condition is [" + pushingNotCurrentBranch + "]");
        return pushingNotCurrentBranch;
    }

    @NotNull
    private static List<GitRepository> getRejectedAndNotPushed(@NotNull Map<GitRepository, GitPushRepoResult> results) {
        if (results == null) {
            GitPushOperation.$$$reportNull$$$0(14);
        }
        List list2 = ContainerUtil.filter(results.keySet(), repository -> ((GitPushRepoResult)results.get(repository)).getType() == GitPushRepoResult.Type.REJECTED_NO_FF || ((GitPushRepoResult)results.get(repository)).getType() == GitPushRepoResult.Type.NOT_PUSHED);
        if (list2 == null) {
            GitPushOperation.$$$reportNull$$$0(15);
        }
        return list2;
    }

    @NotNull
    private Map<GitRepository, String> updateRootInfoAndRememberPositions() {
        Set<GitRepository> repositories2 = this.myPushSpecs.keySet();
        repositories2.forEach(Repository::update);
        Map map2 = StreamEx.of(repositories2).toMap(Repository::getCurrentRevision);
        if (map2 == null) {
            GitPushOperation.$$$reportNull$$$0(16);
        }
        return map2;
    }

    @NotNull
    private GitPushResult prepareCombinedResult(@NotNull Map<GitRepository, GitPushRepoResult> allRoots, @NotNull Map<GitRepository, GitUpdateResult> updatedRoots, @NotNull Map<GitRepository, String> preUpdatePositions, @Nullable Label beforeUpdateLabel, @Nullable Label afterUpdateLabel) {
        if (allRoots == null) {
            GitPushOperation.$$$reportNull$$$0(17);
        }
        if (updatedRoots == null) {
            GitPushOperation.$$$reportNull$$$0(18);
        }
        if (preUpdatePositions == null) {
            GitPushOperation.$$$reportNull$$$0(19);
        }
        HashMap<GitRepository, GitPushRepoResult> results = new HashMap<GitRepository, GitPushRepoResult>();
        UpdatedFiles updatedFiles = UpdatedFiles.create();
        for (Map.Entry<GitRepository, GitPushRepoResult> entry : allRoots.entrySet()) {
            GitRepository repository = entry.getKey();
            GitPushRepoResult simpleResult = entry.getValue();
            GitUpdateResult updateResult = updatedRoots.get(repository);
            if (updateResult == null) {
                results.put(repository, simpleResult);
                continue;
            }
            this.collectUpdatedFiles(updatedFiles, repository, preUpdatePositions.get(repository));
            results.put(repository, GitPushRepoResult.addUpdateResult(simpleResult, updateResult));
        }
        return new GitPushResult(results, updatedFiles, beforeUpdateLabel, afterUpdateLabel, this.myUpdatedRanges);
    }

    @NotNull
    private Map<GitRepository, GitPushRepoResult> push(@NotNull List<? extends GitRepository> repositories2) {
        PushSpec<GitPushSource, GitPushTarget> spec;
        if (repositories2 == null) {
            GitPushOperation.$$$reportNull$$$0(20);
        }
        LinkedHashMap<GitRepository, GitPushRepoResult> results = new LinkedHashMap<GitRepository, GitPushRepoResult>();
        for (GitRepository gitRepository : repositories2) {
            GitPushRepoResult repoResult;
            spec = this.myPushSpecs.get(gitRepository);
            ResultWithOutput resultWithOutput = this.doPush(gitRepository, spec);
            LOG.debug("Pushed to " + DvcsUtil.getShortRepositoryName((Repository)gitRepository) + ": " + resultWithOutput);
            GitPushSource pushSource = (GitPushSource)spec.getSource();
            GitPushTarget target = (GitPushTarget)spec.getTarget();
            if (resultWithOutput.isError()) {
                repoResult = GitPushRepoResult.error(pushSource, target.getBranch(), resultWithOutput.getErrorAsString());
            } else {
                List<GitPushNativeResult> nativeResults = resultWithOutput.parsedResults;
                GitPushNativeResult sourceResult = GitPushOperation.getPushedBranchOrCommit(nativeResults);
                if (sourceResult == null) {
                    LOG.error("No result for branch or commit among: [" + nativeResults + "]\nFull result: " + resultWithOutput);
                    continue;
                }
                List tagResults = ContainerUtil.filter(nativeResults, result2 -> !result2.equals(sourceResult) && (result2.getType() == GitPushNativeResult.Type.NEW_REF || result2.getType() == GitPushNativeResult.Type.FORCED_UPDATE));
                int commits2 = this.collectNumberOfPushedCommits(gitRepository.getRoot(), sourceResult);
                repoResult = GitPushRepoResult.convertFromNative(sourceResult, tagResults, commits2, pushSource, target.getBranch());
            }
            LOG.debug("Converted result: " + repoResult);
            results.put(gitRepository, repoResult);
        }
        for (GitRepository gitRepository : repositories2) {
            if (results.containsKey(gitRepository)) continue;
            spec = this.myPushSpecs.get(gitRepository);
            results.put(gitRepository, GitPushRepoResult.notPushed((GitPushSource)spec.getSource(), ((GitPushTarget)spec.getTarget()).getBranch()));
        }
        LinkedHashMap<GitRepository, GitPushRepoResult> linkedHashMap = results;
        if (linkedHashMap == null) {
            GitPushOperation.$$$reportNull$$$0(21);
        }
        return linkedHashMap;
    }

    @Nullable
    private static GitPushNativeResult getPushedBranchOrCommit(@NotNull List<? extends GitPushNativeResult> results) {
        if (results == null) {
            GitPushOperation.$$$reportNull$$$0(22);
        }
        return (GitPushNativeResult)ContainerUtil.find(results, result2 -> GitPushOperation.isBranch(result2) || GitPushOperation.isHash(result2) || GitPushOperation.isHeadRelativeReference(result2));
    }

    private static boolean isBranch(@NotNull GitPushNativeResult result2) {
        String sourceRef;
        if (result2 == null) {
            GitPushOperation.$$$reportNull$$$0(23);
        }
        return (sourceRef = result2.getSourceRef()).startsWith("refs/heads/") || VcsLogUtil.HASH_REGEX.matcher(sourceRef).matches();
    }

    private static boolean isHash(@NotNull GitPushNativeResult result2) {
        if (result2 == null) {
            GitPushOperation.$$$reportNull$$$0(24);
        }
        String sourceRef = result2.getSourceRef();
        return VcsLogUtil.HASH_REGEX.matcher(sourceRef).matches();
    }

    private static boolean isHeadRelativeReference(@NotNull GitPushNativeResult result2) {
        if (result2 == null) {
            GitPushOperation.$$$reportNull$$$0(25);
        }
        String sourceRef = result2.getSourceRef();
        return sourceRef.startsWith("HEAD");
    }

    private int collectNumberOfPushedCommits(@NotNull VirtualFile root, @NotNull GitPushNativeResult result2) {
        if (root == null) {
            GitPushOperation.$$$reportNull$$$0(26);
        }
        if (result2 == null) {
            GitPushOperation.$$$reportNull$$$0(27);
        }
        if (result2.getType() != GitPushNativeResult.Type.SUCCESS) {
            return -1;
        }
        String range = result2.getRange();
        if (range == null) {
            LOG.error("Range of pushed commits not reported in " + result2);
            return -1;
        }
        try {
            return GitHistoryUtils.history(this.myProject, root, range).size();
        }
        catch (VcsException e) {
            LOG.error("Couldn't collect commits from range " + range);
            return -1;
        }
    }

    private void collectUpdatedFiles(@NotNull UpdatedFiles updatedFiles, @NotNull GitRepository repository, @NotNull String preUpdatePosition) {
        if (updatedFiles == null) {
            GitPushOperation.$$$reportNull$$$0(28);
        }
        if (repository == null) {
            GitPushOperation.$$$reportNull$$$0(29);
        }
        if (preUpdatePosition == null) {
            GitPushOperation.$$$reportNull$$$0(30);
        }
        try {
            new MergeChangeCollector(this.myProject, repository, new GitRevisionNumber(preUpdatePosition)).collect(updatedFiles);
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    private ResultWithOutput doPush(@NotNull GitRepository repository, @NotNull PushSpec<GitPushSource, GitPushTarget> pushSpec) {
        GitPushParamsImpl params;
        GitCommandResult res;
        if (repository == null) {
            GitPushOperation.$$$reportNull$$$0(31);
        }
        if (pushSpec == null) {
            GitPushOperation.$$$reportNull$$$0(32);
        }
        GitPushSource pushSource = (GitPushSource)pushSpec.getSource();
        GitPushTarget pushTarget = (GitPushTarget)pushSpec.getTarget();
        GitLocalBranch sourceBranch = pushSource.getBranch();
        GitRemoteBranch targetBranch = pushTarget.getBranch();
        GitLineHandlerListener progressListener = GitStandardProgressAnalyzer.createListener(this.myProgressIndicator);
        boolean setUpstream = sourceBranch != null && pushTarget.isNewBranchCreated() && pushSource.isBranchRef() && !GitPushOperation.branchTrackingInfoIsSet(repository, sourceBranch);
        String tagMode = this.myTagMode == null ? null : this.myTagMode.getArgument();
        String spec = GitPushOperation.createPushSpec(pushSource, pushTarget, setUpstream);
        GitRemote remote = targetBranch.getRemote();
        List<GitPushParams.ForceWithLease> forceWithLease = Collections.emptyList();
        if (this.myForceMode == ForceMode.FORCE_WITH_LEASE) {
            Hash hash = repository.getBranches().getHash(targetBranch);
            String expectedHash = hash != null ? hash.asString() : "";
            forceWithLease = Collections.singletonList(new GitPushParamsImpl.ForceWithLeaseReference(targetBranch.getNameForRemoteOperations(), expectedHash));
        }
        if ((res = this.myGit.push(repository, params = new GitPushParamsImpl(remote, spec, this.myForceMode.isForce(), setUpstream, this.mySkipHook, tagMode, forceWithLease), progressListener)).success()) {
            ((GitAuthenticationListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, GitAuthenticationListener.GIT_AUTHENTICATION_SUCCESS)).authenticationSucceeded(repository, remote);
        }
        return new ResultWithOutput(res);
    }

    private static String createPushSpec(@NotNull GitPushSource source, @NotNull GitPushTarget target, boolean setUpstream) {
        if (source == null) {
            GitPushOperation.$$$reportNull$$$0(33);
        }
        if (target == null) {
            GitPushOperation.$$$reportNull$$$0(34);
        }
        boolean needFullRefName = setUpstream || !source.isBranchRef();
        String remoteBranchName = target.getBranch().getNameForRemoteOperations();
        String targetRef = needFullRefName && !remoteBranchName.startsWith("refs/") ? "refs/heads/" + remoteBranchName : remoteBranchName;
        return source.getRevision() + ":" + targetRef;
    }

    private static boolean branchTrackingInfoIsSet(@NotNull GitRepository repository, @NotNull GitLocalBranch source) {
        if (repository == null) {
            GitPushOperation.$$$reportNull$$$0(35);
        }
        if (source == null) {
            GitPushOperation.$$$reportNull$$$0(36);
        }
        return ContainerUtil.exists(repository.getBranchTrackInfos(), info -> info.getLocalBranch().equals(source));
    }

    private void savePushUpdateSettings(@NotNull PushUpdateSettings settings, boolean rebaseOverMergeDetected) {
        if (settings == null) {
            GitPushOperation.$$$reportNull$$$0(37);
        }
        UpdateMethod updateMethod = settings.getUpdateMethod();
        if (!rebaseOverMergeDetected && this.mySettings.getUpdateMethod() != updateMethod && this.mySettings.getUpdateMethod() != UpdateMethod.BRANCH_DEFAULT) {
            this.mySettings.setUpdateMethod(updateMethod);
        }
    }

    @NotNull
    private PushUpdateSettings readPushUpdateSettings() {
        UpdateMethod updateMethod = this.mySettings.getUpdateMethod();
        if (updateMethod == UpdateMethod.BRANCH_DEFAULT) {
            updateMethod = GitUpdater.resolveUpdateMethod(this.myPushSpecs.keySet().iterator().next());
        }
        return new PushUpdateSettings(updateMethod);
    }

    @Nullable
    private PushUpdateSettings showDialogAndGetExitCode(@NotNull Set<? extends GitRepository> repositories2, @NotNull PushUpdateSettings initialSettings, boolean rebaseOverMergeProblemDetected) {
        if (repositories2 == null) {
            GitPushOperation.$$$reportNull$$$0(38);
        }
        if (initialSettings == null) {
            GitPushOperation.$$$reportNull$$$0(39);
        }
        Ref updateSettings = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            GitRejectedPushUpdateDialog dialog2 = new GitRejectedPushUpdateDialog(this.myProject, repositories2, initialSettings, rebaseOverMergeProblemDetected);
            GitRejectedPushUpdateDialog.Companion.PushRejectedExitCode exitCode = dialog2.showAndGet();
            if (!exitCode.equals((Object)GitRejectedPushUpdateDialog.Companion.PushRejectedExitCode.CANCEL)) {
                this.mySettings.setAutoUpdateIfPushRejected(dialog2.getShouldAutoUpdateInFuture());
                updateSettings.set((Object)new PushUpdateSettings(GitPushOperation.convertUpdateMethodFromDialogExitCode(exitCode)));
            }
        });
        return (PushUpdateSettings)updateSettings.get();
    }

    @NotNull
    private static UpdateMethod convertUpdateMethodFromDialogExitCode(GitRejectedPushUpdateDialog.Companion.PushRejectedExitCode exitCode) {
        UpdateMethod updateMethod = switch (exitCode) {
            case GitRejectedPushUpdateDialog.Companion.PushRejectedExitCode.MERGE -> UpdateMethod.MERGE;
            case GitRejectedPushUpdateDialog.Companion.PushRejectedExitCode.REBASE -> UpdateMethod.REBASE;
            default -> throw new IllegalStateException("Unexpected exit code: " + exitCode);
        };
        if (updateMethod == null) {
            GitPushOperation.$$$reportNull$$$0(40);
        }
        return updateMethod;
    }

    @NotNull
    protected GitUpdateResult update(@NotNull Collection<? extends GitRepository> rootsToUpdate, @NotNull UpdateMethod updateMethod, boolean checkForRebaseOverMergeProblem) {
        if (rootsToUpdate == null) {
            GitPushOperation.$$$reportNull$$$0(41);
        }
        if (updateMethod == null) {
            GitPushOperation.$$$reportNull$$$0(42);
        }
        GitUpdateProcess updateProcess = new GitUpdateProcess(this.myProject, this.myProgressIndicator, new HashSet<GitRepository>(rootsToUpdate), UpdatedFiles.create(), null, checkForRebaseOverMergeProblem, false);
        GitUpdateResult updateResult = updateProcess.update(updateMethod);
        Map<GitRepository, HashRange> ranges = updateProcess.getUpdatedRanges();
        if (ranges != null) {
            this.joinUpdatedRanges(ranges);
        }
        for (GitRepository gitRepository : rootsToUpdate) {
            gitRepository.getRoot().refresh(true, true);
            gitRepository.update();
        }
        GitUpdateResult gitUpdateResult = updateResult;
        if (gitUpdateResult == null) {
            GitPushOperation.$$$reportNull$$$0(43);
        }
        return gitUpdateResult;
    }

    private void joinUpdatedRanges(@NotNull Map<GitRepository, HashRange> newRanges) {
        if (newRanges == null) {
            GitPushOperation.$$$reportNull$$$0(44);
        }
        for (GitRepository repository : newRanges.keySet()) {
            HashRange newRange = newRanges.get(repository);
            HashRange current = this.myUpdatedRanges.get(repository);
            HashRange joinedRange = current == null ? newRange : new HashRange(current.getStart(), newRange.getEnd());
            this.myUpdatedRanges.put(repository, joinedRange);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 10, 15, 16, 21, 40, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushSupport";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushSpecs";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 15: 
            case 16: 
            case 21: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/push/GitPushOperation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forceMode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToSearch";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRepositories";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rejected";
                break;
            }
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRoots";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedRoots";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preUpdatePositions";
                break;
            }
            case 20: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedFiles";
                break;
            }
            case 29: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preUpdatePosition";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushSpec";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSettings";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToUpdate";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateMethod";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/push/GitPushOperation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getForceMode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findRootsWithMergeCommits";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRejectedAndNotPushed";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "updateRootInfoAndRememberPositions";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "push";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "convertUpdateMethodFromDialogExitCode";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "update";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 15: 
            case 16: 
            case 21: 
            case 40: 
            case 43: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findRootsWithMergeCommits";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deriveForceWithoutLease";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "pushingToNotTrackedBranch";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "pushingNotCurrentBranch";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRejectedAndNotPushed";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "prepareCombinedResult";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPushedBranchOrCommit";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isBranch";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isHash";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isHeadRelativeReference";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectNumberOfPushedCommits";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "collectUpdatedFiles";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "doPush";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createPushSpec";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "branchTrackingInfoIsSet";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "savePushUpdateSettings";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "showDialogAndGetExitCode";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "joinUpdatedRanges";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 10, 15, 16, 21, 40, 43 -> new IllegalStateException(string);
        };
    }

    static enum ForceMode {
        NONE,
        FORCE,
        FORCE_WITH_LEASE;


        public boolean isForce() {
            return this != NONE;
        }
    }

    private static class ResultWithOutput {
        @NotNull
        private final List<GitPushNativeResult> parsedResults;
        @NotNull
        private final GitCommandResult resultOutput;

        ResultWithOutput(@NotNull GitCommandResult resultOutput) {
            if (resultOutput == null) {
                ResultWithOutput.$$$reportNull$$$0(0);
            }
            this.resultOutput = resultOutput;
            this.parsedResults = GitPushNativeResultParser.parse(resultOutput.getOutput());
        }

        boolean isError() {
            return this.parsedResults.isEmpty();
        }

        @NotNull
        String getErrorAsString() {
            String string = this.resultOutput.getErrorOutputAsJoinedString();
            if (string == null) {
                ResultWithOutput.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String toString() {
            return "Parsed results: " + this.parsedResults + "\nCommand output:" + this.resultOutput;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultOutput";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/push/GitPushOperation$ResultWithOutput";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/push/GitPushOperation$ResultWithOutput";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorAsString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

