/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.utils;

import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeResolutionListener;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.ExceptionUtils;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.server.LongRunningTask;
import org.jetbrains.idea.maven.server.Maven3AetherModelConverter;
import org.jetbrains.idea.maven.server.Maven3ImporterSpy;
import org.jetbrains.idea.maven.server.Maven3ModelConverter;
import org.jetbrains.idea.maven.server.Maven3ServerConsoleLogger;
import org.jetbrains.idea.maven.server.Maven3ServerEmbedder;
import org.jetbrains.idea.maven.server.Maven3TransferListenerAdapter;
import org.jetbrains.idea.maven.server.Maven3WorkspaceMapReader;
import org.jetbrains.idea.maven.server.Maven3WorkspaceReader;
import org.jetbrains.idea.maven.server.Maven3XProfileUtil;
import org.jetbrains.idea.maven.server.Maven3XServerEmbedder;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicator;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicatorImpl;
import org.jetbrains.idea.maven.server.MavenServerExecutionResult;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.server.ParallelRunner;
import org.jetbrains.idea.maven.server.RemoteNativeMaven3ProjectHolder;
import org.jetbrains.idea.maven.server.embedder.CustomMaven3ModelInterpolator2;
import org.jetbrains.idea.maven.server.embedder.Maven3ExecutionResult;
import org.jetbrains.idea.maven.server.utils.Maven3ResolverUtil;

public class Maven3XProjectResolver {
    @NotNull
    private final Maven3XServerEmbedder myEmbedder;
    private final boolean myUpdateSnapshots;
    @NotNull
    private final Maven3ImporterSpy myImporterSpy;
    @NotNull
    private final MavenServerConsoleIndicatorImpl myCurrentIndicator;
    @Nullable
    private final MavenWorkspaceMap myWorkspaceMap;
    @NotNull
    private final MavenEmbedderSettings myEmbedderSettings;
    @NotNull
    private final Maven3ServerConsoleLogger myConsoleWrapper;
    @NotNull
    private final ArtifactRepository myLocalRepository;

    public Maven3XProjectResolver(@NotNull Maven3XServerEmbedder embedder, boolean updateSnapshots, @NotNull Maven3ImporterSpy importerSpy, @NotNull MavenServerConsoleIndicatorImpl currentIndicator, @Nullable MavenWorkspaceMap workspaceMap, @NotNull MavenEmbedderSettings embedderSettings, @NotNull Maven3ServerConsoleLogger consoleWrapper, @NotNull ArtifactRepository localRepository) {
        if (embedder == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(0);
        }
        if (importerSpy == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(1);
        }
        if (currentIndicator == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(2);
        }
        if (embedderSettings == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(3);
        }
        if (consoleWrapper == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(4);
        }
        if (localRepository == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(5);
        }
        this.myEmbedder = embedder;
        this.myUpdateSnapshots = updateSnapshots;
        this.myImporterSpy = importerSpy;
        this.myCurrentIndicator = currentIndicator;
        this.myWorkspaceMap = workspaceMap;
        this.myEmbedderSettings = embedderSettings;
        this.myConsoleWrapper = consoleWrapper;
        this.myLocalRepository = localRepository;
    }

    @NotNull
    public Collection<MavenServerExecutionResult> resolveProjects(@NotNull LongRunningTask task, @NotNull Collection<File> files, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles) {
        List list;
        if (task == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(6);
        }
        if (files == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(7);
        }
        if (activeProfiles == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(8);
        }
        if (inactiveProfiles == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(9);
        }
        try {
            DependencyTreeResolutionListener listener = new DependencyTreeResolutionListener((Logger)this.myConsoleWrapper);
            Collection<Maven3ExecutionResult> results = this.doResolveProject(task, files, activeProfiles, inactiveProfiles, Collections.singletonList(listener));
            list = ContainerUtilRt.map2List(results, result -> this.createExecutionResult(result.getPomFile(), (Maven3ExecutionResult)result, listener.getRootNode()));
        }
        catch (Exception e) {
            throw this.myEmbedder.wrapToSerializableRuntimeException(e);
        }
        if (list == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private Collection<Maven3ExecutionResult> doResolveProject(@NotNull LongRunningTask task, @NotNull Collection<File> files, @NotNull List<String> activeProfiles, @NotNull List<String> inactiveProfiles, List<ResolutionListener> listeners) throws RemoteException {
        if (task == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(11);
        }
        if (files == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(12);
        }
        if (activeProfiles == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(13);
        }
        if (inactiveProfiles == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(14);
        }
        File file = !files.isEmpty() ? files.iterator().next() : null;
        MavenExecutionRequest request = this.myEmbedder.createRequest(file, activeProfiles, inactiveProfiles);
        request.setUpdateSnapshots(this.myUpdateSnapshots);
        ArrayList<Maven3ExecutionResult> executionResults = new ArrayList<Maven3ExecutionResult>();
        HashMap buildingResultsToResolveDependencies = new HashMap();
        this.myEmbedder.executeWithMavenSession(request, () -> {
            try {
                MavenSession mavenSession = this.myEmbedder.getComponent(LegacySupport.class).getSession();
                RepositorySystemSession repositorySession = this.myEmbedder.getComponent(LegacySupport.class).getRepositorySession();
                if (repositorySession instanceof DefaultRepositorySystemSession) {
                    DefaultRepositorySystemSession session = (DefaultRepositorySystemSession)repositorySession;
                    this.myImporterSpy.setIndicator((MavenServerConsoleIndicator)this.myCurrentIndicator);
                    session.setTransferListener((TransferListener)new Maven3TransferListenerAdapter(this.myCurrentIndicator));
                    if (this.myWorkspaceMap != null) {
                        session.setWorkspaceReader((WorkspaceReader)new Maven3WorkspaceMapReader(this.myWorkspaceMap));
                    }
                    session.setConfigProperty("aether.conflictResolver.verbose", (Object)true);
                    session.setConfigProperty("aether.dependencyManager.verbose", (Object)true);
                }
                List<ProjectBuildingResult> buildingResults = this.getProjectBuildingResults(request, files);
                Maven3XProjectResolver.fillSessionCache(mavenSession, repositorySession, buildingResults);
                boolean addUnresolved = System.getProperty("idea.maven.no.use.dependency.graph") == null;
                for (ProjectBuildingResult buildingResult : buildingResults) {
                    ArrayList<Exception> exceptions;
                    MavenProject project = buildingResult.getProject();
                    if (project == null) {
                        exceptions = new ArrayList<Exception>();
                        for (ModelProblem problem : buildingResult.getProblems()) {
                            exceptions.add(problem.getException());
                        }
                        executionResults.add(new Maven3ExecutionResult(buildingResult.getPomFile(), exceptions));
                        continue;
                    }
                    exceptions = new ArrayList();
                    this.loadExtensions(project, exceptions);
                    project.setDependencyArtifacts(project.createArtifacts(this.myEmbedder.getComponent(ArtifactFactory.class), null, null));
                    if (Maven3ServerEmbedder.USE_MVN2_COMPATIBLE_DEPENDENCY_RESOLVING) {
                        executionResults.add(this.resolveMvn2CompatResult(project, exceptions, listeners, this.myLocalRepository));
                        continue;
                    }
                    buildingResultsToResolveDependencies.put(buildingResult, exceptions);
                }
                task.updateTotalRequests(buildingResultsToResolveDependencies.size());
                boolean runInParallel = this.canResolveDependenciesInParallel();
                List execResults = ParallelRunner.execute((boolean)runInParallel, buildingResultsToResolveDependencies.entrySet(), entry -> {
                    if (task.isCanceled()) {
                        return new Maven3ExecutionResult(Collections.emptyList());
                    }
                    Maven3ExecutionResult result = this.resolveBuildingResult(repositorySession, addUnresolved, (ProjectBuildingResult)entry.getKey(), (List)entry.getValue());
                    task.incrementFinishedRequests();
                    return result;
                });
                executionResults.addAll(execResults);
            }
            catch (Exception e) {
                executionResults.add(Maven3XProjectResolver.handleException(e));
            }
        });
        ArrayList<Maven3ExecutionResult> arrayList = executionResults;
        if (arrayList == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    private Maven3ExecutionResult resolveBuildingResult(RepositorySystemSession repositorySession, boolean addUnresolved, ProjectBuildingResult buildingResult, List<Exception> exceptions) {
        MavenProject project = buildingResult.getProject();
        try {
            ArrayList modelProblems = new ArrayList();
            if (buildingResult.getProblems() != null) {
                modelProblems.addAll(buildingResult.getProblems());
            }
            DependencyResolutionResult dependencyResolutionResult = this.resolveDependencies(project, repositorySession);
            Set<Artifact> artifacts = this.resolveArtifacts(dependencyResolutionResult, addUnresolved);
            project.setArtifacts(artifacts);
            return new Maven3ExecutionResult(project, dependencyResolutionResult, exceptions, modelProblems);
        }
        catch (Exception e) {
            Maven3ExecutionResult maven3ExecutionResult = Maven3XProjectResolver.handleException(project, e);
            if (maven3ExecutionResult == null) {
                Maven3XProjectResolver.$$$reportNull$$$0(16);
            }
            return maven3ExecutionResult;
        }
    }

    private boolean canResolveDependenciesInParallel() {
        if (this.myEmbedderSettings.forceResolveDependenciesSequentially()) {
            return false;
        }
        String mavenVersion = System.getProperty("idea.maven.embedder.version");
        return !"3.8.2".equals(mavenVersion) && !"3.8.3".equals(mavenVersion);
    }

    @NotNull
    private MavenServerExecutionResult createExecutionResult(@Nullable File file, Maven3ExecutionResult result, DependencyNode rootNode) {
        Collection problems = MavenProjectProblem.createProblemsList();
        this.myEmbedder.collectProblems(file, result.getExceptions(), result.getModelProblems(), problems);
        HashSet<MavenProjectProblem> unresolvedProblems = new HashSet<MavenProjectProblem>();
        this.collectUnresolvedArtifactProblems(file, result.getDependencyResolutionResult(), unresolvedProblems);
        MavenProject mavenProject = result.getMavenProject();
        if (mavenProject == null) {
            return new MavenServerExecutionResult(null, problems, Collections.emptySet());
        }
        MavenModel model = new MavenModel();
        try {
            if (Maven3ServerEmbedder.USE_MVN2_COMPATIBLE_DEPENDENCY_RESOLVING) {
                List dependencyNodes = rootNode == null ? Collections.emptyList() : rootNode.getChildren();
                model = Maven3ModelConverter.convertModel((Model)mavenProject.getModel(), (List)mavenProject.getCompileSourceRoots(), (List)mavenProject.getTestCompileSourceRoots(), (Collection)mavenProject.getArtifacts(), (Collection)dependencyNodes, (Collection)mavenProject.getExtensionArtifacts(), (File)this.myEmbedder.getLocalRepositoryFile());
            } else {
                DependencyResolutionResult dependencyResolutionResult = result.getDependencyResolutionResult();
                org.eclipse.aether.graph.DependencyNode dependencyGraph = dependencyResolutionResult != null ? dependencyResolutionResult.getDependencyGraph() : null;
                List dependencyNodes = dependencyGraph != null ? dependencyGraph.getChildren() : Collections.emptyList();
                model = Maven3AetherModelConverter.convertModelWithAetherDependencyTree(mavenProject.getModel(), mavenProject.getCompileSourceRoots(), mavenProject.getTestCompileSourceRoots(), mavenProject.getArtifacts(), dependencyNodes, mavenProject.getExtensionArtifacts(), this.myEmbedder.getLocalRepositoryFile());
            }
        }
        catch (Exception e) {
            this.myEmbedder.collectProblems(mavenProject.getFile(), Collections.singleton(e), result.getModelProblems(), problems);
        }
        RemoteNativeMaven3ProjectHolder holder = new RemoteNativeMaven3ProjectHolder(mavenProject);
        try {
            UnicastRemoteObject.exportObject((Remote)holder, 0);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        Collection<String> activatedProfiles = Maven3XProfileUtil.collectActivatedProfiles(mavenProject);
        Map mavenModelMap = Maven3ModelConverter.convertToMap((Object)mavenProject.getModel());
        MavenServerExecutionResult.ProjectData data = new MavenServerExecutionResult.ProjectData(model, mavenModelMap, (NativeMavenProjectHolder)holder, activatedProfiles);
        return new MavenServerExecutionResult(data, problems, Collections.emptySet(), unresolvedProblems);
    }

    private static void fillSessionCache(MavenSession mavenSession, RepositorySystemSession session, List<ProjectBuildingResult> buildingResults) {
        String mavenVersion = System.getProperty("idea.maven.embedder.version");
        if (VersionComparatorUtil.compare((String)mavenVersion, (String)"3.3.1") < 0) {
            return;
        }
        if (session instanceof DefaultRepositorySystemSession) {
            int initialCapacity = (int)((double)buildingResults.size() * 1.5);
            HashMap<MavenId, Model> cacheMavenModelMap = new HashMap<MavenId, Model>(initialCapacity);
            HashMap<String, MavenProject> mavenProjectMap = new HashMap<String, MavenProject>(initialCapacity);
            for (ProjectBuildingResult result : buildingResults) {
                if (result.getProblems() != null && !result.getProblems().isEmpty()) continue;
                Model model = result.getProject().getModel();
                String key = ArtifactUtils.key((String)model.getGroupId(), (String)model.getArtifactId(), (String)model.getVersion());
                mavenProjectMap.put(key, result.getProject());
                cacheMavenModelMap.put(new MavenId(model.getGroupId(), model.getArtifactId(), model.getVersion()), model);
            }
            mavenSession.setProjectMap(mavenProjectMap);
            ((DefaultRepositorySystemSession)session).setWorkspaceReader((WorkspaceReader)new Maven3WorkspaceReader(session.getWorkspaceReader(), cacheMavenModelMap));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<ProjectBuildingResult> getProjectBuildingResults(@NotNull MavenExecutionRequest request, @NotNull Collection<File> files) {
        List<Object> buildingResults;
        block13: {
            if (request == null) {
                Maven3XProjectResolver.$$$reportNull$$$0(17);
            }
            if (files == null) {
                Maven3XProjectResolver.$$$reportNull$$$0(18);
            }
            ProjectBuilder builder = this.myEmbedder.getComponent(ProjectBuilder.class);
            ModelInterpolator modelInterpolator = this.myEmbedder.getComponent(ModelInterpolator.class);
            String savedLocalRepository = null;
            if (modelInterpolator instanceof CustomMaven3ModelInterpolator2) {
                CustomMaven3ModelInterpolator2 customMaven3ModelInterpolator2 = (CustomMaven3ModelInterpolator2)modelInterpolator;
                savedLocalRepository = customMaven3ModelInterpolator2.getLocalRepository();
                customMaven3ModelInterpolator2.setLocalRepository(request.getLocalRepositoryPath().getAbsolutePath());
            }
            buildingResults = new ArrayList<ProjectBuildingResult>();
            ProjectBuildingRequest projectBuildingRequest = request.getProjectBuildingRequest();
            projectBuildingRequest.setValidationLevel(0);
            projectBuildingRequest.setResolveDependencies(false);
            try {
                if (files.size() == 1) {
                    this.buildSinglePom(builder, buildingResults, projectBuildingRequest, files.iterator().next());
                    break block13;
                }
                try {
                    buildingResults = builder.build(new ArrayList<File>(files), false, projectBuildingRequest);
                }
                catch (ProjectBuildingException e) {
                    for (ProjectBuildingResult result : e.getResults()) {
                        if (result.getProject() != null) {
                            buildingResults.add(result);
                            continue;
                        }
                        this.buildSinglePom(builder, buildingResults, projectBuildingRequest, result.getPomFile());
                    }
                }
            }
            finally {
                if (modelInterpolator instanceof CustomMaven3ModelInterpolator2 && savedLocalRepository != null) {
                    ((CustomMaven3ModelInterpolator2)modelInterpolator).setLocalRepository(savedLocalRepository);
                }
            }
        }
        List<Object> list = buildingResults;
        if (list == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(19);
        }
        return list;
    }

    private void buildSinglePom(ProjectBuilder builder, List<ProjectBuildingResult> buildingResults, ProjectBuildingRequest projectBuildingRequest, File pomFile) {
        try {
            ProjectBuildingResult build = builder.build(pomFile, projectBuildingRequest);
            buildingResults.add(build);
        }
        catch (ProjectBuildingException e) {
            Maven3ResolverUtil.handleProjectBuildingException(buildingResults, (ProjectBuildingException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExtensions(MavenProject project, List<Exception> exceptions) {
        LegacySupport legacySupport;
        MavenSession session;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Collection<AbstractMavenLifecycleParticipant> lifecycleParticipants = this.getLifecycleParticipants(Collections.singletonList(project));
        if (!lifecycleParticipants.isEmpty() && null != (session = (legacySupport = this.myEmbedder.getComponent(LegacySupport.class)).getSession())) {
            session.setCurrentProject(project);
            try {
                session.setAllProjects(Collections.singletonList(project));
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            session.setProjects(Collections.singletonList(project));
            for (AbstractMavenLifecycleParticipant listener : lifecycleParticipants) {
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                try {
                    listener.afterProjectsRead(session);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
            }
        }
    }

    private Maven3ExecutionResult resolveMvn2CompatResult(MavenProject project, List<Exception> exceptions, List<ResolutionListener> listeners, ArtifactRepository localRepository) {
        ArtifactResolutionRequest resolutionRequest = new ArtifactResolutionRequest();
        resolutionRequest.setArtifactDependencies(project.getDependencyArtifacts());
        resolutionRequest.setArtifact(project.getArtifact());
        resolutionRequest.setManagedVersionMap(project.getManagedVersionMap());
        resolutionRequest.setLocalRepository(localRepository);
        resolutionRequest.setRemoteRepositories(project.getRemoteArtifactRepositories());
        resolutionRequest.setListeners(listeners);
        resolutionRequest.setResolveRoot(false);
        resolutionRequest.setResolveTransitively(true);
        ArtifactResolver resolver = this.myEmbedder.getComponent(ArtifactResolver.class);
        ArtifactResolutionResult result = resolver.resolve(resolutionRequest);
        project.setArtifacts(result.getArtifacts());
        return new Maven3ExecutionResult(project, exceptions);
    }

    private static Maven3ExecutionResult handleException(Exception e) {
        return new Maven3ExecutionResult(Collections.singletonList(e));
    }

    private static Maven3ExecutionResult handleException(MavenProject mavenProject, Exception e) {
        return new Maven3ExecutionResult(mavenProject, Collections.singletonList(e));
    }

    private DependencyResolutionResult resolveDependencies(MavenProject project, RepositorySystemSession session) {
        DependencyResolutionResult resolutionResult;
        try {
            ProjectDependenciesResolver dependencyResolver = this.myEmbedder.getComponent(ProjectDependenciesResolver.class);
            DefaultDependencyResolutionRequest resolution = new DefaultDependencyResolutionRequest(project, session);
            resolutionResult = dependencyResolver.resolve((DependencyResolutionRequest)resolution);
        }
        catch (DependencyResolutionException e) {
            resolutionResult = e.getResult();
        }
        LinkedHashSet artifacts = new LinkedHashSet();
        if (resolutionResult.getDependencyGraph() != null) {
            RepositoryUtils.toArtifacts(artifacts, (Collection)resolutionResult.getDependencyGraph().getChildren(), Collections.singletonList(project.getArtifact().getId()), null);
            LocalRepositoryManager lrm = session.getLocalRepositoryManager();
            for (Artifact artifact : artifacts) {
                if (artifact.isResolved()) continue;
                String path = lrm.getPathForLocalArtifact(RepositoryUtils.toArtifact((Artifact)artifact));
                artifact.setFile(new File(lrm.getRepository().getBasedir(), path));
            }
        }
        project.setResolvedArtifacts(artifacts);
        project.setArtifacts(artifacts);
        return resolutionResult;
    }

    @NotNull
    private Set<Artifact> resolveArtifacts(DependencyResolutionResult dependencyResolutionResult, boolean addUnresolvedNodes) {
        IdentityHashMap<Dependency, Artifact> winnerDependencyMap = new IdentityHashMap<Dependency, Artifact>();
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        Set addedDependencies = Collections.newSetFromMap(new IdentityHashMap());
        Maven3XProjectResolver.resolveConflicts(dependencyResolutionResult, winnerDependencyMap);
        if (dependencyResolutionResult.getDependencyGraph() != null) {
            dependencyResolutionResult.getDependencyGraph().getChildren();
        }
        for (Dependency dependency : dependencyResolutionResult.getDependencies()) {
            Artifact artifact = dependency == null ? null : (Artifact)winnerDependencyMap.get(dependency);
            if (artifact == null) continue;
            addedDependencies.add(dependency);
            artifacts.add(artifact);
            this.resolveAsModule(artifact);
        }
        if (addUnresolvedNodes) {
            ArrayDeque queue = new ArrayDeque(dependencyResolutionResult.getDependencyGraph().getChildren());
            while (!queue.isEmpty()) {
                Artifact artifact;
                org.eclipse.aether.graph.DependencyNode node = (org.eclipse.aether.graph.DependencyNode)queue.poll();
                queue.addAll(node.getChildren());
                Dependency dependency = node.getDependency();
                if (dependency == null || !addedDependencies.add(dependency) || (artifact = (Artifact)winnerDependencyMap.get(dependency)) == null) continue;
                addedDependencies.add(dependency);
                artifacts.add(artifact);
                this.resolveAsModule(artifact);
            }
        }
        LinkedHashSet<Artifact> linkedHashSet = artifacts;
        if (linkedHashSet == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(20);
        }
        return linkedHashSet;
    }

    private static void resolveConflicts(DependencyResolutionResult dependencyResolutionResult, final Map<Dependency, Artifact> winnerDependencyMap) {
        dependencyResolutionResult.getDependencyGraph().accept((DependencyVisitor)new TreeDependencyVisitor(new DependencyVisitor(){

            public boolean visitEnter(org.eclipse.aether.graph.DependencyNode node) {
                Object winner = node.getData().get("conflict.winner");
                Dependency dependency = node.getDependency();
                if (dependency != null && winner == null) {
                    Artifact winnerArtifact = Maven3AetherModelConverter.toArtifact(dependency);
                    winnerDependencyMap.put(dependency, winnerArtifact);
                }
                return true;
            }

            public boolean visitLeave(org.eclipse.aether.graph.DependencyNode node) {
                return true;
            }
        }));
    }

    private boolean resolveAsModule(Artifact a) {
        MavenWorkspaceMap map = this.myWorkspaceMap;
        if (map == null) {
            return false;
        }
        MavenWorkspaceMap.Data resolved = map.findFileAndOriginalId(Maven3ModelConverter.createMavenId((Artifact)a));
        if (resolved == null) {
            return false;
        }
        a.setResolved(true);
        a.setFile(resolved.getFile(a.getType()));
        a.selectVersion(resolved.originalId.getVersion());
        return true;
    }

    private void collectUnresolvedArtifactProblems(@Nullable File file, @Nullable DependencyResolutionResult result, Collection<MavenProjectProblem> problems) {
        if (result == null) {
            return;
        }
        String path = file == null ? "" : file.getPath();
        for (Dependency unresolvedDependency : result.getUnresolvedDependencies()) {
            Iterator iterator = result.getResolutionErrors(unresolvedDependency).iterator();
            if (!iterator.hasNext()) continue;
            Exception exception = (Exception)iterator.next();
            String message = Maven3XProjectResolver.getRootMessage(exception);
            Artifact artifact = RepositoryUtils.toArtifact((org.eclipse.aether.artifact.Artifact)unresolvedDependency.getArtifact());
            MavenArtifact mavenArtifact = Maven3ModelConverter.convertArtifact((Artifact)artifact, (File)this.myEmbedder.getLocalRepositoryFile());
            problems.add(MavenProjectProblem.createUnresolvedArtifactProblem((String)path, (String)message, (boolean)true, (MavenArtifact)mavenArtifact));
        }
    }

    @NotNull
    private static String getRootMessage(Throwable each) {
        String baseMessage = each.getMessage() != null ? each.getMessage() : "";
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)each);
        String rootMessage = rootCause != null ? rootCause.getMessage() : "";
        String string = StringUtils.isNotEmpty((String)rootMessage) ? rootMessage : baseMessage;
        if (string == null) {
            Maven3XProjectResolver.$$$reportNull$$$0(21);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<AbstractMavenLifecycleParticipant> getLifecycleParticipants(Collection<MavenProject> projects) {
        LinkedHashSet<AbstractMavenLifecycleParticipant> lifecycleListeners = new LinkedHashSet<AbstractMavenLifecycleParticipant>();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            lifecycleListeners.addAll(this.myEmbedder.getComponents(AbstractMavenLifecycleParticipant.class));
            HashSet<ClassRealm> scannedRealms = new HashSet<ClassRealm>();
            for (MavenProject project : projects) {
                ClassRealm projectRealm = project.getClassRealm();
                if (projectRealm == null || !scannedRealms.add(projectRealm)) continue;
                Thread.currentThread().setContextClassLoader((ClassLoader)projectRealm);
                lifecycleListeners.addAll(this.myEmbedder.getComponents(AbstractMavenLifecycleParticipant.class));
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return lifecycleListeners;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embedder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importerSpy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentIndicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embedderSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleWrapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRepository";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 7: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inactiveProfiles";
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/utils/Maven3XProjectResolver";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/utils/Maven3XProjectResolver";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveProjects";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveProject";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveBuildingResult";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectBuildingResults";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveArtifacts";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjects";
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doResolveProject";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getProjectBuildingResults";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

