/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrIfThenElseImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmLateinitLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Transformer", "backend.jvm.lower"})
public final class JvmLateinitLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public JvmLateinitLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Transformer transformer2 = new Transformer(this.context);
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irFile), (IrElementTransformerVoid)transformer2);
        for (IrVariable variable2 : transformer2.getLateinitVariables()) {
            variable2.setLateinit(false);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\f\u0010\u001e\u001a\u00020\u001f*\u00020\rH\u0002J\f\u0010 \u001a\u00020\u001f*\u00020!H\u0002J\u0014\u0010\"\u001a\u00020\u0011*\u00020#2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmLateinitLowering$Transformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "backendContext", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lateinitVariables", "", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "getLateinitVariables", "()Ljava/util/List;", "transformGetter", "", "backingField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getter", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitField", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitVariable", "isLateinitBackingField", "", "isRealLateinit", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "throwUninitializedPropertyAccessException", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "name", "", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nJvmLateinitLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmLateinitLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmLateinitLowering$Transformer\n+ 2 LateinitLowering.kt\norg/jetbrains/kotlin/backend/common/lower/LateinitLoweringKt\n*L\n1#1,180:1\n218#2,12:181\n*S KotlinDebug\n*F\n+ 1 JvmLateinitLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmLateinitLowering$Transformer\n*L\n131#1:181,12\n*E\n"})
    private static final class Transformer
    extends IrElementTransformerVoid {
        @NotNull
        private final JvmBackendContext backendContext;
        @NotNull
        private final List<IrVariable> lateinitVariables;

        public Transformer(@NotNull JvmBackendContext backendContext) {
            Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
            this.backendContext = backendContext;
            this.lateinitVariables = new ArrayList();
        }

        @NotNull
        public final List<IrVariable> getLateinitVariables() {
            return this.lateinitVariables;
        }

        @NotNull
        public IrStatement visitField(@NotNull IrField declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            if (this.isLateinitBackingField(declaration)) {
                boolean bl;
                boolean bl2 = bl = declaration.getInitializer() == null;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "lateinit property backing field should not have an initializer:\n" + DumpIrTreeKt.dump$default((IrElement)((IrElement)declaration), null, (int)1, null);
                    throw new AssertionError((Object)string2);
                }
                declaration.setType(IrTypesKt.makeNullable((IrType)declaration.getType()));
            }
            this.transformChildrenVoid((IrElement)declaration);
            return (IrStatement)declaration;
        }

        @NotNull
        public IrStatement visitVariable(@NotNull IrVariable declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)declaration), (IrElementTransformerVoid)this);
            if (declaration.isLateinit()) {
                declaration.setType(IrTypesKt.makeNullable((IrType)declaration.getType()));
                declaration.setVar(true);
                declaration.setInitializer((IrExpression)IrConstImpl.Companion.constNull(declaration.getStartOffset(), declaration.getEndOffset(), this.backendContext.getIrBuiltIns().getNothingNType()));
                ((Collection)this.lateinitVariables).add(declaration);
            }
            return (IrStatement)declaration;
        }

        @NotNull
        public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
            IrProperty property;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            IrPropertySymbol irPropertySymbol = declaration.getCorrespondingPropertySymbol();
            Object object = property = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            if (property != null && this.isRealLateinit(property) && Intrinsics.areEqual((Object)declaration, (Object)property.getGetter())) {
                IrField irField = property.getBackingField();
                Intrinsics.checkNotNull((Object)irField);
                this.transformGetter(irField, (IrFunction)declaration);
                return (IrStatement)declaration;
            }
            this.transformChildrenVoid((IrElement)declaration);
            return (IrStatement)declaration;
        }

        @NotNull
        public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrValueDeclaration irValue = expression2.getSymbol().getOwner();
            if (!(irValue instanceof IrVariable) || !((IrVariable)irValue).isLateinit()) {
                return (IrExpression)expression2;
            }
            BackendContext backendContext = (BackendContext)this.backendContext;
            IrDeclarationParent irDeclarationParent = irValue.getParent();
            Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
            DeclarationIrBuilder $this$visitGetValue_u24lambda_u241 = LowerUtilsKt.createIrBuilder((BackendContext)backendContext, (IrSymbol)((IrSymbolOwner)irDeclarationParent).getSymbol(), (int)expression2.getStartOffset(), (int)expression2.getEndOffset());
            boolean bl = false;
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$visitGetValue_u24lambda_u241;
            IrType irType = expression2.getType();
            IrExpression irExpression = ExpressionHelpersKt.irEqualsNull((IrBuilderWithScope)((IrBuilderWithScope)$this$visitGetValue_u24lambda_u241), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$visitGetValue_u24lambda_u241), (IrValueDeclaration)irValue)));
            IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$visitGetValue_u24lambda_u241;
            String string2 = irValue.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            return (IrExpression)ExpressionHelpersKt.irIfThenElse$default((IrBuilderWithScope)irBuilderWithScope, (IrType)irType, (IrExpression)irExpression, (IrExpression)this.backendContext.throwUninitializedPropertyAccessException(irBuilderWithScope2, string2), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$visitGetValue_u24lambda_u241), (IrValueDeclaration)irValue)), null, (int)16, null);
        }

        @NotNull
        public IrExpression visitGetField(@NotNull IrGetField expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)this);
            IrField irField = (IrField)expression2.getSymbol().getOwner();
            if (this.isLateinitBackingField(irField)) {
                expression2.setType(IrTypesKt.makeNullable((IrType)expression2.getType()));
            }
            return (IrExpression)expression2;
        }

        private final boolean isLateinitBackingField(IrField $this$isLateinitBackingField) {
            IrPropertySymbol irPropertySymbol = $this$isLateinitBackingField.getCorrespondingPropertySymbol();
            IrProperty property = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            return property != null && this.isRealLateinit(property);
        }

        private final boolean isRealLateinit(IrProperty $this$isRealLateinit) {
            return $this$isRealLateinit.isLateinit() && !$this$isRealLateinit.isFakeOverride();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression2) {
            IrExpression irExpression;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)expression2), (IrElementTransformerVoid)this);
            if (!Symbols.Companion.isLateinitIsInitializedPropertyGetter((IrFunctionSymbol)expression2.getSymbol())) {
                return (IrExpression)expression2;
            }
            IrExpression irExpression2 = expression2.getExtensionReceiver();
            Intrinsics.checkNotNull((Object)irExpression2);
            IrExpression $this$replaceTailExpression$iv = irExpression2;
            boolean $i$f$replaceTailExpression = false;
            IrExpression current$iv = $this$replaceTailExpression$iv;
            IrContainerExpression block$iv = null;
            while (current$iv instanceof IrContainerExpression) {
                block$iv = (IrContainerExpression)current$iv;
                Object object = CollectionsKt.last((List)((IrContainerExpression)current$iv).getStatements());
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                current$iv = (IrExpression)object;
            }
            IrExpression it = current$iv;
            boolean bl = false;
            IrPropertyReference irPropertyReference = it instanceof IrPropertyReference ? (IrPropertyReference)it : null;
            if (irPropertyReference == null) {
                throw new AssertionError((Object)("Property reference expected: " + RenderIrElementKt.render$default((IrElement)((IrElement)it), null, (int)1, null)));
            }
            IrPropertyReference irPropertyRef = irPropertyReference;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = irPropertyRef.getGetter();
            if (irSimpleFunctionSymbol == null || (irSimpleFunctionSymbol = (IrSimpleFunction)irSimpleFunctionSymbol.getOwner()) == null || (irSimpleFunctionSymbol = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default((IrOverridableDeclaration)((IrOverridableDeclaration)irSimpleFunctionSymbol), (boolean)false, null, (int)3, null)) == null || (irSimpleFunctionSymbol = irSimpleFunctionSymbol.getCorrespondingPropertySymbol()) == null || (irSimpleFunctionSymbol = (IrProperty)irSimpleFunctionSymbol.getOwner()) == null) {
                throw new AssertionError((Object)("isInitialized cannot be invoked on " + RenderIrElementKt.render$default((IrElement)((IrElement)it), null, (int)1, null)));
            }
            IrSimpleFunctionSymbol property = irSimpleFunctionSymbol;
            if (!property.isLateinit()) {
                boolean bl2 = false;
                String string2 = "isInitialized invoked on non-lateinit property " + RenderIrElementKt.render$default((IrElement)((IrElement)property), null, (int)1, null);
                throw new IllegalArgumentException(string2.toString());
            }
            IrField irField = property.getBackingField();
            if (irField == null) {
                throw new AssertionError((Object)"Lateinit property is supposed to have a backing field");
            }
            IrField backingField = irField;
            DeclarationIrBuilder $this$visitCall_u24lambda_u244_u24lambda_u243 = LowerUtilsKt.createIrBuilder((BackendContext)((BackendContext)this.backendContext), (IrSymbol)((IrPropertyReference)it).getSymbol(), (int)expression2.getStartOffset(), (int)expression2.getEndOffset());
            boolean bl3 = false;
            current$iv = ExpressionHelpersKt.irNotEquals((IrBuilderWithScope)((IrBuilderWithScope)$this$visitCall_u24lambda_u244_u24lambda_u243), (IrExpression)((IrExpression)ExpressionHelpersKt.irGetField$default((IrBuilderWithScope)((IrBuilderWithScope)$this$visitCall_u24lambda_u244_u24lambda_u243), (IrExpression)((IrPropertyReference)it).getDispatchReceiver(), (IrField)backingField, null, (int)4, null)), (IrExpression)((IrExpression)ExpressionHelpersKt.irNull((IrBuilderWithScope)((IrBuilderWithScope)$this$visitCall_u24lambda_u244_u24lambda_u243))));
            if (block$iv == null) {
                irExpression = current$iv;
            } else {
                void var2_2;
                block$iv.getStatements().set(block$iv.getStatements().size() - 1, current$iv);
                irExpression = var2_2;
            }
            return irExpression;
        }

        private final void transformGetter(IrField backingField, IrFunction getter2) {
            boolean bl;
            IrType type2 = backingField.getType();
            boolean bl2 = bl = !IrTypePredicatesKt.isPrimitiveType$default((IrType)type2, (boolean)false, (int)1, null);
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-JvmLateinitLowering$Transformer$transformGetter$22 = false;
                String $i$a$-assert-JvmLateinitLowering$Transformer$transformGetter$22 = "'lateinit' property type should not be primitive:\n" + DumpIrTreeKt.dump$default((IrElement)((IrElement)backingField), null, (int)1, null);
                throw new AssertionError((Object)$i$a$-assert-JvmLateinitLowering$Transformer$transformGetter$22);
            }
            int startOffset = getter2.getStartOffset();
            int endOffset = getter2.getEndOffset();
            getter2.setBody((IrBody)this.backendContext.getIrFactory().createBlockBody(startOffset, endOffset, (Function1)new Function1<IrBlockBody, Unit>(this, getter2, startOffset, endOffset, backingField){
                final /* synthetic */ Transformer this$0;
                final /* synthetic */ IrFunction $getter;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                final /* synthetic */ IrField $backingField;
                {
                    this.this$0 = $receiver;
                    this.$getter = $getter;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    this.$backingField = $backingField;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull IrBlockBody $this$createBlockBody) {
                    IrGetValueImpl irGetValueImpl;
                    DeclarationIrBuilder irBuilder;
                    Intrinsics.checkNotNullParameter((Object)$this$createBlockBody, (String)"$this$createBlockBody");
                    DeclarationIrBuilder declarationIrBuilder = irBuilder = LowerUtilsKt.createIrBuilder((BackendContext)((BackendContext)Transformer.access$getBackendContext$p(this.this$0)), (IrSymbol)((IrSymbol)this.$getter.getSymbol()), (int)this.$startOffset, (int)this.$endOffset);
                    IrFunction irFunction = this.$getter;
                    IrField irField = this.$backingField;
                    Transformer transformer2 = this.this$0;
                    DeclarationIrBuilder $this$invoke_u24lambda_u241 = declarationIrBuilder;
                    boolean bl = false;
                    Scope scope = $this$invoke_u24lambda_u241.getScope();
                    IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$invoke_u24lambda_u241;
                    IrValueParameter irValueParameter = irFunction.getDispatchReceiverParameter();
                    if (irValueParameter != null) {
                        void it;
                        IrValueParameter irValueParameter2 = irValueParameter;
                        IrBuilderWithScope irBuilderWithScope2 = irBuilderWithScope;
                        Scope scope2 = scope;
                        boolean bl2 = false;
                        IrGetValueImpl irGetValueImpl2 = ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$invoke_u24lambda_u241), (IrValueDeclaration)((IrValueDeclaration)it));
                        scope = scope2;
                        irBuilderWithScope = irBuilderWithScope2;
                        irGetValueImpl = irGetValueImpl2;
                    } else {
                        irGetValueImpl = null;
                    }
                    IrVariable resultVar = IrBuilderKt.createTmpVariable$default((Scope)scope, (IrExpression)((IrExpression)ExpressionHelpersKt.irGetField((IrBuilderWithScope)irBuilderWithScope, (IrExpression)((IrExpression)irGetValueImpl), (IrField)irField, (IrType)IrTypesKt.makeNullable((IrType)irField.getType()))), null, (boolean)false, null, null, (int)30, null);
                    resultVar.setParent((IrDeclarationParent)irFunction);
                    $this$createBlockBody.getStatements().add(resultVar);
                    IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$invoke_u24lambda_u241;
                    IrType irType = $this$invoke_u24lambda_u241.getContext().getIrBuiltIns().getNothingType();
                    IrExpression irExpression = ExpressionHelpersKt.irNotEquals((IrBuilderWithScope)((IrBuilderWithScope)$this$invoke_u24lambda_u241), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$invoke_u24lambda_u241), (IrValueDeclaration)((IrValueDeclaration)resultVar))), (IrExpression)((IrExpression)ExpressionHelpersKt.irNull((IrBuilderWithScope)((IrBuilderWithScope)$this$invoke_u24lambda_u241))));
                    IrExpression irExpression2 = (IrExpression)ExpressionHelpersKt.irReturn((IrBuilderWithScope)((IrBuilderWithScope)$this$invoke_u24lambda_u241), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$invoke_u24lambda_u241), (IrValueDeclaration)((IrValueDeclaration)resultVar))));
                    IrBuilderWithScope irBuilderWithScope4 = (IrBuilderWithScope)$this$invoke_u24lambda_u241;
                    String string2 = irField.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                    IrIfThenElseImpl throwIfNull = ExpressionHelpersKt.irIfThenElse$default((IrBuilderWithScope)irBuilderWithScope3, (IrType)irType, (IrExpression)irExpression, (IrExpression)irExpression2, (IrExpression)Transformer.access$throwUninitializedPropertyAccessException(transformer2, irBuilderWithScope4, string2), null, (int)16, null);
                    $this$createBlockBody.getStatements().add(throwIfNull);
                }
            }));
        }

        private final IrExpression throwUninitializedPropertyAccessException(IrBuilderWithScope $this$throwUninitializedPropertyAccessException, String name2) {
            return this.backendContext.throwUninitializedPropertyAccessException($this$throwUninitializedPropertyAccessException, name2);
        }

        public static final /* synthetic */ IrExpression access$throwUninitializedPropertyAccessException(Transformer $this, IrBuilderWithScope $receiver, String name2) {
            return $this.throwUninitializedPropertyAccessException($receiver, name2);
        }
    }
}

