/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"excludeDeclarationsFromCodegen", "", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "backend.wasm"})
public final class ExcludeDeclarationsFromCodegenKt {
    public static final void excludeDeclarationsFromCodegen(@NotNull WasmBackendContext context, @NotNull IrModuleFragment module2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        for (IrFile file2 : module2.getFiles()) {
            Iterator it = file2.getDeclarations().iterator();
            while (it.hasNext()) {
                IrDeclarationWithName d;
                Object e = it.next();
                IrDeclarationWithName irDeclarationWithName = e instanceof IrDeclarationWithName ? (IrDeclarationWithName)e : null;
                if (irDeclarationWithName == null || !ExcludeDeclarationsFromCodegenKt.excludeDeclarationsFromCodegen$isExcluded((IrDeclaration)(d = irDeclarationWithName))) continue;
                it.remove();
                IrUtilsKt.addChild((IrDeclarationContainer)((IrDeclarationContainer)context.getExcludedPackageFragment(file2.getPackageFqName())), (IrDeclaration)((IrDeclaration)d));
            }
        }
    }

    private static final boolean excludeDeclarationsFromCodegen$isExcluded(IrDeclaration declaration) {
        IrFile parentFile;
        if (AnnotationsKt.hasExcludedFromCodegenAnnotation((IrAnnotationContainer)declaration)) {
            return true;
        }
        IrDeclarationParent irDeclarationParent = declaration.getParent();
        IrFile irFile = parentFile = irDeclarationParent instanceof IrFile ? (IrFile)irDeclarationParent : null;
        return irFile != null ? AnnotationsKt.hasExcludedFromCodegenAnnotation((IrAnnotationContainer)irFile) : false;
    }
}

