/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.wasm.resolve.diagnostics.ErrorsWasm;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012\u00b2\u0006\n\u0010\u0013\u001a\u00020\u0014X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/wasm/resolve/diagnostics/WasmImportAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "wasmImportFqName", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isParameterTypeSupported", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "isReturnTypeSupported", "wasm.frontend", "valueParameterDeclaration", "Lcom/intellij/psi/PsiElement;"})
public final class WasmImportAnnotationChecker
implements DeclarationChecker {
    @NotNull
    public static final WasmImportAnnotationChecker INSTANCE = new WasmImportAnnotationChecker();
    @NotNull
    private static final FqName wasmImportFqName = new FqName("kotlin.wasm.WasmImport");

    private WasmImportAnnotationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        PsiElement wasmImportPsi;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        AnnotationDescriptor annotationDescriptor = descriptor2.getAnnotations().findAnnotation(wasmImportFqName);
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor wasmImport = annotationDescriptor;
        BindingTrace trace = context.getTrace();
        PsiElement psiElement = PsiSourceElementKt.getPsi((SourceElement)wasmImport.getSource());
        if (psiElement == null) {
            psiElement = wasmImportPsi = (PsiElement)declaration;
        }
        if (!DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            trace.report(ErrorsWasm.NESTED_WASM_IMPORT.on(wasmImportPsi));
        }
        if (descriptor2 instanceof FunctionDescriptor) {
            if (!DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2)) {
                trace.report(ErrorsWasm.WASM_IMPORT_ON_NON_EXTERNAL_DECLARATION.on(wasmImportPsi));
            }
            Iterator<ValueParameterDescriptor> iterator2 = ((FunctionDescriptor)descriptor2).getValueParameters().iterator();
            while (iterator2.hasNext()) {
                ValueParameterDescriptor parameter;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                Lazy valueParameterDeclaration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PsiElement>(parameter){
                    final /* synthetic */ ValueParameterDescriptor $parameter;
                    {
                        this.$parameter = $parameter;
                        super(0);
                    }

                    @NotNull
                    public final PsiElement invoke() {
                        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(this.$parameter);
                        Intrinsics.checkNotNull((Object)psiElement);
                        return psiElement;
                    }
                }));
                if (parameter.declaresDefaultValue()) {
                    trace.report(ErrorsWasm.WASM_IMPORT_PARAMETER_DEFAULT_VALUE.on(WasmImportAnnotationChecker.check$lambda$0((Lazy<? extends PsiElement>)valueParameterDeclaration$delegate)));
                }
                if (ArgumentsUtilsKt.isVararg(parameter)) {
                    trace.report(ErrorsWasm.WASM_IMPORT_VARARG_PARAMETER.on(WasmImportAnnotationChecker.check$lambda$0((Lazy<? extends PsiElement>)valueParameterDeclaration$delegate)));
                }
                KotlinType kotlinType = parameter.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                if (this.isParameterTypeSupported(kotlinType)) continue;
                trace.report(ErrorsWasm.WASM_IMPORT_UNSUPPORTED_PARAMETER_TYPE.on(WasmImportAnnotationChecker.check$lambda$0((Lazy<? extends PsiElement>)valueParameterDeclaration$delegate), parameter.getType()));
            }
            KotlinType returnType2 = ((FunctionDescriptor)descriptor2).getReturnType();
            if (returnType2 != null && !this.isReturnTypeSupported(returnType2)) {
                trace.report(ErrorsWasm.WASM_IMPORT_UNSUPPORTED_RETURN_TYPE.on((PsiElement)declaration, returnType2));
            }
        }
    }

    private final boolean isParameterTypeSupported(KotlinType type2) {
        return TypeUtilsKt.isPrimitiveNumberType(type2) || TypeUtilsKt.isBoolean(type2);
    }

    private final boolean isReturnTypeSupported(KotlinType type2) {
        return this.isParameterTypeSupported(type2) || TypeUtilsKt.isUnit(type2);
    }

    private static final PsiElement check$lambda$0(Lazy<? extends PsiElement> $valueParameterDeclaration$delegate) {
        Lazy<? extends PsiElement> lazy = $valueParameterDeclaration$delegate;
        return (PsiElement)lazy.getValue();
    }
}

