/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.groovy;

import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.ExternalNameInfo;
import com.android.tools.idea.gradle.dsl.parser.GradleDslWriter;
import com.android.tools.idea.gradle.dsl.parser.SharedParserUtilsKt;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslInfixExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslUtil;
import com.android.tools.idea.gradle.dsl.parser.repositories.MavenRepositoryDslElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public class GroovyDslWriter
extends GroovyDslNameConverter
implements GradleDslWriter {
    public GroovyDslWriter(@NotNull BuildModelContext context) {
        if (context == null) {
            GroovyDslWriter.$$$reportNull$$$0(0);
        }
        super(context);
    }

    @Override
    public PsiElement moveDslElement(@NotNull GradleDslElement element) {
        if (element == null) {
            GroovyDslWriter.$$$reportNull$$$0(1);
        }
        GradleDslElement anchorAfter = element.getAnchor();
        GroovyPsiElement psiElement = GroovyDslUtil.ensureGroovyPsi(element.getPsiElement());
        if (psiElement == null) {
            return null;
        }
        PsiElement parentPsiElement = GroovyDslUtil.getParentPsi(element);
        if (parentPsiElement == null) {
            return null;
        }
        PsiElement anchor = GroovyDslUtil.getPsiElementForAnchor(parentPsiElement, anchorAfter);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)parentPsiElement.getProject());
        PsiElement lineTerminator = factory.createLineTerminator(1);
        PsiElement toReplace = parentPsiElement.addAfter(lineTerminator, anchor);
        PsiElement e = element.getPsiElement();
        while (!(e.getParent() instanceof GroovyFile) && !(e.getParent() instanceof GrClosableBlock)) {
            if (e.getParent() == null) {
                e = element.getPsiElement();
                break;
            }
            e = e.getParent();
        }
        PsiElement treeCopy = e.copy();
        PsiElement newTree = toReplace.replace(treeCopy);
        e.delete();
        element.setPsiElement(newTree);
        return element.getPsiElement();
    }

    @Override
    public PsiElement createDslElement(@NotNull GradleDslElement element) {
        PsiElement addedElement;
        PsiElement parentPsiElement;
        if (element == null) {
            GroovyDslWriter.$$$reportNull$$$0(2);
        }
        if (element instanceof GradleDslInfixExpression) {
            return this.createDslInfixExpression((GradleDslInfixExpression)element);
        }
        GroovyPsiElement psiElement = GroovyDslUtil.ensureGroovyPsi(element.getPsiElement());
        if (psiElement != null) {
            return psiElement;
        }
        GradleDslElement anchorAfter = element.getAnchor();
        boolean addBefore = false;
        if (element.isNewEmptyBlockElement()) {
            return null;
        }
        if (GroovyDslUtil.needToCreateParent(element)) {
            addBefore = true;
            anchorAfter = null;
        }
        if ((parentPsiElement = GroovyDslUtil.getParentPsi(element)) == null) {
            return null;
        }
        Project project = parentPsiElement.getProject();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
        ExternalNameInfo externalNameInfo = SharedParserUtilsKt.maybeTrimForParent(element, this);
        Object statementText = GroovyDslUtil.quotePartsIfNecessary(externalNameInfo);
        assert (!((String)statementText).isEmpty()) : "Element name can't be empty! This will cause statement creation to error.";
        ExternalNameInfo.ExternalNameSyntax syntax = externalNameInfo.syntax;
        switch (syntax) {
            case UNKNOWN: {
                syntax = element.getExternalSyntax();
                break;
            }
            default: {
                element.setExternalSyntax(syntax);
            }
        }
        if (element.isBlockElement()) {
            statementText = element instanceof MavenRepositoryDslElement && element.getContainedElements(true).isEmpty() ? (String)statementText + "()" : (String)statementText + " {\n}\n";
        } else if (syntax == ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT || syntax == ExternalNameInfo.ExternalNameSyntax.AUGMENTED_ASSIGNMENT) {
            if (element.getElementType() == PropertyType.REGULAR) {
                switch (syntax) {
                    case ASSIGNMENT: {
                        statementText = (String)statementText + " = 'abc'";
                        break;
                    }
                    case AUGMENTED_ASSIGNMENT: {
                        statementText = (String)statementText + " += 'abc'";
                    }
                }
            } else if (element.getElementType() == PropertyType.VARIABLE) {
                statementText = "def " + (String)statementText + " = 'abc'";
            }
        } else {
            statementText = (String)statementText + " \"abc\", \"xyz\"";
        }
        GrStatement statement = factory.createStatementFromText((CharSequence)statementText);
        if (statement instanceof GrApplicationStatement) {
            ((GrApplicationStatement)statement).getArgumentList().delete();
        } else if (statement instanceof GrAssignmentExpression) {
            GrAssignmentExpression assignment = (GrAssignmentExpression)statement;
            if (assignment.getRValue() != null) {
                assignment.getRValue().delete();
            }
        } else if (statement instanceof GrVariableDeclaration) {
            GrVariableDeclaration variableDeclaration = (GrVariableDeclaration)statement;
            for (GrVariable var : variableDeclaration.getVariables()) {
                if (var.getInitializerGroovy() == null) continue;
                var.getInitializerGroovy().delete();
                ASTNode node = var.getNode();
                node.addLeaf(GroovyTokenTypes.mASSIGN, (CharSequence)"=", var.getLastChild().getNode().getTreeNext());
            }
        }
        PsiElement lineTerminator = factory.createLineTerminator(1);
        PsiElement anchor = GroovyDslUtil.getPsiElementForAnchor(parentPsiElement, anchorAfter);
        if (parentPsiElement instanceof GroovyFile) {
            PsiElement firstFileChild = parentPsiElement.getFirstChild();
            addedElement = addBefore ? parentPsiElement.addBefore((PsiElement)statement, anchor) : (firstFileChild != null && firstFileChild.getNode().getElementType() == GroovyElementTypes.ML_COMMENT && anchor == null ? parentPsiElement.addAfter((PsiElement)statement, firstFileChild) : parentPsiElement.addAfter((PsiElement)statement, anchor));
            if (element.isBlockElement() && !PsiImplUtil.isWhiteSpaceOrNls((PsiElement)addedElement.getPrevSibling())) {
                parentPsiElement.addBefore(lineTerminator, addedElement);
            }
            if (addBefore) {
                parentPsiElement.addAfter(lineTerminator, addedElement);
            } else {
                parentPsiElement.addBefore(lineTerminator, addedElement);
            }
        } else if (parentPsiElement instanceof GrClosableBlock) {
            addedElement = parentPsiElement.addAfter((PsiElement)statement, anchor);
            if (anchorAfter != null) {
                parentPsiElement.addBefore(lineTerminator, addedElement);
            } else {
                parentPsiElement.addAfter(lineTerminator, addedElement);
                if (GroovyDslUtil.closableBlockNeedsNewline((GrClosableBlock)parentPsiElement)) {
                    parentPsiElement.addBefore(lineTerminator, addedElement);
                }
            }
        } else {
            addedElement = parentPsiElement.addAfter((PsiElement)statement, anchor);
            parentPsiElement.addBefore(lineTerminator, addedElement);
        }
        if (element.isBlockElement()) {
            GrClosableBlock closableBlock = GroovyDslUtil.getClosableBlock(addedElement);
            if (closableBlock != null) {
                element.setPsiElement((PsiElement)closableBlock);
            }
        } else if (addedElement instanceof GrApplicationStatement || addedElement instanceof GrAssignmentExpression || addedElement instanceof GrVariableDeclaration) {
            element.setPsiElement(addedElement);
        }
        return element.getPsiElement();
    }

    @Override
    public void deleteDslElement(@NotNull GradleDslElement element) {
        if (element == null) {
            GroovyDslWriter.$$$reportNull$$$0(3);
        }
        GroovyDslUtil.deletePsiElement(element, element.getPsiElement());
    }

    @Override
    public PsiElement createDslLiteral(@NotNull GradleDslLiteral literal) {
        if (literal == null) {
            GroovyDslWriter.$$$reportNull$$$0(4);
        }
        return this.createDslLiteralOrReference(literal);
    }

    @Override
    public void applyDslLiteral(@NotNull GradleDslLiteral literal) {
        if (literal == null) {
            GroovyDslWriter.$$$reportNull$$$0(5);
        }
        GroovyDslUtil.applyDslLiteralOrReference(literal, this);
    }

    @Override
    public void deleteDslLiteral(@NotNull GradleDslLiteral literal) {
        if (literal == null) {
            GroovyDslWriter.$$$reportNull$$$0(6);
        }
        GroovyDslUtil.deletePsiElement(literal, literal.getExpression());
        GroovyDslUtil.deletePsiElement(literal, literal.getNameElement().getNamedPsiElement());
    }

    @Override
    public PsiElement createDslMethodCall(@NotNull GradleDslMethodCall methodCall) {
        GrExpression[] expressionArguments;
        String statementText;
        PsiElement parentPsiElement;
        PsiElement psiElement;
        if (methodCall == null) {
            GroovyDslWriter.$$$reportNull$$$0(7);
        }
        if ((psiElement = methodCall.getPsiElement()) != null && psiElement.isValid()) {
            return psiElement;
        }
        if (methodCall.getParent() == null) {
            return null;
        }
        GradleDslElement anchorAfter = methodCall.getAnchor();
        if (GroovyDslUtil.needToCreateParent(methodCall)) {
            anchorAfter = null;
        }
        if ((parentPsiElement = methodCall.getParent().create()) == null) {
            return null;
        }
        PsiElement anchor = GroovyDslUtil.getPsiElementForAnchor(parentPsiElement, anchorAfter);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)parentPsiElement.getProject());
        GradleDslLiteral fakeElement = new GradleDslLiteral(methodCall.getParent(), GradleNameElement.fake(methodCall.getMethodName()));
        String methodCallText = (methodCall.isConstructor() ? "new " : "") + GroovyDslUtil.quotePartsIfNecessary(SharedParserUtilsKt.maybeTrimForParent(fakeElement, this)) + "()";
        if (!methodCall.getNameElement().isEmpty()) {
            ExternalNameInfo info = SharedParserUtilsKt.maybeTrimForParent(methodCall, this);
            ExternalNameInfo.ExternalNameSyntax syntax = info.syntax;
            if (syntax == ExternalNameInfo.ExternalNameSyntax.UNKNOWN) {
                syntax = methodCall.getExternalSyntax();
            }
            String elementName = GroovyDslUtil.quotePartsIfNecessary(info) + " ";
            statementText = elementName + (syntax == ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT ? "= " : "") + methodCallText;
        } else {
            statementText = methodCallText;
        }
        GrStatement statement = factory.createStatementFromText((CharSequence)statementText);
        PsiElement addedElement = parentPsiElement.addAfter((PsiElement)statement, anchor);
        if (addedElement instanceof GrApplicationStatement && (expressionArguments = ((GrApplicationStatement)addedElement).getArgumentList().getExpressionArguments()).length == 1 && expressionArguments[0] instanceof GrMethodCallExpression) {
            methodCall.setPsiElement((PsiElement)expressionArguments[0]);
            GrMethodCallExpression methodCallExpression = (GrMethodCallExpression)expressionArguments[0];
            methodCall.getArgumentsElement().setPsiElement((PsiElement)methodCallExpression.getArgumentList());
            return methodCall.getPsiElement();
        }
        if (addedElement instanceof GrAssignmentExpression) {
            GrExpression rValue = ((GrAssignmentExpression)addedElement).getRValue();
            if (rValue instanceof GrMethodCallExpression) {
                methodCall.setPsiElement((PsiElement)rValue);
                GrMethodCallExpression methodCallExpression = (GrMethodCallExpression)rValue;
                methodCall.getArgumentsElement().setPsiElement((PsiElement)methodCallExpression.getArgumentList());
                return methodCall.getPsiElement();
            }
            if (rValue instanceof GrNewExpression) {
                methodCall.setPsiElement((PsiElement)rValue);
                GrNewExpression newExpression = (GrNewExpression)rValue;
                methodCall.getArgumentsElement().setPsiElement((PsiElement)newExpression.getArgumentList());
            }
            return methodCall.getPsiElement();
        }
        if (addedElement instanceof GrMethodCallExpression) {
            methodCall.setPsiElement(addedElement);
            methodCall.getArgumentsElement().setPsiElement((PsiElement)((GrMethodCallExpression)addedElement).getArgumentList());
            methodCall.getArgumentsElement().applyChanges();
            if (methodCall.getUnsavedClosure() != null) {
                GroovyDslUtil.createAndAddClosure(methodCall.getUnsavedClosure(), methodCall);
            }
            return methodCall.getPsiElement();
        }
        return null;
    }

    @Override
    public void applyDslMethodCall(@NotNull GradleDslMethodCall element) {
        if (element == null) {
            GroovyDslWriter.$$$reportNull$$$0(8);
        }
        GroovyDslUtil.maybeUpdateName(element, this);
        element.getArgumentsElement().applyChanges();
        if (element.getUnsavedClosure() != null) {
            GroovyDslUtil.createAndAddClosure(element.getUnsavedClosure(), element);
        }
    }

    @Override
    public PsiElement createDslExpressionList(@NotNull GradleDslExpressionList expressionList) {
        PsiElement psiElement;
        if (expressionList == null) {
            GroovyDslWriter.$$$reportNull$$$0(9);
        }
        if ((psiElement = expressionList.getPsiElement()) == null) {
            if (expressionList.getParent() instanceof GradleDslExpressionMap) {
                return GroovyDslUtil.createNamedArgumentList(expressionList);
            }
            if (expressionList.getParent() instanceof GradleDslMethodCall) {
                return GroovyDslUtil.createMethodCallArgumentList(expressionList);
            }
        } else {
            return psiElement;
        }
        psiElement = this.createDslElement(expressionList);
        if (psiElement == null) {
            return null;
        }
        if (psiElement instanceof GrListOrMap) {
            return psiElement;
        }
        if (psiElement instanceof GrAssignmentExpression || psiElement instanceof GrVariableDeclaration) {
            GrExpression emptyMap = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject()).createExpressionFromText((CharSequence)"[]");
            PsiElement element = psiElement.addAfter((PsiElement)emptyMap, psiElement.getLastChild());
            expressionList.setPsiElement(element);
            return expressionList.getPsiElement();
        }
        if (psiElement instanceof GrArgumentList) {
            if (expressionList.getExpressions().size() == 1 && ((GrArgumentList)psiElement).getAllArguments().length == 1 && !expressionList.isAppendToArgumentListWithOneElement()) {
                expressionList.setPsiElement(null);
                psiElement = this.createDslElement(expressionList);
            } else {
                return psiElement;
            }
        }
        if (psiElement instanceof GrApplicationStatement) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject());
            GrArgumentList argumentList = factory.createArgumentListFromText("xyz");
            argumentList.getFirstChild().delete();
            PsiElement added = psiElement.addAfter((PsiElement)argumentList, psiElement.getLastChild());
            if (added instanceof GrArgumentList) {
                GrArgumentList addedArgumentList = (GrArgumentList)added;
                expressionList.setPsiElement((PsiElement)addedArgumentList);
                return addedArgumentList;
            }
        }
        return null;
    }

    @Override
    public void applyDslExpressionList(@NotNull GradleDslExpressionList expressionList) {
        if (expressionList == null) {
            GroovyDslWriter.$$$reportNull$$$0(10);
        }
        GroovyDslUtil.maybeUpdateName(expressionList, this);
    }

    @Override
    public PsiElement createDslExpressionMap(@NotNull GradleDslExpressionMap expressionMap) {
        PsiElement psiElement;
        if (expressionMap == null) {
            GroovyDslWriter.$$$reportNull$$$0(11);
        }
        if (expressionMap.getPsiElement() != null) {
            return expressionMap.getPsiElement();
        }
        if (expressionMap.getElementType() == PropertyType.DERIVED && expressionMap.isLiteralMap()) {
            psiElement = GroovyDslUtil.createDerivedMap(expressionMap);
        } else {
            if (expressionMap.getElementType() == PropertyType.DERIVED && expressionMap.getParent() instanceof GradleDslExpressionList && expressionMap.getParent().getParent() instanceof GradleDslMethodCall) {
                return expressionMap.getParent() == null ? null : expressionMap.getParent().create();
            }
            psiElement = this.createDslElement(expressionMap);
        }
        if (psiElement == null) {
            return null;
        }
        if (psiElement instanceof GrListOrMap || psiElement instanceof GrArgumentList || psiElement instanceof GrNamedArgument) {
            return psiElement;
        }
        if (psiElement instanceof GrAssignmentExpression || psiElement instanceof GrVariableDeclaration) {
            GrExpression emptyMap = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject()).createExpressionFromText((CharSequence)"[:]");
            PsiElement element = psiElement.addAfter((PsiElement)emptyMap, psiElement.getLastChild());
            expressionMap.setPsiElement(element);
            return element;
        }
        if (psiElement instanceof GrApplicationStatement) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject());
            GrArgumentList argumentList = factory.createArgumentListFromText("xyz");
            argumentList.getFirstChild().delete();
            PsiElement added = psiElement.addAfter((PsiElement)argumentList, psiElement.getLastChild());
            if (added instanceof GrArgumentList) {
                GrArgumentList addedArgumentList = (GrArgumentList)added;
                expressionMap.setPsiElement((PsiElement)addedArgumentList);
                return addedArgumentList;
            }
        }
        return null;
    }

    @Override
    public void applyDslExpressionMap(@NotNull GradleDslExpressionMap expressionMap) {
        if (expressionMap == null) {
            GroovyDslWriter.$$$reportNull$$$0(12);
        }
        GroovyDslUtil.maybeUpdateName(expressionMap, this);
    }

    public PsiElement createDslInfixExpression(@NotNull GradleDslInfixExpression expression) {
        if (expression == null) {
            GroovyDslWriter.$$$reportNull$$$0(13);
        }
        if (expression.getPsiElement() != null) {
            return expression.getPsiElement();
        }
        GradleDslElement parent = expression.getParent();
        if (parent == null) {
            return null;
        }
        PsiElement parentPsi = parent.create();
        GradleDslElement firstElement = expression.getCurrentElements().get(0);
        if (firstElement instanceof GradleDslLiteral) {
            GradleDslLiteral firstLiteral = (GradleDslLiteral)firstElement;
            expression.setPsiElement(parentPsi);
            PsiElement elementPsi = this.createDslElement(firstLiteral);
            expression.setPsiElement(elementPsi);
            this.applyDslLiteral(firstLiteral);
            firstLiteral.reset();
            firstLiteral.commit();
        } else if (firstElement instanceof GradleDslMethodCall) {
            GradleDslMethodCall firstMethodCall = (GradleDslMethodCall)firstElement;
            expression.setPsiElement(parentPsi);
            PsiElement elementPsi = this.createDslMethodCall(firstMethodCall);
            expression.setPsiElement(elementPsi);
            this.applyDslMethodCall(firstMethodCall);
            firstMethodCall.commit();
        } else {
            return null;
        }
        return expression.getPsiElement();
    }

    @Override
    public void applyDslPropertiesElement(@NotNull GradlePropertiesDslElement element) {
        if (element == null) {
            GroovyDslWriter.$$$reportNull$$$0(14);
        }
        GroovyDslUtil.maybeUpdateName(element, this);
    }

    private PsiElement createDslLiteralOrReference(@NotNull GradleDslSettableExpression expression) {
        GradleDslElement parent;
        if (expression == null) {
            GroovyDslWriter.$$$reportNull$$$0(15);
        }
        if ((parent = expression.getParent()) instanceof GradleDslExpressionMap) {
            return GroovyDslUtil.processMapElement(expression);
        }
        if (parent instanceof GradleDslExpressionList) {
            return GroovyDslUtil.processListElement(expression);
        }
        if (parent instanceof GradleDslInfixExpression) {
            return GroovyDslUtil.createInfixElement(expression);
        }
        return this.createDslElement(expression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionList";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionMap";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslWriter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "moveDslElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createDslElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteDslElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createDslLiteral";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "applyDslLiteral";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteDslLiteral";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createDslMethodCall";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "applyDslMethodCall";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createDslExpressionList";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "applyDslExpressionList";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createDslExpressionMap";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "applyDslExpressionMap";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "createDslInfixExpression";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "applyDslPropertiesElement";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createDslLiteralOrReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

