/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.PerforceNumberNameSynchronizer;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.jobs.EditChangelistJobsDialog;
import org.jetbrains.idea.perforce.perforce.jobs.JobDetailsLoader;
import org.jetbrains.idea.perforce.perforce.jobs.P4JobsLogicConn;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;

public class LinkChangeListToJobsAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            LinkChangeListToJobsAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            LinkChangeListToJobsAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setText(PerforceBundle.messagePointer("action.link.changelist.to.jobs", new Object[0]));
        if (!LinkChangeListToJobsAction.enabled(e)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    private static boolean enabled(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null || project.isDefault()) {
            return false;
        }
        if (!PerforceSettings.getSettings((Project)project).ENABLED) {
            return false;
        }
        if (!PerforceSettings.getSettings((Project)project).USE_PERFORCE_JOBS) {
            return false;
        }
        ChangeList[] lists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        if (lists == null || lists.length != 1) {
            return false;
        }
        return !PerforceNumberNameSynchronizer.getInstance(project).getAllNumbers(lists[0].getName()).isEmpty();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            LinkChangeListToJobsAction.$$$reportNull$$$0(2);
        }
        if (!LinkChangeListToJobsAction.enabled(e)) {
            return;
        }
        Project project = e.getProject();
        ChangeList[] lists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        assert (lists != null);
        LocalChangeList list = (LocalChangeList)lists[0];
        JobDetailsLoader loader = new JobDetailsLoader(project);
        HashMap<ConnectionKey, P4JobsLogicConn> connMap = new HashMap<ConnectionKey, P4JobsLogicConn>();
        HashMap<ConnectionKey, List<PerforceJob>> perforceJobs = new HashMap<ConnectionKey, List<PerforceJob>>();
        loader.loadJobsForList(list, connMap, perforceJobs);
        if (perforceJobs.isEmpty()) {
            Messages.showInfoMessage((String)PerforceBundle.message("connection.no.valid.connections", new Object[0]), (String)PerforceBundle.message("perforce", new Object[0]));
            return;
        }
        new EditChangelistJobsDialog(project, list, false, connMap, perforceJobs).show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/actions/LinkChangeListToJobsAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/actions/LinkChangeListToJobsAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

