/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.ChangeListData;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceFileRevision;
import org.jetbrains.idea.perforce.application.PerforceVcsRevisionNumber;
import org.jetbrains.idea.perforce.perforce.PerforceChangeCache;
import org.jetbrains.idea.perforce.perforce.PerforceChangeList;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class ShowAllSubmittedFilesAction
extends AnAction
implements DumbAware {
    public ShowAllSubmittedFilesAction() {
        super(PerforceBundle.messagePointer("action.text.show.all.submitted", new Object[0]), AllIcons.Actions.ListChanges);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowAllSubmittedFilesAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ShowAllSubmittedFilesAction.$$$reportNull$$$0(1);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabled(e.getData(VcsDataKeys.VCS_FILE_REVISION) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ShowAllSubmittedFilesAction.$$$reportNull$$$0(2);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        VcsFileRevision revision = (VcsFileRevision)e.getData(VcsDataKeys.VCS_FILE_REVISION);
        if (revision != null) {
            PerforceFileRevision perfRevision = (PerforceFileRevision)revision;
            ShowAllSubmittedFilesAction.showAllSubmittedFiles(project, ((PerforceVcsRevisionNumber)perfRevision.getRevisionNumber()).getChangeNumber(), perfRevision.getCommitMessage(), perfRevision.getRevisionDate(), perfRevision.getAuthor(), perfRevision.getConnection());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void showAllSubmittedFiles(Project project, long number, String submitMessage, Date date, String user, @NotNull P4Connection p4Connection) {
        if (p4Connection == null) {
            ShowAllSubmittedFilesAction.$$$reportNull$$$0(3);
        }
        try {
            void connection;
            PerforceChangeList changeList = ShowAllSubmittedFilesAction.getSubmittedChangeList(project, number, submitMessage, date, user, (P4Connection)connection);
            if (changeList != null) {
                if (changeList.getChanges().size() > 300) {
                    Messages.showInfoMessage((String)PerforceBundle.message("show.all.files.from.change.list.too.many.files.affected.error.message", new Object[0]), (String)ShowAllSubmittedFilesAction.getTitle(number));
                } else {
                    AbstractVcsHelper.getInstance((Project)project).showChangesListBrowser((CommittedChangeList)changeList, ShowAllSubmittedFilesAction.getTitle(number));
                }
            }
        }
        catch (VcsException ex) {
            Messages.showErrorDialog((String)PerforceBundle.message("message.text.cannot.show.revisions", ex.getLocalizedMessage()), (String)ShowAllSubmittedFilesAction.getTitle(number));
        }
    }

    @Nullable
    public static PerforceChangeList getSubmittedChangeList(Project project, long number, String submitMessage, Date date, String user, P4Connection connection) throws VcsException {
        ChangeListData data = new ChangeListData();
        data.NUMBER = number;
        data.USER = user;
        data.DATE = ChangeListData.DATE_FORMAT.format(date);
        data.DESCRIPTION = submitMessage;
        final PerforceChangeList changeList = new PerforceChangeList(data, project, connection, new PerforceChangeCache(project));
        boolean result = VcsUtil.runVcsProcessWithProgress((VcsRunnable)new VcsRunnable(){

            public void run() throws VcsException {
                changeList.getChanges();
            }
        }, (String)PerforceBundle.message("show.all.files.from.change.list.searching.for.changed.files.progress.title", new Object[0]), (boolean)true, (Project)project);
        return result ? changeList : null;
    }

    private static String getTitle(long changeListNumber) {
        return PerforceBundle.message("dialog.title.show.all.revisions.in.changelist", changeListNumber);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/actions/ShowAllSubmittedFilesAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/actions/ShowAllSubmittedFilesAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showAllSubmittedFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

